/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.items;

import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.colony.workorders.IWorkOrderView;
import com.minecolonies.api.tileentities.AbstractTileEntityColonyBuilding;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.MessageUtils;
import com.minecolonies.core.Network;
import com.minecolonies.core.client.gui.WindowResourceList;
import com.minecolonies.core.colony.buildings.moduleviews.BuildingResourcesModuleView;
import com.minecolonies.core.colony.buildings.workerbuildings.BuildingBuilder;
import com.minecolonies.core.colony.buildings.workerbuildings.BuildingWareHouse;
import com.minecolonies.core.items.AbstractItemMinecolonies;
import com.minecolonies.core.network.messages.server.ResourceScrollSaveWarehouseSnapshotMessage;
import com.minecolonies.core.tileentities.TileEntityRack;
import com.minecolonies.core.tileentities.TileEntityWareHouse;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemResourceScroll
extends AbstractItemMinecolonies {
    public ItemResourceScroll(Item.Properties properties) {
        super("resourcescroll", properties.m_41487_(64));
    }

    private static void openWindow(CompoundTag compound, Player player) {
        int colonyId = compound.m_128451_("colony");
        BlockPos builderPos = compound.m_128441_("builder") ? BlockPosUtil.read(compound, "builder") : null;
        IColonyView colonyView = IColonyManager.getInstance().getColonyView(colonyId, (ResourceKey<Level>)Minecraft.m_91087_().f_91073_.m_46472_());
        if (colonyView != null) {
            IBuildingView buildingView = colonyView.getBuilding(builderPos);
            if (buildingView instanceof BuildingBuilder.View) {
                BuildingBuilder.View builderBuildingView = (BuildingBuilder.View)buildingView;
                String currentHash = ItemResourceScroll.getWorkOrderHash(buildingView);
                String storedHash = compound.m_128441_("wo_hash") ? compound.m_128461_("wo_hash") : null;
                boolean snapshotNeedsUpdate = !Objects.equals(currentHash, storedHash);
                Map<String, Integer> warehouseSnapshot = new HashMap<String, Integer>();
                if (snapshotNeedsUpdate) {
                    Network.getNetwork().sendToServer(new ResourceScrollSaveWarehouseSnapshotMessage(builderPos));
                } else if (compound.m_128441_("version")) {
                    CompoundTag warehouseSnapshotCompound = compound.m_128469_("version");
                    warehouseSnapshot = warehouseSnapshotCompound.m_128431_().stream().collect(Collectors.toMap(k -> k, arg_0 -> ((CompoundTag)warehouseSnapshotCompound).m_128451_(arg_0)));
                }
                new WindowResourceList(builderBuildingView, warehouseSnapshot).open();
            } else {
                MessageUtils.format((Component)Component.m_237115_((String)"com.minecolonies.coremod.item.scroll.needcolony")).sendTo(player);
            }
        } else {
            MessageUtils.format((Component)Component.m_237115_((String)"com.minecolonies.coremod.item.scroll.needcolony")).sendTo(player);
        }
    }

    @NotNull
    private static String getWorkOrderHash(IBuildingView buildingView) {
        Optional<IWorkOrderView> currentWorkOrder = buildingView.getColony().getWorkOrders().stream().filter(o -> o.getClaimedBy().equals((Object)buildingView.getID())).max(Comparator.comparingInt(IWorkOrderView::getPriority));
        if (currentWorkOrder.isEmpty()) {
            return "";
        }
        long location = currentWorkOrder.get().getLocation().m_121878_();
        return location + "__" + currentWorkOrder.get().getPackName();
    }

    private static void updateWarehouseSnapshot(BlockPos warehousePos, CompoundTag compound, Player player) {
        BlockPos builderPos;
        IBuildingView buildingView;
        if (!compound.m_128441_("colony") || !compound.m_128441_("builder")) {
            MessageUtils.format("com.minecolonies.coremod.item.scroll.needcolony", new Object[0]).sendTo(player);
            return;
        }
        IColonyView colonyView = IColonyManager.getInstance().getColonyView(compound.m_128451_("colony"), (ResourceKey<Level>)Minecraft.m_91087_().f_91073_.m_46472_());
        if (colonyView != null && (buildingView = colonyView.getBuilding(builderPos = BlockPosUtil.read(compound, "builder"))) instanceof BuildingBuilder.View) {
            String currentHash = ItemResourceScroll.getWorkOrderHash(buildingView);
            WarehouseSnapshot warehouseSnapshotData = ItemResourceScroll.gatherWarehouseSnapshot(buildingView, warehousePos, currentHash, player);
            if (warehouseSnapshotData != null) {
                Network.getNetwork().sendToServer(new ResourceScrollSaveWarehouseSnapshotMessage(builderPos, warehouseSnapshotData.snapshot, warehouseSnapshotData.hash));
            } else {
                Network.getNetwork().sendToServer(new ResourceScrollSaveWarehouseSnapshotMessage(builderPos));
            }
        }
    }

    @Nullable
    private static WarehouseSnapshot gatherWarehouseSnapshot(IBuildingView buildingView, BlockPos warehouseBlockPos, String hash, Player player) {
        IBuildingView warehouse = buildingView.getColony().getBuilding(warehouseBlockPos);
        if (warehouse == null) {
            MessageUtils.format("com.minecolonies.coremod.item.scroll.wrong_colony", new Object[0]).sendTo(player);
            return null;
        }
        if (hash.isBlank()) {
            return null;
        }
        BuildingResourcesModuleView resourcesModule = buildingView.getModuleViewByType(BuildingResourcesModuleView.class);
        HashMap<String, Integer> items = new HashMap<String, Integer>();
        for (BlockPos container : warehouse.getContainerList()) {
            BlockEntity blockEntity = warehouse.getColony().getWorld().m_7702_(container);
            if (!(blockEntity instanceof TileEntityRack)) continue;
            TileEntityRack rack = (TileEntityRack)blockEntity;
            rack.getAllContent().forEach((item, amount) -> {
                int hashCode = item.getItemStack().m_41782_() ? item.getItemStack().m_41783_().hashCode() : 0;
                String key = item.getItemStack().m_41778_() + "-" + hashCode;
                if (!resourcesModule.getResources().containsKey(key)) {
                    return;
                }
                int oldAmount = items.getOrDefault(key, 0);
                items.put(key, oldAmount + amount);
            });
        }
        return new WarehouseSnapshot(items, hash);
    }

    @NotNull
    public InteractionResult m_6225_(UseOnContext ctx) {
        ItemStack scroll = ctx.m_43723_().m_21120_(ctx.m_43724_());
        CompoundTag compound = scroll.m_41784_();
        BlockEntity entity = ctx.m_43725_().m_7702_(ctx.m_8083_());
        if (ctx.m_43725_().f_46443_) {
            if (entity instanceof AbstractTileEntityColonyBuilding) {
                AbstractTileEntityColonyBuilding buildingEntity = (AbstractTileEntityColonyBuilding)entity;
                if (buildingEntity instanceof TileEntityWareHouse) {
                    ItemResourceScroll.updateWarehouseSnapshot(buildingEntity.getTilePos(), compound, ctx.m_43723_());
                }
            } else {
                ItemResourceScroll.openWindow(compound, ctx.m_43723_());
            }
        } else if (entity instanceof AbstractTileEntityColonyBuilding) {
            AbstractTileEntityColonyBuilding buildingEntity = (AbstractTileEntityColonyBuilding)entity;
            if (buildingEntity.getBuilding() instanceof BuildingBuilder) {
                compound.m_128405_("colony", buildingEntity.getColonyId());
                BlockPosUtil.write(compound, "builder", buildingEntity.getPosition());
                MessageUtils.format("com.minecolonies.coremod.item.scroll.registered", buildingEntity.getColony().getName()).sendTo(ctx.m_43723_());
            } else if (buildingEntity.getBuilding() instanceof BuildingWareHouse) {
                MessageUtils.format("com.minecolonies.coremod.item.scroll.snapshot", new Object[0]).sendTo(ctx.m_43723_());
            } else if (buildingEntity.getBuilding() != null) {
                MutableComponent buildingTypeComponent = MessageUtils.format(buildingEntity.getBuilding().getBuildingType().getTranslationKey(), new Object[0]).create();
                MessageUtils.format("com.minecolonies.coremod.item.scroll.wrong_building", buildingTypeComponent, buildingEntity.getColony().getName()).sendTo(ctx.m_43723_());
            }
        }
        return InteractionResult.SUCCESS;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand hand) {
        ItemStack clipboard = playerIn.m_21120_(hand);
        if (!worldIn.f_46443_) {
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)clipboard);
        }
        ItemResourceScroll.openWindow(clipboard.m_41784_(), playerIn);
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)clipboard);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        IBuildingView buildingView;
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        if (worldIn == null) {
            return;
        }
        CompoundTag compound = stack.m_41784_();
        int colonyId = compound.m_128451_("colony");
        BlockPos builderPos = BlockPosUtil.read(compound, "builder");
        IColonyView colonyView = IColonyManager.getInstance().getColonyView(colonyId, (ResourceKey<Level>)worldIn.m_46472_());
        if (colonyView != null && (buildingView = colonyView.getBuilding(builderPos)) instanceof BuildingBuilder.View) {
            BuildingBuilder.View builderBuildingView = (BuildingBuilder.View)buildingView;
            String name = builderBuildingView.getWorkerName();
            tooltip.add((Component)(name != null && !name.trim().isEmpty() ? Component.m_237113_((String)(ChatFormatting.DARK_PURPLE + name)) : Component.m_237115_((String)"com.minecolonies.coremod.item.scroll.no_builder")));
        }
    }

    private record WarehouseSnapshot(Map<String, Integer> snapshot, String hash) {
    }
}

