/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.entity.pathfinding.pathjobs;

import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.ShapeUtil;
import com.minecolonies.api.util.constant.ColonyConstants;
import com.minecolonies.core.entity.pathfinding.MNode;
import com.minecolonies.core.entity.pathfinding.PathfindingUtils;
import com.minecolonies.core.entity.pathfinding.SurfaceType;
import com.minecolonies.core.entity.pathfinding.pathjobs.AbstractPathJob;
import com.minecolonies.core.entity.pathfinding.pathjobs.IDestinationPathJob;
import com.minecolonies.core.entity.pathfinding.pathresults.PathResult;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PathJobMoveToLocation
extends AbstractPathJob
implements IDestinationPathJob {
    private static final float DESTINATION_SLACK_NONE = 0.1f;
    private static final float DESTINATION_SLACK_ADJACENT = (float)Math.sqrt(2.0);
    @NotNull
    protected final BlockPos destination;
    private float destinationSlack = 0.1f;

    public PathJobMoveToLocation(Level world, @NotNull BlockPos start, @NotNull BlockPos end, int range, Mob entity) {
        super(world, start, end, new PathResult(), entity);
        this.maxNodes += range;
        this.destination = new BlockPos((Vec3i)end);
        this.extraNodes = 4;
    }

    @Override
    @Nullable
    protected Path search() {
        if (this.getGroundHeight(null, this.destination.m_123341_(), this.destination.m_123342_(), this.destination.m_123343_()) != this.destination.m_123342_()) {
            this.destinationSlack = DESTINATION_SLACK_ADJACENT;
        }
        return super.search();
    }

    @Override
    protected double computeHeuristic(int x, int y, int z) {
        return BlockPosUtil.distManhattan(this.destination, x, y, z);
    }

    @Override
    protected boolean isAtDestination(@NotNull MNode n) {
        boolean atDest = false;
        if (this.destinationSlack <= 0.1f) {
            atDest = n.x == this.destination.m_123341_() && n.y == this.destination.m_123342_() && n.z == this.destination.m_123343_();
        } else if (n.y == this.destination.m_123342_() - 1) {
            atDest = (float)BlockPosUtil.distSqr(this.destination, n.x, this.destination.m_123342_(), n.z) < DESTINATION_SLACK_ADJACENT * DESTINATION_SLACK_ADJACENT;
        } else {
            boolean bl = atDest = (float)BlockPosUtil.distSqr(this.destination, n.x, n.y, n.z) < DESTINATION_SLACK_ADJACENT * DESTINATION_SLACK_ADJACENT;
        }
        if (atDest) {
            atDest = SurfaceType.getSurfaceType((BlockGetter)this.world, this.cachedBlockLookup.getBlockState(n.x, n.y - 1, n.z), (BlockPos)this.tempWorldPos.m_122178_(n.x, n.y - 1, n.z), this.getPathingOptions()) == SurfaceType.WALKABLE;
        }
        return atDest;
    }

    @Override
    protected double getEndNodeScore(@NotNull MNode n) {
        if (PathfindingUtils.isLiquid(this.cachedBlockLookup.getBlockState(n.x, n.y - 1, n.z))) {
            return BlockPosUtil.distManhattan(this.destination, n.x, n.y, n.z) + 30;
        }
        if (!ShapeUtil.isEmpty(this.cachedBlockLookup.getBlockState(n.x, n.y, n.z).m_60812_((BlockGetter)this.cachedBlockLookup, (BlockPos)this.tempWorldPos.m_122178_(n.x, n.y, n.z)))) {
            return BlockPosUtil.distManhattan(this.destination, n.x, n.y, n.z) + 10;
        }
        int xDist = Math.abs(this.destination.m_123341_() - n.x);
        int yDist = Math.abs(this.destination.m_123342_() - n.y);
        int zDist = Math.abs(this.destination.m_123343_() - n.z);
        return xDist + yDist + zDist;
    }

    @Override
    protected boolean stopOnNodeLimit(int totalNodesVisited, MNode bestNode, int nodesSinceEndNode) {
        if (totalNodesVisited < 5000 && BlockPosUtil.distManhattan(this.start, bestNode.x, bestNode.y, bestNode.z) < 10 && ColonyConstants.rand.nextInt(100) <= 20) {
            this.maxNodes += 1000;
            return false;
        }
        if (nodesSinceEndNode < 200 && totalNodesVisited < 10000) {
            this.maxNodes += 500;
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        return super.toString() + " destination:" + this.destination;
    }

    @Override
    public BlockPos getDestination() {
        return this.destination;
    }

    public static boolean isJobFor(AbstractPathJob job, BlockPos desiredPosition) {
        if (job instanceof PathJobMoveToLocation) {
            PathJobMoveToLocation pathJob = (PathJobMoveToLocation)job;
            return pathJob.getDestination().equals((Object)desiredPosition);
        }
        return false;
    }
}

