/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.entity.pathfinding.pathjobs;

import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.core.entity.pathfinding.MNode;
import com.minecolonies.core.entity.pathfinding.PathfindingUtils;
import com.minecolonies.core.entity.pathfinding.SurfaceType;
import com.minecolonies.core.entity.pathfinding.pathjobs.AbstractPathJob;
import com.minecolonies.core.entity.pathfinding.pathjobs.IDestinationPathJob;
import com.minecolonies.core.entity.pathfinding.pathresults.PathResult;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.NotNull;

public class PathJobMoveCloseToXNearY
extends AbstractPathJob
implements IDestinationPathJob {
    public final BlockPos desiredPosition;
    public final BlockPos nearbyPosition;
    public final int distToDesired;

    public PathJobMoveCloseToXNearY(Level world, BlockPos desiredPosition, BlockPos nearbyPosition, int distToDesired, Mob entity) {
        super(world, PathfindingUtils.prepareStart((LivingEntity)entity), desiredPosition, new PathResult(), entity);
        this.desiredPosition = desiredPosition;
        this.nearbyPosition = nearbyPosition;
        this.distToDesired = distToDesired;
        this.extraNodes = 20;
    }

    @Override
    protected double computeHeuristic(int x, int y, int z) {
        return BlockPosUtil.distManhattan(this.desiredPosition, x, y, z) + BlockPosUtil.distManhattan(this.nearbyPosition, x, y, z) * 2;
    }

    @Override
    protected boolean isAtDestination(@NotNull MNode n) {
        if (this.desiredPosition.m_123341_() == n.x && this.desiredPosition.m_123343_() == n.z) {
            return false;
        }
        return BlockPosUtil.distManhattan(this.desiredPosition, n.x, n.y, n.z) <= this.distToDesired && SurfaceType.getSurfaceType((BlockGetter)this.world, this.cachedBlockLookup.getBlockState(n.x, n.y - 1, n.z), (BlockPos)this.tempWorldPos.m_122178_(n.x, n.y - 1, n.z), this.getPathingOptions()) == SurfaceType.WALKABLE;
    }

    @Override
    protected double getEndNodeScore(@NotNull MNode n) {
        if (this.desiredPosition.m_123341_() == n.x && this.desiredPosition.m_123343_() == n.z) {
            return 1000.0;
        }
        double dist = BlockPosUtil.distManhattan(this.desiredPosition, n.x, n.y, n.z) * 2 + BlockPosUtil.distManhattan(this.nearbyPosition, n.x, n.y, n.z);
        if (n.isSwimming()) {
            dist += 50.0;
        } else if (this.cachedBlockLookup.getBlockState(n.x, n.y - 1, n.z) == Blocks.f_49990_.m_49966_()) {
            dist += 50.0;
        }
        return dist;
    }

    @Override
    protected boolean stopOnNodeLimit(int totalNodesVisited, MNode bestNode, int nodesSinceEndNode) {
        if (nodesSinceEndNode > 200) {
            return true;
        }
        this.maxNodes += 200;
        return false;
    }

    @Override
    public BlockPos getDestination() {
        return this.desiredPosition;
    }

    public static boolean isJobFor(AbstractPathJob job, BlockPos desiredPosition, BlockPos nearbyPosition, int distance) {
        if (job instanceof PathJobMoveCloseToXNearY) {
            PathJobMoveCloseToXNearY pathJob = (PathJobMoveCloseToXNearY)job;
            return pathJob.desiredPosition.equals((Object)desiredPosition) && pathJob.nearbyPosition.equals((Object)nearbyPosition) && pathJob.distToDesired == distance;
        }
        return false;
    }
}

