/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.entity.pathfinding.navigation;

import com.ldtteam.structurize.util.BlockUtils;
import com.minecolonies.api.entity.ai.workers.util.IBuilderUndestroyable;
import com.minecolonies.api.entity.pathfinding.IStuckHandler;
import com.minecolonies.api.entity.pathfinding.IStuckHandlerEntity;
import com.minecolonies.api.items.ModTags;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.DamageSourceKeys;
import com.minecolonies.api.util.constant.ColonyConstants;
import com.minecolonies.core.entity.pathfinding.SurfaceType;
import com.minecolonies.core.entity.pathfinding.navigation.AbstractAdvancedPathNavigate;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LadderBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.phys.Vec3;

public class PathingStuckHandler
implements IStuckHandler {
    private static final double MIN_TARGET_DIST = 3.0;
    private static final int MIN_TP_DELAY = 2400;
    private static final int MIN_DIST_FOR_TP = 10;
    private static final int TICKS_PER_BLOCK = 7;
    private int teleportRange = 0;
    private int timePerBlockDistance = 200;
    private int stuckLevel = 0;
    private int globalTimeout = 0;
    private BlockPos prevDestination = BlockPos.f_121853_;
    private boolean canBreakBlocks = false;
    private boolean canPlaceLadders = false;
    private boolean canBuildLeafBridges = false;
    private boolean canTeleportGoal = false;
    private boolean takeDamageOnCompleteStuck = false;
    private float damagePct = 0.2f;
    private int completeStuckBlockBreakRange = 0;
    private double chanceToByPassMovingAway = 0.0;
    private boolean hadPath = false;
    private int lastPathIndex = -1;
    private int progressedNodes = 0;
    private int delayBeforeActions;
    private int delayToNextUnstuckAction = this.delayBeforeActions = 200;
    private BlockPos moveAwayStartPos = BlockPos.f_121853_;
    private Direction movingAwayDir = Direction.EAST;
    private Random rand = new Random();

    private PathingStuckHandler() {
    }

    public static PathingStuckHandler createStuckHandler() {
        return new PathingStuckHandler();
    }

    @Override
    public void checkStuck(AbstractAdvancedPathNavigate navigator) {
        if (navigator.getDesiredPos() == null || navigator.getDesiredPos().equals((Object)BlockPos.f_121853_)) {
            this.resetGlobalStuckTimers();
            return;
        }
        if (navigator.getOurEntity() instanceof IStuckHandlerEntity && !((IStuckHandlerEntity)navigator.getOurEntity()).canBeStuck()) {
            this.resetGlobalStuckTimers();
            return;
        }
        double distanceToGoal = navigator.getOurEntity().m_20182_().m_82554_(new Vec3((double)navigator.getDesiredPos().m_123341_(), (double)navigator.getDesiredPos().m_123342_(), (double)navigator.getDesiredPos().m_123343_()));
        if (distanceToGoal < 3.0) {
            this.resetGlobalStuckTimers();
            return;
        }
        if (this.prevDestination.equals((Object)navigator.getDesiredPos())) {
            ++this.globalTimeout;
            if ((double)this.globalTimeout > Math.max(2400.0, (double)this.timePerBlockDistance * Math.max(10.0, distanceToGoal))) {
                this.completeStuckAction(navigator);
            }
        } else {
            this.resetGlobalStuckTimers();
        }
        --this.delayToNextUnstuckAction;
        this.prevDestination = navigator.getDesiredPos();
        if (navigator.m_26570_() == null || navigator.m_26570_().m_77392_()) {
            this.lastPathIndex = -1;
            this.progressedNodes = 0;
            if (!this.hadPath) {
                this.tryUnstuck(navigator);
            }
        } else if (navigator.m_26570_().m_77399_() == this.lastPathIndex) {
            this.tryUnstuck(navigator);
        } else if (this.lastPathIndex != -1) {
            if (this.lastPathIndex != navigator.m_26570_().m_77399_()) {
                this.delayToNextUnstuckAction = Math.max(this.delayToNextUnstuckAction, 100);
            } else if (this.lastPathIndex < 2 && navigator.m_26570_().m_77398_() > 2) {
                navigator.m_26570_().m_77393_(2);
            }
            if (this.stuckLevel == 0 || navigator.m_26570_().m_77406_().m_123331_((Vec3i)this.prevDestination) < 25.0) {
                int n = this.progressedNodes = navigator.m_26570_().m_77399_() > this.lastPathIndex ? this.progressedNodes + 1 : this.progressedNodes - 1;
                if (!(this.progressedNodes <= 5 || navigator.m_26570_().m_77395_() != null && this.moveAwayStartPos.equals((Object)navigator.m_26570_().m_77395_().m_77288_()))) {
                    this.resetStuckTimers();
                }
            }
        }
        this.lastPathIndex = navigator.m_26570_() != null ? navigator.m_26570_().m_77399_() : -1;
        this.hadPath = navigator.m_26570_() != null && !navigator.m_26570_().m_77392_();
    }

    private void resetGlobalStuckTimers() {
        this.globalTimeout = 0;
        this.prevDestination = BlockPos.f_121853_;
        this.resetStuckTimers();
    }

    private void completeStuckAction(AbstractAdvancedPathNavigate navigator) {
        BlockPos tpPos;
        BlockPos desired = navigator.getDesiredPos();
        Level world = navigator.getOurEntity().m_9236_();
        Mob entity = navigator.getOurEntity();
        if (this.canTeleportGoal && (tpPos = BlockPosUtil.findAround(world, desired, 10, 10, (posworld, pos) -> SurfaceType.getSurfaceType(posworld, posworld.m_8055_(pos.m_7495_()), pos.m_7495_()) == SurfaceType.WALKABLE && SurfaceType.getSurfaceType(posworld, posworld.m_8055_(pos), pos) == SurfaceType.DROPABLE && SurfaceType.getSurfaceType(posworld, posworld.m_8055_(pos.m_7494_()), pos.m_7494_()) == SurfaceType.DROPABLE)) != null) {
            entity.m_6021_((double)tpPos.m_123341_() + 0.5, (double)tpPos.m_123342_(), (double)tpPos.m_123343_() + 0.5);
        }
        if (this.takeDamageOnCompleteStuck) {
            entity.m_6469_(world.m_269111_().m_269079_(DamageSourceKeys.STUCK_DAMAGE), entity.m_21233_() * this.damagePct);
        }
        if (this.completeStuckBlockBreakRange > 0) {
            Direction facing = BlockPosUtil.getFacing(BlockPos.m_274446_((Position)entity.m_20182_()), navigator.getDesiredPos());
            for (int i = 1; i <= this.completeStuckBlockBreakRange; ++i) {
                if (world.m_46859_(BlockPos.m_274446_((Position)entity.m_20182_()).m_5484_(facing, i)) && world.m_46859_(BlockPos.m_274446_((Position)entity.m_20182_()).m_5484_(facing, i).m_7494_())) continue;
                this.breakBlocksAhead(world, BlockPos.m_274446_((Position)entity.m_20182_()).m_5484_(facing, i - 1), facing);
                break;
            }
        }
        navigator.m_26573_();
        this.resetGlobalStuckTimers();
    }

    private void tryUnstuck(AbstractAdvancedPathNavigate navigator) {
        if (this.delayToNextUnstuckAction > 0) {
            return;
        }
        this.delayToNextUnstuckAction = 100;
        if (this.stuckLevel == 0) {
            ++this.stuckLevel;
            this.delayToNextUnstuckAction = 100;
            navigator.getOurEntity().m_8127_();
            BlockPos desired = navigator.getDesiredPos();
            navigator.m_26573_();
            navigator.setDesiredPos(desired);
            return;
        }
        if (this.stuckLevel == 1 && this.rand.nextDouble() > this.chanceToByPassMovingAway || this.stuckLevel >= 3 && this.stuckLevel <= 8 && !this.canBreakBlocks && !this.canBuildLeafBridges && !this.canPlaceLadders && this.rand.nextBoolean()) {
            this.delayToNextUnstuckAction = 600;
            this.moveAwayStartPos = navigator.m_26570_() != null ? navigator.m_26570_().m_77396_(navigator.m_26570_().m_77399_()) : navigator.getOurEntity().m_20183_().m_7494_();
            navigator.m_26573_();
            int range = ColonyConstants.rand.nextInt(20) + Math.min(100, Math.max(20, BlockPosUtil.distManhattan(navigator.ourEntity.m_20183_(), this.prevDestination)));
            navigator.walkTowards(navigator.getOurEntity().m_20183_().m_5484_(this.movingAwayDir, 40), range, 1.0);
            this.movingAwayDir = this.movingAwayDir.m_122427_();
            navigator.setPauseTicks(range * 7);
            return;
        }
        if (this.stuckLevel == 2 && this.teleportRange > 0 && this.hadPath) {
            int index = Math.min(navigator.m_26570_().m_77399_() + this.teleportRange, navigator.m_26570_().m_77398_() - 1);
            Node togo = navigator.m_26570_().m_77375_(index);
            navigator.getOurEntity().m_6021_((double)togo.f_77271_ + 0.5, (double)togo.f_77272_, (double)togo.f_77273_ + 0.5);
            this.delayToNextUnstuckAction = 300;
        }
        if (this.stuckLevel >= 3 && this.stuckLevel <= 5) {
            this.delayToNextUnstuckAction = 200;
            if (this.canPlaceLadders && this.rand.nextBoolean()) {
                this.placeLadders(navigator);
            } else if (this.canBuildLeafBridges && this.rand.nextBoolean()) {
                this.delayToNextUnstuckAction = 100;
                this.placeLeaves(navigator);
            } else if (this.canPlaceLadders || this.canBuildLeafBridges) {
                return;
            }
        }
        if (this.stuckLevel >= 6 && this.stuckLevel <= 8 && this.canBreakBlocks) {
            this.delayToNextUnstuckAction = 200;
            this.breakBlocks(navigator);
        }
        this.chanceStuckLevel();
        if (this.stuckLevel == 9) {
            this.completeStuckAction(navigator);
            this.resetStuckTimers();
        }
    }

    private void chanceStuckLevel() {
        ++this.stuckLevel;
        if (this.stuckLevel > 1 && this.rand.nextInt(6) == 0) {
            this.stuckLevel = Math.max(1, this.stuckLevel - 2);
        }
    }

    private void resetStuckTimers() {
        this.delayToNextUnstuckAction = this.delayBeforeActions;
        this.lastPathIndex = -1;
        this.progressedNodes = 0;
        this.stuckLevel = 0;
        this.moveAwayStartPos = BlockPos.f_121853_;
    }

    private boolean breakBlocksAhead(Level world, BlockPos start, Direction facing) {
        if (!world.m_46859_(start)) {
            this.setAirIfPossible(world, start);
            return true;
        }
        if (!world.m_46859_(start.m_6630_(3))) {
            this.setAirIfPossible(world, start.m_6630_(3));
            return true;
        }
        if (!world.m_46859_(start.m_7494_().m_121945_(facing))) {
            this.setAirIfPossible(world, start.m_7494_().m_121945_(facing));
            return true;
        }
        if (!world.m_46859_(start.m_121945_(facing))) {
            this.setAirIfPossible(world, start.m_121945_(facing));
            return true;
        }
        return false;
    }

    private void setAirIfPossible(Level world, BlockPos pos) {
        BlockState state = world.m_8055_(pos);
        Block blockAtPos = state.m_60734_();
        if (blockAtPos instanceof IBuilderUndestroyable || state.m_204336_(ModTags.indestructible)) {
            return;
        }
        world.m_46597_(pos, Blocks.f_50016_.m_49966_());
    }

    private void placeLadders(AbstractAdvancedPathNavigate navigator) {
        Level world = navigator.getOurEntity().f_19853_;
        Mob entity = navigator.getOurEntity();
        BlockPos entityPos = entity.m_20183_();
        while (world.m_8055_(entityPos).m_60734_() == Blocks.f_50155_) {
            entityPos = entityPos.m_7494_();
        }
        this.tryPlaceLadderAt(world, entityPos);
        this.tryPlaceLadderAt(world, entityPos.m_7494_());
        this.tryPlaceLadderAt(world, entityPos.m_6630_(2));
    }

    private void placeLeaves(AbstractAdvancedPathNavigate navigator) {
        Level world = navigator.getOurEntity().m_9236_();
        Mob entity = navigator.getOurEntity();
        Direction badFacing = BlockPosUtil.getFacing(BlockPos.m_274446_((Position)entity.m_20182_()), navigator.getDesiredPos()).m_122424_();
        for (Direction dir : BlockPosUtil.HORIZONTAL_DIRS) {
            if (dir == badFacing) continue;
            for (int i = 1; i <= (dir == badFacing.m_122424_() ? 3 : 1) && this.tryPlaceLeaveOnPos(world, BlockPos.m_274446_((Position)entity.m_20182_()).m_7495_().m_5484_(dir, i)); ++i) {
            }
        }
    }

    private boolean tryPlaceLeaveOnPos(Level world, BlockPos pos) {
        if (world.m_46859_(pos)) {
            world.m_46597_(pos, Blocks.f_50054_.m_49966_());
            return true;
        }
        return false;
    }

    private void breakBlocks(AbstractAdvancedPathNavigate navigator) {
        Level world = navigator.getOurEntity().m_9236_();
        Mob entity = navigator.getOurEntity();
        Direction facing = BlockPosUtil.getFacing(BlockPos.m_274446_((Position)entity.m_20182_()), navigator.getDesiredPos());
        if (this.breakBlocksAhead(world, entity.m_20183_(), facing) && entity.m_21223_() >= entity.m_21233_() / 3.0f) {
            entity.m_6469_(world.m_269111_().m_269079_(DamageSourceKeys.STUCK_DAMAGE), (float)Math.max(0.5, (double)entity.m_21223_() / 20.0));
        }
    }

    private void tryPlaceLadderAt(Level world, BlockPos pos) {
        BlockState state = world.m_8055_(pos);
        if ((this.canBreakBlocks || state.m_247087_() || state.m_60795_()) && state.m_60734_() != Blocks.f_50155_ && !(state.m_60734_() instanceof IBuilderUndestroyable) && !state.m_204336_(ModTags.indestructible)) {
            for (Direction dir : BlockPosUtil.HORIZONTAL_DIRS) {
                BlockState toPlace = (BlockState)Blocks.f_50155_.m_49966_().m_61124_((Property)LadderBlock.f_54337_, (Comparable)dir.m_122424_());
                if (!BlockUtils.isAnySolid((BlockState)world.m_8055_(pos.m_121945_(dir))) || !Blocks.f_50155_.m_7898_(toPlace, (LevelReader)world, pos)) continue;
                world.m_46597_(pos, toPlace);
                break;
            }
        }
    }

    public PathingStuckHandler withBlockBreaks() {
        this.canBreakBlocks = true;
        return this;
    }

    public PathingStuckHandler withPlaceLadders() {
        this.canPlaceLadders = true;
        return this;
    }

    public PathingStuckHandler withBuildLeafBridges() {
        this.canBuildLeafBridges = true;
        return this;
    }

    public PathingStuckHandler withChanceToByPassMovingAway(double chance) {
        this.chanceToByPassMovingAway = chance;
        return this;
    }

    public PathingStuckHandler withTeleportSteps(int steps) {
        this.teleportRange = steps;
        return this;
    }

    public PathingStuckHandler withTeleportOnFullStuck() {
        this.canTeleportGoal = true;
        return this;
    }

    public PathingStuckHandler withTakeDamageOnStuck(float damagePct) {
        this.damagePct = damagePct;
        this.takeDamageOnCompleteStuck = true;
        return this;
    }

    public PathingStuckHandler withTimePerBlockDistance(int time) {
        this.timePerBlockDistance = time;
        return this;
    }

    public PathingStuckHandler withDelayBeforeStuckActions(int delay) {
        this.delayBeforeActions = delay;
        return this;
    }

    public PathingStuckHandler withCompleteStuckBlockBreak(int range) {
        this.completeStuckBlockBreakRange = range;
        return this;
    }
}

