/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.entity.pathfinding;

import com.ldtteam.domumornamentum.block.decorative.PanelBlock;
import com.ldtteam.domumornamentum.block.vanilla.TrapdoorBlock;
import com.minecolonies.api.blocks.huts.AbstractBlockMinecoloniesDefault;
import com.minecolonies.api.entity.mobs.drownedpirate.AbstractDrownedEntityPirateRaider;
import com.minecolonies.api.items.ModTags;
import com.minecolonies.api.util.ShapeUtil;
import com.minecolonies.core.Network;
import com.minecolonies.core.entity.pathfinding.PathPointExtended;
import com.minecolonies.core.entity.pathfinding.PathingOptions;
import com.minecolonies.core.entity.pathfinding.world.CachingBlockLookup;
import com.minecolonies.core.network.messages.client.SyncPathReachedMessage;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.LadderBlock;
import net.minecraft.world.level.block.MagmaBlock;
import net.minecraft.world.level.block.PowderSnowBlock;
import net.minecraft.world.level.block.SweetBerryBushBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PathfindingUtils {
    private static Object empty = Fluids.f_76191_.m_76145_();
    public static final Map<UUID, UUID> trackingMap = new ConcurrentHashMap<UUID, UUID>();
    public static final Map<String, UUID> trackByType = new HashMap<String, UUID>();

    public static void syncDebugReachedPositions(HashSet<BlockPos> reached, List<ServerPlayer> players) {
        if (reached.isEmpty() || players.isEmpty()) {
            return;
        }
        SyncPathReachedMessage message = new SyncPathReachedMessage(reached);
        for (ServerPlayer player : players) {
            Network.getNetwork().sendToPlayer(message, player);
        }
    }

    public static BlockPos prepareStart(@NotNull LivingEntity entity) {
        // Could not load outer class - annotation placement on inner may be incorrect
        @NotNull BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(Mth.m_14107_((double)entity.m_20185_()), Mth.m_14107_((double)entity.m_20186_()), Mth.m_14107_((double)entity.m_20189_()));
        Level level = entity.f_19853_;
        BlockState bs = level.m_8055_((BlockPos)pos);
        VoxelShape collisionShape = bs.m_60812_((BlockGetter)level, (BlockPos)pos);
        boolean isFineToStandIn = PathfindingUtils.canStandInSolidBlock(bs);
        if (bs.m_280555_() && !isFineToStandIn && collisionShape.m_83297_(Direction.Axis.Y) > 0.0) {
            double relPosX = Math.abs(entity.m_20185_() % 1.0);
            double relPosZ = Math.abs(entity.m_20189_() % 1.0);
            for (AABB box : collisionShape.m_83299_()) {
                if (!(relPosX >= box.f_82288_) || !(relPosX <= box.f_82291_) || !(relPosZ >= box.f_82290_) || !(relPosZ <= box.f_82293_) || !(box.f_82292_ > 0.0)) continue;
                pos.m_122178_(pos.m_123341_(), pos.m_123342_() + 1, pos.m_123343_());
                bs = level.m_8055_((BlockPos)pos);
                break;
            }
        }
        BlockState down = level.m_8055_(pos.m_7495_());
        while (PathfindingUtils.canStandInSolidBlock(bs) && PathfindingUtils.canStandInSolidBlock(down) && !down.m_60734_().isLadder(down, (LevelReader)level, pos.m_7495_(), entity) && down.m_60819_().m_76178_()) {
            pos.m_122175_(Direction.DOWN, 1);
            bs = down;
            down = level.m_8055_(pos.m_7495_());
            if (pos.m_123342_() >= entity.m_20193_().m_141937_()) continue;
            return entity.m_20183_();
        }
        Block b = bs.m_60734_();
        if (entity.m_20069_() && !(entity instanceof AbstractDrownedEntityPirateRaider)) {
            while (!bs.m_60819_().m_76178_()) {
                pos.m_122178_(pos.m_123341_(), pos.m_123342_() + 1, pos.m_123343_());
                bs = level.m_8055_((BlockPos)pos);
            }
        } else if (b instanceof FenceBlock || b instanceof WallBlock || b instanceof AbstractBlockMinecoloniesDefault || bs.m_280555_() && !PathfindingUtils.canStandInSolidBlock(bs)) {
            VoxelShape shape = bs.m_60812_((BlockGetter)level, (BlockPos)pos);
            if (shape.m_83281_()) {
                return pos.m_7949_();
            }
            Vec3 relativePos = entity.m_20182_().m_82546_(shape.m_83216_((double)entity.m_146903_(), (double)entity.m_146904_(), (double)entity.m_146907_()).m_83215_().m_82399_());
            double dX = relativePos.f_82479_;
            double dZ = relativePos.f_82481_;
            if (Math.abs(dX) < Math.abs(dZ)) {
                pos.m_122178_(pos.m_123341_(), pos.m_123342_(), dZ < 0.0 ? pos.m_123343_() - 1 : pos.m_123343_() + 1);
            } else {
                pos.m_122178_(dX < 0.0 ? pos.m_123341_() - 1 : pos.m_123341_() + 1, pos.m_123342_(), pos.m_123343_());
            }
        }
        return pos.m_7949_();
    }

    private static boolean canStandInSolidBlock(BlockState state) {
        return state.m_60734_() instanceof DoorBlock || state.m_60734_() instanceof TrapDoorBlock || state.m_60734_() instanceof PanelBlock && (Boolean)state.m_61143_((Property)PanelBlock.OPEN) != false || !state.m_60734_().f_60439_.f_60884_;
    }

    public static void setLadderFacing(@NotNull LevelReader world, BlockPos pos, @NotNull PathPointExtended p) {
        BlockState state = world.m_8055_(pos);
        Block block = state.m_60734_();
        if (block instanceof VineBlock) {
            if (((Boolean)state.m_61143_((Property)VineBlock.f_57836_)).booleanValue()) {
                p.setLadderFacing(Direction.NORTH);
            } else if (((Boolean)state.m_61143_((Property)VineBlock.f_57837_)).booleanValue()) {
                p.setLadderFacing(Direction.EAST);
            } else if (((Boolean)state.m_61143_((Property)VineBlock.f_57834_)).booleanValue()) {
                p.setLadderFacing(Direction.SOUTH);
            } else if (((Boolean)state.m_61143_((Property)VineBlock.f_57835_)).booleanValue()) {
                p.setLadderFacing(Direction.WEST);
            }
        } else if (block instanceof LadderBlock) {
            p.setLadderFacing((Direction)state.m_61143_((Property)LadderBlock.f_54337_));
        } else {
            p.setLadderFacing(Direction.UP);
        }
    }

    public static boolean isLiquid(BlockState state) {
        return state.m_278721_() || !state.m_280555_() && !state.m_60819_().m_76178_();
    }

    public static boolean isWater(@NotNull BlockGetter world, BlockPos pos) {
        return PathfindingUtils.isWater(world, pos, null, null);
    }

    public static boolean isWater(@NotNull BlockGetter world, BlockPos pos, @Nullable BlockState pState, @Nullable FluidState pFluidState) {
        BlockState state = pState;
        if (state == null) {
            state = world.m_8055_(pos);
        }
        if (state.m_280296_()) {
            return false;
        }
        if (state.m_60734_() == Blocks.f_49990_) {
            return true;
        }
        FluidState fluidState = pFluidState;
        if (fluidState == null) {
            fluidState = state.m_60819_();
        }
        if (fluidState == empty || fluidState.m_76178_()) {
            return false;
        }
        if (state.m_60734_() instanceof TrapdoorBlock || state.m_60734_() instanceof PanelBlock && !((Boolean)state.m_61143_((Property)TrapdoorBlock.f_57514_)).booleanValue() && state.m_61143_((Property)TrapdoorBlock.f_57515_) == Half.TOP) {
            return false;
        }
        Fluid fluid = fluidState.m_76152_();
        return fluid == Fluids.f_76193_ || fluid == Fluids.f_76192_;
    }

    public static boolean isLava(@NotNull BlockGetter world, BlockPos pos, @Nullable BlockState pState, @Nullable FluidState pFluidState) {
        BlockState state = pState;
        if (state == null) {
            state = world.m_8055_(pos);
        }
        if (state.m_60734_() == Blocks.f_49991_) {
            return true;
        }
        FluidState fluidState = pFluidState;
        if (fluidState == null) {
            fluidState = world.m_6425_(pos);
        }
        if (fluidState == empty || fluidState.m_76178_()) {
            return false;
        }
        Fluid fluid = fluidState.m_76152_();
        return fluid == Fluids.f_76195_ || fluid == Fluids.f_76194_;
    }

    public static boolean isLadder(BlockState blockState, @Nullable PathingOptions options) {
        if (options != null && options.canWalkUnderWater() && PathfindingUtils.isLiquid(blockState)) {
            return true;
        }
        return blockState.m_204336_(BlockTags.f_13082_) && (options != null && options.canClimbAdvanced() || blockState.m_60734_() instanceof LadderBlock || blockState.m_204336_(ModTags.freeClimbBlocks));
    }

    public static boolean isDangerous(BlockState blockState) {
        Block block = blockState.m_60734_();
        return blockState.m_204336_(ModTags.dangerousBlocks) || block instanceof FireBlock || block instanceof CampfireBlock || block instanceof MagmaBlock || block instanceof SweetBerryBushBlock || block instanceof PowderSnowBlock;
    }

    public static boolean hasAnyCollisionAlong(int startX, int startY, int startZ, int endX, int endY, int endZ, CachingBlockLookup blockLookup) {
        int x = startX;
        int y = startY;
        int z = startZ;
        int dx = Math.abs(endX - startX);
        int dy = Math.abs(endY - startY);
        int dz = Math.abs(endZ - startZ);
        int stepX = endX > startX ? 1 : -1;
        int stepY = endY > startY ? 1 : -1;
        int stepZ = endZ > startZ ? 1 : -1;
        double stepCostX = 1.0 / (double)dx;
        double stepCostY = 1.0 / (double)dy;
        double stepCostZ = 1.0 / (double)dz;
        double stepCostSumX = dx == 0 ? Double.POSITIVE_INFINITY : 0.5 / (double)dx;
        double stepCostSumY = dy == 0 ? Double.POSITIVE_INFINITY : 0.5 / (double)dy;
        double stepCostSumZ = dz == 0 ? Double.POSITIVE_INFINITY : 0.5 / (double)dz;
        for (int i = 0; i < dx + dy + dz && (x != endX || y != endY || z != endZ); ++i) {
            if (ShapeUtil.hasCollision(blockLookup, x, y, z, blockLookup.getBlockState(x, y, z))) {
                return true;
            }
            if (PathfindingUtils.doubleEquals(stepCostSumX, stepCostSumY)) {
                if (ShapeUtil.hasCollision(blockLookup, x + stepX, y, z, blockLookup.getBlockState(x + stepX, y, z))) {
                    return true;
                }
                if (ShapeUtil.hasCollision(blockLookup, x + stepX, y + stepY, z, blockLookup.getBlockState(x + stepX, y + stepY, z))) {
                    return true;
                }
            }
            if (PathfindingUtils.doubleEquals(stepCostSumX, stepCostSumZ)) {
                if (ShapeUtil.hasCollision(blockLookup, x + stepX, y, z, blockLookup.getBlockState(x + stepX, y, z))) {
                    return true;
                }
                if (ShapeUtil.hasCollision(blockLookup, x + stepX, y, z + stepZ, blockLookup.getBlockState(x + stepX, y, z + stepZ))) {
                    return true;
                }
            }
            if (PathfindingUtils.doubleEquals(stepCostSumY, stepCostSumZ)) {
                if (ShapeUtil.hasCollision(blockLookup, x, y + stepY, z, blockLookup.getBlockState(x, y + stepY, z))) {
                    return true;
                }
                if (ShapeUtil.hasCollision(blockLookup, x, y + stepY, z + stepZ, blockLookup.getBlockState(x, y + stepY, z + stepZ))) {
                    return true;
                }
            }
            if (stepCostSumX < stepCostSumY) {
                if (stepCostSumX < stepCostSumZ) {
                    x += stepX;
                    stepCostSumX += stepCostX;
                    continue;
                }
                z += stepZ;
                stepCostSumZ += stepCostZ;
                continue;
            }
            if (stepCostSumY < stepCostSumZ) {
                y += stepY;
                stepCostSumY += stepCostY;
                continue;
            }
            z += stepZ;
            stepCostSumZ += stepCostZ;
        }
        return ShapeUtil.hasCollision(blockLookup, endX, endY, endZ, blockLookup.getBlockState(endX, endY, endZ));
    }

    private static boolean doubleEquals(double a, double b) {
        if (Double.isFinite(a) || Double.isFinite(b) || Double.isNaN(a) || Double.isNaN(b)) {
            return false;
        }
        return Math.abs(a - b) < 5.0E-6;
    }
}

