/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.entity.other;

import com.minecolonies.api.entity.ModEntities;
import com.minecolonies.api.util.EntityUtils;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;

public class SittingEntity
extends Entity {
    int maxLifeTime = 100;
    private BlockPos sittingpos = BlockPos.f_121853_;

    public SittingEntity(EntityType<?> type, Level worldIn) {
        super(type, worldIn);
        this.m_6842_(true);
        this.f_19794_ = true;
        this.m_20242_(true);
    }

    public SittingEntity(EntityType<?> type, Level worldIn, double x, double y, double z, int lifeTime) {
        super(type, worldIn);
        this.m_6034_(x, y, z);
        this.m_6842_(true);
        this.f_19794_ = true;
        this.m_20242_(true);
        this.maxLifeTime = lifeTime;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        return false;
    }

    public boolean m_6087_() {
        return false;
    }

    protected void m_7378_(CompoundTag compound) {
    }

    protected void m_7380_(CompoundTag compound) {
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void m_8097_() {
    }

    public void m_8119_() {
        if (this.f_19853_.f_46443_) {
            return;
        }
        if (!this.m_20160_() || this.maxLifeTime-- < 0) {
            if (this.m_20197_().size() > 0) {
                this.m_20153_();
            }
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    protected void m_20348_(Entity passenger) {
        super.m_20348_(passenger);
        if (this.f_19853_.f_46443_) {
            return;
        }
        passenger.f_19815_ = passenger.f_19815_.m_20390_(1.0f, 0.5f);
    }

    protected void m_20351_(Entity passenger) {
        super.m_20351_(passenger);
        if (this.f_19853_.f_46443_) {
            return;
        }
        if (passenger instanceof LivingEntity) {
            passenger.f_19815_ = ((LivingEntity)passenger).m_6162_() ? passenger.m_6095_().m_20680_().m_20388_(0.5f) : passenger.m_6095_().m_20680_();
        }
    }

    @NotNull
    public Vec3 m_7688_(@NotNull LivingEntity passenger) {
        BlockPos start = this.sittingpos == BlockPos.f_121853_ ? this.m_20183_().m_7494_() : this.sittingpos;
        BlockPos spawn = EntityUtils.getSpawnPoint(this.f_19853_, start);
        if (spawn == null) {
            return super.m_7688_(passenger);
        }
        return new Vec3((double)spawn.m_123341_() + 0.5, (double)spawn.m_123342_() + 0.2, (double)spawn.m_123343_() + 0.5);
    }

    public void setMaxLifeTime(int maxLifeTime) {
        this.maxLifeTime = maxLifeTime;
    }

    public void setSittingPos(BlockPos pos) {
        this.sittingpos = pos;
    }

    public static void sitDown(BlockPos pos, Mob entity, int maxLifeTime) {
        if (entity.m_20202_() != null) {
            return;
        }
        SittingEntity sittingEntity = (SittingEntity)ModEntities.SITTINGENTITY.m_20615_(entity.f_19853_);
        BlockState state = entity.f_19853_.m_8055_(pos);
        double minY = 1.0;
        List shapes = state.m_60812_((BlockGetter)entity.f_19853_, pos).m_83299_();
        for (AABB box : shapes) {
            if (!(box.f_82292_ < minY)) continue;
            minY = box.f_82292_;
        }
        if (shapes.isEmpty()) {
            minY = 0.0;
        }
        sittingEntity.m_6034_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + minY - (double)(entity.m_20206_() / 2.0f), (double)pos.m_123343_() + 0.5);
        sittingEntity.setMaxLifeTime(maxLifeTime);
        sittingEntity.setSittingPos(pos);
        entity.f_19853_.m_7967_((Entity)sittingEntity);
        entity.m_20329_((Entity)sittingEntity);
        entity.m_21573_().m_26573_();
    }
}

