/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.entity.ai.workers.service;

import com.minecolonies.api.advancements.AdvancementTriggers;
import com.minecolonies.api.colony.GraveData;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.entity.ai.statemachine.AITarget;
import com.minecolonies.api.entity.ai.statemachine.states.AIWorkerState;
import com.minecolonies.api.entity.ai.statemachine.states.IAIState;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.entity.citizen.Skill;
import com.minecolonies.api.entity.citizen.VisibleCitizenStatus;
import com.minecolonies.api.equipment.ModEquipmentTypes;
import com.minecolonies.api.equipment.registry.EquipmentTypeEntry;
import com.minecolonies.api.research.util.ResearchConstants;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.MessageUtils;
import com.minecolonies.api.util.Tuple;
import com.minecolonies.api.util.constant.UndertakerConstants;
import com.minecolonies.core.Network;
import com.minecolonies.core.colony.buildings.modules.GraveyardManagementModule;
import com.minecolonies.core.colony.buildings.workerbuildings.BuildingGraveyard;
import com.minecolonies.core.colony.jobs.JobUndertaker;
import com.minecolonies.core.entity.ai.workers.AbstractEntityAIInteract;
import com.minecolonies.core.entity.pathfinding.navigation.EntityNavigationUtils;
import com.minecolonies.core.network.messages.client.VanillaParticleMessage;
import com.minecolonies.core.tileentities.TileEntityGrave;
import com.minecolonies.core.util.AdvancementUtils;
import com.minecolonies.core.util.citizenutils.CitizenItemUtils;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityAIWorkUndertaker
extends AbstractEntityAIInteract<JobUndertaker, BuildingGraveyard> {
    private Random random = new Random();
    private int effortCounter = 0;
    private boolean shouldDumpInventory = false;
    private BlockPos wanderPos = null;
    private Tuple<BlockPos, Direction> burialPos = null;

    public EntityAIWorkUndertaker(@NotNull JobUndertaker job) {
        super(job);
        super.registerTargets(new AITarget<AIWorkerState>(AIWorkerState.IDLE, AIWorkerState.START_WORKING, 60), new AITarget<Object>(AIWorkerState.START_WORKING, this::startWorking, 5), new AITarget<Object>(AIWorkerState.WANDER, this::wander, 5), new AITarget<Object>(AIWorkerState.EMPTY_GRAVE, this::emptyGrave, 5), new AITarget<Object>(AIWorkerState.TRY_RESURRECT, this::tryResurrect, 5), new AITarget<Object>(AIWorkerState.DIG_GRAVE, this::digGrave, 5), new AITarget<Object>(AIWorkerState.BURY_CITIZEN, this::buryCitizen, 5));
        this.worker.m_21553_(true);
    }

    @Override
    public Class<BuildingGraveyard> getExpectedBuildingClass() {
        return BuildingGraveyard.class;
    }

    @NotNull
    private IAIState startWorking() {
        this.worker.getCitizenData().setVisibleStatus(VisibleCitizenStatus.WORKING);
        this.worker.getCitizenData().setIdleAtJob(false);
        @Nullable BlockPos currentGrave = ((BuildingGraveyard)this.building).getGraveToWorkOn();
        if (currentGrave != null) {
            if (!this.walkToBuilding()) {
                return this.getState();
            }
            BlockEntity entity = this.world.m_7702_(currentGrave);
            if (entity instanceof TileEntityGrave) {
                return AIWorkerState.EMPTY_GRAVE;
            }
            ((BuildingGraveyard)this.building).ClearCurrentGrave();
        }
        return AIWorkerState.WANDER;
    }

    @NotNull
    private IAIState wander() {
        if (this.worker.getNavigation().m_26571_()) {
            if (((BuildingGraveyard)this.building).isInBuilding(this.worker.m_20183_())) {
                EntityNavigationUtils.walkToRandomPosWithin(this.worker, 10, 0.6, ((BuildingGraveyard)this.building).getCorners());
            } else {
                this.walkToBuilding();
            }
        }
        return AIWorkerState.IDLE;
    }

    private IAIState emptyGrave() {
        @Nullable BuildingGraveyard buildingGraveyard = (BuildingGraveyard)this.building;
        if (buildingGraveyard == null || this.checkForToolOrWeapon((EquipmentTypeEntry)ModEquipmentTypes.shovel.get()) || buildingGraveyard.getGraveToWorkOn() == null) {
            return AIWorkerState.IDLE;
        }
        this.worker.getCitizenData().setVisibleStatus(UndertakerConstants.EMPTYING_ICON);
        this.worker.m_6858_(this.worker.getCitizenColonyHandler().getColonyOrRegister().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.UNDERTAKER_RUN) > 0.0);
        this.unequip();
        @Nullable BlockPos gravePos = buildingGraveyard.getGraveToWorkOn();
        if (this.walkWithProxy(gravePos, 3)) {
            return this.getState();
        }
        BlockEntity entity = this.world.m_7702_(gravePos);
        if (entity instanceof TileEntityGrave) {
            if (((TileEntityGrave)entity).isEmpty()) {
                return AIWorkerState.TRY_RESURRECT;
            }
            if (this.worker.getInventoryCitizen().isFull()) {
                return AIWorkerState.INVENTORY_FULL;
            }
            if (this.effortCounter < 100) {
                this.worker.m_6674_(InteractionHand.MAIN_HAND);
                this.effortCounter += this.getPrimarySkillLevel();
                return this.getState();
            }
            this.effortCounter = 0;
            if (InventoryUtils.transferAllItemHandler((IItemHandler)((TileEntityGrave)entity).getInventory(), (IItemHandler)this.worker.getInventoryCitizen())) {
                return AIWorkerState.TRY_RESURRECT;
            }
        }
        return AIWorkerState.IDLE;
    }

    private IAIState digGrave() {
        @Nullable BuildingGraveyard buildingGraveyard = (BuildingGraveyard)this.building;
        if (this.checkForToolOrWeapon((EquipmentTypeEntry)ModEquipmentTypes.shovel.get()) || buildingGraveyard.getGraveToWorkOn() == null) {
            return AIWorkerState.IDLE;
        }
        this.worker.getCitizenData().setVisibleStatus(UndertakerConstants.DIGGING_ICON);
        this.worker.m_6858_(this.worker.getCitizenColonyHandler().getColonyOrRegister().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.UNDERTAKER_RUN) > 0.0);
        @Nullable BlockPos gravePos = buildingGraveyard.getGraveToWorkOn();
        if (gravePos == null) {
            return AIWorkerState.IDLE;
        }
        if (this.walkWithProxy(gravePos, 3)) {
            return this.getState();
        }
        this.worker.m_6858_(false);
        BlockEntity entity = this.world.m_7702_(gravePos);
        if (entity instanceof TileEntityGrave) {
            if (!this.digIfAble(gravePos, entity)) {
                return this.getState();
            }
            this.worker.decreaseSaturationForAction();
            this.worker.getCitizenData().getCitizenSkillHandler().addXpToSkill(this.getModuleForJob().getPrimarySkill(), 7.5, this.worker.getCitizenData());
            return AIWorkerState.BURY_CITIZEN;
        }
        return AIWorkerState.IDLE;
    }

    private boolean digIfAble(BlockPos position, BlockEntity entity) {
        if (!this.checkForToolOrWeapon((EquipmentTypeEntry)ModEquipmentTypes.shovel.get())) {
            this.equipShovel();
            GraveData graveData = (GraveData)((TileEntityGrave)entity).getGraveData();
            if (this.mineBlock(position)) {
                this.worker.decreaseSaturationForContinuousAction();
                ((BuildingGraveyard)this.building).ClearCurrentGrave();
                ((GraveyardManagementModule)((BuildingGraveyard)this.building).getFirstModuleOccurance(GraveyardManagementModule.class)).setLastGraveData(graveData);
                return true;
            }
        }
        return false;
    }

    private IAIState tryResurrect() {
        @Nullable BuildingGraveyard buildingGraveyard = (BuildingGraveyard)this.building;
        if (this.checkForToolOrWeapon((EquipmentTypeEntry)ModEquipmentTypes.shovel.get()) || buildingGraveyard.getGraveToWorkOn() == null) {
            return AIWorkerState.IDLE;
        }
        this.unequip();
        @Nullable BlockPos gravePos = buildingGraveyard.getGraveToWorkOn();
        if (gravePos == null) {
            return AIWorkerState.IDLE;
        }
        if (this.walkWithProxy(gravePos, 3)) {
            return this.getState();
        }
        BlockEntity entity = this.world.m_7702_(gravePos);
        if (entity instanceof TileEntityGrave) {
            if (this.effortCounter < 400) {
                this.worker.m_21563_().m_24950_((double)gravePos.m_123341_(), (double)gravePos.m_123342_(), (double)gravePos.m_123343_(), 10.0f, (float)this.worker.m_8132_());
                this.worker.m_6674_(InteractionHand.MAIN_HAND);
                Network.getNetwork().sendToTrackingEntity(new VanillaParticleMessage((float)gravePos.m_123341_() + 0.5f, (float)gravePos.m_123342_() + 0.05f, (float)gravePos.m_123343_() + 0.5f, ParticleTypes.f_123809_), (Entity)this.worker);
                this.effortCounter += this.getSecondarySkillLevel();
                return this.getState();
            }
            this.effortCounter = 0;
            this.shouldDumpInventory = true;
            double chance = this.getResurrectChance(buildingGraveyard);
            if (this.getTotemResurrectChance() > 0.0 && this.random.nextDouble() <= 0.01) {
                this.worker.getInventoryCitizen().extractItem(InventoryUtils.findFirstSlotInItemHandlerWith((IItemHandler)this.worker.getInventoryCitizen(), Items.f_42747_), 1, false);
                this.worker.m_5496_(SoundEvents.f_12513_, 1.0f, 1.0f);
            }
            if (chance >= this.random.nextDouble()) {
                Network.getNetwork().sendToTrackingEntity(new VanillaParticleMessage((float)gravePos.m_123341_() + 0.5f, (float)gravePos.m_123342_() + 0.05f, (float)gravePos.m_123343_() + 0.5f, ParticleTypes.f_123750_), (Entity)this.worker);
                GraveData graveData = (GraveData)((TileEntityGrave)entity).getGraveData();
                ICitizenData citizenData = buildingGraveyard.getColony().getCitizenManager().resurrectCivilianData(graveData.getCitizenDataNBT(), true, this.world, gravePos);
                MessageUtils.format("com.minecolonies.coremod.resurrect", citizenData.getName()).sendTo(buildingGraveyard.getColony()).forManagers();
                this.worker.getCitizenColonyHandler().getColonyOrRegister().getCitizenManager().updateCitizenMourn(citizenData, false);
                AdvancementUtils.TriggerAdvancementPlayersForColony(this.worker.getCitizenColonyHandler().getColonyOrRegister(), playerMP -> AdvancementTriggers.CITIZEN_RESURRECT.trigger((ServerPlayer)playerMP));
                ((GraveyardManagementModule)buildingGraveyard.getFirstModuleOccurance(GraveyardManagementModule.class)).setLastGraveData(null);
                this.world.m_46597_(gravePos, Blocks.f_50016_.m_49966_());
                return AIWorkerState.INVENTORY_FULL;
            }
        }
        return AIWorkerState.DIG_GRAVE;
    }

    private double getResurrectChance(@NotNull BuildingGraveyard buildingGraveyard) {
        double cap;
        double totemChance = this.getTotemResurrectChance();
        double chance = (double)buildingGraveyard.getBuildingLevel() * 0.005 + (double)this.worker.getCitizenData().getCitizenSkillHandler().getLevel(Skill.Mana) * 0.00125 + this.worker.getCitizenColonyHandler().getColonyOrRegister().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.RESURRECT_CHANCE) + totemChance;
        if (chance > (cap = 0.025 + (double)this.worker.getCitizenColonyHandler().getColonyOrRegister().getBuildingManager().getMysticalSiteMaxBuildingLevel() * 0.005 + totemChance)) {
            chance = cap;
        }
        return chance;
    }

    private double getTotemResurrectChance() {
        if (this.worker.getCitizenColonyHandler().getColonyOrRegister().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.USE_TOTEM) > 0.0) {
            int totems = InventoryUtils.getItemCountInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), Items.f_42747_);
            if (totems > 0) {
                AdvancementUtils.TriggerAdvancementPlayersForColony(this.worker.getCitizenColonyHandler().getColonyOrRegister(), AdvancementTriggers.UNDERTAKER_TOTEM::trigger);
            }
            if (totems == 1) {
                return 0.05;
            }
            if (totems > 1) {
                return 0.075;
            }
        }
        return 0.0;
    }

    private IAIState buryCitizen() {
        @Nullable BuildingGraveyard buildingGraveyard = (BuildingGraveyard)this.building;
        GraveyardManagementModule module = (GraveyardManagementModule)buildingGraveyard.getFirstModuleOccurance(GraveyardManagementModule.class);
        if (this.checkForToolOrWeapon((EquipmentTypeEntry)ModEquipmentTypes.shovel.get()) || module.getLastGraveData() == null) {
            return AIWorkerState.IDLE;
        }
        this.worker.getCitizenData().setVisibleStatus(UndertakerConstants.BURYING_ICON);
        if (this.burialPos == null || !this.world.m_8055_(this.burialPos.getA()).m_247087_()) {
            this.burialPos = ((BuildingGraveyard)this.building).getRandomFreeVisualGravePos();
        }
        if (this.burialPos == null || this.burialPos.getA() == null) {
            MessageUtils.forCitizen(this.worker, (Component)Component.m_237110_((String)"com.minecolonies.coremod.nospaceforgrave", (Object[])new Object[]{module.getLastGraveData().getCitizenName()})).sendTo(this.worker.getCitizenColonyHandler().getColonyOrRegister().getMessagePlayerEntities());
            return AIWorkerState.IDLE;
        }
        if (this.walkWithProxy(this.burialPos.getA(), 4)) {
            return this.getState();
        }
        if (this.effortCounter < 400) {
            this.equipShovel();
            CitizenItemUtils.hitBlockWithToolInHand(this.worker, this.burialPos.getA(), false);
            this.effortCounter += this.getPrimarySkillLevel();
            return this.getState();
        }
        this.effortCounter = 0;
        this.unequip();
        module.buryCitizenHere(this.burialPos, this.worker);
        AdvancementUtils.TriggerAdvancementPlayersForColony(this.worker.getCitizenColonyHandler().getColonyOrRegister(), playerMP -> AdvancementTriggers.CITIZEN_BURY.trigger((ServerPlayer)playerMP));
        module.setLastGraveData(null);
        this.burialPos = null;
        this.shouldDumpInventory = true;
        return AIWorkerState.INVENTORY_FULL;
    }

    @Override
    protected boolean wantInventoryDumped() {
        if (this.shouldDumpInventory) {
            this.shouldDumpInventory = false;
            return true;
        }
        return false;
    }

    private void equipShovel() {
        CitizenItemUtils.setHeldItem(this.worker, InteractionHand.MAIN_HAND, this.getShovelSlot());
    }

    private void unequip() {
        CitizenItemUtils.removeHeldItem(this.worker);
    }

    private int getShovelSlot() {
        return InventoryUtils.getFirstSlotOfItemHandlerContainingEquipment((IItemHandler)this.getInventory(), (EquipmentTypeEntry)ModEquipmentTypes.shovel.get(), 0, ((BuildingGraveyard)this.building).getMaxEquipmentLevel());
    }

    @Nullable
    public AbstractEntityCitizen getCitizen() {
        return this.worker;
    }
}

