/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.entity.ai.workers.crafting;

import com.google.common.collect.ImmutableList;
import com.google.common.reflect.TypeToken;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.interactionhandling.ChatPriority;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.colony.requestsystem.request.RequestState;
import com.minecolonies.api.colony.requestsystem.requestable.StackList;
import com.minecolonies.api.colony.requestsystem.requestable.crafting.PublicCrafting;
import com.minecolonies.api.crafting.IRecipeStorage;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.entity.ai.statemachine.AIEventTarget;
import com.minecolonies.api.entity.ai.statemachine.AITarget;
import com.minecolonies.api.entity.ai.statemachine.states.AIBlockingEventType;
import com.minecolonies.api.entity.ai.statemachine.states.AIWorkerState;
import com.minecolonies.api.entity.ai.statemachine.states.IAIState;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.Tuple;
import com.minecolonies.api.util.WorldUtil;
import com.minecolonies.core.colony.buildings.AbstractBuilding;
import com.minecolonies.core.colony.buildings.modules.FurnaceUserModule;
import com.minecolonies.core.colony.buildings.modules.ItemListModule;
import com.minecolonies.core.colony.interactionhandling.StandardInteraction;
import com.minecolonies.core.colony.jobs.AbstractJobCrafter;
import com.minecolonies.core.entity.ai.workers.crafting.AbstractEntityAICrafting;
import com.minecolonies.core.util.citizenutils.CitizenItemUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FurnaceBlock;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.FurnaceBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractEntityAIRequestSmelter<J extends AbstractJobCrafter<?, J>, B extends AbstractBuilding>
extends AbstractEntityAICrafting<J, B> {
    private static final double BASE_XP_GAIN = 5.0;
    private BlockPos fuelPos = null;
    private IAIState preFuelState = null;

    public AbstractEntityAIRequestSmelter(@NotNull J smelteryJob) {
        super(smelteryJob);
        super.registerTargets(new AIEventTarget<Supplier<Object>>(AIBlockingEventType.EVENT, this::isFuelNeeded, this::checkFurnaceFuel, 200), new AIEventTarget<Supplier<Object>>(AIBlockingEventType.EVENT, this::accelerateFurnaces, this::getState, 20), new AITarget<Object>(AIWorkerState.START_USING_FURNACE, this::fillUpFurnace, 20), new AITarget<Object>(AIWorkerState.RETRIEVING_END_PRODUCT_FROM_FURNACE, this::retrieveSmeltableFromFurnace, 20), new AITarget<Object>(AIWorkerState.RETRIEVING_USED_FUEL_FROM_FURNACE, this::retrieveUsedFuel, 20), new AITarget<Object>(AIWorkerState.ADD_FUEL_TO_FURNACE, this::addFuelToFurnace, 20));
    }

    @Override
    protected int getExtendedCount(ItemStack stack) {
        if (this.currentRecipeStorage != null && this.currentRecipeStorage.getIntermediate() == Blocks.f_50094_) {
            int count = 0;
            for (BlockPos pos : ((FurnaceUserModule)this.building.getFirstModuleOccurance(FurnaceUserModule.class)).getFurnaces()) {
                BlockEntity entity;
                if (!WorldUtil.isBlockLoaded((LevelAccessor)this.world, pos) || !((entity = this.world.m_7702_(pos)) instanceof FurnaceBlockEntity)) continue;
                FurnaceBlockEntity furnace = (FurnaceBlockEntity)entity;
                ItemStack smeltableSlot = furnace.m_8020_(0);
                ItemStack resultSlot = furnace.m_8020_(2);
                if (ItemStackUtils.compareItemStacksIgnoreStackSize(stack, smeltableSlot).booleanValue()) {
                    count += smeltableSlot.m_41613_();
                    continue;
                }
                if (!ItemStackUtils.compareItemStacksIgnoreStackSize(stack, resultSlot).booleanValue()) continue;
                count += resultSlot.m_41613_();
            }
            return count;
        }
        return 0;
    }

    @Override
    protected IAIState getRecipe() {
        IRequest currentTask = ((AbstractJobCrafter)this.job).getCurrentTask();
        if (currentTask == null) {
            this.worker.m_21008_(InteractionHand.MAIN_HAND, ItemStackUtils.EMPTY);
            return AIWorkerState.START_WORKING;
        }
        ((AbstractJobCrafter)this.job).setMaxCraftingCount(((PublicCrafting)currentTask.getRequest()).getCount());
        BlockPos furnacePosWithUsedFuel = this.getPositionOfOvenToRetrieveFuelFrom();
        if (furnacePosWithUsedFuel != null) {
            this.currentRequest = currentTask;
            this.walkTo = furnacePosWithUsedFuel;
            return AIWorkerState.RETRIEVING_USED_FUEL_FROM_FURNACE;
        }
        BlockPos furnacePos = this.getPositionOfOvenToRetrieveFrom();
        if (furnacePos != null) {
            this.currentRequest = currentTask;
            this.walkTo = furnacePos;
            return AIWorkerState.RETRIEVING_END_PRODUCT_FROM_FURNACE;
        }
        if (this.currentRecipeStorage != null && this.currentRecipeStorage.getIntermediate() == Blocks.f_50094_) {
            for (BlockPos pos : ((FurnaceUserModule)this.building.getFirstModuleOccurance(FurnaceUserModule.class)).getFurnaces()) {
                FurnaceBlockEntity furnace;
                BlockEntity entity = this.world.m_7702_(pos);
                if (!(entity instanceof FurnaceBlockEntity) || !(furnace = (FurnaceBlockEntity)entity).m_58425_() && ItemStackUtils.isEmpty(furnace.m_8020_(2)) && ItemStackUtils.isEmpty(furnace.m_8020_(0))) continue;
                if (furnace.m_58425_()) {
                    this.setDelay(20);
                }
                return AIWorkerState.CRAFT;
            }
        }
        IAIState newState = super.getRecipe();
        ItemListModule module = (ItemListModule)this.building.getModuleMatching(ItemListModule.class, m -> m.getId().equals("fuel"));
        if (newState == AIWorkerState.QUERY_ITEMS && this.currentRecipeStorage != null && module.isItemInList(new ItemStorage(this.currentRecipeStorage.getPrimaryOutput()))) {
            ((AbstractJobCrafter)this.job).setCraftCounter(0);
        }
        return newState;
    }

    private int countOfBurningFurnaces() {
        int count = 0;
        Level world = this.building.getColony().getWorld();
        for (BlockPos pos : ((FurnaceUserModule)this.building.getFirstModuleOccurance(FurnaceUserModule.class)).getFurnaces()) {
            FurnaceBlockEntity furnace;
            BlockEntity entity;
            if (!WorldUtil.isBlockLoaded((LevelAccessor)world, pos) || !((entity = world.m_7702_(pos)) instanceof FurnaceBlockEntity) || !(furnace = (FurnaceBlockEntity)entity).m_58425_()) continue;
            ++count;
        }
        return count;
    }

    private boolean accelerateFurnaces() {
        int accelerationTicks = this.worker.getCitizenData().getCitizenSkillHandler().getLevel(this.getModuleForJob().getSecondarySkill()) / 10 * 2;
        Level world = this.building.getColony().getWorld();
        for (BlockPos pos : ((FurnaceUserModule)this.building.getFirstModuleOccurance(FurnaceUserModule.class)).getFurnaces()) {
            BlockEntity entity;
            if (!WorldUtil.isBlockLoaded((LevelAccessor)world, pos) || !((entity = world.m_7702_(pos)) instanceof FurnaceBlockEntity)) continue;
            FurnaceBlockEntity furnace = (FurnaceBlockEntity)entity;
            for (int i = 0; i < accelerationTicks; ++i) {
                if (!furnace.m_58425_()) continue;
                FurnaceBlockEntity.m_155013_((Level)entity.m_58904_(), (BlockPos)entity.m_58899_(), (BlockState)entity.m_58900_(), (AbstractFurnaceBlockEntity)furnace);
            }
        }
        return false;
    }

    private List<ItemStack> getActivePossibleFuels() {
        List<ItemStack> possibleFuels = this.getAllowedFuel();
        if (possibleFuels.isEmpty()) {
            if (this.worker.getCitizenData() != null) {
                this.worker.getCitizenData().triggerInteraction(new StandardInteraction((Component)Component.m_237115_((String)"com.minecolonies.coremod.furnaceuser.nofuel"), ChatPriority.IMPORTANT));
            }
            return ImmutableList.of();
        }
        if (this.currentRecipeStorage != null) {
            possibleFuels.removeIf(stack -> ItemStackUtils.compareItemStacksIgnoreStackSize(stack, this.currentRecipeStorage.getPrimaryOutput()));
            possibleFuels.removeIf(stack -> ItemStackUtils.compareItemStacksIgnoreStackSize(stack, this.currentRecipeStorage.getCleanedInput().get(0).getItemStack()));
        }
        return possibleFuels;
    }

    private boolean isFuelNeeded() {
        FurnaceUserModule module = (FurnaceUserModule)this.building.getFirstModuleOccurance(FurnaceUserModule.class);
        for (BlockPos pos : module.getFurnaces()) {
            if (!WorldUtil.isBlockLoaded((LevelAccessor)this.world, pos)) continue;
            BlockEntity entity = this.world.m_7702_(pos);
            if (!(entity instanceof FurnaceBlockEntity)) {
                module.removeFromFurnaces(pos);
                continue;
            }
            FurnaceBlockEntity furnace = (FurnaceBlockEntity)entity;
            if (furnace.m_58425_() || !ItemStackUtils.hasSmeltableInFurnaceAndNoFuel(furnace) && !ItemStackUtils.hasNeitherFuelNorSmeltAble(furnace) || this.currentRecipeStorage == null || this.currentRecipeStorage.getIntermediate() != Blocks.f_50094_) continue;
            return this.getState() != AIWorkerState.GATHERING_REQUIRED_MATERIALS;
        }
        return false;
    }

    private static Predicate<ItemStack> isCorrectFuel(List<ItemStack> possibleFuels) {
        return item -> ItemStackUtils.compareItemStackListIgnoreStackSize(possibleFuels, item);
    }

    private IAIState checkFurnaceFuel() {
        Level world = this.building.getColony().getWorld();
        List<ItemStack> possibleFuels = this.getActivePossibleFuels();
        FurnaceUserModule module = (FurnaceUserModule)this.building.getFirstModuleOccurance(FurnaceUserModule.class);
        if (!(InventoryUtils.hasItemInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), AbstractEntityAIRequestSmelter.isCorrectFuel(possibleFuels)) || InventoryUtils.hasItemInProvider((ICapabilityProvider)this.building, AbstractEntityAIRequestSmelter.isCorrectFuel(possibleFuels)) || this.building.hasWorkerOpenRequestsOfType(this.worker.getCitizenData().getId(), TypeToken.of(StackList.class)) || this.currentRecipeStorage == null || this.currentRecipeStorage.getIntermediate() != Blocks.f_50094_)) {
            this.worker.getCitizenData().createRequestAsync(new StackList(possibleFuels, "com.minecolonies.coremod.request.burnable", 64 * module.getFurnaces().size(), 1));
            return this.getState();
        }
        for (BlockPos pos : module.getFurnaces()) {
            FurnaceBlockEntity furnace;
            BlockEntity entity;
            if (!WorldUtil.isBlockLoaded((LevelAccessor)world, pos) || !((entity = world.m_7702_(pos)) instanceof FurnaceBlockEntity) || (furnace = (FurnaceBlockEntity)entity).m_58425_() || !ItemStackUtils.hasSmeltableInFurnaceAndNoFuel(furnace) && !ItemStackUtils.hasNeitherFuelNorSmeltAble(furnace) || this.currentRecipeStorage == null || this.currentRecipeStorage.getIntermediate() != Blocks.f_50094_) continue;
            if (!InventoryUtils.hasItemInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), AbstractEntityAIRequestSmelter.isCorrectFuel(possibleFuels))) {
                if (InventoryUtils.hasItemInProvider((ICapabilityProvider)this.building, AbstractEntityAIRequestSmelter.isCorrectFuel(possibleFuels))) {
                    this.needsCurrently = new Tuple<Predicate<ItemStack>, Integer>(AbstractEntityAIRequestSmelter.isCorrectFuel(possibleFuels), 64);
                    this.walkTo = null;
                    return AIWorkerState.GATHERING_REQUIRED_MATERIALS;
                }
                return this.getState();
            }
            this.fuelPos = pos;
            if (this.preFuelState == null) {
                this.preFuelState = this.getState();
            }
            return AIWorkerState.ADD_FUEL_TO_FURNACE;
        }
        return this.getState();
    }

    private IAIState addFuelToFurnace() {
        BlockEntity entity;
        List<ItemStack> possibleFuels = this.getActivePossibleFuels();
        if (!InventoryUtils.hasItemInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), AbstractEntityAIRequestSmelter.isCorrectFuel(possibleFuels))) {
            if (InventoryUtils.hasItemInProvider((ICapabilityProvider)this.building, AbstractEntityAIRequestSmelter.isCorrectFuel(possibleFuels))) {
                this.needsCurrently = new Tuple<Predicate<ItemStack>, Integer>(AbstractEntityAIRequestSmelter.isCorrectFuel(possibleFuels), 64);
                return AIWorkerState.GATHERING_REQUIRED_MATERIALS;
            }
            this.preFuelState = null;
            this.fuelPos = null;
            return AIWorkerState.START_WORKING;
        }
        if (this.fuelPos == null || !this.walkToWorkPos(this.fuelPos)) {
            return this.getState();
        }
        if (WorldUtil.isBlockLoaded((LevelAccessor)this.world, this.fuelPos) && (entity = this.world.m_7702_(this.fuelPos)) instanceof FurnaceBlockEntity) {
            FurnaceBlockEntity furnace = (FurnaceBlockEntity)entity;
            if (InventoryUtils.hasItemInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), AbstractEntityAIRequestSmelter.isCorrectFuel(possibleFuels)) && (ItemStackUtils.hasSmeltableInFurnaceAndNoFuel(furnace) || ItemStackUtils.hasNeitherFuelNorSmeltAble(furnace))) {
                InventoryUtils.transferXOfFirstSlotInItemHandlerWithIntoInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), AbstractEntityAIRequestSmelter.isCorrectFuel(possibleFuels), 64, (IItemHandler)new InvWrapper((Container)furnace), 1);
                if (this.preFuelState != null && this.preFuelState != AIWorkerState.ADD_FUEL_TO_FURNACE) {
                    IAIState returnState = this.preFuelState;
                    this.preFuelState = null;
                    this.fuelPos = null;
                    return returnState;
                }
            }
        }
        this.preFuelState = null;
        this.fuelPos = null;
        return AIWorkerState.START_WORKING;
    }

    private int getMaxUsableFurnaces() {
        int maxSkillFurnaces = this.worker.getCitizenData().getCitizenSkillHandler().getLevel(this.getModuleForJob().getPrimarySkill()) / 10 + 1;
        return Math.min(maxSkillFurnaces, ((FurnaceUserModule)this.building.getFirstModuleOccurance(FurnaceUserModule.class)).getFurnaces().size());
    }

    private BlockPos getPositionOfOvenToRetrieveFrom() {
        for (BlockPos pos : ((FurnaceUserModule)this.building.getFirstModuleOccurance(FurnaceUserModule.class)).getFurnaces()) {
            BlockEntity entity = this.world.m_7702_(pos);
            if (!(entity instanceof FurnaceBlockEntity)) continue;
            FurnaceBlockEntity furnace = (FurnaceBlockEntity)entity;
            int countInResultSlot = 0;
            boolean fullResult = false;
            if (!ItemStackUtils.isEmpty(furnace.m_8020_(2))) {
                countInResultSlot = furnace.m_8020_(2).m_41613_();
                boolean bl = fullResult = countInResultSlot >= furnace.m_8020_(2).m_41741_();
            }
            if (!fullResult && (furnace.m_58425_() || countInResultSlot <= 0 || !ItemStackUtils.isEmpty(furnace.m_8020_(0)))) continue;
            return pos;
        }
        return null;
    }

    protected BlockPos getPositionOfOvenToRetrieveFuelFrom() {
        for (BlockPos pos : ((FurnaceUserModule)this.building.getFirstModuleOccurance(FurnaceUserModule.class)).getFurnaces()) {
            FurnaceBlockEntity furnace;
            BlockEntity entity = this.world.m_7702_(pos);
            if (!(entity instanceof FurnaceBlockEntity) || (furnace = (FurnaceBlockEntity)entity).m_8020_(1).m_41619_() || ItemStackUtils.compareItemStackListIgnoreStackSize(this.getAllowedFuel(), furnace.m_8020_(1), false, false)) continue;
            return pos;
        }
        return null;
    }

    @Override
    protected IAIState checkForItems(@NotNull IRecipeStorage storage) {
        if (storage.getIntermediate() != Blocks.f_50094_) {
            return super.checkForItems(storage);
        }
        List<ItemStorage> input = storage.getCleanedInput();
        int countInFurnaces = this.getExtendedCount(storage.getPrimaryOutput());
        int outputInInv = InventoryUtils.getItemCountInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), stack -> ItemStackUtils.compareItemStacksIgnoreStackSize(stack, storage.getPrimaryOutput()));
        for (ItemStorage inputStorage : input) {
            int inputInInv;
            Predicate<ItemStack> predicate = stack -> !ItemStackUtils.isEmpty(stack) && ItemStackUtils.compareItemStacksIgnoreStackSize(stack, inputStorage.getItemStack()) != false;
            int inputInFurnace = this.getExtendedCount(inputStorage.getItemStack());
            if (countInFurnaces + inputInFurnace + (inputInInv = InventoryUtils.getItemCountInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), predicate)) + outputInInv < inputStorage.getAmount() * ((AbstractJobCrafter)this.job).getMaxCraftingCount() && InventoryUtils.hasItemInProvider((ICapabilityProvider)this.building, predicate)) {
                this.needsCurrently = new Tuple<Predicate<ItemStack>, Integer>(predicate, inputStorage.getAmount() * (((AbstractJobCrafter)this.job).getMaxCraftingCount() - countInFurnaces - inputInFurnace));
                return AIWorkerState.GATHERING_REQUIRED_MATERIALS;
            }
            int countOfInput = inputInInv + InventoryUtils.getCountFromBuilding((IBuilding)this.building, predicate) + countInFurnaces + inputInFurnace + outputInInv;
            if (countOfInput >= inputStorage.getAmount() * ((AbstractJobCrafter)this.job).getMaxCraftingCount()) continue;
            ((AbstractJobCrafter)this.job).finishRequest(false);
            this.resetValues();
        }
        return AIWorkerState.CRAFT;
    }

    private IAIState retrieveSmeltableFromFurnace() {
        if (this.walkTo == null || this.currentRequest == null) {
            return AIWorkerState.START_WORKING;
        }
        BlockEntity entity = this.world.m_7702_(this.walkTo);
        if (!(entity instanceof FurnaceBlockEntity) || ItemStackUtils.isEmpty(((FurnaceBlockEntity)entity).m_8020_(2))) {
            this.walkTo = null;
            return AIWorkerState.START_WORKING;
        }
        if (!this.walkToWorkPos(this.walkTo)) {
            return this.getState();
        }
        this.walkTo = null;
        int preExtractCount = InventoryUtils.getItemCountInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), stack -> ItemStackUtils.compareItemStacksIgnoreStackSize(((PublicCrafting)this.currentRequest.getRequest()).getStack(), stack));
        this.extractFromFurnaceSlot((FurnaceBlockEntity)entity, 2);
        int resultCount = InventoryUtils.getItemCountInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), stack -> ItemStackUtils.compareItemStacksIgnoreStackSize(((PublicCrafting)this.currentRequest.getRequest()).getStack(), stack)) - preExtractCount;
        if (resultCount > 0) {
            ItemStack stack2 = ((PublicCrafting)this.currentRequest.getRequest()).getStack().m_41777_();
            stack2.m_41764_(resultCount);
            this.currentRequest.addDelivery(stack2);
            ((AbstractJobCrafter)this.job).setCraftCounter(((AbstractJobCrafter)this.job).getCraftCounter() + resultCount);
            ((AbstractJobCrafter)this.job).setProgress(((AbstractJobCrafter)this.job).getProgress() - resultCount);
            if (((AbstractJobCrafter)this.job).getMaxCraftingCount() == 0) {
                ((AbstractJobCrafter)this.job).setMaxCraftingCount(((PublicCrafting)this.currentRequest.getRequest()).getCount());
            }
            if (((AbstractJobCrafter)this.job).getCraftCounter() >= ((AbstractJobCrafter)this.job).getMaxCraftingCount() && ((AbstractJobCrafter)this.job).getProgress() <= 0) {
                ((AbstractJobCrafter)this.job).finishRequest(true);
                this.resetValues();
                this.currentRecipeStorage = null;
                this.incrementActionsDoneAndDecSaturation();
                return AIWorkerState.INVENTORY_FULL;
            }
        }
        this.setDelay(5);
        return AIWorkerState.START_WORKING;
    }

    private IAIState retrieveUsedFuel() {
        if (this.walkTo == null) {
            return AIWorkerState.START_WORKING;
        }
        if (!this.walkToWorkPos(this.walkTo)) {
            return this.getState();
        }
        BlockEntity entity = this.world.m_7702_(this.walkTo);
        if (!(entity instanceof FurnaceBlockEntity) || ItemStackUtils.isEmpty(((FurnaceBlockEntity)entity).m_8020_(1))) {
            this.walkTo = null;
            return AIWorkerState.START_WORKING;
        }
        this.walkTo = null;
        this.extractFromFurnaceSlot((FurnaceBlockEntity)entity, 1);
        return AIWorkerState.START_WORKING;
    }

    private void extractFromFurnaceSlot(FurnaceBlockEntity furnace, int slot) {
        InventoryUtils.transferItemStackIntoNextFreeSlotInItemHandler((IItemHandler)new InvWrapper((Container)furnace), slot, (IItemHandler)this.worker.getInventoryCitizen());
        if (slot == 2) {
            this.worker.getCitizenExperienceHandler().addExperience(5.0);
        }
    }

    private IAIState checkIfAbleToSmelt() {
        int burning = this.countOfBurningFurnaces();
        if (burning > 0 && (burning >= this.getMaxUsableFurnaces() || ((AbstractJobCrafter)this.job).getCraftCounter() + ((AbstractJobCrafter)this.job).getProgress() >= ((AbstractJobCrafter)this.job).getMaxCraftingCount())) {
            this.setDelay(20);
            return this.getState();
        }
        FurnaceUserModule module = (FurnaceUserModule)this.building.getFirstModuleOccurance(FurnaceUserModule.class);
        for (BlockPos pos : module.getFurnaces()) {
            BlockEntity entity = this.world.m_7702_(pos);
            if (entity instanceof FurnaceBlockEntity) {
                if (!ItemStackUtils.isEmpty(((FurnaceBlockEntity)entity).m_8020_(0))) continue;
                this.walkTo = pos;
                return AIWorkerState.START_USING_FURNACE;
            }
            if (this.world.m_8055_(pos).m_60734_() instanceof FurnaceBlock) continue;
            module.removeFromFurnaces(pos);
        }
        if (burning > 0) {
            this.setDelay(20);
        }
        return this.getState();
    }

    /*
     * Enabled aggressive block sorting
     */
    private IAIState fillUpFurnace() {
        block13: {
            FurnaceUserModule module;
            block11: {
                int amountOfSmeltableInInv;
                int amountOfSmeltableInBuilding;
                int targetCount;
                Predicate<ItemStack> smeltable;
                block12: {
                    module = (FurnaceUserModule)this.building.getFirstModuleOccurance(FurnaceUserModule.class);
                    if (module.getFurnaces().isEmpty()) {
                        if (this.worker.getCitizenData() != null) {
                            this.worker.getCitizenData().triggerInteraction(new StandardInteraction((Component)Component.m_237115_((String)"com.minecolonies.coremod.bakery.nofurnace"), ChatPriority.BLOCKING));
                        }
                        this.setDelay(5);
                        return AIWorkerState.START_WORKING;
                    }
                    if (this.walkTo == null || this.world.m_8055_(this.walkTo).m_60734_() != Blocks.f_50094_) {
                        this.walkTo = null;
                        this.setDelay(5);
                        return AIWorkerState.START_WORKING;
                    }
                    int burningCount = this.countOfBurningFurnaces();
                    BlockEntity entity = this.world.m_7702_(this.walkTo);
                    if (!(entity instanceof FurnaceBlockEntity) || this.currentRecipeStorage == null) break block11;
                    FurnaceBlockEntity furnace = (FurnaceBlockEntity)entity;
                    int maxFurnaces = this.getMaxUsableFurnaces();
                    smeltable = stack -> ItemStackUtils.compareItemStacksIgnoreStackSize(this.currentRecipeStorage.getCleanedInput().get(0).getItemStack(), stack);
                    int smeltableInFurnaces = this.getExtendedCount(this.currentRecipeStorage.getCleanedInput().get(0).getItemStack());
                    int resultInFurnaces = this.getExtendedCount(this.currentRecipeStorage.getPrimaryOutput());
                    int resultInCitizenInv = InventoryUtils.getItemCountInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), stack -> ItemStackUtils.compareItemStacksIgnoreStackSize(stack, this.currentRecipeStorage.getPrimaryOutput()));
                    targetCount = ((PublicCrafting)this.currentRequest.getRequest()).getCount() - smeltableInFurnaces - resultInFurnaces - resultInCitizenInv;
                    if (targetCount <= 0) {
                        return AIWorkerState.START_WORKING;
                    }
                    amountOfSmeltableInBuilding = InventoryUtils.getCountFromBuilding((IBuilding)this.building, smeltable);
                    amountOfSmeltableInInv = InventoryUtils.getItemCountInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), smeltable);
                    if (this.worker.m_21120_(InteractionHand.MAIN_HAND).m_41619_()) {
                        this.worker.m_21008_(InteractionHand.MAIN_HAND, this.currentRecipeStorage.getCleanedInput().get(0).getItemStack().m_41777_());
                    }
                    if (amountOfSmeltableInInv <= 0) break block12;
                    if (ItemStackUtils.hasFuelInFurnaceAndNoSmeltable(furnace) || ItemStackUtils.hasNeitherFuelNorSmeltAble(furnace)) {
                        int toTransfer = 0;
                        if (burningCount < maxFurnaces) {
                            int availableFurnaces = maxFurnaces - burningCount;
                            toTransfer = targetCount > 64 * availableFurnaces ? 64 : Math.min(targetCount / availableFurnaces + targetCount % availableFurnaces, 64);
                        }
                        if (toTransfer > 0) {
                            if (!this.walkToWorkPos(this.walkTo)) {
                                return this.getState();
                            }
                            CitizenItemUtils.hitBlockWithToolInHand(this.worker, this.walkTo);
                            InventoryUtils.transferXInItemHandlerIntoSlotInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), smeltable, toTransfer, (IItemHandler)new InvWrapper((Container)furnace), 0);
                        }
                    }
                    break block13;
                }
                if (amountOfSmeltableInBuilding >= targetCount - amountOfSmeltableInInv && this.currentRecipeStorage.getIntermediate() == Blocks.f_50094_) {
                    this.needsCurrently = new Tuple<Predicate<ItemStack>, Integer>(smeltable, targetCount);
                    return AIWorkerState.GATHERING_REQUIRED_MATERIALS;
                }
                ((AbstractJobCrafter)this.job).finishRequest(false);
                this.resetValues();
                this.walkTo = null;
                return AIWorkerState.IDLE;
            }
            if (!(this.world.m_8055_(this.walkTo).m_60734_() instanceof FurnaceBlock)) {
                module.removeFromFurnaces(this.walkTo);
            }
        }
        this.walkTo = null;
        this.setDelay(5);
        return AIWorkerState.START_WORKING;
    }

    private List<ItemStack> getAllowedFuel() {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (ItemStorage storage : ((ItemListModule)this.building.getModuleMatching(ItemListModule.class, m -> m.getId().equals("fuel"))).getList()) {
            ItemStack stack = storage.getItemStack().m_41777_();
            stack.m_41764_(stack.m_41741_());
            list.add(stack);
        }
        return list;
    }

    @Override
    protected IAIState craft() {
        FurnaceUserModule module = (FurnaceUserModule)this.building.getFirstModuleOccurance(FurnaceUserModule.class);
        List<ItemStack> possibleFuels = this.getAllowedFuel();
        if (possibleFuels.isEmpty()) {
            if (this.worker.getCitizenData() != null) {
                this.worker.getCitizenData().triggerInteraction(new StandardInteraction((Component)Component.m_237115_((String)"com.minecolonies.coremod.furnaceuser.nofuel"), ChatPriority.BLOCKING));
            }
            return this.getState();
        }
        if (this.currentRecipeStorage != null) {
            possibleFuels.removeIf(stack -> ItemStackUtils.compareItemStacksIgnoreStackSize(stack, this.currentRecipeStorage.getPrimaryOutput()));
            possibleFuels.removeIf(stack -> ItemStackUtils.compareItemStacksIgnoreStackSize(stack, this.currentRecipeStorage.getCleanedInput().get(0).getItemStack()));
        }
        if (!this.walkToBuilding()) {
            this.setDelay(5);
            return this.getState();
        }
        if (this.currentRecipeStorage != null && this.currentRequest == null) {
            this.currentRequest = ((AbstractJobCrafter)this.job).getCurrentTask();
        }
        if (this.currentRecipeStorage != null && this.currentRecipeStorage.getIntermediate() != Blocks.f_50094_) {
            return super.craft();
        }
        if (module.getFurnaces().isEmpty()) {
            if (this.worker.getCitizenData() != null) {
                this.worker.getCitizenData().triggerInteraction(new StandardInteraction((Component)Component.m_237115_((String)"com.minecolonies.coremod.bakery.nofurnace"), ChatPriority.BLOCKING));
            }
            this.setDelay(5);
            return AIWorkerState.START_WORKING;
        }
        BlockPos furnacePosWithUsedFuel = this.getPositionOfOvenToRetrieveFuelFrom();
        if (furnacePosWithUsedFuel != null) {
            this.walkTo = furnacePosWithUsedFuel;
            return AIWorkerState.RETRIEVING_USED_FUEL_FROM_FURNACE;
        }
        BlockPos posOfOven = this.getPositionOfOvenToRetrieveFrom();
        if (posOfOven != null) {
            this.walkTo = posOfOven;
            return AIWorkerState.RETRIEVING_END_PRODUCT_FROM_FURNACE;
        }
        if (this.currentRequest != null && ((AbstractJobCrafter)this.job).getMaxCraftingCount() > 0 && ((AbstractJobCrafter)this.job).getCraftCounter() >= ((AbstractJobCrafter)this.job).getMaxCraftingCount()) {
            ((AbstractJobCrafter)this.job).finishRequest(true);
            this.currentRecipeStorage = null;
            this.currentRequest = null;
            this.resetValues();
            return AIWorkerState.INVENTORY_FULL;
        }
        if (this.currentRequest != null && (this.currentRequest.getState() == RequestState.CANCELLED || this.currentRequest.getState() == RequestState.FAILED)) {
            this.incrementActionsDone(this.getActionRewardForCraftingSuccess());
            this.currentRecipeStorage = null;
            this.currentRequest = null;
            this.resetValues();
            return AIWorkerState.START_WORKING;
        }
        return this.checkIfAbleToSmelt();
    }
}

