/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.compatibility.journeymap;

import com.minecolonies.core.compatibility.journeymap.ColonyBorderMapping;
import com.minecolonies.core.compatibility.journeymap.ColonyDeathpoints;
import com.minecolonies.core.compatibility.journeymap.EventListener;
import com.minecolonies.core.compatibility.journeymap.Journeymap;
import com.minecolonies.core.compatibility.journeymap.JourneymapOptions;
import java.util.EnumSet;
import journeymap.client.api.ClientPlugin;
import journeymap.client.api.IClientAPI;
import journeymap.client.api.IClientPlugin;
import journeymap.client.api.event.ClientEvent;
import journeymap.client.api.event.RegistryEvent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

@ClientPlugin
public class JourneymapPlugin
implements IClientPlugin {
    private Journeymap jmap;
    private EventListener listener;

    public void initialize(@NotNull IClientAPI api) {
        this.jmap = new Journeymap(api);
        this.listener = new EventListener(this.jmap);
        api.subscribe("minecolonies", EnumSet.of(ClientEvent.Type.MAPPING_STARTED, ClientEvent.Type.MAPPING_STOPPED, ClientEvent.Type.REGISTRY));
    }

    public String getModId() {
        return "minecolonies";
    }

    public void onEvent(@NotNull ClientEvent event) {
        switch (event.type) {
            case MAPPING_STARTED: {
                ColonyBorderMapping.load(this.jmap, (ResourceKey<Level>)event.dimension);
                break;
            }
            case MAPPING_STOPPED: {
                ColonyBorderMapping.unload(this.jmap, (ResourceKey<Level>)event.dimension);
                ColonyDeathpoints.unload(this.jmap, (ResourceKey<Level>)event.dimension);
                break;
            }
            case REGISTRY: {
                RegistryEvent registryEvent = (RegistryEvent)event;
                if (RegistryEvent.RegistryType.OPTIONS.equals((Object)registryEvent.getRegistryType())) {
                    this.jmap.setOptions(new JourneymapOptions());
                    break;
                }
                if (!RegistryEvent.RegistryType.INFO_SLOT.equals((Object)registryEvent.getRegistryType())) break;
                RegistryEvent.InfoSlotRegistryEvent infoSlotRegistry = (RegistryEvent.InfoSlotRegistryEvent)registryEvent;
                infoSlotRegistry.register("minecolonies", "com.minecolonies.coremod.journeymap.currentcolony", 2500L, ColonyBorderMapping::getCurrentColony);
            }
        }
    }
}

