/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.compatibility;

import com.minecolonies.api.IMinecoloniesAPI;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.buildings.modules.IBuildingModule;
import com.minecolonies.api.colony.buildings.modules.ICraftingBuildingModule;
import com.minecolonies.api.colony.buildings.registry.BuildingEntry;
import com.minecolonies.api.compatibility.ICompatibilityManager;
import com.minecolonies.api.crafting.IGenericRecipe;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.crafting.ModCraftingTypes;
import com.minecolonies.api.crafting.registry.CraftingType;
import com.minecolonies.api.items.IMinecoloniesFoodItem;
import com.minecolonies.api.items.ModTags;
import com.minecolonies.api.util.FoodUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.Log;
import com.minecolonies.core.colony.buildings.modules.AnimalHerdingModule;
import com.minecolonies.core.colony.buildings.modules.SimpleCraftingModule;
import com.minecolonies.core.colony.crafting.CustomRecipeManager;
import com.minecolonies.core.colony.crafting.LootTableAnalyzer;
import com.minecolonies.core.colony.crafting.RecipeAnalyzer;
import com.minecolonies.core.colony.crafting.ToolUsage;
import com.minecolonies.core.colony.crafting.ToolsAnalyzer;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CraftingTagAuditor {
    public static void doRecipeAudit(@NotNull MinecraftServer server, @NotNull CustomRecipeManager customRecipeManager) {
        CraftingTagAuditor.createFile("item tag audit", server, "tag_item_audit.csv", writer -> CraftingTagAuditor.doItemTagAudit(writer, server));
        CraftingTagAuditor.createFile("block tag audit", server, "tag_block_audit.csv", writer -> CraftingTagAuditor.doBlockTagAudit(writer, server));
        CraftingTagAuditor.createFile("path block audit", server, "path_block_audit.csv", writer -> CraftingTagAuditor.doPathBlockTagAudit(writer, server));
        CraftingTagAuditor.createFile("biome tag audit", server, "biome_tag_audit.csv", writer -> CraftingTagAuditor.doBiomeTagAudit(writer, server));
        CraftingTagAuditor.createFile("recipe audit", server, "recipe_audit.csv", writer -> CraftingTagAuditor.doRecipeAudit(writer, server, customRecipeManager));
        CraftingTagAuditor.createFile("domum audit", server, "domum_audit.csv", writer -> CraftingTagAuditor.doDomumAudit(writer, server));
        CraftingTagAuditor.createFile("tools audit", server, "tools_audit.csv", writer -> CraftingTagAuditor.doToolsAudit(writer, server));
        CraftingTagAuditor.createFile("food audit", server, "food_audit.csv", writer -> CraftingTagAuditor.doFoodAudit(writer, server));
    }

    private static boolean createFile(@NotNull String description, @NotNull MinecraftServer server, @NotNull String filename, @NotNull Writeable generator) {
        Path outputPath = server.m_129843_(LevelResource.f_78182_).resolve("minecolonies").resolve(filename);
        Log.getLogger().info("Beginning " + description + "...");
        try {
            Files.createDirectories(outputPath.getParent(), new FileAttribute[0]);
            try (BufferedWriter writer = Files.newBufferedWriter(outputPath, new OpenOption[0]);){
                generator.write(writer);
            }
            Log.getLogger().info("Completed " + description + "; written to " + outputPath);
            return true;
        }
        catch (Exception ex) {
            Log.getLogger().error("Failed to write " + description + " to " + outputPath, (Throwable)ex);
            return false;
        }
    }

    private static List<ItemStack> getAllItems() {
        ICompatibilityManager compatibility = IColonyManager.getInstance().getCompatibilityManager();
        ArrayList<ItemStack> items = new ArrayList<ItemStack>(compatibility.getListOfAllItems());
        items.sort(Comparator.comparing(stack -> ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_()).toString()));
        return items;
    }

    private static void doItemTagAudit(@NotNull BufferedWriter writer, @NotNull MinecraftServer server) throws IOException {
        CraftingTagAuditor.writeItemHeaders(writer);
        writer.write(",tags...");
        writer.newLine();
        for (ItemStack item : CraftingTagAuditor.getAllItems()) {
            CraftingTagAuditor.writeItemData(writer, item);
            item.m_204131_().map(t -> t.f_203868_().toString()).sorted().forEach(t -> {
                try {
                    writer.write(44);
                    writer.write((String)t);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
            writer.newLine();
        }
    }

    private static void doBlockTagAudit(@NotNull BufferedWriter writer, @NotNull MinecraftServer server) throws IOException {
        writer.write("block,name,tags...");
        writer.newLine();
        for (Map.Entry entry : ForgeRegistries.BLOCKS.getEntries()) {
            writer.write(((ResourceKey)entry.getKey()).m_135782_().toString());
            writer.write(44);
            writer.write(34);
            writer.write(Component.m_237115_((String)((Block)entry.getValue()).m_7705_()).getString().replace("\"", "\"\""));
            writer.write(34);
            ForgeRegistries.BLOCKS.tags().getReverseTag((Object)((Block)entry.getValue())).ifPresent(tags -> tags.getTagKeys().map(t -> t.f_203868_().toString()).sorted().forEach(t -> {
                try {
                    writer.write(44);
                    writer.write((String)t);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }));
            writer.newLine();
        }
    }

    private static void doPathBlockTagAudit(@NotNull BufferedWriter writer, @NotNull MinecraftServer server) throws IOException {
        writer.write("block,name,path,climbable,dangerous");
        writer.newLine();
        for (Map.Entry entry : ForgeRegistries.BLOCKS.getEntries()) {
            writer.write(((ResourceKey)entry.getKey()).m_135782_().toString());
            writer.write(44);
            writer.write(34);
            writer.write(Component.m_237115_((String)((Block)entry.getValue()).m_7705_()).getString().replace("\"", "\"\""));
            writer.write(34);
            writer.write(44);
            if (((Block)entry.getValue()).m_49966_().m_204336_(ModTags.pathingBlocks)) {
                writer.write("path");
            }
            writer.write(44);
            if (((Block)entry.getValue()).m_49966_().m_204336_(ModTags.freeClimbBlocks)) {
                writer.write("climb");
            }
            writer.write(44);
            if (((Block)entry.getValue()).m_49966_().m_204336_(ModTags.dangerousBlocks)) {
                writer.write("danger");
            }
            writer.newLine();
        }
    }

    private static void doBiomeTagAudit(@NotNull BufferedWriter writer, @NotNull MinecraftServer server) throws IOException {
        writer.write("biome,name,tags...");
        writer.newLine();
        Registry biomes = server.m_206579_().m_6632_(Registries.f_256952_).orElse(null);
        if (biomes == null) {
            return;
        }
        for (ResourceLocation id : biomes.m_6566_().stream().sorted().toList()) {
            writer.write(id.toString());
            writer.write(44);
            writer.write(34);
            writer.write(Component.m_237115_((String)id.m_214296_("biome")).getString().replace("\"", "\"\""));
            writer.write(34);
            biomes.m_203636_(ResourceKey.m_135785_((ResourceKey)biomes.m_123023_(), (ResourceLocation)id)).ifPresent(holder -> holder.m_203616_().map(t -> t.f_203868_().toString()).sorted().forEach(t -> {
                try {
                    writer.write(44);
                    writer.write((String)t);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }));
            writer.newLine();
        }
    }

    private static void doRecipeAudit(@NotNull BufferedWriter writer, @NotNull MinecraftServer server, @NotNull CustomRecipeManager customRecipeManager) throws IOException {
        List<IGenericRecipe> recipes;
        Map<CraftingType, List<IGenericRecipe>> vanillaRecipesMap = RecipeAnalyzer.buildVanillaRecipesMap(server.m_129894_(), (Level)server.m_129783_());
        List<Animal> animals = RecipeAnalyzer.createAnimals((Level)server.m_129783_());
        List<ICraftingBuildingModule> crafters = CraftingTagAuditor.getCraftingModules().stream().sorted(Comparator.comparing(m -> m instanceof SimpleCraftingModule).reversed().thenComparing(ICraftingBuildingModule::getCustomRecipeKey)).toList();
        List<AnimalHerdingModule> herders = CraftingTagAuditor.getHerdingModules();
        HashMap<ItemStorage, Map<Object, List<IGenericRecipe>>> craftingMap = new HashMap<ItemStorage, Map<Object, List<IGenericRecipe>>>();
        for (List<IGenericRecipe> recipeList : vanillaRecipesMap.values()) {
            for (IGenericRecipe recipe : recipeList) {
                CraftingTagAuditor.add(customRecipeManager, craftingMap, null, recipe);
            }
        }
        CraftingTagAuditor.writeItemHeaders(writer);
        writer.write(",player");
        for (ICraftingBuildingModule crafter : crafters) {
            writer.write(44);
            writer.write(crafter.getCustomRecipeKey());
            recipes = RecipeAnalyzer.findRecipes(vanillaRecipesMap, crafter, (Level)server.m_129783_());
            for (IGenericRecipe recipe : recipes) {
                CraftingTagAuditor.add(customRecipeManager, craftingMap, crafter, recipe);
            }
        }
        for (AnimalHerdingModule herder : herders) {
            writer.write(44);
            writer.write(herder.getHerdingJob().getJobRegistryEntry().getKey().m_135815_());
            recipes = RecipeAnalyzer.findRecipes(animals, herder);
            for (IGenericRecipe recipe : recipes) {
                CraftingTagAuditor.add(customRecipeManager, craftingMap, herder, recipe);
            }
        }
        writer.newLine();
        for (ItemStack item : CraftingTagAuditor.getAllItems()) {
            CraftingTagAuditor.writeItemData(writer, item);
            Map<Object, List<IGenericRecipe>> crafterMap = craftingMap.getOrDefault(new ItemStorage(item, true, false), Collections.emptyMap());
            CraftingTagAuditor.writeCrafterValue(writer, crafterMap, null);
            for (ICraftingBuildingModule crafter : crafters) {
                CraftingTagAuditor.writeCrafterValue(writer, crafterMap, crafter);
            }
            for (AnimalHerdingModule herder : herders) {
                CraftingTagAuditor.writeCrafterValue(writer, crafterMap, herder);
            }
            writer.newLine();
        }
    }

    private static void doDomumAudit(@NotNull BufferedWriter writer, @NotNull MinecraftServer server) throws IOException {
        ArrayList<IGenericRecipe> cutterRecipes = new ArrayList<IGenericRecipe>(((CraftingType)ModCraftingTypes.ARCHITECTS_CUTTER.get()).findRecipes(server.m_129894_(), (Level)server.m_129783_()));
        cutterRecipes.sort(Comparator.comparing(r -> ForgeRegistries.ITEMS.getKey((Object)r.getPrimaryOutput().m_41720_()).toString()));
        List<ICraftingBuildingModule> crafters = CraftingTagAuditor.getCraftingModules().stream().filter(m -> m.canLearn((CraftingType)ModCraftingTypes.ARCHITECTS_CUTTER.get())).sorted(Comparator.comparing(ICraftingBuildingModule::getCustomRecipeKey)).toList();
        writer.write("type,");
        CraftingTagAuditor.writeItemHeaders(writer);
        for (ICraftingBuildingModule crafter : crafters) {
            writer.write(44);
            writer.write(crafter.getCustomRecipeKey());
        }
        writer.newLine();
        for (IGenericRecipe recipe : cutterRecipes) {
            boolean first = true;
            List<ItemStack> allSkins = recipe.getInputs().stream().flatMap(Collection::stream).map(ItemStorage::new).distinct().sorted(Comparator.comparing(s -> ForgeRegistries.ITEMS.getKey((Object)s.getItem()).toString())).map(ItemStorage::getItemStack).toList();
            for (ItemStack skin : allSkins) {
                if (first) {
                    CraftingTagAuditor.writeItemStack(writer, recipe.getPrimaryOutput());
                    first = false;
                }
                writer.write(44);
                CraftingTagAuditor.writeItemData(writer, skin);
                for (ICraftingBuildingModule crafter : crafters) {
                    writer.write(crafter.getIngredientValidator().test(skin).orElse(false) != false ? ",1" : ",");
                }
                writer.newLine();
            }
        }
    }

    private static void doToolsAudit(@NotNull BufferedWriter writer, @NotNull MinecraftServer server) throws IOException {
        List<ToolUsage> toolUsages = ToolsAnalyzer.findTools();
        CraftingTagAuditor.writeItemHeaders(writer);
        for (ToolUsage tool : toolUsages) {
            writer.write(44);
            writer.write(tool.tool().getRegistryName().toString());
        }
        writer.newLine();
        for (ItemStack item : CraftingTagAuditor.getAllItems()) {
            CraftingTagAuditor.writeItemData(writer, item);
            block2: for (ToolUsage tool : toolUsages) {
                writer.write(44);
                for (int level = 0; level < tool.toolLevels().size(); ++level) {
                    List<ItemStack> stacks = tool.toolLevels().get(level);
                    if (!ItemStackUtils.compareItemStackListIgnoreStackSize(stacks, item, false, true)) continue;
                    writer.write(Integer.toString(level));
                    continue block2;
                }
            }
            writer.newLine();
        }
    }

    private static void doFoodAudit(@NotNull BufferedWriter writer, @NotNull MinecraftServer server) throws IOException {
        CraftingTagAuditor.writeItemHeaders(writer);
        writer.write(",nutrition,maxlevel,tier");
        for (int level = 0; level <= 5; ++level) {
            writer.write(",actual" + level);
        }
        writer.newLine();
        for (ItemStack item : CraftingTagAuditor.getAllItems()) {
            FoodProperties properties;
            if (!ItemStackUtils.ISFOOD.test(item) || (properties = item.m_41720_().getFoodProperties(item, null)) == null) continue;
            CraftingTagAuditor.writeItemData(writer, item);
            writer.write(44);
            writer.write(Integer.toString(properties.m_38744_()));
            writer.write(44);
            writer.write(Integer.toString(FoodUtils.getBuildingLevelForFood(item)));
            writer.write(44);
            Item item2 = item.m_41720_();
            if (item2 instanceof IMinecoloniesFoodItem) {
                IMinecoloniesFoodItem mcolFood = (IMinecoloniesFoodItem)item2;
                writer.write(Integer.toString(mcolFood.getTier()));
            }
            for (int level = 0; level <= 5; ++level) {
                writer.write(44);
                writer.write(Double.toString(FoodUtils.getFoodValue(item, properties, level, 0.0)));
            }
            writer.newLine();
        }
    }

    private static void writeItemHeaders(@NotNull BufferedWriter writer) throws IOException {
        writer.write("item,name");
    }

    private static void writeItemData(@NotNull BufferedWriter writer, @NotNull ItemStack stack) throws IOException {
        CraftingTagAuditor.writeItemStack(writer, stack);
        writer.write(",\"");
        writer.write(stack.m_41611_().getString().replace("\"", "\"\""));
        writer.write(34);
    }

    private static void writeItemStack(@NotNull BufferedWriter writer, @NotNull ItemStack stack) throws IOException {
        writer.write(34);
        writer.write(ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_()).toString());
        if (stack.m_41782_() && !stack.m_41763_()) {
            writer.write(stack.m_41783_().toString().replace("\"", "\"\""));
        }
        writer.write(34);
    }

    private static void writeCrafterValue(@NotNull BufferedWriter writer, @NotNull Map<Object, List<IGenericRecipe>> crafterMap, @Nullable Object crafter) throws IOException {
        writer.write(44);
        List recipeList = crafterMap.getOrDefault(crafter, Collections.emptyList());
        if (!recipeList.isEmpty()) {
            writer.write(Integer.toString(recipeList.size()));
        }
    }

    private static void add(@NotNull CustomRecipeManager customRecipeManager, @NotNull Map<ItemStorage, Map<Object, List<IGenericRecipe>>> craftingMap, @Nullable Object crafter, @NotNull IGenericRecipe recipe) {
        for (ItemStack stack : recipe.getAllMultiOutputs()) {
            CraftingTagAuditor.add(craftingMap, crafter, recipe, stack);
        }
        if (recipe.getLootTable() != null) {
            for (LootTableAnalyzer.LootDrop drop : customRecipeManager.getLootDrops(recipe.getLootTable())) {
                for (ItemStack stack : drop.getItemStacks()) {
                    CraftingTagAuditor.add(craftingMap, crafter, recipe, stack);
                }
            }
        }
    }

    private static void add(@NotNull Map<ItemStorage, Map<Object, List<IGenericRecipe>>> craftingMap, @Nullable Object crafter, @NotNull IGenericRecipe recipe, @NotNull ItemStack stack) {
        craftingMap.computeIfAbsent(new ItemStorage(stack, true, false), s -> new HashMap()).computeIfAbsent(crafter, c -> new ArrayList()).add(recipe);
    }

    private static List<ICraftingBuildingModule> getCraftingModules() {
        ArrayList<ICraftingBuildingModule> modules = new ArrayList<ICraftingBuildingModule>();
        for (String producerKey : BuildingEntry.getALlModuleProducers().keySet()) {
            IBuildingModule module = BuildingEntry.produceModuleWithoutBuilding(producerKey);
            if (module == null || !(module instanceof ICraftingBuildingModule)) continue;
            ICraftingBuildingModule crafting = (ICraftingBuildingModule)module;
            modules.add(crafting);
        }
        return modules;
    }

    private static List<AnimalHerdingModule> getHerdingModules() {
        ArrayList<AnimalHerdingModule> modules = new ArrayList<AnimalHerdingModule>();
        for (BuildingEntry buildingEntry : IMinecoloniesAPI.getInstance().getBuildingRegistry()) {
        }
        return modules;
    }

    private CraftingTagAuditor() {
    }

    @FunctionalInterface
    private static interface Writeable {
        public void write(@NotNull BufferedWriter var1) throws IOException;
    }
}

