/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.commands.citizencommands;

import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.entity.citizen.Skill;
import com.minecolonies.core.colony.buildings.modules.WorkerBuildingModule;
import com.minecolonies.core.commands.commandTypes.IMCColonyOfficerCommand;
import com.minecolonies.core.commands.commandTypes.IMCCommand;
import com.minecolonies.core.entity.citizen.EntityCitizen;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Optional;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;

public class CommandCitizenInfo
implements IMCColonyOfficerCommand {
    @Override
    public int onExecute(CommandContext<CommandSourceStack> context) {
        BlockPos homePosition;
        BlockPos citizenPosition;
        AbstractEntityCitizen entityCitizen;
        Entity sender = ((CommandSourceStack)context.getSource()).m_81373_();
        int colonyID = IntegerArgumentType.getInteger(context, (String)"colonyID");
        IColony colony = IColonyManager.getInstance().getColonyByDimension(colonyID, (ResourceKey<Level>)(sender == null ? Level.f_46428_ : ((CommandSourceStack)context.getSource()).m_81372_().m_46472_()));
        if (colony == null) {
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)"com.minecolonies.command.colonyidnotfound", (Object[])new Object[]{colonyID}), true);
            return 0;
        }
        ICitizenData citizenData = colony.getCitizenManager().getCivilian(IntegerArgumentType.getInteger(context, (String)"citizenID"));
        if (citizenData == null) {
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237115_((String)"com.minecolonies.command.citizeninfo.notfound"), true);
            return 0;
        }
        Optional<AbstractEntityCitizen> optionalEntityCitizen = citizenData.getEntity();
        if (optionalEntityCitizen.isPresent()) {
            entityCitizen = optionalEntityCitizen.get();
            citizenPosition = entityCitizen.m_20183_();
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)"com.minecolonies.command.citizeninfo.pos", (Object[])new Object[]{citizenPosition.m_123341_(), citizenPosition.m_123342_(), citizenPosition.m_123343_()}), true);
            homePosition = citizenData.getHomePosition();
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)"com.minecolonies.command.citizeninfo.homepos", (Object[])new Object[]{homePosition.m_123341_(), homePosition.m_123342_(), homePosition.m_123343_()}), true);
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)"com.minecolonies.command.citizeninfo.health", (Object[])new Object[]{Float.valueOf(entityCitizen.m_21223_()), Float.valueOf(entityCitizen.m_21233_())}), true);
        } else {
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)"com.minecolonies.command.citizeninfo.pos", (Object[])new Object[]{citizenData.getLastPosition().m_123341_(), citizenData.getLastPosition().m_123342_(), citizenData.getLastPosition().m_123343_()}), true);
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237115_((String)"com.minecolonies.command.citizeninfo.notloaded"), true);
        }
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)"com.minecolonies.command.citizeninfo.desc", (Object[])new Object[]{citizenData.getId(), citizenData.getName()}), true);
        entityCitizen = optionalEntityCitizen.get();
        citizenPosition = entityCitizen.m_20183_();
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)"com.minecolonies.command.citizeninfo.pos", (Object[])new Object[]{citizenPosition.m_123341_(), citizenPosition.m_123342_(), citizenPosition.m_123343_()}), true);
        homePosition = citizenData.getHomePosition();
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)"com.minecolonies.command.citizeninfo.homepos", (Object[])new Object[]{homePosition.m_123341_(), homePosition.m_123342_(), homePosition.m_123343_()}), true);
        if (citizenData.getWorkBuilding() == null) {
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237115_((String)"com.minecolonies.command.citizeninfo.workposnull"), true);
        } else {
            BlockPos workingPosition = citizenData.getWorkBuilding().getPosition();
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)"com.minecolonies.command.citizeninfo.workpos", (Object[])new Object[]{workingPosition.m_123341_(), workingPosition.m_123342_(), workingPosition.m_123343_()}), true);
        }
        Object[] skills = new Object[]{citizenData.getCitizenSkillHandler().getSkills().get((Object)Skill.Athletics).getLevel(), citizenData.getCitizenSkillHandler().getSkills().get((Object)Skill.Dexterity).getLevel(), citizenData.getCitizenSkillHandler().getSkills().get((Object)Skill.Strength).getLevel(), citizenData.getCitizenSkillHandler().getSkills().get((Object)Skill.Agility).getLevel(), citizenData.getCitizenSkillHandler().getSkills().get((Object)Skill.Stamina).getLevel(), citizenData.getCitizenSkillHandler().getSkills().get((Object)Skill.Mana).getLevel(), citizenData.getCitizenSkillHandler().getSkills().get((Object)Skill.Adaptability).getLevel(), citizenData.getCitizenSkillHandler().getSkills().get((Object)Skill.Focus).getLevel(), citizenData.getCitizenSkillHandler().getSkills().get((Object)Skill.Creativity).getLevel(), citizenData.getCitizenSkillHandler().getSkills().get((Object)Skill.Knowledge).getLevel(), citizenData.getCitizenSkillHandler().getSkills().get((Object)Skill.Intelligence).getLevel()};
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)"com.minecolonies.command.citizeninfo.skills", (Object[])skills), true);
        if (citizenData.getJob() == null) {
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237115_((String)"com.minecolonies.command.citizeninfo.jobnull"), true);
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237115_((String)"com.minecolonies.command.citizeninfo.noactivity"), true);
        } else if (citizenData.getWorkBuilding() != null && citizenData.getWorkBuilding().hasModule(WorkerBuildingModule.class)) {
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)"com.minecolonies.command.citizeninfo.job", (Object[])new Object[]{((WorkerBuildingModule)citizenData.getWorkBuilding().getFirstModuleOccurance(WorkerBuildingModule.class)).getJobEntry().getTranslationKey()}), true);
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)"com.minecolonies.command.citizeninfo.activity", (Object[])new Object[]{((EntityCitizen)entityCitizen).getCitizenAI().getState(), entityCitizen.getCitizenJobHandler().getColonyJob().getNameTagDescription(), entityCitizen.getCitizenJobHandler().getWorkAI().getState()}), true);
        }
        return 1;
    }

    @Override
    public String getName() {
        return "info";
    }

    @Override
    public LiteralArgumentBuilder<CommandSourceStack> build() {
        return (LiteralArgumentBuilder)IMCCommand.newLiteral(this.getName()).then(IMCCommand.newArgument("colonyID", IntegerArgumentType.integer((int)1)).then(IMCCommand.newArgument("citizenID", IntegerArgumentType.integer((int)1)).executes(this::checkPreConditionAndExecute)));
    }
}

