/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.requestsystem.resolvers;

import com.google.common.reflect.TypeToken;
import com.minecolonies.api.colony.buildings.workerbuildings.IWareHouse;
import com.minecolonies.api.colony.requestsystem.location.ILocation;
import com.minecolonies.api.colony.requestsystem.manager.IRequestManager;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.colony.requestsystem.requestable.deliveryman.Pickup;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.constant.TypeConstants;
import com.minecolonies.core.colony.requestsystem.resolvers.DeliverymenRequestResolver;
import org.jetbrains.annotations.NotNull;

public class PickupRequestResolver
extends DeliverymenRequestResolver<Pickup> {
    public PickupRequestResolver(@NotNull ILocation location, @NotNull IToken<?> token) {
        super(location, token);
    }

    @Override
    public int getSuitabilityMetric(@NotNull IRequestManager manager, @NotNull IRequest<? extends Pickup> request) {
        return (int)BlockPosUtil.getDistance(request.getRequester().getLocation().getInDimensionLocation(), this.getLocation().getInDimensionLocation());
    }

    @Override
    public boolean canResolveRequest(@NotNull IRequestManager manager, IRequest<? extends Pickup> requestToCheck) {
        IWareHouse wareHouse = manager.getColony().getBuildingManager().getBuilding(this.getLocation().getInDimensionLocation(), IWareHouse.class);
        if (wareHouse == null) {
            return false;
        }
        return super.canResolveRequest(manager, requestToCheck);
    }

    @Override
    public TypeToken<? extends Pickup> getRequestType() {
        return TypeConstants.PICKUP;
    }
}

