/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.events.raid;

import com.minecolonies.api.MinecoloniesAPIProxy;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.colonyEvents.EventStatus;
import com.minecolonies.api.colony.colonyEvents.IColonyEvent;
import com.minecolonies.api.colony.colonyEvents.IColonyRaidEvent;
import com.minecolonies.api.colony.managers.interfaces.IRaiderManager;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.entity.citizen.happiness.ExpirationBasedHappinessModifier;
import com.minecolonies.api.entity.citizen.happiness.StaticHappinessSupplier;
import com.minecolonies.api.entity.mobs.AbstractEntityMinecoloniesRaider;
import com.minecolonies.api.sounds.RaidSounds;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.ColonyUtils;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.MessageUtils;
import com.minecolonies.api.util.WorldUtil;
import com.minecolonies.api.util.constant.ColonyConstants;
import com.minecolonies.core.MineColonies;
import com.minecolonies.core.colony.Colony;
import com.minecolonies.core.colony.buildings.modules.LivingBuildingModule;
import com.minecolonies.core.colony.buildings.workerbuildings.BuildingGuardTower;
import com.minecolonies.core.colony.buildings.workerbuildings.BuildingTownHall;
import com.minecolonies.core.colony.events.raid.AbstractShipRaidEvent;
import com.minecolonies.core.colony.events.raid.HordeRaidEvent;
import com.minecolonies.core.colony.events.raid.amazonevent.AmazonRaidEvent;
import com.minecolonies.core.colony.events.raid.barbarianEvent.BarbarianRaidEvent;
import com.minecolonies.core.colony.events.raid.barbarianEvent.Horde;
import com.minecolonies.core.colony.events.raid.egyptianevent.EgyptianRaidEvent;
import com.minecolonies.core.colony.events.raid.norsemenevent.NorsemenRaidEvent;
import com.minecolonies.core.colony.events.raid.norsemenevent.NorsemenShipRaidEvent;
import com.minecolonies.core.colony.events.raid.pirateEvent.DrownedPirateRaidEvent;
import com.minecolonies.core.colony.events.raid.pirateEvent.PirateGroundRaidEvent;
import com.minecolonies.core.colony.events.raid.pirateEvent.PirateRaidEvent;
import com.minecolonies.core.colony.events.raid.pirateEvent.ShipBasedRaiderUtils;
import com.minecolonies.core.colony.events.raid.pirateEvent.ShipSize;
import com.minecolonies.core.colony.jobs.AbstractJobGuard;
import com.minecolonies.core.entity.ai.workers.guard.AbstractEntityAIGuard;
import com.minecolonies.core.entity.citizen.citizenhandlers.CitizenSkillHandler;
import com.minecolonies.core.entity.pathfinding.Pathfinding;
import com.minecolonies.core.entity.pathfinding.PathfindingUtils;
import com.minecolonies.core.entity.pathfinding.pathjobs.PathJobRaiderPathing;
import com.minecolonies.core.entity.pathfinding.pathresults.PathResult;
import com.minecolonies.core.network.messages.client.PlayAudioMessage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class RaidManager
implements IRaiderManager {
    public static final double SPAWN_MODIFIER = 60.0;
    private static final int MIN_BUILDING_SPAWN_DIST = 35;
    private static final double LOST_CITIZEN_DIFF_REDUCE_PCT = 0.15;
    private static final double LOST_CITIZEN_DIFF_INCREASE_PCT = 0.05;
    private static final int MIN_RAID_DIFFICULTY = 1;
    private static final int MAX_RAID_DIFFICULTY = 14;
    private static final double MIN_DIFFICULTY_MODIFIER = 0.2;
    private static final String TAG_RAID_DIFFICULTY = "difficulty";
    private static final String TAG_LOST_CITIZENS = "lostCitizens";
    public static final int MIN_REQUIRED_RAIDLEVEL = 75;
    private static final double INCREASE_PER_PLAYER = 0.05;
    private static final int IGNORE_BIOME_CHANCE = 2;
    private static final int INITIAL_RAID_DIFFICULTY = 7;
    private int raidDifficulty = 7;
    private double spawnCountAdjustedDifficulty = 1.0;
    private boolean raidTonight = false;
    private static boolean INITIAL_CAN_HAVE_BARB_EVENTS = true;
    private boolean haveBarbEvents = INITIAL_CAN_HAVE_BARB_EVENTS;
    private static final int INITIAL_NIGHTS_SINCE_LAST_RAID = 0;
    private int nightsSinceLastRaid = 0;
    private final Colony colony;
    private boolean spiesEnabled;
    private BlockPos lastBuilding;
    private int buildingPosUsage = 0;
    private static final int INITIAL_LOST_CITIZENS = 0;
    private static final String INITIAL_NEXT_RAID_TYPE = "";
    private String nextForcedType = "";
    private List<RaidHistory> raidHistories = new ArrayList<RaidHistory>();
    private boolean allowShips = true;
    private long passingThroughRaidTime = 0L;

    public RaidManager(Colony colony) {
        this.colony = colony;
    }

    @Override
    public boolean canHaveRaiderEvents() {
        return this.haveBarbEvents;
    }

    @Override
    public boolean willRaidTonight() {
        return this.raidTonight;
    }

    @Override
    public void setCanHaveRaiderEvents(boolean canHave) {
        this.haveBarbEvents = canHave;
    }

    @Override
    public void setRaidNextNight(boolean willRaid, String raidType, boolean allowShips) {
        this.raidTonight = willRaid;
        this.nextForcedType = raidType;
        this.allowShips = allowShips;
    }

    @Override
    public boolean areSpiesEnabled() {
        return this.spiesEnabled;
    }

    @Override
    public void setSpiesEnabled(boolean enabled) {
        if (this.spiesEnabled != enabled) {
            this.colony.markDirty();
        }
        this.spiesEnabled = enabled;
    }

    @Override
    public void raiderEvent() {
        this.raiderEvent(INITIAL_NEXT_RAID_TYPE, false);
    }

    @Override
    public IRaiderManager.RaidSpawnResult raiderEvent(String raidType, boolean forced, boolean allowShips) {
        if (this.colony.getWorld() == null || raidType == null) {
            return IRaiderManager.RaidSpawnResult.ERROR;
        }
        if (!forced && !this.canRaid()) {
            return IRaiderManager.RaidSpawnResult.CANNOT_RAID;
        }
        int raidLevel = this.getColonyRaidLevel();
        int amount = this.calculateRaiderAmount(raidLevel);
        if (amount <= 0 || raidLevel < 75) {
            return IRaiderManager.RaidSpawnResult.TOO_SMALL;
        }
        this.spawnCountAdjustedDifficulty = 1.0;
        if (amount >= (Integer)MineColonies.getConfig().getServer().maxRaiders.get()) {
            this.spawnCountAdjustedDifficulty = (double)amount / (double)((Integer)MineColonies.getConfig().getServer().maxRaiders.get()).intValue();
        }
        int raidCount = Math.max(1, amount / 20);
        HashSet<BlockPos> spawnPoints = new HashSet<BlockPos>();
        int retries = 0;
        for (int i = 0; i < raidCount; ++i) {
            BlockPos targetSpawnPoint = this.calculateSpawnLocation();
            if (targetSpawnPoint == null || targetSpawnPoint.equals((Object)this.colony.getCenter()) || !this.colony.getWorld().m_6857_().m_61937_(targetSpawnPoint)) {
                if (retries >= 10) continue;
                ++retries;
                --i;
                continue;
            }
            spawnPoints.add(targetSpawnPoint);
        }
        if (spawnPoints.isEmpty()) {
            return IRaiderManager.RaidSpawnResult.NO_SPAWN_POINT;
        }
        this.raidHistories.add(new RaidHistory(amount, this.colony.getWorld().m_46467_()));
        this.nightsSinceLastRaid = 0;
        this.raidTonight = false;
        amount = (int)Math.ceil((float)amount / (float)spawnPoints.size());
        for (BlockPos targetSpawnPoint : spawnPoints) {
            IColonyRaidEvent raidEvent = null;
            if (((Boolean)MineColonies.getConfig().getServer().enableInDevelopmentFeatures.get()).booleanValue()) {
                MessageUtils.format((Component)Component.m_237113_((String)("Horde Spawn Point: " + targetSpawnPoint))).sendTo(this.colony).forAllPlayers();
            }
            BlockState aboveState = this.colony.getWorld().m_8055_(targetSpawnPoint.m_7494_());
            BlockState spawnState = this.colony.getWorld().m_8055_(targetSpawnPoint);
            BlockState belowState = this.colony.getWorld().m_8055_(targetSpawnPoint.m_7495_());
            if (((Boolean)MineColonies.getConfig().getServer().skyRaiders.get()).booleanValue() && spawnState.m_60795_() && belowState.m_60795_()) {
                raidType = PirateRaidEvent.PIRATE_RAID_EVENT_TYPE_ID.m_135815_();
            } else if ((raidType.isEmpty() || raidType.equals(DrownedPirateRaidEvent.PIRATE_RAID_EVENT_TYPE_ID.m_135815_())) && (PathfindingUtils.isWater((BlockGetter)this.colony.getWorld(), targetSpawnPoint.m_7494_(), aboveState, null) || ColonyConstants.rand.nextInt(100) <= 20) && PathfindingUtils.isWater((BlockGetter)this.colony.getWorld(), targetSpawnPoint, spawnState, null) && PathfindingUtils.isWater((BlockGetter)this.colony.getWorld(), targetSpawnPoint.m_7495_(), belowState, null)) {
                raidType = DrownedPirateRaidEvent.PIRATE_RAID_EVENT_TYPE_ID.m_135815_();
                for (int i = 0; i < 13 && PathfindingUtils.isLiquid(this.colony.getWorld().m_8055_(targetSpawnPoint.m_7494_())); ++i) {
                    targetSpawnPoint = targetSpawnPoint.m_7494_();
                }
            }
            int shipRotation = this.colony.getWorld().f_46441_.m_188503_(4);
            Holder biome = this.colony.getWorld().m_204166_(this.colony.getCenter());
            int rand = this.colony.getWorld().f_46441_.m_188503_(100);
            if (allowShips && (raidType.isEmpty() && (biome.m_203656_(BiomeTags.f_207609_) || rand < 2) || raidType.equals(NorsemenRaidEvent.NORSEMEN_RAID_EVENT_TYPE_ID.m_135815_())) && ShipBasedRaiderUtils.canSpawnShipAt(this.colony, targetSpawnPoint, amount, shipRotation, "norsemen_ship")) {
                event = new NorsemenShipRaidEvent(this.colony);
                ((AbstractShipRaidEvent)event).setSpawnPoint(targetSpawnPoint);
                ((AbstractShipRaidEvent)event).setShipSize(ShipSize.getShipForRaiderAmount(amount));
                ((AbstractShipRaidEvent)event).setShipRotation(shipRotation);
                ((AbstractShipRaidEvent)event).setSpawnPath(this.createSpawnPath(targetSpawnPoint, false));
                ((AbstractShipRaidEvent)event).setMaxRaiderCount(amount * 2);
                raidEvent = event;
                this.colony.getEventManager().addEvent(event);
            } else if (allowShips && (raidType.isEmpty() && biome.m_203656_(BiomeTags.f_207603_) || raidType.equals(DrownedPirateRaidEvent.PIRATE_RAID_EVENT_TYPE_ID.m_135815_())) && ShipBasedRaiderUtils.canSpawnShipAt(this.colony, targetSpawnPoint, amount, shipRotation, "sunk_ship", 13)) {
                event = new DrownedPirateRaidEvent(this.colony);
                ((AbstractShipRaidEvent)event).setSpawnPoint(targetSpawnPoint);
                ((AbstractShipRaidEvent)event).setShipSize(ShipSize.getShipForRaiderAmount(amount));
                ((AbstractShipRaidEvent)event).setShipRotation(shipRotation);
                ((AbstractShipRaidEvent)event).setSpawnPath(this.createSpawnPath(targetSpawnPoint, true));
                ((AbstractShipRaidEvent)event).setMaxRaiderCount(amount * 2);
                raidEvent = event;
                this.colony.getEventManager().addEvent(event);
            } else if (allowShips && ShipBasedRaiderUtils.canSpawnShipAt(this.colony, targetSpawnPoint, amount, shipRotation, "pirate_ship") && (raidType.isEmpty() || raidType.equals(PirateRaidEvent.PIRATE_RAID_EVENT_TYPE_ID.m_135815_()))) {
                event = new PirateRaidEvent(this.colony);
                ((AbstractShipRaidEvent)event).setSpawnPoint(targetSpawnPoint);
                ((AbstractShipRaidEvent)event).setShipSize(ShipSize.getShipForRaiderAmount(amount));
                ((AbstractShipRaidEvent)event).setShipRotation(shipRotation);
                ((AbstractShipRaidEvent)event).setSpawnPath(this.createSpawnPath(targetSpawnPoint, false));
                ((AbstractShipRaidEvent)event).setMaxRaiderCount(amount * 2);
                raidEvent = event;
                this.colony.getEventManager().addEvent(event);
            } else {
                if ((biome.m_203656_(BiomeTags.f_207614_) || rand > 2 && rand < 4) && raidType.isEmpty() || raidType.equals(EgyptianRaidEvent.EGYPTIAN_RAID_EVENT_TYPE_ID.m_135815_())) {
                    event = new EgyptianRaidEvent(this.colony);
                } else if ((biome.m_203656_(BiomeTags.f_207610_) || rand > 4 && rand < 6) && raidType.isEmpty() || raidType.equals(AmazonRaidEvent.AMAZON_RAID_EVENT_TYPE_ID.m_135815_())) {
                    event = new AmazonRaidEvent(this.colony);
                } else if ((biome.m_203656_(BiomeTags.f_207609_) || rand > 6 && rand < 8) && raidType.isEmpty() || raidType.equals(NorsemenRaidEvent.NORSEMEN_RAID_EVENT_TYPE_ID.m_135815_())) {
                    event = new NorsemenRaidEvent(this.colony);
                } else if (raidType.equals(PirateRaidEvent.PIRATE_RAID_EVENT_TYPE_ID.m_135815_())) {
                    event = new PirateGroundRaidEvent(this.colony);
                } else if (raidType.isEmpty() || raidType.equals(BarbarianRaidEvent.BARBARIAN_RAID_EVENT_TYPE_ID.m_135815_())) {
                    event = new BarbarianRaidEvent(this.colony);
                } else {
                    return IRaiderManager.RaidSpawnResult.NO_SPAWN_POINT;
                }
                ((HordeRaidEvent)event).setSpawnPoint(targetSpawnPoint);
                ((HordeRaidEvent)event).setHorde(new Horde(amount));
                ((HordeRaidEvent)event).setSpawnPath(this.createSpawnPath(targetSpawnPoint, false));
                raidEvent = event;
                this.colony.getEventManager().addEvent(event);
            }
            this.getLastRaid().spawnData.add(new RaidSpawnInfo(raidEvent.getEventTypeID(), targetSpawnPoint));
            this.getLastRaid().difficulty = (double)((int)(this.getRaidDifficultyModifier() * 100.0)) / 100.0;
        }
        this.colony.markDirty();
        return IRaiderManager.RaidSpawnResult.SUCCESS;
    }

    private PathResult createSpawnPath(BlockPos targetSpawnPoint, boolean underwater) {
        BlockPos closestBuildingPos = this.colony.getBuildingManager().getBestBuilding(targetSpawnPoint, IBuilding.class);
        PathJobRaiderPathing job = new PathJobRaiderPathing(new ArrayList<IBuilding>(this.colony.getBuildingManager().getBuildings().values()), this.colony.getWorld(), closestBuildingPos, targetSpawnPoint);
        job.getPathingOptions().withWalkUnderWater(underwater);
        job.getResult().startJob(Pathfinding.getExecutor());
        return job.getResult();
    }

    @Override
    public BlockPos calculateSpawnLocation() {
        BlockPos locationSum = new BlockPos(0, 0, 0);
        int amount = 0;
        for (IBuilding building : this.colony.getBuildingManager().getBuildings().values()) {
            if (!WorldUtil.isEntityBlockLoaded((LevelAccessor)this.colony.getWorld(), building.getPosition())) continue;
            ++amount;
            locationSum = locationSum.m_121955_((Vec3i)building.getPosition());
        }
        if (amount == 0) {
            Log.getLogger().info("Trying to spawn raid on colony with no loaded buildings, aborting!");
            return null;
        }
        BlockPos calcCenter = new BlockPos(locationSum.m_123341_() / amount, locationSum.m_123342_() / amount, locationSum.m_123343_() / amount);
        int degree = this.colony.getWorld().f_46441_.m_188503_(360);
        int x = (int)Math.round(500.0 * Math.cos(Math.toRadians(degree)));
        int z = (int)Math.round(500.0 * Math.sin(Math.toRadians(degree)));
        BlockPos advanceTowards = calcCenter.m_7918_(x, 0, z);
        BlockPos spawnPos = null;
        BlockPos closestBuilding = this.colony.getBuildingManager().getBestBuilding(advanceTowards, IBuilding.class);
        if (closestBuilding == null) {
            return null;
        }
        BlockPos worldSpawnPos = null;
        for (int i = 0; i < 8; ++i) {
            spawnPos = this.findSpawnPointInDirections(new BlockPos(closestBuilding.m_123341_(), calcCenter.m_123342_(), closestBuilding.m_123343_()), advanceTowards);
            if (spawnPos == null) continue;
            worldSpawnPos = BlockPosUtil.findAround(this.colony.getWorld(), BlockPosUtil.getFloor(spawnPos, this.colony.getWorld()), 30, 3, BlockPosUtil.SOLID_AIR_POS_SELECTOR);
            if (worldSpawnPos == null && this.colony.getWorld().m_8055_(spawnPos).m_60734_() == Blocks.f_49990_) {
                worldSpawnPos = spawnPos;
                break;
            }
            if (worldSpawnPos != null || ((Boolean)MineColonies.getConfig().getServer().skyRaiders.get()).booleanValue()) break;
        }
        if (spawnPos == null) {
            return null;
        }
        if (worldSpawnPos == null && ((Boolean)MineColonies.getConfig().getServer().skyRaiders.get()).booleanValue()) {
            worldSpawnPos = BlockPosUtil.findAround(this.colony.getWorld(), BlockPosUtil.getFloor(spawnPos, this.colony.getWorld()), 15, 10, BlockPosUtil.DOUBLE_AIR_POS_SELECTOR);
        }
        return worldSpawnPos;
    }

    private BlockPos findSpawnPointInDirections(BlockPos start, BlockPos advancePos) {
        BlockPos spawnPos = new BlockPos((Vec3i)start);
        BlockPos tempPos = new BlockPos(spawnPos.m_123341_(), spawnPos.m_123342_(), spawnPos.m_123343_());
        Collection<IBuilding> buildings = this.colony.getBuildingManager().getBuildings().values();
        int xDiff = Math.abs(start.m_123341_() - advancePos.m_123341_());
        int zDiff = Math.abs(start.m_123343_() - advancePos.m_123343_());
        Vec3 xzRatio = new Vec3((double)(xDiff * (start.m_123341_() < advancePos.m_123341_() ? 1 : -1)), 0.0, (double)(zDiff * (start.m_123343_() < advancePos.m_123343_() ? 1 : -1)));
        xzRatio = xzRatio.m_82541_().m_82490_(3.0);
        int validChunkCount = 0;
        for (int i = 0; i < 10 && WorldUtil.isEntityBlockLoaded((LevelAccessor)this.colony.getWorld(), tempPos); ++i) {
            tempPos = tempPos.m_7918_((int)(16.0 * xzRatio.f_82479_), 0, (int)(16.0 * xzRatio.f_82481_));
            if (!WorldUtil.isEntityBlockLoaded((LevelAccessor)this.colony.getWorld(), tempPos)) break;
            if (!RaidManager.isValidSpawnPoint(buildings, tempPos) || this.isOtherColony(tempPos.m_123341_(), tempPos.m_123343_())) continue;
            spawnPos = tempPos;
            if (++validChunkCount <= 2 && i <= 2) continue;
            return spawnPos;
        }
        if (!spawnPos.equals((Object)start)) {
            return spawnPos;
        }
        return null;
    }

    private boolean isOtherColony(int x, int z) {
        int owningColonyId = ColonyUtils.getOwningColony(this.colony.getWorld().m_6325_(x >> 4, z >> 4));
        return owningColonyId != 0 && owningColonyId != this.colony.getID();
    }

    public static boolean isValidSpawnPoint(Collection<IBuilding> buildings, BlockPos spawnPos) {
        for (IBuilding building : buildings) {
            if (building.getBuildingLevel() == 0) continue;
            int minDist = 35;
            minDist = building instanceof BuildingGuardTower ? (minDist += building.getBuildingLevel() * 7) : (building.hasModule(LivingBuildingModule.class) ? (minDist += building.getBuildingLevel() * 4) : (building instanceof BuildingTownHall ? (minDist += building.getBuildingLevel() * 8) : (minDist += building.getBuildingLevel() * 2)));
            if (BlockPosUtil.getDistance2D(building.getPosition(), spawnPos) >= (long)minDist) continue;
            return false;
        }
        return true;
    }

    @Override
    public List<BlockPos> getLastSpawnPoints() {
        if (this.raidHistories.isEmpty()) {
            return List.of();
        }
        RaidHistory last = this.raidHistories.get(this.raidHistories.size() - 1);
        return last.spawnData.stream().map(raidSpawnInfo -> raidSpawnInfo.spawnpos).collect(Collectors.toList());
    }

    @Override
    public int calculateRaiderAmount(int raidLevel) {
        int nearbyColonyPlayers = 0;
        for (Player player : this.colony.getMessagePlayerEntities()) {
            if (player.m_5833_()) continue;
            ++nearbyColonyPlayers;
        }
        return 1 + Math.min((Integer)MineColonies.getConfig().getServer().maxRaiders.get(), (int)((double)raidLevel / 60.0 * this.getRaidDifficultyModifier() * (1.0 + (double)nearbyColonyPlayers * 0.05) * (ColonyConstants.rand.nextDouble() * 0.3 + 0.85)));
    }

    @Override
    public boolean isRaided() {
        if (this.colony.getWorld().m_46467_() <= this.passingThroughRaidTime) {
            return true;
        }
        for (IColonyEvent event : this.colony.getEventManager().getEvents().values()) {
            IColonyRaidEvent raidEvent;
            if (!(event instanceof IColonyRaidEvent) || !(raidEvent = (IColonyRaidEvent)event).isRaidActive()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void onNightFall() {
        if (!this.isRaided() || this.passingThroughRaidTime > 0L) {
            if (this.nightsSinceLastRaid == 0 && !this.raidHistories.isEmpty()) {
                RaidHistory history = this.raidHistories.get(this.raidHistories.size() - 1);
                double lostPct = (double)history.lostCitizens / (double)this.colony.getCitizenManager().getMaxCitizens();
                if (lostPct > 0.15) {
                    this.raidDifficulty = Math.max(1, this.raidDifficulty - (int)(lostPct / 0.15));
                } else if (lostPct < 0.05) {
                    this.raidDifficulty = Math.min(14, this.raidDifficulty + 1);
                }
            }
            ++this.nightsSinceLastRaid;
        } else {
            this.nightsSinceLastRaid = 0;
        }
        if (this.raidTonight) {
            boolean overrideConfig = !this.nextForcedType.isEmpty();
            IRaiderManager.RaidSpawnResult result = this.raiderEvent(this.nextForcedType, overrideConfig, this.allowShips);
            if (result == IRaiderManager.RaidSpawnResult.SUCCESS || result == IRaiderManager.RaidSpawnResult.TOO_SMALL) {
                this.raidTonight = false;
                this.nextForcedType = INITIAL_NEXT_RAID_TYPE;
            }
        } else {
            this.determineRaidForNextDay();
        }
    }

    @Override
    public int getNightsSinceLastRaid() {
        return this.nightsSinceLastRaid;
    }

    @Override
    public void setNightsSinceLastRaid(int nightsSinceLastRaid) {
        this.nightsSinceLastRaid = nightsSinceLastRaid;
    }

    @Override
    public boolean canRaid() {
        return !WorldUtil.isPeaceful(this.colony.getWorld()) && (Boolean)MineColonies.getConfig().getServer().enableColonyRaids.get() != false && this.colony.getRaiderManager().canHaveRaiderEvents() && !this.colony.getPackageManager().getImportantColonyPlayers().isEmpty();
    }

    private void determineRaidForNextDay() {
        boolean raid;
        boolean bl = raid = this.canRaid() && this.raidThisNight(this.colony.getWorld(), this.colony);
        if (((Boolean)MineColonies.getConfig().getServer().enableInDevelopmentFeatures.get()).booleanValue()) {
            MessageUtils.format((Component)Component.m_237113_((String)("Will raid tomorrow: " + raid))).sendTo(this.colony).forAllPlayers();
        }
        this.setRaidNextNight(raid);
    }

    @Override
    public int getColonyRaidLevel() {
        int levels = 0;
        for (ICitizenData data : this.colony.getCitizenManager().getCitizens()) {
            if (data.isChild()) continue;
            levels += 5;
            int skillSum = 0;
            for (CitizenSkillHandler.SkillData skillData : data.getCitizenSkillHandler().getSkills().values()) {
                skillSum += skillData.getLevel();
            }
            levels += skillSum / 100;
        }
        for (IBuilding building : this.colony.getBuildingManager().getBuildings().values()) {
            if (building.getBuildingLevel() <= 0) continue;
            levels += 5 + building.getBuildingLevel() * building.getBuildingLevel() / 5;
        }
        double populationFactor = Math.min(1.0, (double)this.colony.getCitizenManager().getCurrentCitizenCount() / (double)this.colony.getCitizenManager().getMaxCitizens());
        return (int)((double)(levels += this.colony.getResearchManager().getResearchTree().getCompletedList().size() * 3) * populationFactor);
    }

    private boolean raidThisNight(Level world, IColony colony) {
        if (this.nightsSinceLastRaid < (Integer)MineColonies.getConfig().getServer().minimumNumberOfNightsBetweenRaids.get()) {
            return false;
        }
        if (this.nightsSinceLastRaid > (Integer)MineColonies.getConfig().getServer().averageNumberOfNightsBetweenRaids.get() + 2) {
            return true;
        }
        return world.f_46441_.m_188500_() < 1.0 / (double)((Integer)MineColonies.getConfig().getServer().averageNumberOfNightsBetweenRaids.get() - (Integer)MineColonies.getConfig().getServer().minimumNumberOfNightsBetweenRaids.get());
    }

    @Override
    @NotNull
    public BlockPos getRandomBuilding() {
        ++this.buildingPosUsage;
        if (this.buildingPosUsage > Math.max(6, this.getLastRaid().raiderAmount / 3) || this.lastBuilding == null) {
            this.buildingPosUsage = 0;
            Collection<IBuilding> buildingList = this.colony.getBuildingManager().getBuildings().values();
            Object[] buildingArray = buildingList.toArray();
            if (buildingArray.length != 0) {
                int rand = this.colony.getWorld().f_46441_.m_188503_(buildingArray.length);
                IBuilding building = (IBuilding)buildingArray[rand];
                if (this.lastBuilding != null) {
                    ArrayList<AbstractEntityCitizen> possibleGuards = new ArrayList<AbstractEntityCitizen>();
                    for (ICitizenData entry : this.colony.getCitizenManager().getCitizens()) {
                        if (!entry.getEntity().isPresent() || !(entry.getJob() instanceof AbstractJobGuard) || BlockPosUtil.getDistanceSquared(entry.getEntity().get().m_20183_(), this.lastBuilding) >= 5625L || entry.getJob().getWorkerAI() == null || !((AbstractEntityAIGuard)entry.getJob().getWorkerAI()).canHelp(building.getPosition())) continue;
                        possibleGuards.add(entry.getEntity().get());
                    }
                    possibleGuards.sort(Comparator.comparingInt(guard -> (int)this.lastBuilding.m_123331_((Vec3i)guard.m_20183_())));
                    for (int i = 0; i < possibleGuards.size() && i <= 3; ++i) {
                        ((AbstractEntityAIGuard)((AbstractEntityCitizen)possibleGuards.get(i)).getCitizenData().getJob().getWorkerAI()).setNextPatrolTargetAndMove(this.lastBuilding);
                    }
                }
                this.lastBuilding = building.getPosition();
            } else {
                this.lastBuilding = this.colony.getCenter();
            }
        }
        return this.lastBuilding;
    }

    @Override
    public double getRaidDifficultyModifier() {
        return ((double)this.raidDifficulty / 10.0 + 0.2) * ((double)((Integer)MinecoloniesAPIProxy.getInstance().getConfig().getServer().raidDifficulty.get()).intValue() / 5.0) * ((double)this.colony.getWorld().m_46791_().m_19028_() / 2.0) * this.spawnCountAdjustedDifficulty;
    }

    @Override
    public void onLostCitizen(ICitizenData citizen) {
        if (!this.isRaided()) {
            return;
        }
        if (this.raidHistories.isEmpty()) {
            return;
        }
        RaidHistory history = this.raidHistories.get(this.raidHistories.size() - 1);
        history.lostCitizens = citizen.getJob() instanceof AbstractJobGuard ? ++history.lostCitizens : (history.lostCitizens += 2);
        if ((double)history.lostCitizens / (double)this.colony.getCitizenManager().getMaxCitizens() > 0.5) {
            for (IColonyEvent event : this.colony.getEventManager().getEvents().values()) {
                if (!(event instanceof IColonyRaidEvent)) continue;
                IColonyRaidEvent raidEvent = (IColonyRaidEvent)event;
                raidEvent.setStatus(EventStatus.DONE);
            }
        }
    }

    @Override
    public void write(CompoundTag compound) {
        compound.m_128379_("raidable", this.canHaveRaiderEvents());
        compound.m_128405_("nightsRaid", this.getNightsSinceLastRaid());
        compound.m_128405_(TAG_RAID_DIFFICULTY, this.raidDifficulty);
        ListTag nbtList = new ListTag();
        for (RaidHistory history : this.raidHistories) {
            nbtList.add((Object)history.write());
        }
        compound.m_128365_("raidhistory", (Tag)nbtList);
    }

    @Override
    public void read(CompoundTag compound) {
        if (compound.m_128441_("raidable")) {
            this.setCanHaveRaiderEvents(compound.m_128471_("raidable"));
        } else {
            this.setCanHaveRaiderEvents(true);
        }
        if (compound.m_128441_("nightsRaid")) {
            this.setNightsSinceLastRaid(compound.m_128451_("nightsRaid"));
        }
        this.raidDifficulty = Mth.m_14045_((int)compound.m_128451_(TAG_RAID_DIFFICULTY), (int)1, (int)14);
        if (compound.m_128441_("raidhistory")) {
            this.raidHistories.clear();
            ListTag nbtList = compound.m_128437_("raidhistory", 10);
            for (Tag tag : nbtList) {
                this.raidHistories.add(RaidHistory.fromNBT((CompoundTag)tag));
            }
        }
    }

    @Override
    public int getLostCitizen() {
        if (this.raidHistories.isEmpty()) {
            return 0;
        }
        return this.raidHistories.get((int)(this.raidHistories.size() - 1)).lostCitizens;
    }

    @Override
    public void onRaiderDeath(AbstractEntityMinecoloniesRaider entity) {
        RaidHistory last = this.getLastRaid();
        if (last != null) {
            ++last.deadRaiders;
        }
    }

    @Override
    public void onRaidEventFinished(IColonyRaidEvent finishedRaid) {
        for (IColonyEvent event : this.colony.getEventManager().getEvents().values()) {
            IColonyRaidEvent raidEvent;
            if (!(event instanceof IColonyRaidEvent) || (raidEvent = (IColonyRaidEvent)event).getStatus() != EventStatus.PROGRESSING) continue;
            return;
        }
        if ((double)this.raidHistories.get((int)0).lostCitizens / (double)this.colony.getCitizenManager().getMaxCitizens() > 0.5) {
            MessageUtils.format("com.minecolonies.core.barbarians.mercy", this.colony.getName()).sendTo(this.colony).forManagers();
        } else {
            Object msgID = "com.minecolonies.coremod.barbarians.killed";
            int rng = ColonyConstants.rand.nextInt(3);
            if (rng > 0) {
                msgID = (String)msgID + rng;
            }
            MessageUtils.format((String)msgID, this.colony.getName()).sendTo(this.colony).forManagers();
        }
        PlayAudioMessage audio = new PlayAudioMessage(this.raidHistories.get((int)0).raiderAmount <= 5 ? RaidSounds.VICTORY_EARLY : RaidSounds.VICTORY, SoundSource.RECORDS);
        PlayAudioMessage.sendToAll(this.colony, false, true, audio);
        if (this.colony.getRaiderManager().getLostCitizen() == 0) {
            this.colony.getCitizenManager().injectModifier(new ExpirationBasedHappinessModifier("raidwithoutdeath", 1.0, new StaticHappinessSupplier(2.0), 3));
        }
    }

    public RaidHistory getLastRaid() {
        if (this.raidHistories.isEmpty()) {
            return null;
        }
        return this.raidHistories.get(this.raidHistories.size() - 1);
    }

    @Override
    public void setPassThroughRaid() {
        this.passingThroughRaidTime = this.colony.getWorld().m_46467_() + 400L;
    }

    public List<RaidHistory> getAllRaids() {
        return new ArrayList<RaidHistory>(this.raidHistories);
    }

    public static class RaidHistory {
        static final String TAG_LOSTCITIZENS = "lostCitizens";
        static final String TAG_RAIDERAMOUNT = "raiderAmount";
        static final String TAG_RAIDTIME = "raidTime";
        static final String TAG_DIFFICULTY = "difficulty";
        static final String TAG_SPAWNINFO = "spawnInfo";
        public int lostCitizens = 0;
        public final int raiderAmount;
        public int deadRaiders = 0;
        public final long raidTime;
        public double difficulty = 0.0;
        public final List<RaidSpawnInfo> spawnData = new ArrayList<RaidSpawnInfo>();

        public RaidHistory(int raiderAmount, long raidTime) {
            this.raidTime = raidTime;
            this.raiderAmount = raiderAmount;
        }

        private CompoundTag write() {
            CompoundTag tag = new CompoundTag();
            tag.m_128405_("lostCitizens", this.lostCitizens);
            tag.m_128405_(TAG_RAIDERAMOUNT, this.raiderAmount);
            tag.m_128356_(TAG_RAIDTIME, this.raidTime);
            tag.m_128347_("difficulty", this.difficulty);
            ListTag nbtList = new ListTag();
            for (RaidSpawnInfo raidSpawnInfo : this.spawnData) {
                nbtList.add((Object)raidSpawnInfo.write());
            }
            tag.m_128365_(TAG_SPAWNINFO, (Tag)nbtList);
            return tag;
        }

        private static RaidHistory fromNBT(CompoundTag tag) {
            RaidHistory history = new RaidHistory(tag.m_128451_(TAG_RAIDERAMOUNT), tag.m_128454_(TAG_RAIDTIME));
            history.lostCitizens = tag.m_128451_("lostCitizens");
            history.difficulty = tag.m_128459_("difficulty");
            ListTag nbtList = tag.m_128437_(TAG_SPAWNINFO, 10);
            for (Tag entry : nbtList) {
                history.spawnData.add(RaidSpawnInfo.fromNBT((CompoundTag)entry));
            }
            return history;
        }

        public String toString() {
            return "Raid on: " + this.raidTime / 24000L + "\nRaiders spawned: " + this.raiderAmount + "\nRaiders killed: " + this.deadRaiders + "\nCitizens lost: " + this.lostCitizens + "\nDifficulty: " + this.difficulty + "\nSpawns:" + this.spawnData.stream().map(Object::toString).collect(Collectors.joining("\n"));
        }
    }

    public static class RaidSpawnInfo {
        static final String TAG_RAIDTYPE = "raidtype";
        public final ResourceLocation raidType;
        public final BlockPos spawnpos;

        public RaidSpawnInfo(ResourceLocation raidType, BlockPos spawnpos) {
            this.raidType = raidType;
            this.spawnpos = spawnpos;
        }

        private CompoundTag write() {
            CompoundTag tag = new CompoundTag();
            tag.m_128359_(TAG_RAIDTYPE, this.raidType.toString());
            tag.m_128405_("x", this.spawnpos.m_123341_());
            tag.m_128405_("y", this.spawnpos.m_123342_());
            tag.m_128405_("z", this.spawnpos.m_123343_());
            return tag;
        }

        public static RaidSpawnInfo fromNBT(CompoundTag tag) {
            return new RaidSpawnInfo(new ResourceLocation(tag.m_128461_(TAG_RAIDTYPE)), new BlockPos(tag.m_128451_("x"), tag.m_128451_("y"), tag.m_128451_("z")));
        }

        public String toString() {
            return "Type: " + this.raidType.toString() + " pos: " + this.spawnpos.m_123344_();
        }
    }
}

