/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.buildings.workerbuildings.plantation.modules.specific;

import com.minecolonies.api.colony.fields.IField;
import com.minecolonies.api.colony.fields.plantation.IPlantationModule;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.equipment.ModEquipmentTypes;
import com.minecolonies.api.equipment.registry.EquipmentTypeEntry;
import com.minecolonies.core.colony.buildings.workerbuildings.plantation.modules.generic.BoneMealedPlantModule;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BoneMealItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SeaPickleBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.jetbrains.annotations.NotNull;

public class SeapicklePlantModule
extends BoneMealedPlantModule {
    private static final int MAX_PLANTS = 10;

    public SeapicklePlantModule(IField field, String fieldTag, String workTag, Item item) {
        super(field, fieldTag, workTag, item);
    }

    @Override
    public EquipmentTypeEntry getRequiredTool() {
        return (EquipmentTypeEntry)ModEquipmentTypes.none.get();
    }

    @Override
    public IPlantationModule.PlantationModuleResult.Builder decideFieldWork(Level world, @NotNull BlockPos workPosition) {
        BlockState state = world.m_8055_(workPosition.m_7494_());
        if (state.m_60734_().equals(Blocks.f_49990_)) {
            return new IPlantationModule.PlantationModuleResult.Builder().plant(workPosition.m_7494_()).pickNewPosition();
        }
        return super.decideFieldWork(world, workPosition);
    }

    @Override
    protected boolean isValidHarvestBlock(BlockState blockState) {
        if (blockState.m_60734_() instanceof SeaPickleBlock) {
            Integer value = (Integer)blockState.m_61143_((Property)SeaPickleBlock.f_56074_);
            return value >= 4;
        }
        return super.isValidHarvestBlock(blockState);
    }

    @Override
    protected boolean isValidBonemealLocation(BlockState blockState) {
        if (blockState.m_60734_() instanceof SeaPickleBlock) {
            Integer value = (Integer)blockState.m_61143_((Property)SeaPickleBlock.f_56074_);
            return value < 4;
        }
        return super.isValidBonemealLocation(blockState);
    }

    @Override
    protected int getMaxWorkingPositions() {
        return 10;
    }

    @Override
    public @NonNull List<Item> getValidBonemeal() {
        return List.of(Items.f_42499_);
    }

    @Override
    public void applyBonemeal(AbstractEntityCitizen worker, BlockPos workPosition, ItemStack stackInSlot, Player fakePlayer) {
        BoneMealItem.applyBonemeal((ItemStack)stackInSlot, (Level)worker.m_9236_(), (BlockPos)workPosition.m_7494_(), (Player)fakePlayer);
        BoneMealItem.m_40638_((LevelAccessor)worker.m_9236_(), (BlockPos)workPosition.m_7494_(), (int)1);
    }
}

