/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.buildings.workerbuildings;

import com.ldtteam.blockui.views.BOWindow;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.buildings.modules.settings.ISettingKey;
import com.minecolonies.api.colony.fields.IField;
import com.minecolonies.api.colony.fields.registry.FieldRegistries;
import com.minecolonies.api.colony.jobs.registry.JobEntry;
import com.minecolonies.api.crafting.GenericRecipe;
import com.minecolonies.api.crafting.IGenericRecipe;
import com.minecolonies.api.equipment.ModEquipmentTypes;
import com.minecolonies.api.equipment.registry.EquipmentTypeEntry;
import com.minecolonies.api.util.CraftingUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.OptionalPredicate;
import com.minecolonies.api.util.constant.TagConstants;
import com.minecolonies.core.blocks.MinecoloniesCropBlock;
import com.minecolonies.core.client.gui.modules.FarmFieldsModuleWindow;
import com.minecolonies.core.colony.buildings.AbstractBuilding;
import com.minecolonies.core.colony.buildings.modules.AbstractCraftingBuildingModule;
import com.minecolonies.core.colony.buildings.modules.FieldsModule;
import com.minecolonies.core.colony.buildings.modules.settings.BoolSetting;
import com.minecolonies.core.colony.buildings.modules.settings.SettingKey;
import com.minecolonies.core.colony.buildings.moduleviews.FieldsModuleView;
import com.minecolonies.core.colony.fields.FarmField;
import com.minecolonies.core.items.ItemCrop;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.StemBlock;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.Tags;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuildingFarmer
extends AbstractBuilding {
    public static final ISettingKey<BoolSetting> FERTILIZE = new SettingKey<BoolSetting>(BoolSetting.class, new ResourceLocation("minecolonies", "fertilize"));
    private static final String FARMER = "farmer";
    private static final int MAX_BUILDING_LEVEL = 5;

    public BuildingFarmer(IColony c, BlockPos l) {
        super(c, l);
        this.keepX.put(itemStack -> ItemStackUtils.hasEquipmentLevel(itemStack, (EquipmentTypeEntry)ModEquipmentTypes.hoe.get(), 0, this.getMaxEquipmentLevel()), new Tuple((Object)1, (Object)true));
        this.keepX.put(itemStack -> ItemStackUtils.hasEquipmentLevel(itemStack, (EquipmentTypeEntry)ModEquipmentTypes.axe.get(), 0, this.getMaxEquipmentLevel()), new Tuple((Object)1, (Object)true));
    }

    @Override
    public boolean canBeGathered() {
        return true;
    }

    @Override
    public Map<Predicate<ItemStack>, Tuple<Integer, Boolean>> getRequiredItemsAndAmount() {
        HashMap<Predicate<ItemStack>, Tuple<Integer, Boolean>> toKeep = new HashMap<Predicate<ItemStack>, Tuple<Integer, Boolean>>(super.getRequiredItemsAndAmount());
        for (FieldsModule module : this.getModulesByType(FieldsModule.class)) {
            for (IField field : module.getOwnedFields()) {
                FarmField farmField;
                if (!(field instanceof FarmField) || (farmField = (FarmField)field).getSeed().m_41619_()) continue;
                toKeep.put(stack -> ItemStack.m_41656_((ItemStack)farmField.getSeed(), (ItemStack)stack), (Tuple<Integer, Boolean>)new Tuple((Object)64, (Object)true));
            }
        }
        return toKeep;
    }

    @Override
    public boolean canEat(ItemStack stack) {
        for (FieldsModule module : this.getModulesByType(FieldsModule.class)) {
            for (IField field : module.getOwnedFields()) {
                FarmField farmField;
                if (!(field instanceof FarmField) || (farmField = (FarmField)field).getSeed().m_41619_() || !ItemStackUtils.compareItemStacksIgnoreStackSize(farmField.getSeed(), stack).booleanValue()) continue;
                return false;
            }
        }
        if (stack.m_41720_() == Items.f_42405_) {
            return false;
        }
        return super.canEat(stack);
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return FARMER;
    }

    public boolean requestFertilizer() {
        return this.getSetting(FERTILIZE).getValue();
    }

    public static class CraftingModule
    extends AbstractCraftingBuildingModule.Crafting {
        public CraftingModule(JobEntry jobEntry) {
            super(jobEntry);
        }

        @Override
        @NotNull
        public OptionalPredicate<ItemStack> getIngredientValidator() {
            return CraftingUtils.getIngredientValidatorBasedOnTags(TagConstants.CRAFTING_FARMER).combine(super.getIngredientValidator());
        }

        @Override
        public boolean isRecipeCompatible(@NotNull IGenericRecipe recipe) {
            if (!super.isRecipeCompatible(recipe)) {
                return false;
            }
            return CraftingUtils.isRecipeCompatibleBasedOnTags(recipe, TagConstants.CRAFTING_FARMER).orElse(false);
        }

        @Override
        @NotNull
        public List<IGenericRecipe> getAdditionalRecipesForDisplayPurposesOnly(@NotNull Level world) {
            ArrayList<IGenericRecipe> recipes = new ArrayList<IGenericRecipe>(super.getAdditionalRecipesForDisplayPurposesOnly(world));
            for (ItemStack stack : IColonyManager.getInstance().getCompatibilityManager().getListOfAllItems()) {
                BlockItem item;
                BlockItem item2;
                Object restrictions;
                ItemCrop cropItem;
                Item item3 = stack.m_41720_();
                if (item3 instanceof ItemCrop && (item3 = (cropItem = (ItemCrop)item3).m_40614_()) instanceof MinecoloniesCropBlock) {
                    MinecoloniesCropBlock crop = (MinecoloniesCropBlock)item3;
                    restrictions = new ArrayList();
                    if (crop.getPreferredBiome() != null) {
                        Registry biomeRegistry = world.m_9598_().m_175515_(crop.getPreferredBiome().f_203867_());
                        Object[] biomes = ((HolderSet.Named)biomeRegistry.m_203431_(crop.getPreferredBiome()).get()).m_203614_().map(b -> Component.m_237115_((String)biomeRegistry.m_7981_((Object)((Biome)b.get())).m_214296_("biome"))).toArray();
                        restrictions.add(Component.m_237110_((String)"com.minecolonies.coremod.jei.biomerestriction", (Object[])new Object[]{Component.m_237110_((String)String.join((CharSequence)", ", Collections.nCopies(biomes.length, "%s")), (Object[])biomes)}));
                    }
                    recipes.add(new GenericRecipe(null, ItemStack.f_41583_, List.of(), List.of(List.of(new ItemStack((ItemLike)cropItem))), 1, crop.getPreferredFarmland(), crop.m_60589_(), (EquipmentTypeEntry)ModEquipmentTypes.hoe.get(), (List<Component>)restrictions, 0));
                    continue;
                }
                restrictions = stack.m_41720_();
                if (restrictions instanceof BlockItem && (restrictions = (item2 = (BlockItem)restrictions).m_40614_()) instanceof CropBlock) {
                    CropBlock crop = (CropBlock)restrictions;
                    recipes.add(new GenericRecipe(null, ItemStack.f_41583_, List.of(), List.of(List.of(crop.m_7397_((BlockGetter)world, BlockPos.f_121853_, crop.m_49966_()))), 1, Blocks.f_50093_, crop.m_60589_(), (EquipmentTypeEntry)ModEquipmentTypes.hoe.get(), List.of(), 0));
                    continue;
                }
                if (!stack.m_204117_(Tags.Items.SEEDS)) continue;
                Item item4 = stack.m_41720_();
                if (item4 instanceof BlockItem && (item4 = (item = (BlockItem)item4).m_40614_()) instanceof StemBlock) {
                    StemBlock stem = (StemBlock)item4;
                    recipes.add(new GenericRecipe(null, new ItemStack((ItemLike)stem.m_57056_()), List.of(), List.of(List.of(stack)), 1, Blocks.f_50093_, null, (EquipmentTypeEntry)ModEquipmentTypes.hoe.get(), List.of(), 0));
                    continue;
                }
                recipes.add(new GenericRecipe(null, ItemStack.f_41583_, List.of(), List.of(List.of(stack)), 1, Blocks.f_50093_, null, (EquipmentTypeEntry)ModEquipmentTypes.hoe.get(), List.of(), 0));
            }
            return recipes;
        }

        @Override
        @NotNull
        public List<ResourceLocation> getAdditionalLootTables() {
            ArrayList<ResourceLocation> tables = new ArrayList<ResourceLocation>(super.getAdditionalLootTables());
            for (ItemStack stack : IColonyManager.getInstance().getCompatibilityManager().getListOfAllItems()) {
                BlockItem item;
                ItemCrop cropItem;
                Item item2 = stack.m_41720_();
                if (item2 instanceof ItemCrop && (item2 = (cropItem = (ItemCrop)item2).m_40614_()) instanceof MinecoloniesCropBlock) {
                    MinecoloniesCropBlock crop = (MinecoloniesCropBlock)item2;
                    tables.add(crop.m_60589_());
                    continue;
                }
                item2 = stack.m_41720_();
                if (!(item2 instanceof BlockItem) || !((item2 = (item = (BlockItem)item2).m_40614_()) instanceof CropBlock)) continue;
                CropBlock crop = (CropBlock)item2;
                tables.add(crop.m_60589_());
            }
            return tables;
        }
    }

    public static class FarmerFieldsModuleView
    extends FieldsModuleView {
        @Override
        @OnlyIn(value=Dist.CLIENT)
        public BOWindow getWindow() {
            return new FarmFieldsModuleWindow(this.buildingView, this);
        }

        @Override
        public boolean canAssignFieldOverride(IField field) {
            FarmField farmField;
            return field instanceof FarmField && !(farmField = (FarmField)field).getSeed().m_41619_();
        }

        @Override
        protected List<IField> getFieldsInColony() {
            return this.getColony().getFields(field -> field.getFieldType().equals(FieldRegistries.farmField.get()));
        }

        @Override
        @Nullable
        public MutableComponent getFieldWarningTooltip(IField field) {
            FarmField farmField;
            MutableComponent result = super.getFieldWarningTooltip(field);
            if (result != null) {
                return result;
            }
            if (field instanceof FarmField && (farmField = (FarmField)field).getSeed().m_41619_()) {
                return Component.m_237115_((String)"com.minecolonies.coremod.gui.workerhuts.fields.farmer.noseed");
            }
            return null;
        }
    }

    public static class FarmerFieldsModule
    extends FieldsModule {
        @Override
        protected int getMaxFieldCount() {
            return this.building.getBuildingLevel();
        }

        @Override
        public Class<?> getExpectedFieldType() {
            return FarmField.class;
        }

        @Override
        @NotNull
        public List<IField> getFields() {
            return this.building.getColony().getBuildingManager().getFields(field -> field.getFieldType().equals(FieldRegistries.farmField.get())).stream().toList();
        }

        @Override
        public boolean canAssignFieldOverride(IField field) {
            FarmField farmField;
            return field instanceof FarmField && !(farmField = (FarmField)field).getSeed().m_41619_();
        }

        @Override
        protected int getFieldCheckTimeoutSeconds() {
            return 60;
        }
    }
}

