/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.buildings.workerbuildings;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.modules.settings.ISettingKey;
import com.minecolonies.api.colony.jobs.ModJobs;
import com.minecolonies.api.colony.jobs.registry.JobEntry;
import com.minecolonies.api.crafting.GenericRecipe;
import com.minecolonies.api.crafting.IGenericRecipe;
import com.minecolonies.api.equipment.ModEquipmentTypes;
import com.minecolonies.api.equipment.registry.EquipmentTypeEntry;
import com.minecolonies.api.util.NBTUtils;
import com.minecolonies.core.colony.buildings.AbstractBuilding;
import com.minecolonies.core.colony.buildings.modules.AnimalHerdingModule;
import com.minecolonies.core.colony.buildings.modules.settings.BeekeeperCollectionSetting;
import com.minecolonies.core.colony.buildings.modules.settings.SettingKey;
import com.minecolonies.core.colony.buildings.views.AbstractBuildingView;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.NotNull;

public class BuildingBeekeeper
extends AbstractBuilding {
    public static final ISettingKey<BeekeeperCollectionSetting> MODE = new SettingKey<BeekeeperCollectionSetting>(BeekeeperCollectionSetting.class, new ResourceLocation("minecolonies", "beekeeper"));
    public static final String HONEYCOMB = "com.minecolonies.core.apiary.setting.honeycomb";
    public static final String HONEY = "com.minecolonies.core.apiary.setting.honey";
    public static final String BOTH = "com.minecolonies.core.apiary.setting.both";
    private static final String BEEKEEPER = "beekeeper";
    private Set<BlockPos> hives = new HashSet<BlockPos>();

    public BuildingBeekeeper(@NotNull IColony c, BlockPos l) {
        super(c, l);
        this.keepX.put(stack -> Items.f_42574_ == stack.m_41720_(), new Tuple((Object)1, (Object)true));
        this.keepX.put(stack -> Items.f_42590_ == stack.m_41720_(), new Tuple((Object)4, (Object)true));
        this.keepX.put(stack -> stack.m_204117_(ItemTags.f_13149_), new Tuple((Object)64, (Object)true));
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return BEEKEEPER;
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    @Override
    public void deserializeNBT(CompoundTag compound) {
        super.deserializeNBT(compound);
        NBTUtils.streamCompound(compound.m_128437_("hives", 10)).map(NbtUtils::m_129239_).forEach(this.hives::add);
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag nbt = super.serializeNBT();
        nbt.m_128365_("hives", (Tag)this.hives.stream().map(NbtUtils::m_129224_).collect(NBTUtils.toListNBT()));
        return nbt;
    }

    @Override
    public void serializeToView(@NotNull FriendlyByteBuf buf, boolean fullSync) {
        super.serializeToView(buf, fullSync);
        buf.m_130130_(this.hives.size());
        for (BlockPos hive : this.hives) {
            buf.m_130064_(hive);
        }
    }

    @Override
    public boolean canEat(ItemStack stack) {
        if (stack.m_41720_() == Items.f_42787_) {
            return false;
        }
        return super.canEat(stack);
    }

    public Set<BlockPos> getHives() {
        return Collections.unmodifiableSet(new HashSet<BlockPos>(this.hives));
    }

    public void removeHive(BlockPos pos) {
        this.hives.remove(pos);
    }

    public void addHive(BlockPos pos) {
        this.hives.add(pos);
    }

    public String getHarvestTypes() {
        return this.getSetting(MODE).getValue();
    }

    public int getMaximumHives() {
        return (int)Math.pow(2.0, this.getBuildingLevel() - 1);
    }

    public static class HerdingModule
    extends AnimalHerdingModule {
        public HerdingModule() {
            super((JobEntry)ModJobs.beekeeper.get(), a -> a instanceof Bee, ItemStack.f_41583_);
        }

        @Override
        @NotNull
        public List<ItemStack> getBreedingItems() {
            if (this.building != null) {
                // empty if block
            }
            return IColonyManager.getInstance().getCompatibilityManager().getImmutableFlowers().stream().map(flower -> new ItemStack((ItemLike)flower.getItem(), 2)).collect(Collectors.toList());
        }

        @Override
        @NotNull
        public List<IGenericRecipe> getRecipesForDisplayPurposesOnly(@NotNull Animal animal) {
            ArrayList<IGenericRecipe> recipes = new ArrayList<IGenericRecipe>();
            recipes.add(new GenericRecipe(null, new ItemStack((ItemLike)Items.f_42784_), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), 0, Blocks.f_50016_, null, (EquipmentTypeEntry)ModEquipmentTypes.shears.get(), animal.m_6095_(), Collections.emptyList(), 0));
            recipes.add(new GenericRecipe(null, new ItemStack((ItemLike)Items.f_42787_), Collections.emptyList(), Collections.emptyList(), Collections.singletonList(Collections.singletonList(new ItemStack((ItemLike)Items.f_42590_))), 0, Blocks.f_50016_, null, (EquipmentTypeEntry)ModEquipmentTypes.none.get(), animal.m_6095_(), Collections.emptyList(), 0));
            return recipes;
        }
    }

    public static class View
    extends AbstractBuildingView {
        private Set<BlockPos> hives;

        public View(IColonyView c, BlockPos l) {
            super(c, l);
        }

        @Override
        public void deserialize(@NotNull FriendlyByteBuf buf) {
            super.deserialize(buf);
            int hiveCount = buf.m_130242_();
            this.hives = new HashSet<BlockPos>();
            for (int i = 0; i < hiveCount; ++i) {
                this.hives.add(buf.m_130135_());
            }
        }

        public Set<BlockPos> getHives() {
            return Collections.unmodifiableSet(new HashSet<BlockPos>(this.hives));
        }
    }
}

