/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.buildings.moduleviews;

import com.ldtteam.blockui.views.BOWindow;
import com.minecolonies.api.colony.buildings.modules.AbstractBuildingModuleView;
import com.minecolonies.api.colony.buildings.modules.IEntityListModuleView;
import com.minecolonies.core.Network;
import com.minecolonies.core.client.gui.modules.EntityListModuleWindow;
import com.minecolonies.core.network.messages.server.colony.building.AssignFilterableEntityMessage;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class EntityListModuleView
extends AbstractBuildingModuleView
implements IEntityListModuleView {
    private final List<ResourceLocation> listOfEntities = new ArrayList<ResourceLocation>();
    private final String id;
    private final boolean inverted;
    private final String desc;

    public EntityListModuleView(String id, String desc, boolean inverted) {
        this.id = id;
        this.desc = desc;
        this.inverted = inverted;
    }

    @Override
    public void addEntity(ResourceLocation entity) {
        Network.getNetwork().sendToServer(new AssignFilterableEntityMessage(this.buildingView, this.getProducer().getRuntimeID(), entity, true));
        this.listOfEntities.add(entity);
    }

    @Override
    public boolean isAllowedEntity(ResourceLocation entity) {
        return this.listOfEntities.contains(entity);
    }

    @Override
    public int getSize() {
        return this.listOfEntities.size();
    }

    @Override
    public void removeEntity(ResourceLocation entity) {
        Network.getNetwork().sendToServer(new AssignFilterableEntityMessage(this.buildingView, this.getProducer().getRuntimeID(), entity, false));
        this.listOfEntities.remove(entity);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public boolean isInverted() {
        return this.inverted;
    }

    @Override
    public void clearEntities() {
        this.listOfEntities.clear();
    }

    @Override
    public String getDesc() {
        return this.desc;
    }

    @Override
    public void deserialize(@NotNull FriendlyByteBuf buf) {
        this.listOfEntities.clear();
        int size = buf.readInt();
        for (int j = 0; j < size; ++j) {
            this.listOfEntities.add(ForgeRegistries.ENTITY_TYPES.getKey((Object)((EntityType)buf.readRegistryIdUnsafe(ForgeRegistries.ENTITY_TYPES))));
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public BOWindow getWindow() {
        return new EntityListModuleWindow("minecolonies:gui/layouthuts/layoutfilterableentitylist.xml", this.buildingView, this);
    }

    @Override
    public String getIcon() {
        return "workers";
    }
}

