/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.util;

import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.ICivilianData;
import com.minecolonies.api.colony.IVisitorData;
import com.minecolonies.api.colony.jobs.IJob;
import com.minecolonies.api.sounds.EventType;
import com.minecolonies.api.sounds.ModSoundEvents;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.level.NoteBlockEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SoundUtils {
    private static final int ONE_HUNDRED = 100;
    public static final float PITCH = 1.0f;
    private static final Random rand = new Random();
    public static final double VOLUME = 0.5;
    private static final double BASE_PITCH = 0.8;
    private static final double PITCH_DIVIDER = 1.0;
    private static final double PITCH_MULTIPLIER = 0.4;
    public static final NoteBlockEvent.Note[] PENTATONIC = new NoteBlockEvent.Note[]{NoteBlockEvent.Note.A, NoteBlockEvent.Note.B, NoteBlockEvent.Note.D, NoteBlockEvent.Note.E, NoteBlockEvent.Note.F_SHARP, NoteBlockEvent.Note.A, NoteBlockEvent.Note.B, NoteBlockEvent.Note.D};
    private static final double MIN_REQUIRED_SOUND_DIST = 100.0;

    private SoundUtils() {
    }

    public static void playRandomSound(@NotNull Level worldIn, @NotNull BlockPos pos, @NotNull ICitizenData citizen) {
        boolean playerCloseEnough = false;
        for (Player player : citizen.getColony().getPackageManager().getCloseSubscribers()) {
            if (!(player.m_20183_().m_123331_((Vec3i)pos) < 100.0)) continue;
            playerCloseEnough = true;
            break;
        }
        if (!playerCloseEnough) {
            return;
        }
        if (citizen.isAsleep()) {
            SoundUtils.playSoundAtCitizenWith(worldIn, pos, EventType.OFF_TO_BED, citizen);
            return;
        }
        double v = rand.nextDouble();
        if (v <= 0.1) {
            if (citizen.getSaturation() < 2.0) {
                SoundUtils.playSoundAtCitizenWith(worldIn, pos, EventType.SATURATION_LOW, citizen);
            } else {
                SoundUtils.playSoundAtCitizenWith(worldIn, pos, EventType.SATURATION_HIGH, citizen);
            }
        } else if (v <= 0.2) {
            if (citizen.getCitizenHappinessHandler().getHappiness(citizen.getColony(), citizen) < 5.0) {
                SoundUtils.playSoundAtCitizenWith(worldIn, pos, EventType.UNHAPPY, citizen);
            } else {
                SoundUtils.playSoundAtCitizenWith(worldIn, pos, EventType.HAPPY, citizen);
            }
        } else if (v <= 0.3) {
            SoundUtils.playSoundAtCitizenWith(worldIn, pos, EventType.GENERAL, citizen);
        } else if (v <= 0.4 && citizen.getEntity().isPresent() && citizen.getCitizenDiseaseHandler().isSick()) {
            SoundUtils.playSoundAtCitizenWith(worldIn, pos, EventType.SICKNESS, citizen);
        } else if (v <= 0.5 && (citizen.getHomeBuilding() == null || citizen.getHomeBuilding().getBuildingLevel() <= 2)) {
            SoundUtils.playSoundAtCitizenWith(worldIn, pos, EventType.BAD_HOUSING, citizen);
        } else if (v <= 0.6 && worldIn.m_46471_()) {
            SoundUtils.playSoundAtCitizenWith(worldIn, pos, EventType.BAD_WEATHER, citizen);
        } else if (v <= 0.8 && citizen.isIdleAtJob()) {
            SoundUtils.playSoundAtCitizenWith(worldIn, pos, EventType.MISSING_EQUIPMENT, citizen);
        } else {
            SoundUtils.playSoundAtCitizenWith(worldIn, pos, EventType.NOISE, citizen, EventType.NOISE.getChance(), 0.25);
        }
    }

    public static void playSoundAtCitizen(@NotNull Level worldIn, @NotNull BlockPos position, @NotNull SoundEvent event) {
        worldIn.m_5594_(null, position, event, SoundSource.NEUTRAL, 0.5f, 1.0f);
    }

    public static void playSuccessSound(@NotNull Player player, @NotNull BlockPos position) {
        if (player instanceof ServerPlayer) {
            ((ServerPlayer)player).f_8906_.m_9829_((Packet)new ClientboundSoundPacket((Holder)SoundEvents.f_12210_, SoundSource.NEUTRAL, (double)position.m_123341_(), (double)position.m_123342_(), (double)position.m_123343_(), 1.0f, 1.0f, player.m_9236_().f_46441_.m_188505_()));
        } else {
            player.m_6330_((SoundEvent)SoundEvents.f_12210_.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
        }
    }

    public static void playErrorSound(@NotNull Player player, @NotNull BlockPos position) {
        if (player instanceof ServerPlayer) {
            ((ServerPlayer)player).f_8906_.m_9829_((Packet)new ClientboundSoundPacket((Holder)SoundEvents.f_12169_, SoundSource.NEUTRAL, (double)position.m_123341_(), (double)position.m_123342_(), (double)position.m_123343_(), 1.0f, 0.3f, player.m_9236_().f_46441_.m_188505_()));
        } else {
            player.m_6330_((SoundEvent)SoundEvents.f_12169_.get(), SoundSource.NEUTRAL, 1.0f, 0.3f);
        }
    }

    public static void playSoundAtCitizenWith(@NotNull Level worldIn, @NotNull BlockPos position, @Nullable EventType type, @Nullable ICivilianData citizenData) {
        SoundUtils.playSoundAtCitizenWith(worldIn, position, type, citizenData, type.getChance());
    }

    public static void playSoundAtCitizenWith(@NotNull Level worldIn, @NotNull BlockPos position, @Nullable EventType type, @Nullable ICivilianData citizenData, double chance, double volume) {
        SoundEvent event;
        IJob<?> job;
        if (citizenData == null) {
            return;
        }
        String jobDesc = citizenData instanceof IVisitorData ? "visitor" : (citizenData.isChild() ? "child" : (citizenData instanceof ICitizenData ? ((job = ((ICitizenData)citizenData).getJob()) == null ? "unemployed" : job.getJobRegistryEntry().getKey().m_135815_()) : "unemployed"));
        SoundEvent soundEvent = event = citizenData.isFemale() ? ModSoundEvents.CITIZEN_SOUND_EVENTS.get(jobDesc).get((Object)type).get(citizenData.getVoiceProfile()).getB() : ModSoundEvents.CITIZEN_SOUND_EVENTS.get(jobDesc).get((Object)type).get(citizenData.getVoiceProfile()).getA();
        if (chance > rand.nextDouble() * 100.0) {
            if (worldIn.f_46443_ || !citizenData.getEntity().isPresent()) {
                worldIn.m_5594_(null, position, event, SoundSource.NEUTRAL, (float)volume, 1.0f);
            } else {
                citizenData.getEntity().get().queueSound(event, position, 60, 0, (float)volume, 1.0f);
            }
        }
    }

    public static void playSoundAtCitizenWith(@NotNull Level worldIn, @NotNull BlockPos position, @Nullable EventType type, @Nullable ICivilianData citizenData, double chance) {
        SoundUtils.playSoundAtCitizenWith(worldIn, position, type, citizenData, chance, 0.5);
    }

    public static double getRandomPitch(RandomSource random) {
        return 1.0 / (random.m_188500_() * 0.4 + 0.8);
    }

    public static double getRandomPentatonic(RandomSource random) {
        int index = random.m_188503_(PENTATONIC.length);
        int tone = PENTATONIC[index].ordinal() + Math.floorDiv(index, 5) * 12;
        return Math.pow(2.0, (double)(tone - 12) / 12.0);
    }

    public static void playSoundForPlayer(ServerPlayer playerEntity, SoundEvent sound, float volume, float pitch) {
        playerEntity.f_8906_.m_9829_((Packet)new ClientboundSoundPacket(Holder.m_205709_((Object)sound), playerEntity.m_5720_(), playerEntity.m_20185_(), playerEntity.m_20186_(), playerEntity.m_20189_(), 16.0f * volume, pitch, playerEntity.m_9236_().f_46441_.m_188505_()));
    }
}

