/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.equipment;

import com.minecolonies.api.IMinecoloniesAPI;
import com.minecolonies.api.compatibility.Compatibility;
import com.minecolonies.api.equipment.registry.EquipmentTypeEntry;
import com.minecolonies.api.util.ItemStackUtils;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.FlintAndSteelItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TieredItem;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class ModEquipmentTypes {
    public static final DeferredRegister<EquipmentTypeEntry> DEFERRED_REGISTER = DeferredRegister.create((ResourceLocation)new ResourceLocation("minecolonies", "equipmenttypes"), (String)"minecolonies");
    public static final RegistryObject<EquipmentTypeEntry> none = ModEquipmentTypes.register("none", builder -> builder.setDisplayName((Component)Component.m_237115_((String)"com.minecolonies.coremod.tooltype.none")).setIsEquipment((itemStack, equipmentType) -> true).setEquipmentLevel((itemStack, equipmentType) -> -1).build());
    public static final RegistryObject<EquipmentTypeEntry> pickaxe = ModEquipmentTypes.register("pickaxe", builder -> builder.setDisplayName((Component)Component.m_237115_((String)"com.minecolonies.coremod.tooltype.pickaxe")).setIsEquipment((itemStack, equipmentType) -> ModEquipmentTypes.canPerformDefaultActions(itemStack, ToolActions.DEFAULT_PICKAXE_ACTIONS) || Compatibility.isTinkersTool(itemStack, equipmentType)).setEquipmentLevel(ModEquipmentTypes::vanillaToolLevel).build());
    public static final RegistryObject<EquipmentTypeEntry> shovel = ModEquipmentTypes.register("shovel", builder -> builder.setDisplayName((Component)Component.m_237115_((String)"com.minecolonies.coremod.tooltype.shovel")).setIsEquipment((itemStack, equipmentType) -> ModEquipmentTypes.canPerformDefaultActions(itemStack, ToolActions.DEFAULT_SHOVEL_ACTIONS) || Compatibility.isTinkersTool(itemStack, equipmentType)).setEquipmentLevel(ModEquipmentTypes::vanillaToolLevel).build());
    public static final RegistryObject<EquipmentTypeEntry> axe = ModEquipmentTypes.register("axe", builder -> builder.setDisplayName((Component)Component.m_237115_((String)"com.minecolonies.coremod.tooltype.axe")).setIsEquipment((itemStack, equipmentType) -> ModEquipmentTypes.canPerformDefaultActions(itemStack, ToolActions.DEFAULT_AXE_ACTIONS) || Compatibility.isTinkersTool(itemStack, equipmentType)).setEquipmentLevel(ModEquipmentTypes::vanillaToolLevel).build());
    public static final RegistryObject<EquipmentTypeEntry> hoe = ModEquipmentTypes.register("hoe", builder -> builder.setDisplayName((Component)Component.m_237115_((String)"com.minecolonies.coremod.tooltype.hoe")).setIsEquipment((itemStack, equipmentType) -> ModEquipmentTypes.canPerformDefaultActions(itemStack, ToolActions.DEFAULT_HOE_ACTIONS) || Compatibility.isTinkersTool(itemStack, equipmentType)).setEquipmentLevel(ModEquipmentTypes::vanillaToolLevel).build());
    public static final RegistryObject<EquipmentTypeEntry> sword = ModEquipmentTypes.register("sword", builder -> builder.setDisplayName((Component)Component.m_237115_((String)"com.minecolonies.coremod.tooltype.sword")).setIsEquipment((itemStack, equipmentType) -> ModEquipmentTypes.canPerformDefaultActions(itemStack, ToolActions.DEFAULT_SWORD_ACTIONS) || Compatibility.isTinkersWeapon(itemStack)).setEquipmentLevel((itemStack, equipmentType) -> {
        if (Compatibility.isTinkersWeapon(itemStack)) {
            return Compatibility.getToolLevel(itemStack);
        }
        Item patt5149$temp = itemStack.m_41720_();
        if (patt5149$temp instanceof TieredItem) {
            TieredItem tieredItem = (TieredItem)patt5149$temp;
            return tieredItem.m_43314_().m_6604_();
        }
        return -1;
    }).build());
    public static final RegistryObject<EquipmentTypeEntry> bow = ModEquipmentTypes.register("bow", builder -> builder.setDisplayName((Component)Component.m_237115_((String)"com.minecolonies.coremod.tooltype.bow")).setIsEquipment((itemStack, equipmentType) -> itemStack.m_41720_() instanceof BowItem).setEquipmentLevel((itemStack, equipmentType) -> ModEquipmentTypes.durabilityBasedLevel(itemStack, Items.f_42411_.m_41462_())).build());
    public static final RegistryObject<EquipmentTypeEntry> fishing_rod = ModEquipmentTypes.register("rod", builder -> builder.setDisplayName((Component)Component.m_237115_((String)"com.minecolonies.coremod.tooltype.fishingrod")).setIsEquipment((itemStack, equipmentType) -> ModEquipmentTypes.canPerformDefaultActions(itemStack, ToolActions.DEFAULT_FISHING_ROD_ACTIONS)).setEquipmentLevel((itemStack, equipmentType) -> ModEquipmentTypes.durabilityBasedLevel(itemStack, Items.f_42523_.m_41462_())).build());
    public static final RegistryObject<EquipmentTypeEntry> shears = ModEquipmentTypes.register("shears", builder -> builder.setDisplayName((Component)Component.m_237115_((String)"com.minecolonies.coremod.tooltype.shears")).setIsEquipment((itemStack, equipmentType) -> ModEquipmentTypes.canPerformDefaultActions(itemStack, ToolActions.DEFAULT_SHEARS_ACTIONS)).setEquipmentLevel((itemStack, equipmentType) -> ModEquipmentTypes.durabilityBasedLevel(itemStack, Items.f_42574_.m_41462_())).build());
    public static final RegistryObject<EquipmentTypeEntry> shield = ModEquipmentTypes.register("shield", builder -> builder.setDisplayName((Component)Component.m_237115_((String)"com.minecolonies.coremod.tooltype.shield")).setIsEquipment((itemStack, equipmentType) -> ModEquipmentTypes.canPerformDefaultActions(itemStack, ToolActions.DEFAULT_SHIELD_ACTIONS)).setEquipmentLevel((itemStack, equipmentType) -> ModEquipmentTypes.durabilityBasedLevel(itemStack, Items.f_42740_.m_41462_())).build());
    public static final RegistryObject<EquipmentTypeEntry> helmet = ModEquipmentTypes.register("helmet", builder -> builder.setDisplayName((Component)Component.m_237115_((String)"com.minecolonies.coremod.tooltype.helmet")).setIsEquipment((itemStack, equipmentType) -> {
        ArmorItem armor;
        Item patt7407$temp = itemStack.m_41720_();
        return patt7407$temp instanceof ArmorItem && EquipmentSlot.HEAD.equals((Object)(armor = (ArmorItem)patt7407$temp).m_40402_());
    }).setEquipmentLevel((itemStack, equipmentType) -> ModEquipmentTypes.armorLevel(itemStack)).build());
    public static final RegistryObject<EquipmentTypeEntry> leggings = ModEquipmentTypes.register("leggings", builder -> builder.setDisplayName((Component)Component.m_237115_((String)"com.minecolonies.coremod.tooltype.leggings")).setIsEquipment((itemStack, equipmentType) -> {
        ArmorItem armor;
        Item patt7875$temp = itemStack.m_41720_();
        return patt7875$temp instanceof ArmorItem && EquipmentSlot.LEGS.equals((Object)(armor = (ArmorItem)patt7875$temp).m_40402_());
    }).setEquipmentLevel((itemStack, equipmentType) -> ModEquipmentTypes.armorLevel(itemStack)).build());
    public static final RegistryObject<EquipmentTypeEntry> chestplate = ModEquipmentTypes.register("chestplate", builder -> builder.setDisplayName((Component)Component.m_237115_((String)"com.minecolonies.coremod.tooltype.chestplate")).setIsEquipment((itemStack, equipmentType) -> {
        ArmorItem armor;
        Item patt8350$temp = itemStack.m_41720_();
        return patt8350$temp instanceof ArmorItem && EquipmentSlot.CHEST.equals((Object)(armor = (ArmorItem)patt8350$temp).m_40402_());
    }).setEquipmentLevel((itemStack, equipmentType) -> ModEquipmentTypes.armorLevel(itemStack)).build());
    public static final RegistryObject<EquipmentTypeEntry> boots = ModEquipmentTypes.register("boots", builder -> builder.setDisplayName((Component)Component.m_237115_((String)"com.minecolonies.coremod.tooltype.boots")).setIsEquipment((itemStack, equipmentType) -> {
        ArmorItem armor;
        Item patt8810$temp = itemStack.m_41720_();
        return patt8810$temp instanceof ArmorItem && EquipmentSlot.FEET.equals((Object)(armor = (ArmorItem)patt8810$temp).m_40402_());
    }).setEquipmentLevel((itemStack, equipmentType) -> ModEquipmentTypes.armorLevel(itemStack)).build());
    public static final RegistryObject<EquipmentTypeEntry> flint_and_steel = ModEquipmentTypes.register("flintandsteel", builder -> builder.setDisplayName((Component)Component.m_237115_((String)"com.minecolonies.coremod.tooltype.lighter")).setIsEquipment((itemStack, equipmentType) -> itemStack.m_41720_() instanceof FlintAndSteelItem).setEquipmentLevel((itemStack, equipmentType) -> ModEquipmentTypes.durabilityBasedLevel(itemStack, Items.f_42409_.m_41462_())).build());

    public static IForgeRegistry<EquipmentTypeEntry> getRegistry() {
        return IMinecoloniesAPI.getInstance().getEquipmentTypeRegistry();
    }

    private static RegistryObject<EquipmentTypeEntry> register(String id, Consumer<EquipmentTypeEntry.Builder> consumer) {
        EquipmentTypeEntry.Builder equipmentType = new EquipmentTypeEntry.Builder().setRegistryName(new ResourceLocation("minecolonies", id));
        consumer.accept(equipmentType);
        return DEFERRED_REGISTER.register(id, equipmentType::build);
    }

    public static int vanillaToolLevel(ItemStack itemStack, EquipmentTypeEntry equipmentType) {
        if (Compatibility.isTinkersTool(itemStack, equipmentType)) {
            return Compatibility.getToolLevel(itemStack);
        }
        Item item = itemStack.m_41720_();
        if (item instanceof TieredItem) {
            TieredItem tieredItem = (TieredItem)item;
            return tieredItem.m_43314_().m_6604_();
        }
        return -1;
    }

    public static int armorLevel(ItemStack itemStack) {
        Item item = itemStack.m_41720_();
        if (item instanceof ArmorItem) {
            ArmorItem armorItem = (ArmorItem)item;
            return ItemStackUtils.getArmorLevel(armorItem.m_40401_());
        }
        return -1;
    }

    public static int durabilityBasedLevel(ItemStack itemStack, int vanillaItemDurability) {
        if (!itemStack.m_41763_()) {
            return 5;
        }
        return Math.min(itemStack.m_41776_() / vanillaItemDurability, 5);
    }

    public static boolean canPerformDefaultActions(ItemStack itemStack, Set<ToolAction> actions) {
        for (ToolAction toolAction : actions) {
            if (itemStack.canPerformAction(toolAction)) continue;
            return false;
        }
        return true;
    }
}

