/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.configuration;

import com.minecolonies.api.colony.permissions.Explosions;
import com.minecolonies.api.configuration.AbstractConfiguration;
import java.util.Arrays;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;

public class ServerConfiguration
extends AbstractConfiguration {
    public final ForgeConfigSpec.IntValue initialCitizenAmount;
    public final ForgeConfigSpec.BooleanValue allowInfiniteSupplyChests;
    public final ForgeConfigSpec.BooleanValue allowInfiniteColonies;
    public final ForgeConfigSpec.BooleanValue allowOtherDimColonies;
    public final ForgeConfigSpec.IntValue maxCitizenPerColony;
    public final ForgeConfigSpec.BooleanValue enableInDevelopmentFeatures;
    public final ForgeConfigSpec.BooleanValue alwaysRenderNameTag;
    public final ForgeConfigSpec.BooleanValue workersAlwaysWorkInRain;
    public final ForgeConfigSpec.IntValue luckyBlockChance;
    public final ForgeConfigSpec.IntValue minThLevelToTeleport;
    public final ForgeConfigSpec.DoubleValue foodModifier;
    public final ForgeConfigSpec.IntValue diseaseModifier;
    public final ForgeConfigSpec.BooleanValue forceLoadColony;
    public final ForgeConfigSpec.IntValue loadtime;
    public final ForgeConfigSpec.IntValue colonyLoadStrictness;
    public final ForgeConfigSpec.IntValue maxTreeSize;
    public final ForgeConfigSpec.BooleanValue noSupplyPlacementRestrictions;
    public final ForgeConfigSpec.BooleanValue skyRaiders;
    public final ForgeConfigSpec.BooleanValue researchCreativeCompletion;
    public final ForgeConfigSpec.BooleanValue researchDebugLog;
    public final ForgeConfigSpec.ConfigValue<List<? extends String>> researchResetCost;
    public final ForgeConfigSpec.BooleanValue canPlayerUseRTPCommand;
    public final ForgeConfigSpec.BooleanValue canPlayerUseColonyTPCommand;
    public final ForgeConfigSpec.BooleanValue canPlayerUseAllyTHTeleport;
    public final ForgeConfigSpec.BooleanValue canPlayerUseHomeTPCommand;
    public final ForgeConfigSpec.BooleanValue canPlayerUseShowColonyInfoCommand;
    public final ForgeConfigSpec.BooleanValue canPlayerUseKillCitizensCommand;
    public final ForgeConfigSpec.BooleanValue canPlayerUseAddOfficerCommand;
    public final ForgeConfigSpec.BooleanValue canPlayerUseDeleteColonyCommand;
    public final ForgeConfigSpec.BooleanValue canPlayerUseResetCommand;
    public final ForgeConfigSpec.IntValue maxColonySize;
    public final ForgeConfigSpec.IntValue minColonyDistance;
    public final ForgeConfigSpec.IntValue initialColonySize;
    public final ForgeConfigSpec.IntValue maxDistanceFromWorldSpawn;
    public final ForgeConfigSpec.IntValue minDistanceFromWorldSpawn;
    public final ForgeConfigSpec.BooleanValue enableColonyRaids;
    public final ForgeConfigSpec.IntValue raidDifficulty;
    public final ForgeConfigSpec.IntValue maxRaiders;
    public final ForgeConfigSpec.BooleanValue raidersbreakblocks;
    public final ForgeConfigSpec.IntValue averageNumberOfNightsBetweenRaids;
    public final ForgeConfigSpec.IntValue minimumNumberOfNightsBetweenRaids;
    public final ForgeConfigSpec.BooleanValue raidersbreakdoors;
    public final ForgeConfigSpec.BooleanValue mobAttackCitizens;
    public final ForgeConfigSpec.DoubleValue guardDamageMultiplier;
    public final ForgeConfigSpec.DoubleValue guardHealthMult;
    public final ForgeConfigSpec.BooleanValue pvp_mode;
    public final ForgeConfigSpec.BooleanValue enableColonyProtection;
    public final ForgeConfigSpec.EnumValue<Explosions> turnOffExplosionsInColonies;
    public final ForgeConfigSpec.ConfigValue<List<? extends String>> configListRecruitmentItems;
    public final ForgeConfigSpec.BooleanValue auditCraftingTags;
    public final ForgeConfigSpec.BooleanValue debugInventories;
    public final ForgeConfigSpec.BooleanValue blueprintBuildMode;
    public final ForgeConfigSpec.IntValue pathfindingDebugVerbosity;
    public final ForgeConfigSpec.IntValue pathfindingMaxThreadCount;
    public final ForgeConfigSpec.IntValue minimumRailsToPath;
    public final ForgeConfigSpec.BooleanValue creativeResolve;

    protected ServerConfiguration(ForgeConfigSpec.Builder builder) {
        this.createCategory(builder, "gameplay");
        this.initialCitizenAmount = ServerConfiguration.defineInteger(builder, "initialcitizenamount", 4, 1, 10);
        this.allowInfiniteSupplyChests = ServerConfiguration.defineBoolean(builder, "allowinfinitesupplychests", false);
        this.allowInfiniteColonies = ServerConfiguration.defineBoolean(builder, "allowinfinitecolonies", false);
        this.allowOtherDimColonies = ServerConfiguration.defineBoolean(builder, "allowotherdimcolonies", true);
        this.maxCitizenPerColony = ServerConfiguration.defineInteger(builder, "maxcitizenpercolony", 250, 30, 500);
        this.enableInDevelopmentFeatures = ServerConfiguration.defineBoolean(builder, "enableindevelopmentfeatures", false);
        this.alwaysRenderNameTag = ServerConfiguration.defineBoolean(builder, "alwaysrendernametag", true);
        this.workersAlwaysWorkInRain = ServerConfiguration.defineBoolean(builder, "workersalwaysworkinrain", false);
        this.luckyBlockChance = ServerConfiguration.defineInteger(builder, "luckyblockchance", 1, 0, 100);
        this.minThLevelToTeleport = ServerConfiguration.defineInteger(builder, "minthleveltoteleport", 3, 0, 5);
        this.foodModifier = ServerConfiguration.defineDouble(builder, "foodmodifier", 1.0, 0.1, 100.0);
        this.diseaseModifier = ServerConfiguration.defineInteger(builder, "diseasemodifier", 5, 1, 100);
        this.forceLoadColony = ServerConfiguration.defineBoolean(builder, "forceloadcolony", true);
        this.loadtime = ServerConfiguration.defineInteger(builder, "loadtime", 10, 1, 1440);
        this.colonyLoadStrictness = ServerConfiguration.defineInteger(builder, "colonyloadstrictness", 3, 1, 15);
        this.maxTreeSize = ServerConfiguration.defineInteger(builder, "maxtreesize", 400, 1, 1000);
        this.noSupplyPlacementRestrictions = ServerConfiguration.defineBoolean(builder, "nosupplyplacementrestrictions", false);
        this.skyRaiders = ServerConfiguration.defineBoolean(builder, "skyraiders", false);
        this.swapToCategory(builder, "research");
        this.researchCreativeCompletion = ServerConfiguration.defineBoolean(builder, "researchcreativecompletion", true);
        this.researchDebugLog = ServerConfiguration.defineBoolean(builder, "researchdebuglog", false);
        this.researchResetCost = ServerConfiguration.defineList(builder, "researchresetcost", Arrays.asList("minecolonies:ancienttome:1"), s -> s instanceof String);
        this.swapToCategory(builder, "commands");
        this.canPlayerUseRTPCommand = ServerConfiguration.defineBoolean(builder, "canplayerusertpcommand", false);
        this.canPlayerUseColonyTPCommand = ServerConfiguration.defineBoolean(builder, "canplayerusecolonytpcommand", false);
        this.canPlayerUseAllyTHTeleport = ServerConfiguration.defineBoolean(builder, "canplayeruseallytownhallteleport", true);
        this.canPlayerUseHomeTPCommand = ServerConfiguration.defineBoolean(builder, "canplayerusehometpcommand", false);
        this.canPlayerUseShowColonyInfoCommand = ServerConfiguration.defineBoolean(builder, "canplayeruseshowcolonyinfocommand", true);
        this.canPlayerUseKillCitizensCommand = ServerConfiguration.defineBoolean(builder, "canplayerusekillcitizenscommand", false);
        this.canPlayerUseAddOfficerCommand = ServerConfiguration.defineBoolean(builder, "canplayeruseaddofficercommand", true);
        this.canPlayerUseDeleteColonyCommand = ServerConfiguration.defineBoolean(builder, "canplayerusedeletecolonycommand", false);
        this.canPlayerUseResetCommand = ServerConfiguration.defineBoolean(builder, "canplayeruseresetcommand", false);
        this.swapToCategory(builder, "claims");
        this.maxColonySize = ServerConfiguration.defineInteger(builder, "maxColonySize", 20, 1, 250);
        this.minColonyDistance = ServerConfiguration.defineInteger(builder, "minColonyDistance", 8, 1, 200);
        this.initialColonySize = ServerConfiguration.defineInteger(builder, "initialColonySize", 4, 1, 15);
        this.maxDistanceFromWorldSpawn = ServerConfiguration.defineInteger(builder, "maxdistancefromworldspawn", 30000, 1000, Integer.MAX_VALUE);
        this.minDistanceFromWorldSpawn = ServerConfiguration.defineInteger(builder, "mindistancefromworldspawn", 0, 0, 1000);
        this.swapToCategory(builder, "combat");
        this.enableColonyRaids = ServerConfiguration.defineBoolean(builder, "dobarbariansspawn", true);
        this.raidDifficulty = ServerConfiguration.defineInteger(builder, "barbarianhordedifficulty", 5, 0, 10);
        this.maxRaiders = ServerConfiguration.defineInteger(builder, "maxBarbarianSize", 80, 6, 400);
        this.raidersbreakblocks = ServerConfiguration.defineBoolean(builder, "dobarbariansbreakthroughwalls", true);
        this.averageNumberOfNightsBetweenRaids = ServerConfiguration.defineInteger(builder, "averagenumberofnightsbetweenraids", 14, 1, 50);
        this.minimumNumberOfNightsBetweenRaids = ServerConfiguration.defineInteger(builder, "minimumnumberofnightsbetweenraids", 10, 1, 30);
        this.mobAttackCitizens = ServerConfiguration.defineBoolean(builder, "mobattackcitizens", true);
        this.raidersbreakdoors = ServerConfiguration.defineBoolean(builder, "shouldraiderbreakdoors", true);
        this.guardDamageMultiplier = ServerConfiguration.defineDouble(builder, "guardDamageMultiplier", 1.0, 0.1, 15.0);
        this.guardHealthMult = ServerConfiguration.defineDouble(builder, "guardhealthmult", 1.0, 0.1, 5.0);
        this.pvp_mode = ServerConfiguration.defineBoolean(builder, "pvp_mode", false);
        this.swapToCategory(builder, "permissions");
        this.enableColonyProtection = ServerConfiguration.defineBoolean(builder, "enablecolonyprotection", true);
        this.turnOffExplosionsInColonies = ServerConfiguration.defineEnum(builder, "turnoffexplosionsincolonies", Explosions.DAMAGE_ENTITIES);
        this.swapToCategory(builder, "compatibility");
        this.configListRecruitmentItems = ServerConfiguration.defineList(builder, "configlistrecruitmentitems", Arrays.asList("minecraft:hay_block;3", "minecraft:book;2", "minecraft:enchanted_book;9", "minecraft:diamond;9", "minecraft:emerald;8", "minecraft:baked_potato;1", "minecraft:gold_ingot;2", "minecraft:redstone;2", "minecraft:lapis_lazuli;2", "minecraft:cake;11", "minecraft:sunflower;5", "minecraft:honeycomb;6", "minecraft:quartz;3"), s -> s instanceof String);
        this.auditCraftingTags = ServerConfiguration.defineBoolean(builder, "auditcraftingtags", false);
        this.debugInventories = ServerConfiguration.defineBoolean(builder, "debuginventories", false);
        this.blueprintBuildMode = ServerConfiguration.defineBoolean(builder, "blueprintbuildmode", false);
        this.swapToCategory(builder, "pathfinding");
        this.pathfindingDebugVerbosity = ServerConfiguration.defineInteger(builder, "pathfindingdebugverbosity", 0, 0, 10);
        this.minimumRailsToPath = ServerConfiguration.defineInteger(builder, "minimumrailstopath", 8, 5, 100);
        this.pathfindingMaxThreadCount = ServerConfiguration.defineInteger(builder, "pathfindingmaxthreadcount", 1, 1, 10);
        this.swapToCategory(builder, "requestSystem");
        this.creativeResolve = ServerConfiguration.defineBoolean(builder, "creativeresolve", false);
        this.finishCategory(builder);
    }
}

