/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.compatibility;

import com.google.common.collect.ImmutableSet;
import com.minecolonies.api.crafting.CompostRecipe;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.util.Tuple;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ICompatibilityManager {
    public void discover(@NotNull RecipeManager var1, Level var2);

    public void serialize(@NotNull FriendlyByteBuf var1);

    public void deserialize(@NotNull FriendlyByteBuf var1, ClientLevel var2);

    @Nullable
    public ItemStack getSaplingForLeaf(Block var1);

    public Set<ItemStorage> getCopyOfSaplings();

    public Set<ItemStorage> getFuel();

    public Set<ItemStorage> getFood();

    public Set<ItemStorage> getEdibles(int var1);

    public Set<ItemStorage> getSmeltableOres();

    public boolean isMineableOre(@NotNull ItemStack var1);

    public Map<Item, CompostRecipe> getCopyOfCompostRecipes();

    public Set<ItemStorage> getCompostInputs();

    public Set<ItemStorage> getCopyOfPlantables();

    public Set<ItemStorage> getImmutableFlowers();

    public ImmutableSet<ResourceLocation> getAllMonsters();

    public List<Tuple<Item, Integer>> getRecruitmentCostsWeights();

    public boolean isOre(BlockState var1);

    public boolean isOre(ItemStack var1);

    public List<ItemStack> getListOfAllItems();

    public Set<ItemStorage> getSetOfAllItems();

    public void write(@NotNull CompoundTag var1);

    public void read(@NotNull CompoundTag var1);

    public void connectLeafToSapling(Block var1, ItemStack var2);

    public boolean isPlantable(ItemStack var1);

    public boolean isLuckyBlock(Block var1);

    public CreativeModeTab getCreativeTab(ItemStorage var1);

    public int getCreativeTabKey(ItemStorage var1);
}

