/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.compatibility;

import com.minecolonies.api.compatibility.dynamictrees.DynamicTreeProxy;
import com.minecolonies.api.compatibility.resourcefulbees.IBeehiveCompat;
import com.minecolonies.api.compatibility.tinkers.SlimeTreeProxy;
import com.minecolonies.api.compatibility.tinkers.TinkersToolProxy;
import com.minecolonies.api.equipment.registry.EquipmentTypeEntry;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fml.ModList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Compatibility {
    public static IBeehiveCompat beeHiveCompat = new IBeehiveCompat(){};
    public static SlimeTreeProxy tinkersSlimeCompat = new SlimeTreeProxy();
    public static TinkersToolProxy tinkersCompat = new TinkersToolProxy();
    public static DynamicTreeProxy dynamicTreesCompat = new DynamicTreeProxy();

    private Compatibility() {
        throw new IllegalAccessError("Utility class");
    }

    public static boolean getMiningLevelCompatibility(@Nullable ItemStack stack, @Nullable String tool) {
        return !tinkersCompat.checkTinkersBroken(stack);
    }

    public static boolean isSlimeBlock(@NotNull Block block) {
        return tinkersSlimeCompat.checkForTinkersSlimeBlock(block);
    }

    public static boolean isSlimeLeaf(@NotNull Block block) {
        return tinkersSlimeCompat.checkForTinkersSlimeLeaves(block);
    }

    public static boolean isSlimeSapling(@NotNull Block block) {
        return tinkersSlimeCompat.checkForTinkersSlimeSapling(block);
    }

    public static boolean isSlimeDirtOrGrass(@NotNull Block block) {
        return tinkersSlimeCompat.checkForTinkersSlimeDirtOrGrass(block);
    }

    public static int getLeafVariant(@NotNull BlockState leaf) {
        return tinkersSlimeCompat.getTinkersLeafVariant(leaf);
    }

    public static boolean isTinkersWeapon(@NotNull ItemStack stack) {
        return tinkersCompat.isTinkersWeapon(stack);
    }

    public static boolean isTinkersTool(@Nullable ItemStack stack, EquipmentTypeEntry toolType) {
        return tinkersCompat.isTinkersTool(stack, toolType);
    }

    public static double getAttackDamage(@NotNull ItemStack stack) {
        return tinkersCompat.getAttackDamage(stack);
    }

    public static int getToolLevel(@NotNull ItemStack stack) {
        return tinkersCompat.getToolLevel(stack);
    }

    public static boolean isPamsInstalled() {
        return ModList.get().isLoaded("harvestcraft");
    }

    public static boolean isDynTreePresent() {
        return dynamicTreesCompat.isDynamicTreePresent();
    }

    public static ResourceKey<DamageType> getDynamicTreeDamage() {
        return dynamicTreesCompat.getDynamicTreeDamage();
    }

    public static boolean isDynamicBlock(Block block) {
        return dynamicTreesCompat.checkForDynamicTreeBlock(block);
    }

    public static boolean isDynamicLeaf(Block block) {
        return dynamicTreesCompat.checkForDynamicLeavesBlock(block);
    }

    public static boolean isDynamicTrunkShell(Block block) {
        return dynamicTreesCompat.checkForDynamicTrunkShellBlock(block);
    }

    public static NonNullList<ItemStack> getDropsForDynamicLeaf(LevelAccessor world, BlockPos pos, BlockState blockState, int fortune, Block leaf) {
        return dynamicTreesCompat.getDropsForLeaf(world, pos, blockState, fortune, leaf);
    }

    public static boolean plantDynamicSapling(Level world, BlockPos location, ItemStack sapling) {
        return dynamicTreesCompat.plantDynamicSaplingCompat(world, location, sapling);
    }

    public static Runnable getDynamicTreeBreakAction(Level world, BlockPos blockToBreak, ItemStack toolToUse, BlockPos workerPos) {
        return dynamicTreesCompat.getTreeBreakActionCompat(world, blockToBreak, toolToUse, workerPos);
    }

    public static boolean isDynamicTreeSapling(Item item) {
        return dynamicTreesCompat.checkForDynamicSapling(item);
    }

    public static boolean isDynamicTreeSapling(ItemStack stack) {
        return dynamicTreesCompat.checkForDynamicSapling(stack.m_41720_());
    }

    public static boolean isDynamicFamilyFitting(BlockPos block1, BlockPos block2, LevelAccessor world) {
        return dynamicTreesCompat.hasFittingTreeFamilyCompat(block1, block2, world);
    }

    public static List<ItemStack> getCombsFromHive(BlockPos pos, Level world, int amount) {
        return beeHiveCompat.getCombsFromHive(pos, world, amount);
    }
}

