/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.colony.fields.registry;

import com.minecolonies.api.IMinecoloniesAPI;
import com.minecolonies.api.colony.fields.IField;
import com.minecolonies.api.colony.fields.modules.IFieldModule;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import org.apache.commons.lang3.Validate;

public class FieldRegistries {
    public static final ResourceLocation FARM_FIELD_ID = new ResourceLocation("minecolonies", "farmfield");
    public static final ResourceLocation PLANTATION_SUGAR_CANE_FIELD_ID = new ResourceLocation("minecolonies", "plantation_sugar_cane");
    public static final ResourceLocation PLANTATION_CACTUS_FIELD_ID = new ResourceLocation("minecolonies", "plantation_cactus");
    public static final ResourceLocation PLANTATION_BAMBOO_FIELD_ID = new ResourceLocation("minecolonies", "plantation_bamboo");
    public static final ResourceLocation PLANTATION_COCOA_BEANS_FIELD_ID = new ResourceLocation("minecolonies", "plantation_cocoa_beans");
    public static final ResourceLocation PLANTATION_VINES_FIELD_ID = new ResourceLocation("minecolonies", "plantation_vines");
    public static final ResourceLocation PLANTATION_KELP_FIELD_ID = new ResourceLocation("minecolonies", "plantation_kelp");
    public static final ResourceLocation PLANTATION_SEAGRASS_FIELD_ID = new ResourceLocation("minecolonies", "plantation_seagrass");
    public static final ResourceLocation PLANTATION_SEA_PICKLES_FIELD_ID = new ResourceLocation("minecolonies", "plantation_sea_pickles");
    public static final ResourceLocation PLANTATION_GLOWBERRIES_FIELD_ID = new ResourceLocation("minecolonies", "plantation_glowberries");
    public static final ResourceLocation PLANTATION_WEEPING_VINES_FIELD_ID = new ResourceLocation("minecolonies", "plantation_weeping_vines");
    public static final ResourceLocation PLANTATION_TWISTING_VINES_FIELD_ID = new ResourceLocation("minecolonies", "plantation_twisting_vines");
    public static final ResourceLocation PLANTATION_CRIMSON_PLANTS_FIELD_ID = new ResourceLocation("minecolonies", "plantation_crimson_plants");
    public static final ResourceLocation PLANTATION_WARPED_PLANTS_FIELD_ID = new ResourceLocation("minecolonies", "plantation_warped_plants");
    public static RegistryObject<FieldEntry> farmField;
    public static RegistryObject<FieldEntry> plantationSugarCaneField;
    public static RegistryObject<FieldEntry> plantationCactusField;
    public static RegistryObject<FieldEntry> plantationBambooField;
    public static RegistryObject<FieldEntry> plantationCocoaBeansField;
    public static RegistryObject<FieldEntry> plantationVinesField;
    public static RegistryObject<FieldEntry> plantationKelpField;
    public static RegistryObject<FieldEntry> plantationSeagrassField;
    public static RegistryObject<FieldEntry> plantationSeaPicklesField;
    public static RegistryObject<FieldEntry> plantationGlowberriesField;
    public static RegistryObject<FieldEntry> plantationWeepingVinesField;
    public static RegistryObject<FieldEntry> plantationTwistingVinesField;
    public static RegistryObject<FieldEntry> plantationCrimsonPlantsField;
    public static RegistryObject<FieldEntry> plantationWarpedPlantsField;

    private FieldRegistries() {
    }

    public static IForgeRegistry<FieldEntry> getFieldRegistry() {
        return IMinecoloniesAPI.getInstance().getFieldRegistry();
    }

    public static class FieldEntry {
        private final ResourceLocation registryName;
        private final BiFunction<FieldEntry, BlockPos, IField> fieldProducer;
        private final List<Function<IField, IFieldModule>> fieldModuleProducers;

        private FieldEntry(ResourceLocation registryName, BiFunction<FieldEntry, BlockPos, IField> fieldProducer, List<Function<IField, IFieldModule>> fieldModuleProducers) {
            this.registryName = registryName;
            this.fieldProducer = fieldProducer;
            this.fieldModuleProducers = fieldModuleProducers;
        }

        public IField produceField(BlockPos position) {
            IField field = this.fieldProducer.apply(this, position);
            for (Function<IField, IFieldModule> moduleProducer : this.fieldModuleProducers) {
                field.registerModule(moduleProducer.apply(field));
            }
            return field;
        }

        public List<Function<IField, IFieldModule>> getFieldModuleProducers() {
            return Collections.unmodifiableList(this.fieldModuleProducers);
        }

        public ResourceLocation getRegistryName() {
            return this.registryName;
        }

        public int hashCode() {
            return this.registryName.hashCode();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FieldEntry that = (FieldEntry)o;
            return this.registryName.equals((Object)that.registryName);
        }

        public static class Builder {
            private final List<Function<IField, IFieldModule>> fieldModuleProducers = new ArrayList<Function<IField, IFieldModule>>();
            private ResourceLocation registryName;
            private BiFunction<FieldEntry, BlockPos, IField> fieldProducer;

            public Builder setRegistryName(ResourceLocation registryName) {
                this.registryName = registryName;
                return this;
            }

            public Builder setFieldProducer(BiFunction<FieldEntry, BlockPos, IField> fieldProducer) {
                this.fieldProducer = fieldProducer;
                return this;
            }

            public Builder addFieldModuleProducer(Function<IField, IFieldModule> moduleProducer) {
                this.fieldModuleProducers.add(moduleProducer);
                return this;
            }

            public FieldEntry createFieldEntry() {
                Validate.notNull((Object)this.registryName);
                Validate.notNull(this.fieldProducer);
                return new FieldEntry(this.registryName, this.fieldProducer, this.fieldModuleProducers);
            }
        }
    }
}

