/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.networking;

import io.netty.buffer.ByteBuf;
import java.util.function.Supplier;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkEvent;
import stepsword.mahoutsukai.advancements.ModTriggers;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.config.MandatoryFun;
import stepsword.mahoutsukai.potion.ModEffects;
import stepsword.mahoutsukai.tile.exchange.ContractMahoujinTileEntity;
import stepsword.mahoutsukai.util.EffectUtil;
import stepsword.mahoutsukai.util.MahouTsukaiTeleporter;

public class SelectiveDisplacementPacket {
    int id1 = 0;
    int id2 = 0;

    public SelectiveDisplacementPacket() {
    }

    public SelectiveDisplacementPacket(int i, int i2) {
        this.id1 = i;
        this.id2 = i2;
    }

    public void fromBytes(ByteBuf buf) {
        this.id1 = buf.readInt();
        this.id2 = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.id1);
        buf.writeInt(this.id2);
    }

    public static void encode(SelectiveDisplacementPacket msg, ByteBuf buf) {
        msg.toBytes(buf);
    }

    public static SelectiveDisplacementPacket decode(ByteBuf buf) {
        SelectiveDisplacementPacket msg = new SelectiveDisplacementPacket();
        msg.fromBytes(buf);
        return msg;
    }

    public static void handle(final SelectiveDisplacementPacket message, final Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(new Runnable(){

            @Override
            public void run() {
                if (((NetworkEvent.Context)context.get()).getSender() instanceof ServerPlayer) {
                    SelectiveDisplacementPacket.handleAbilitySelectiveDisplacement(((NetworkEvent.Context)context.get()).getSender(), message.id1, message.id2);
                }
            }
        });
        context.get().setPacketHandled(true);
    }

    public static void handleAbilitySelectiveDisplacement(ServerPlayer player, int id, int id2) {
        if (EffectUtil.hasBuff((LivingEntity)player, ModEffects.SELECTIVE_DISPLACEMENT) && !EffectUtil.hasBuff((LivingEntity)player, ModEffects.SELECTIVE_DISPLACEMENT_COOLDOWN) && id != 0) {
            Entity e = player.m_9236_().m_6815_(id);
            Object e2 = player;
            e2 = id2 != 0 && id2 != id ? player.m_9236_().m_6815_(id2) : player;
            if (e != null && e2 != null && e != e2 && EffectUtil.getDimension(e.m_9236_()) == EffectUtil.getDimension(e2.m_9236_())) {
                double x = e.m_20185_();
                double y = e.m_20186_();
                double z = e.m_20189_();
                double x2 = e2.m_20185_();
                double y2 = e2.m_20186_();
                double z2 = e2.m_20189_();
                if (e2.m_20197_().size() > 0) {
                    e2.m_20153_();
                }
                if (e.m_20197_().size() > 0) {
                    e.m_20153_();
                }
                MahouTsukaiTeleporter.teleport(e, e2.m_20185_(), e2.m_20186_(), e2.m_20189_(), EffectUtil.getDimension(e.m_9236_()));
                Vec3 facing = new Vec3(x2, y2, z2).m_82546_(new Vec3(x, y, z));
                facing = facing.m_82541_();
                float pitch = (float)Math.asin(-facing.f_82480_);
                float yaw = (float)Math.atan2(facing.f_82479_, facing.f_82481_);
                if (e2 instanceof LivingEntity) {
                    e2.f_19857_ = EffectUtil.toDegrees(-yaw);
                    e2.f_19858_ = EffectUtil.toDegrees(pitch);
                }
                facing = facing.m_82542_(-1.0, -1.0, -1.0);
                float pitch2 = (float)Math.asin(-facing.f_82480_);
                float yaw2 = (float)Math.atan2(facing.f_82479_, facing.f_82481_);
                if (e instanceof LivingEntity) {
                    e.f_19857_ = EffectUtil.toDegrees(-yaw2);
                    e.f_19858_ = EffectUtil.toDegrees(pitch2);
                }
                MahouTsukaiTeleporter.teleport((Entity)e2, x, y, z, EffectUtil.getDimension(e2.m_9236_()));
                e2.f_19864_ = true;
                e.f_19864_ = true;
                e2.m_6853_(false);
                e.m_6853_(false);
                ServerPlayer target = null;
                if (e == player) {
                    target = e2;
                }
                if (e2 == player) {
                    target = e;
                }
                if (target != null && ContractMahoujinTileEntity.isImmuneToSpell(player.m_9236_(), player.m_20148_(), (Entity)target)) {
                    ModTriggers.BOOGIE_WOOGIE.trigger(player);
                }
                if (e != player && e2 != player) {
                    MandatoryFun.completeFunReq((Player)player, MandatoryFun.FUN_REQS.SWAP_TWO_THINGS);
                }
                EffectUtil.buff((LivingEntity)player, ModEffects.SELECTIVE_DISPLACEMENT_COOLDOWN, false, MTConfig.SELECTIVE_DISPLACEMENT_COOLDOWN);
            }
        }
    }
}

