/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.network.s_to_c;

import com.google.common.hash.Hashing;
import com.google.common.hash.HashingInputStream;
import com.google.common.hash.HashingOutputStream;
import com.legacy.blue_skies.BlueSkies;
import com.legacy.blue_skies.client.gui.screen.journal.BlueJournalScreen;
import com.legacy.blue_skies.data.BlueSkiesData;
import com.legacy.blue_skies.data.managers.SkiesSyncedDataManager;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class SyncDataRegistryPacket {
    private final byte id;
    private final SkiesSyncedDataManager<?, ?, ?> manager;

    public SyncDataRegistryPacket(int id, SkiesSyncedDataManager<?, ?, ?> manager) {
        this.id = (byte)id;
        this.manager = manager;
    }

    public static void encoder(SyncDataRegistryPacket packet, FriendlyByteBuf buff) {
        buff.writeByte((int)packet.id);
        ByteArrayOutputStream byteArrayOutput = new ByteArrayOutputStream();
        HashingOutputStream hasingOutputStream = new HashingOutputStream(Hashing.sha1(), (OutputStream)byteArrayOutput);
        CompoundTag tag = packet.manager.toNBT();
        try {
            NbtIo.m_128947_((CompoundTag)tag, (OutputStream)hasingOutputStream);
            byte[] bytes = byteArrayOutput.toByteArray();
            buff.writeInt(bytes.length);
            buff.writeBytes(bytes);
        }
        catch (IOException e) {
            buff.writeInt(0);
            e.printStackTrace();
        }
    }

    public static SyncDataRegistryPacket decoder(FriendlyByteBuf buff) {
        CompoundTag tag;
        byte id = buff.readByte();
        byte[] bytes = new byte[buff.readInt()];
        if (bytes.length > 0) {
            buff.readBytes(bytes);
            ByteArrayInputStream byteInputStream = new ByteArrayInputStream(bytes);
            HashingInputStream hasingInput = new HashingInputStream(Hashing.sha1(), (InputStream)byteInputStream);
            try {
                tag = NbtIo.m_128939_((InputStream)hasingInput);
            }
            catch (IOException e) {
                e.printStackTrace();
                tag = new CompoundTag();
            }
        } else {
            tag = new CompoundTag();
        }
        return new SyncDataRegistryPacket(id, (SkiesSyncedDataManager<?, ?, ?>)((Object)BlueSkiesData.getSyncedManager(id).fromNBT(tag)));
    }

    public static void handler(SyncDataRegistryPacket packet, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            BlueJournalScreen.savedScreen = null;
            BlueSkiesData.getSyncedManager(packet.id).setData(packet.manager);
            BlueSkies.LOGGER.info("Recieved {} from the server", (Object)packet.manager.m_7812_());
        }));
        context.get().setPacketHandled(true);
    }
}

