/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.datagen.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.klikli_dev.theurgy.datagen.recipe.JsonRecipeProvider;
import com.klikli_dev.theurgy.registry.FluidRegistry;
import com.klikli_dev.theurgy.registry.ItemTagRegistry;
import com.klikli_dev.theurgy.registry.RecipeTypeRegistry;
import com.klikli_dev.theurgy.registry.SulfurRegistry;
import java.util.function.BiConsumer;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.Tags;

public class LiquefactionRecipeProvider
extends JsonRecipeProvider {
    public static final int TIME = 100;

    public LiquefactionRecipeProvider(PackOutput packOutput) {
        super(packOutput, "theurgy", "liquefaction");
    }

    @Override
    public void buildRecipes(BiConsumer<ResourceLocation, JsonObject> recipeConsumer) {
        Fluid salAmmoniac = (Fluid)FluidRegistry.SAL_AMMONIAC.get();
        this.makeRecipe((Item)SulfurRegistry.LOGS.get(), (TagKey<Item>)ItemTags.f_13182_, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.WHEAT.get(), Items.f_42405_, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.IRON.get(), 5, (TagKey<Item>)Tags.Items.ORES_IRON, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.COPPER.get(), 5, (TagKey<Item>)Tags.Items.ORES_COPPER, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.GOLD.get(), 5, (TagKey<Item>)Tags.Items.ORES_GOLD, salAmmoniac, 15);
        this.makeRecipe((Item)SulfurRegistry.NETHERITE.get(), 1, (TagKey<Item>)Tags.Items.ORES_NETHERITE_SCRAP, salAmmoniac, 100);
        this.makeRecipe((Item)SulfurRegistry.URANIUM.get(), 5, ItemTagRegistry.ORES_URANIUM, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.SILVER.get(), 5, ItemTagRegistry.ORES_SILVER, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.AZURE_SILVER.get(), 5, ItemTagRegistry.ORES_AZURE_SILVER, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.ZINC.get(), 5, ItemTagRegistry.ORES_ZINC, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.OSMIUM.get(), 5, ItemTagRegistry.ORES_OSMIUM, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.NICKEL.get(), 5, ItemTagRegistry.ORES_NICKEL, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.LEAD.get(), 5, ItemTagRegistry.ORES_LEAD, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.ALLTHEMODIUM.get(), 5, ItemTagRegistry.ORES_ALLTHEMODIUM, salAmmoniac, 100);
        this.makeRecipe((Item)SulfurRegistry.UNOBTAINIUM.get(), 5, ItemTagRegistry.ORES_UNOBTAINIUM, salAmmoniac, 100);
        this.makeRecipe((Item)SulfurRegistry.IRIDIUM.get(), 5, ItemTagRegistry.ORES_IRIDIUM, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.TIN.get(), 5, ItemTagRegistry.ORES_TIN, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.CINNABAR.get(), 5, ItemTagRegistry.ORES_CINNABAR, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.CRIMSON_IRON.get(), 5, ItemTagRegistry.ORES_CRIMSON_IRON, salAmmoniac, 20);
        this.makeRecipe((Item)SulfurRegistry.PLATINUM.get(), 5, ItemTagRegistry.ORES_PLATINUM, salAmmoniac, 20);
        this.makeRecipe((Item)SulfurRegistry.VIBRANIUM.get(), 5, ItemTagRegistry.ORES_VIBRANIUM, salAmmoniac, 20);
        this.makeRecipe((Item)SulfurRegistry.DESH.get(), 5, ItemTagRegistry.ORES_DESH, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.OSTRUM.get(), 5, ItemTagRegistry.ORES_OSTRUM, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.CALORITE.get(), 5, ItemTagRegistry.ORES_CALORITE, salAmmoniac, 50);
        this.makeRecipe((Item)SulfurRegistry.IESNIUM.get(), 5, ItemTagRegistry.ORES_IESNIUM, salAmmoniac, 50);
        this.makeRecipe((Item)SulfurRegistry.DIAMOND.get(), 4, (TagKey<Item>)Tags.Items.ORES_DIAMOND, salAmmoniac, 100);
        this.makeRecipe((Item)SulfurRegistry.EMERALD.get(), 4, (TagKey<Item>)Tags.Items.ORES_EMERALD, salAmmoniac, 100);
        this.makeRecipe((Item)SulfurRegistry.LAPIS.get(), 12, (TagKey<Item>)Tags.Items.ORES_LAPIS, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.QUARTZ.get(), 10, (TagKey<Item>)Tags.Items.ORES_QUARTZ, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.RUBY.get(), 8, ItemTagRegistry.ORES_RUBY, salAmmoniac, 15);
        this.makeRecipe((Item)SulfurRegistry.APATITE.get(), 9, ItemTagRegistry.ORES_APATITE, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.PERIDOT.get(), 8, ItemTagRegistry.ORES_PERIDOT, salAmmoniac, 15);
        this.makeRecipe((Item)SulfurRegistry.FLUORITE.get(), 8, ItemTagRegistry.ORES_FLUORITE, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.SAPPHIRE.get(), 8, ItemTagRegistry.ORES_SAPPHIRE, salAmmoniac, 15);
        this.makeRecipe((Item)SulfurRegistry.SAL_AMMONIAC.get(), 6, ItemTagRegistry.ORES_SAL_AMMONIAC, salAmmoniac, 15);
        this.makeRecipe((Item)SulfurRegistry.CERTUS_QUARTZ.get(), 6, ItemTagRegistry.ORES_CERTUS_QUARTZ, salAmmoniac, 15);
        this.makeRecipe((Item)SulfurRegistry.NITER.get(), 6, ItemTagRegistry.ORES_NITER, salAmmoniac, 15);
        this.makeRecipe((Item)SulfurRegistry.REDSTONE.get(), 9, (TagKey<Item>)Tags.Items.ORES_REDSTONE, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.COAL.get(), 4, (TagKey<Item>)Tags.Items.ORES_COAL, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.SULFUR.get(), 6, this.tag("forge:ores/sulfur"), salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.IRON.get(), 3, (TagKey<Item>)Tags.Items.RAW_MATERIALS_IRON, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.COPPER.get(), 3, (TagKey<Item>)Tags.Items.RAW_MATERIALS_COPPER, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.GOLD.get(), 3, (TagKey<Item>)Tags.Items.RAW_MATERIALS_GOLD, salAmmoniac, 15);
        this.makeRecipe((Item)SulfurRegistry.URANIUM.get(), 3, ItemTagRegistry.RAW_MATERIALS_URANIUM, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.AZURE_SILVER.get(), 3, ItemTagRegistry.RAW_MATERIALS_AZURE_SILVER, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.SILVER.get(), 3, ItemTagRegistry.RAW_MATERIALS_SILVER, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.ZINC.get(), 3, ItemTagRegistry.RAW_MATERIALS_ZINC, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.OSMIUM.get(), 3, ItemTagRegistry.RAW_MATERIALS_OSMIUM, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.NICKEL.get(), 3, ItemTagRegistry.RAW_MATERIALS_NICKEL, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.LEAD.get(), 3, ItemTagRegistry.RAW_MATERIALS_LEAD, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.ALLTHEMODIUM.get(), 3, ItemTagRegistry.RAW_MATERIALS_ALLTHEMODIUM, salAmmoniac, 100);
        this.makeRecipe((Item)SulfurRegistry.UNOBTAINIUM.get(), 3, ItemTagRegistry.RAW_MATERIALS_UNOBTAINIUM, salAmmoniac, 100);
        this.makeRecipe((Item)SulfurRegistry.IRIDIUM.get(), 3, ItemTagRegistry.RAW_MATERIALS_IRIDIUM, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.TIN.get(), 3, ItemTagRegistry.RAW_MATERIALS_TIN, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.CINNABAR.get(), 3, ItemTagRegistry.RAW_MATERIALS_CINNABAR, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.CRIMSON_IRON.get(), 3, ItemTagRegistry.RAW_MATERIALS_CRIMSON_IRON, salAmmoniac, 20);
        this.makeRecipe((Item)SulfurRegistry.PLATINUM.get(), 3, ItemTagRegistry.RAW_MATERIALS_PLATINUM, salAmmoniac, 20);
        this.makeRecipe((Item)SulfurRegistry.VIBRANIUM.get(), 3, ItemTagRegistry.RAW_MATERIALS_VIBRANIUM, salAmmoniac, 20);
        this.makeRecipe((Item)SulfurRegistry.DESH.get(), 5, ItemTagRegistry.RAW_MATERIALS_DESH, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.OSTRUM.get(), 5, ItemTagRegistry.RAW_MATERIALS_OSTRUM, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.CALORITE.get(), 5, ItemTagRegistry.RAW_MATERIALS_CALORITE, salAmmoniac, 50);
        this.makeRecipe((Item)SulfurRegistry.IESNIUM.get(), 5, ItemTagRegistry.RAW_MATERIALS_IESNIUM, salAmmoniac, 50);
        this.makeRecipe((Item)SulfurRegistry.DEMONITE.get(), 3, ItemTagRegistry.RAW_MATERIALS_DEMONITE, salAmmoniac, 50);
        this.makeRecipe((Item)SulfurRegistry.IRON.get(), 1, (TagKey<Item>)Tags.Items.INGOTS_IRON, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.COPPER.get(), 1, (TagKey<Item>)Tags.Items.INGOTS_COPPER, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.GOLD.get(), 1, (TagKey<Item>)Tags.Items.INGOTS_GOLD, salAmmoniac, 15);
        this.makeRecipe((Item)SulfurRegistry.NETHERITE.get(), 1, (TagKey<Item>)Tags.Items.INGOTS_NETHERITE, salAmmoniac, 100);
        this.makeRecipe((Item)SulfurRegistry.URANIUM.get(), 1, ItemTagRegistry.INGOTS_URANIUM, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.SILVER.get(), 1, ItemTagRegistry.INGOTS_SILVER, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.AZURE_SILVER.get(), 1, ItemTagRegistry.INGOTS_AZURE_SILVER, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.ZINC.get(), 1, ItemTagRegistry.INGOTS_ZINC, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.OSMIUM.get(), 1, ItemTagRegistry.INGOTS_OSMIUM, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.NICKEL.get(), 1, ItemTagRegistry.INGOTS_NICKEL, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.LEAD.get(), 1, ItemTagRegistry.INGOTS_LEAD, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.ALLTHEMODIUM.get(), 1, ItemTagRegistry.INGOTS_ALLTHEMODIUM, salAmmoniac, 100);
        this.makeRecipe((Item)SulfurRegistry.UNOBTAINIUM.get(), 1, ItemTagRegistry.INGOTS_UNOBTAINIUM, salAmmoniac, 100);
        this.makeRecipe((Item)SulfurRegistry.IRIDIUM.get(), 1, ItemTagRegistry.INGOTS_IRIDIUM, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.TIN.get(), 1, ItemTagRegistry.INGOTS_TIN, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.CINNABAR.get(), 1, ItemTagRegistry.INGOTS_CINNABAR, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.CRIMSON_IRON.get(), 1, ItemTagRegistry.INGOTS_CRIMSON_IRON, salAmmoniac, 20);
        this.makeRecipe((Item)SulfurRegistry.PLATINUM.get(), 1, ItemTagRegistry.INGOTS_PLATINUM, salAmmoniac, 20);
        this.makeRecipe((Item)SulfurRegistry.VIBRANIUM.get(), 1, ItemTagRegistry.INGOTS_VIBRANIUM, salAmmoniac, 20);
        this.makeRecipe((Item)SulfurRegistry.DESH.get(), 1, ItemTagRegistry.INGOTS_DESH, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.OSTRUM.get(), 1, ItemTagRegistry.INGOTS_OSTRUM, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.CALORITE.get(), 1, ItemTagRegistry.INGOTS_CALORITE, salAmmoniac, 50);
        this.makeRecipe((Item)SulfurRegistry.IESNIUM.get(), 1, ItemTagRegistry.INGOTS_IESNIUM, salAmmoniac, 50);
        this.makeRecipe((Item)SulfurRegistry.DEMONITE.get(), 1, ItemTagRegistry.INGOTS_DEMONITE, salAmmoniac, 50);
        this.makeRecipe((Item)SulfurRegistry.DIAMOND.get(), 1, (TagKey<Item>)Tags.Items.GEMS_DIAMOND, salAmmoniac, 100);
        this.makeRecipe((Item)SulfurRegistry.EMERALD.get(), 1, (TagKey<Item>)Tags.Items.GEMS_EMERALD, salAmmoniac, 100);
        this.makeRecipe((Item)SulfurRegistry.LAPIS.get(), 1, (TagKey<Item>)Tags.Items.GEMS_LAPIS, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.QUARTZ.get(), 1, (TagKey<Item>)Tags.Items.GEMS_QUARTZ, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.AMETHYST.get(), 1, (TagKey<Item>)Tags.Items.GEMS_AMETHYST, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.PRISMARINE.get(), 1, (TagKey<Item>)Tags.Items.GEMS_PRISMARINE, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.RUBY.get(), 1, ItemTagRegistry.GEMS_RUBY, salAmmoniac, 15);
        this.makeRecipe((Item)SulfurRegistry.APATITE.get(), 1, ItemTagRegistry.GEMS_APATITE, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.PERIDOT.get(), 1, ItemTagRegistry.GEMS_PERIDOT, salAmmoniac, 15);
        this.makeRecipe((Item)SulfurRegistry.FLUORITE.get(), 1, ItemTagRegistry.GEMS_FLUORITE, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.SAPPHIRE.get(), 1, ItemTagRegistry.GEMS_SAPPHIRE, salAmmoniac, 15);
        this.makeRecipe((Item)SulfurRegistry.SAL_AMMONIAC.get(), 1, ItemTagRegistry.GEMS_SAL_AMMONIAC, salAmmoniac, 15);
        this.makeRecipe((Item)SulfurRegistry.CERTUS_QUARTZ.get(), 1, ItemTagRegistry.GEMS_CERTUS_QUARTZ, salAmmoniac, 15);
        this.makeRecipe((Item)SulfurRegistry.FLUIX.get(), 1, ItemTagRegistry.GEMS_FLUIX, salAmmoniac, 15);
        this.makeRecipe((Item)SulfurRegistry.NITER.get(), 1, ItemTagRegistry.GEMS_NITER, salAmmoniac, 15);
        this.makeRecipe((Item)SulfurRegistry.CHIMERITE.get(), 1, ItemTagRegistry.GEMS_CHIMERITE, salAmmoniac, 100);
        this.makeRecipe((Item)SulfurRegistry.REDSTONE.get(), 1, (TagKey<Item>)Tags.Items.DUSTS_REDSTONE, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.COAL.get(), 1, (TagKey<Item>)ItemTags.f_13160_, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.SULFUR.get(), 1, this.tag("forge:gems/sulfur"), salAmmoniac, 10);
    }

    public void makeRecipe(Item sulfurName, Item ingredient, Fluid solvent, int solventAmount) {
        this.makeRecipe(sulfurName, 1, ingredient, solvent, solventAmount, 100);
    }

    public void makeRecipe(Item sulfur, Item ingredient, Fluid solvent, int solventAmount, int liquefactionTime) {
        this.makeRecipe(sulfur, 1, ingredient, solvent, solventAmount, liquefactionTime);
    }

    public void makeRecipe(Item sulfur, int resultCount, Item ingredient, Fluid solvent, int solventAmount) {
        this.makeRecipe(sulfur, resultCount, ingredient, solvent, solventAmount, 100);
    }

    public void makeRecipe(Item sulfur, int resultCount, Item ingredient, Fluid solvent, int solventAmount, int liquefactionTime) {
        JsonObject nbt = this.makeSulfurNbt(ingredient);
        this.recipeConsumer.accept(this.modLoc(this.name(sulfur)), this.makeRecipeJson(this.makeItemIngredient(this.locFor((ItemLike)ingredient)), this.makeFluidIngredient(this.locFor(solvent)), solventAmount, this.makeItemResult(this.locFor((ItemLike)sulfur), resultCount, nbt), liquefactionTime));
    }

    public void makeRecipe(Item sulfurName, TagKey<Item> ingredient, Fluid solvent, int solventAmount) {
        this.makeRecipe(sulfurName, 1, ingredient, solvent, solventAmount, 100);
    }

    public void makeRecipe(Item sulfurName, TagKey<Item> ingredient, Fluid solvent, int solventAmount, int liquefactionTime) {
        this.makeRecipe(sulfurName, 1, ingredient, solvent, solventAmount, liquefactionTime);
    }

    public void makeRecipe(Item sulfur, int resultCount, TagKey<Item> ingredient, Fluid solvent, int solventAmount) {
        this.makeRecipe(sulfur, resultCount, ingredient, solvent, solventAmount, 100);
    }

    public void makeRecipe(Item sulfur, int resultCount, TagKey<Item> ingredient, Fluid solvent, int solventAmount, int liquefactionTime) {
        String name = this.name(sulfur) + "_from_" + this.name(ingredient);
        JsonObject nbt = this.makeSulfurNbt(ingredient);
        JsonObject recipe = this.makeRecipeJson(this.makeTagIngredient(ingredient.f_203868_()), this.makeFluidIngredient(this.locFor(solvent)), solventAmount, this.makeItemResult(this.locFor((ItemLike)sulfur), resultCount, nbt), liquefactionTime);
        JsonArray conditions = new JsonArray();
        conditions.add((JsonElement)this.makeTagNotEmptyCondition(ingredient.f_203868_().toString()));
        recipe.add("conditions", (JsonElement)conditions);
        this.recipeConsumer.accept(this.modLoc(name), recipe);
    }

    public JsonObject makeSulfurNbt(Item ingredient) {
        JsonObject nbt = new JsonObject();
        nbt.addProperty("theurgy:sulfur.source.id", this.locFor((ItemLike)ingredient).toString());
        return nbt;
    }

    public JsonObject makeSulfurNbt(TagKey<Item> ingredient) {
        JsonObject nbt = new JsonObject();
        nbt.addProperty("theurgy:sulfur.source.id", "#" + ingredient.f_203868_());
        return nbt;
    }

    public JsonObject makeRecipeJson(JsonObject ingredient, JsonObject solvent, int solventAmount, JsonObject result, int liquefactionTime) {
        JsonObject recipe = new JsonObject();
        recipe.addProperty("type", RecipeTypeRegistry.LIQUEFACTION.getId().toString());
        recipe.add("solvent", (JsonElement)solvent);
        recipe.addProperty("solvent_amount", (Number)solventAmount);
        recipe.add("ingredient", (JsonElement)ingredient);
        recipe.add("result", (JsonElement)result);
        recipe.addProperty("liquefaction_time", (Number)liquefactionTime);
        return recipe;
    }

    public String m_6055_() {
        return "Liquefaction Recipes";
    }
}

