/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.datagen.lang;

import com.klikli_dev.modonomicon.api.datagen.AbstractModonomiconLanguageProvider;
import com.klikli_dev.theurgy.content.apparatus.calcinationoven.CalcinationOvenBlock;
import com.klikli_dev.theurgy.content.apparatus.caloricfluxemitter.CaloricFluxEmitterBlock;
import com.klikli_dev.theurgy.content.apparatus.digestionvat.DigestionVatBlock;
import com.klikli_dev.theurgy.content.apparatus.distiller.DistillerBlock;
import com.klikli_dev.theurgy.content.apparatus.fermentationvat.FermentationVatBlock;
import com.klikli_dev.theurgy.content.apparatus.incubator.IncubatorBlock;
import com.klikli_dev.theurgy.content.apparatus.incubator.IncubatorMercuryVesselBlock;
import com.klikli_dev.theurgy.content.apparatus.incubator.IncubatorSaltVesselBlock;
import com.klikli_dev.theurgy.content.apparatus.incubator.IncubatorSulfurVesselBlock;
import com.klikli_dev.theurgy.content.apparatus.liquefactioncauldron.LiquefactionCauldronBlock;
import com.klikli_dev.theurgy.content.apparatus.mercurycatalyst.MercuryCatalystBlock;
import com.klikli_dev.theurgy.content.apparatus.pyromanticbrazier.PyromanticBrazierBlock;
import com.klikli_dev.theurgy.content.apparatus.reformationarray.ReformationResultPedestalBlock;
import com.klikli_dev.theurgy.content.apparatus.reformationarray.ReformationSourcePedestalBlock;
import com.klikli_dev.theurgy.content.apparatus.reformationarray.ReformationTargetPedestalBlock;
import com.klikli_dev.theurgy.content.apparatus.reformationarray.SulfuricFluxEmitterBlock;
import com.klikli_dev.theurgy.content.apparatus.salammoniacaccumulator.SalAmmoniacAccumulatorBlock;
import com.klikli_dev.theurgy.content.apparatus.salammoniactank.SalAmmoniacTankBlock;
import com.klikli_dev.theurgy.content.item.AlchemicalSaltItem;
import com.klikli_dev.theurgy.content.item.AlchemicalSulfurItem;
import com.klikli_dev.theurgy.content.item.AlchemicalSulfurTier;
import com.klikli_dev.theurgy.content.item.AlchemicalSulfurType;
import com.klikli_dev.theurgy.content.item.DivinationRodItem;
import com.klikli_dev.theurgy.datagen.lang.TooltipLanguageProvider;
import com.klikli_dev.theurgy.registry.BlockRegistry;
import com.klikli_dev.theurgy.registry.ItemRegistry;
import com.klikli_dev.theurgy.registry.SaltRegistry;
import com.klikli_dev.theurgy.registry.SulfurRegistry;
import java.text.MessageFormat;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class ENUSProvider
extends AbstractModonomiconLanguageProvider
implements TooltipLanguageProvider {
    public ENUSProvider(PackOutput packOutput) {
        super(packOutput, "theurgy", "en_us");
    }

    protected String f(String pattern, Object ... arguments) {
        return MessageFormat.format(pattern, arguments);
    }

    protected String green(String text) {
        return ChatFormatting.GREEN + text + ChatFormatting.RESET + ChatFormatting.GRAY;
    }

    protected String darkRed(String text) {
        return ChatFormatting.DARK_RED + text + ChatFormatting.RESET + ChatFormatting.GRAY;
    }

    private void addMisc() {
        this.add("tooltip.theurgy.show_extended", ChatFormatting.GOLD + "[" + ChatFormatting.LIGHT_PURPLE + "shift " + ChatFormatting.GRAY + "show more" + ChatFormatting.GOLD + "]");
        this.add("tooltip.theurgy.extended_heading", ChatFormatting.GOLD + "[" + ChatFormatting.GRAY + "more" + ChatFormatting.GOLD + "]");
        this.add("tooltip.theurgy.show_usage", ChatFormatting.GOLD + "[" + ChatFormatting.LIGHT_PURPLE + "ctrl " + ChatFormatting.GRAY + "show usage" + ChatFormatting.GOLD + "]");
        this.add("tooltip.theurgy.usage_heading", ChatFormatting.GOLD + "[" + ChatFormatting.GRAY + "usage" + ChatFormatting.GOLD + "]");
        this.add("theurgy.misc.unit.millibuckets", "%smB");
    }

    private void addBehaviours() {
        this.add("theurgy.behaviour.selection.mode", "%1$s %2$s");
        this.add("theurgy.behaviour.selection.mode.caloric_flux_emitter", "Send caloric flux to");
        this.add("theurgy.behaviour.selection.outside_range", "%1$s selected blocks removed for being out of range.");
        this.add("theurgy.behaviour.selection.summary.caloric_flux_emitter", "Caloric Flux Emitter targets %1$s.");
        this.add("theurgy.behaviour.selection.summary.caloric_flux_emitter.no_selection", "Caloric Flux Emitter has no target.");
        this.add("theurgy.behaviour.selection.mode.sulfuric_flux_emitter", "Add to reformation array: ");
        this.add("theurgy.behaviour.selection.summary.sulfuric_flux_emitter", "Sulfuric Flux Emitter is linked to %1$s source, %2$s target and %3$s result pedestals.");
        this.add("theurgy.behaviour.selection.summary.sulfuric_flux_emitter.no_selection", "Sulfuric Flux Emitter has no linked pedestals.");
        this.add("theurgy.behaviour.selection.summary.sulfuric_flux_emitter.no_target", "Sulfuric Flux Emitter has no linked target pedestal.");
        this.add("theurgy.behaviour.selection.summary.sulfuric_flux_emitter.no_sources", "Sulfuric Flux Emitter has no linked source pedestals.");
        this.add("theurgy.behaviour.selection.summary.sulfuric_flux_emitter.no_result", "Sulfuric Flux Emitter has no linked result pedestal.");
        this.add("theurgy.behaviour.interaction.fermentation_vat.no_recipe", "Cannot close vat, the items in it do not form a valid fermentation recipe.");
        this.add("theurgy.behaviour.interaction.fermentation_vat.closed", "Cannot add or remove items or fluids from the vat while it is closed. Shift+Click to open.");
        this.add("theurgy.behaviour.interaction.digestion_vat.no_recipe", "Cannot close vat, the items in it do not form a valid digestion recipe.");
        this.add("theurgy.behaviour.interaction.digestion_vat.closed", "Cannot add or remove items or fluids from the vat while it is closed. Shift+Click to open.");
    }

    private void addIntegrations() {
        this.add("theurgy.jei.category.calcination", "Calcination");
        this.add("theurgy.jei.category.liquefaction", "Liquefaction");
        this.add("theurgy.jei.category.distillation", "Alchemical Distillation");
        this.add("theurgy.jei.category.incubation", "Incubation");
        this.add("theurgy.jei.category.accumulation", "Accumulation");
        this.add("theurgy.jei.category.reformation", "Reformation");
        this.add("theurgy.jei.category.fermentation", "Alchemical Fermentation");
        this.add("theurgy.jei.category.digestion", "Digestion");
        this.add("theurgy.jei.misc.mercury_flux", "Mercury Flux: %s");
        this.add("theurgy.jei.misc.source_pedestal_count", "%sx");
        this.add("theurgy.jei.misc.source_sulfur.tooltip", "The Target Sulfur will not be consumed!\nYou can retrieve it after crafting is complete.");
        this.add("config.jade.plugin_theurgy.mercury_flux", "Theurgy Mercury Flux");
    }

    private void addSubtitles() {
        this.add("theurgy.subtitle.tuning_fork", "Using Divination Rod");
    }

    private void addMessages() {
        this.add("message.theurgy.divination_rod.linked", this.f("{0}: The divination rod is now attuned to %s.", this.green("Success")));
        this.add("message.theurgy.divination_rod.tier_too_low", this.f("{0}: You need a higher tier divination rod to attune to %s.", this.darkRed("Warning")));
        this.add("message.theurgy.divination_rod.block_not_allowed", this.f("{0}: The divination rod cannot be attuned to this type of block: %s.", this.darkRed("Warning")));
        this.add("message.theurgy.divination_rod.block_disallowed", this.f("{0}: The divination rod cannot be attuned to this type of block: %s.", this.darkRed("Warning")));
        this.add("message.theurgy.divination_rod.no_link", "The divination rod is not attuned to any material.");
        this.add("message.theurgy.divination_rod.attuning_not_allowed", this.f("{0}: This type of divination rod cannot be manually attuned.", this.darkRed("Warning")));
    }

    private void addFluids() {
        this.add("fluid_type.theurgy.sal_ammoniac", "Sal Ammoniac");
    }

    private void addBlocks() {
        this.addBlock((Supplier)BlockRegistry.CALCINATION_OVEN, "Calcination Oven");
        this.addTooltip(() -> ((CalcinationOvenBlock)((CalcinationOvenBlock)((Object)BlockRegistry.CALCINATION_OVEN.get()))).m_5456_(), "A device to extract Alchemical Salt from Items.", "Salt represents the \"body\" or \"physical matter\" of an object.", this.f("Place this on top of a heating device such as a Pyromantic Brazier.\n{0} with ingredients to place them in the oven for processing.\n", this.green("Right-Click")));
        this.addBlock((Supplier)BlockRegistry.PYROMANTIC_BRAZIER, "Pyromantic Brazier");
        this.addTooltip(() -> ((PyromanticBrazierBlock)((PyromanticBrazierBlock)((Object)BlockRegistry.PYROMANTIC_BRAZIER.get()))).m_5456_(), "A simple device to heat alchemical apparati.", "Place this below other alchemical apparati to heat them up", this.f("{0} with a fuel item to insert it (or using a hopper)", this.green("Right-Click")));
        this.addBlock((Supplier)BlockRegistry.LIQUEFACTION_CAULDRON, "Liquefaction Cauldron");
        this.addTooltip(() -> ((LiquefactionCauldronBlock)((LiquefactionCauldronBlock)((Object)BlockRegistry.LIQUEFACTION_CAULDRON.get()))).m_5456_(), "A device to extract Alchemical Sulfur from Items using a Solvent.", "Sulfur represents the \"idea\" or \"soul\" of an object and is the key to replication and transmutation.", this.f("Place this on top of a heating device such as a Pyromantic Brazier.\n{0} with ingredients to add them to the cauldron for processing.\n", this.green("Right-Click")));
        this.addBlock((Supplier)BlockRegistry.DISTILLER, "Mercury Distiller");
        this.addTooltip(() -> ((DistillerBlock)((DistillerBlock)((Object)BlockRegistry.DISTILLER.get()))).m_5456_(), "A device to extract Alchemical Mercury from Items.", "Mercury represents the \"energy\" of an object. It has applications both as an energy source and as a catalyst.", this.f("Place this on top of a heating device such as a Pyromantic Brazier.\n{0} with ingredients to add them to the distiller for processing.\n", this.green("Right-Click")));
        this.addBlock((Supplier)BlockRegistry.INCUBATOR, "Incubator");
        this.addTooltip(() -> ((IncubatorBlock)((IncubatorBlock)((Object)BlockRegistry.INCUBATOR.get()))).m_5456_(), "A device to recombine Alchemical Sulfur, Salt and Mercury into items.", null, "Place this on top of a heating device such as a Pyromantic Brazier.\nNeeds Incubator Vessels for all three ingredient types adjacent horizontally to the incubator.\n");
        this.addBlock((Supplier)BlockRegistry.INCUBATOR_MERCURY_VESSEL, "Incubator Mercury Vessel");
        this.addTooltip(() -> ((IncubatorMercuryVesselBlock)((IncubatorMercuryVesselBlock)((Object)BlockRegistry.INCUBATOR_MERCURY_VESSEL.get()))).m_5456_(), "A vessel to hold Mercury for the Incubator.", null, this.f("Place horizontally next to the incubator.\n{0} with Alchemical Mercury to fill the vessel to allow the Incubator to process it.\n", this.green("Right-Click")));
        this.addBlock((Supplier)BlockRegistry.INCUBATOR_SALT_VESSEL, "Incubator Salt Vessel");
        this.addTooltip(() -> ((IncubatorSaltVesselBlock)((IncubatorSaltVesselBlock)((Object)BlockRegistry.INCUBATOR_SALT_VESSEL.get()))).m_5456_(), "A vessel to hold Salt for the Incubator.", null, this.f("Place horizontally next to the incubator.\n{0} with Alchemical Salt to fill the vessel to allow the Incubator to process it.\n", this.green("Right-Click")));
        this.addBlock((Supplier)BlockRegistry.INCUBATOR_SULFUR_VESSEL, "Incubator Sulfur Vessel");
        this.addTooltip(() -> ((IncubatorSulfurVesselBlock)((IncubatorSulfurVesselBlock)((Object)BlockRegistry.INCUBATOR_SULFUR_VESSEL.get()))).m_5456_(), "A vessel to hold Sulfur for the Incubator.", null, this.f("Place horizontally next to the incubator.\n{0} with Alchemical Sulfur to fill the vessel to allow the Incubator to process it.\n", this.green("Right-Click")));
        this.addBlock((Supplier)BlockRegistry.SAL_AMMONIAC_ACCUMULATOR, "Sal Ammoniac Accumulator");
        this.addTooltip(() -> ((SalAmmoniacAccumulatorBlock)((SalAmmoniacAccumulatorBlock)((Object)BlockRegistry.SAL_AMMONIAC_ACCUMULATOR.get()))).m_5456_(), "A simple device to increase the concentration of residual Sal Ammoniac in water by evaporation.", "The resulting concentrated Sal Ammoniac fluid is a solvent that can be used in Liquefaction Cauldrons.", this.f("Place this on top of a Sal Ammoniac Tank.\n{0} with water buckets to fill the accumulator.\nThe water will be consumed to fill the Sal Ammoniac Tank below.\nYou can additionally add Sal Ammoniac Crystals to the Accumulator to speed up the process.\n", this.green("Right-Click")));
        this.addBlock((Supplier)BlockRegistry.SAL_AMMONIAC_TANK, "Sal Ammoniac Tank");
        this.addTooltip(() -> ((SalAmmoniacTankBlock)((SalAmmoniacTankBlock)((Object)BlockRegistry.SAL_AMMONIAC_TANK.get()))).m_5456_(), "A tank to store concentrated Sal Ammoniac fluid.", "Sal Ammoniac is a solvent that can be used in Liquefaction Cauldrons.", "Place this below a filled Sal Ammoniac Accumulator.\nThe Tank will slowly be filled with Sal Ammoniac.\n");
        this.addBlock((Supplier)BlockRegistry.MERCURY_CATALYST, "Mercury Catalyst");
        this.addTooltip(() -> ((MercuryCatalystBlock)((MercuryCatalystBlock)((Object)BlockRegistry.MERCURY_CATALYST.get()))).m_5456_(), "Converts mercury from it's crystal form into it's flux form.", "Mercury in flux form is pure energy and may be used as an energy source for certain processes.", this.f("{0} with mercury shards to add them to the catalyst.\nThey will be slowly consumed to fill the internal energy storage of the catalyst with mercury flux.\n", this.green("Right-Click")));
        this.addBlock((Supplier)BlockRegistry.CALORIC_FLUX_EMITTER, "Caloric Flux Emitter");
        this.addTooltip(() -> ((CaloricFluxEmitterBlock)((CaloricFluxEmitterBlock)((Object)BlockRegistry.CALORIC_FLUX_EMITTER.get()))).m_5456_(), "Remotely heats an Apparatus by emitting Caloric Flux at it.", "Caloric Flux is energy in the form of raw heat, and as such a derivative of Mercury Flux.", this.f("{0} an apparatus block to set it as the target for the emitter.\nThen place the emitter on a Mercury Flux source, such as a Mercury Catalyst.\nIt will \"shoot\" Caloric Flux at the apparatus, heating it up.\n", this.green("Sneak-Right-Click")));
        this.addBlock((Supplier)BlockRegistry.SULFURIC_FLUX_EMITTER, "Sulfuric Flux Emitter");
        this.addTooltip(() -> ((SulfuricFluxEmitterBlock)((SulfuricFluxEmitterBlock)((Object)BlockRegistry.SULFURIC_FLUX_EMITTER.get()))).m_5456_(), "Used to power a sulfur reformation array to replicate Alchemical Sulfur.", "Sulfuric Flux allows to transfer, merge and manipulate Alchemical Sulfur.", this.f(" {0} on Source, Target and Reformation pedestals to set them as the targets for the emitter to form a reformation array.\nThen place the emitter on a Mercury Flux source, such as a Mercury Catalyst.\nView The Hermetica for more information.\n", this.green("Right-Click")));
        this.addBlock((Supplier)BlockRegistry.REFORMATION_SOURCE_PEDESTAL, "Reformation Source Pedestal");
        this.addTooltip(() -> ((ReformationSourcePedestalBlock)((ReformationSourcePedestalBlock)((Object)BlockRegistry.REFORMATION_SOURCE_PEDESTAL.get()))).m_5456_(), "Holds the source Alchemical Sulfur to be reformed into the target Alchemical Sulfur.");
        this.addBlock((Supplier)BlockRegistry.REFORMATION_TARGET_PEDESTAL, "Reformation Target Pedestal");
        this.addTooltip(() -> ((ReformationTargetPedestalBlock)((ReformationTargetPedestalBlock)((Object)BlockRegistry.REFORMATION_TARGET_PEDESTAL.get()))).m_5456_(), "Holds the target Alchemical Sulfur that the source Alchemical Sulfur should be reformed into.");
        this.addBlock((Supplier)BlockRegistry.REFORMATION_RESULT_PEDESTAL, "Reformation Result Pedestal");
        this.addTooltip(() -> ((ReformationResultPedestalBlock)((ReformationResultPedestalBlock)((Object)BlockRegistry.REFORMATION_RESULT_PEDESTAL.get()))).m_5456_(), "The reformation result will appear in this pedestal.");
        this.addBlock((Supplier)BlockRegistry.FERMENTATION_VAT, "Fermentation Vat");
        this.addTooltip(() -> ((FermentationVatBlock)((FermentationVatBlock)((Object)BlockRegistry.FERMENTATION_VAT.get()))).m_5456_(), "A vat for alchemical fermentation, required for transmutation.", "Fermentation is fundamental the conversion between types of matter (such as between metals and gems).", this.f("{0} with ingredients to place them in the vat for processing.\n{1} with an empty hand to close or open the vat to start or stop processing.\n", this.green("Right-Click"), this.green("Shift-right-Click")));
        this.addBlock((Supplier)BlockRegistry.DIGESTION_VAT, "Digestion Vat");
        this.addTooltip(() -> ((DigestionVatBlock)((DigestionVatBlock)((Object)BlockRegistry.DIGESTION_VAT.get()))).m_5456_(), "A vat for alchemical digestion, required for exaltation.", "Digestion is fundamental the conversion between tiers of matter (such as between common and rare [e.g. iron and gold]).", this.f("{0} with ingredients to place them in the vat for processing.\n{1} with an empty hand to close or open the vat to start or stop processing.\n", this.green("Right-Click"), this.green("Shift-right-Click")));
        this.addBlock((Supplier)BlockRegistry.SAL_AMMONIAC_ORE, "Sal Ammoniac Ore");
        this.addExtendedTooltip(() -> ((Block)((Block)BlockRegistry.SAL_AMMONIAC_ORE.get())).m_5456_(), "Ore that yields Sal Ammoniac Crystals for use in a Sal Ammoniac Accumulator.");
        this.addBlock((Supplier)BlockRegistry.DEEPSLATE_SAL_AMMONIAC_ORE, "Deepslate Sal Ammoniac Ore");
        this.addExtendedTooltip(() -> ((Block)((Block)BlockRegistry.DEEPSLATE_SAL_AMMONIAC_ORE.get())).m_5456_(), "Ore that yields Sal Ammoniac Crystals for use in a Sal Ammoniac Accumulator.");
    }

    private void addGenericSulfur(AlchemicalSulfurItem sulfur) {
        this.addItem(() -> sulfur, "Alchemical Niter %s");
        this.addTooltip(() -> sulfur, "Alchemical Niter crafted from Alchemical Sulfur of any %s.", "Niter represents the abstract category and value of an object, thus it is a further abstraction the \"idea\" or \"soul\" represented by Sulfur.", "Niter extraction is a required intermediate step to transform one type of Sulfur into another type.");
    }

    private void addSulfurs() {
        this.add("item.theurgy.alchemical_sulfur.unknown_source", "Unknown Source");
        this.add(AlchemicalSulfurTier.ABUNDANT.descriptionId(), "Abundant");
        this.add(AlchemicalSulfurTier.COMMON.descriptionId(), "Common");
        this.add(AlchemicalSulfurTier.RARE.descriptionId(), "Rare");
        this.add(AlchemicalSulfurTier.PRECIOUS.descriptionId(), "Precious");
        this.add(AlchemicalSulfurType.MISC.descriptionId(), "Misc");
        this.add(AlchemicalSulfurType.METALS.descriptionId(), "Metals");
        this.add(AlchemicalSulfurType.GEMS.descriptionId(), "Gems");
        this.add(AlchemicalSulfurType.OTHER_MINERALS.descriptionId(), "Other Minerals");
        this.add(AlchemicalSulfurType.NITER.descriptionId(), "Niter");
        SulfurRegistry.SULFURS.getEntries().stream().map(RegistryObject::get).map(AlchemicalSulfurItem.class::cast).forEach(sulfur -> {
            if (sulfur.useAutomaticNameLangGeneration) {
                this.addItem(() -> sulfur, "Alchemical Sulfur %s");
            }
            if (sulfur.useAutomaticTooltipLangGeneration) {
                this.addTooltip(() -> sulfur, "Alchemical Sulfur crafted from %s %s %s.", "Sulfur represents the \"idea\" or \"soul\" of an object", "Sulfur is the central element used in Spagyrics processes.\n\n" + ChatFormatting.ITALIC + "Hint: Sulfurs crafted from different states of the same material (such as from Ore or Ingots) are interchangeable." + ChatFormatting.RESET);
            }
        });
        this.add(Util.m_137492_((String)"tag", (ResourceLocation)ItemTags.f_13182_.f_203868_()), "Logs");
        this.addSulfurSource((Supplier<? extends Item>)SulfurRegistry.GEMS_ABUNDANT, "Abundant Gems");
        this.addGenericSulfur((AlchemicalSulfurItem)((Object)SulfurRegistry.GEMS_ABUNDANT.get()));
        this.addSulfurSource((Supplier<? extends Item>)SulfurRegistry.GEMS_COMMON, "Common Gems");
        this.addGenericSulfur((AlchemicalSulfurItem)((Object)SulfurRegistry.GEMS_COMMON.get()));
        this.addSulfurSource((Supplier<? extends Item>)SulfurRegistry.GEMS_RARE, "Rare Gems");
        this.addGenericSulfur((AlchemicalSulfurItem)((Object)SulfurRegistry.GEMS_RARE.get()));
        this.addSulfurSource((Supplier<? extends Item>)SulfurRegistry.GEMS_PRECIOUS, "Precious Gems");
        this.addGenericSulfur((AlchemicalSulfurItem)((Object)SulfurRegistry.GEMS_PRECIOUS.get()));
        this.addSulfurSource((Supplier<? extends Item>)SulfurRegistry.METALS_ABUNDANT, "Abundant Metals");
        this.addGenericSulfur((AlchemicalSulfurItem)((Object)SulfurRegistry.METALS_ABUNDANT.get()));
        this.addSulfurSource((Supplier<? extends Item>)SulfurRegistry.METALS_COMMON, "Common Metals");
        this.addGenericSulfur((AlchemicalSulfurItem)((Object)SulfurRegistry.METALS_COMMON.get()));
        this.addSulfurSource((Supplier<? extends Item>)SulfurRegistry.METALS_RARE, "Rare Metals");
        this.addGenericSulfur((AlchemicalSulfurItem)((Object)SulfurRegistry.METALS_RARE.get()));
        this.addSulfurSource((Supplier<? extends Item>)SulfurRegistry.METALS_PRECIOUS, "Precious Metals");
        this.addGenericSulfur((AlchemicalSulfurItem)((Object)SulfurRegistry.METALS_PRECIOUS.get()));
        this.addSulfurSource((Supplier<? extends Item>)SulfurRegistry.OTHER_MINERALS_ABUNDANT, "Abundant Other Minerals");
        this.addGenericSulfur((AlchemicalSulfurItem)((Object)SulfurRegistry.OTHER_MINERALS_ABUNDANT.get()));
        this.addSulfurSource((Supplier<? extends Item>)SulfurRegistry.OTHER_MINERALS_COMMON, "Common Other Minerals");
        this.addGenericSulfur((AlchemicalSulfurItem)((Object)SulfurRegistry.OTHER_MINERALS_COMMON.get()));
        this.addSulfurSource((Supplier<? extends Item>)SulfurRegistry.OTHER_MINERALS_RARE, "Rare Other Minerals");
        this.addGenericSulfur((AlchemicalSulfurItem)((Object)SulfurRegistry.OTHER_MINERALS_RARE.get()));
        this.addSulfurSource((Supplier<? extends Item>)SulfurRegistry.OTHER_MINERALS_PRECIOUS, "Precious Other Minerals");
        this.addGenericSulfur((AlchemicalSulfurItem)((Object)SulfurRegistry.OTHER_MINERALS_PRECIOUS.get()));
        this.addSulfurSource((Supplier<? extends Item>)SulfurRegistry.IRON, "Iron");
        this.addSulfurSource((Supplier<? extends Item>)SulfurRegistry.COPPER, "Copper");
        this.addSulfurSource((Supplier<? extends Item>)SulfurRegistry.SILVER, "Silver");
        this.addSulfurSource((Supplier<? extends Item>)SulfurRegistry.GOLD, "Gold");
        this.addSulfurSource((Supplier<? extends Item>)SulfurRegistry.NETHERITE, "Netherite");
        this.addSulfurSource((Supplier<? extends Item>)SulfurRegistry.URANIUM, "Uranium");
        this.addSulfurSource((Supplier<? extends Item>)SulfurRegistry.AZURE_SILVER, "Azure Silver");
        this.addSulfurSource((Supplier<? extends Item>)SulfurRegistry.ZINC, "Zinc");
        this.addSulfurSource((Supplier<? extends Item>)SulfurRegistry.OSMIUM, "Osmium");
        this.addSulfurSource((Supplier<? extends Item>)SulfurRegistry.NICKEL, "Nickel");
        this.addSulfurSource((Supplier<? extends Item>)SulfurRegistry.LEAD, "Lead");
        this.addSulfurSource((Supplier<? extends Item>)SulfurRegistry.ALLTHEMODIUM, "Allthemodium");
        this.addSulfurSource((Supplier<? extends Item>)SulfurRegistry.UNOBTAINIUM, "Unobtainium");
        this.addSulfurSource((Supplier<? extends Item>)SulfurRegistry.IRIDIUM, "Iridium");
        this.addSulfurSource((Supplier<? extends Item>)SulfurRegistry.TIN, "Tin");
        this.addSulfurSource((Supplier<? extends Item>)SulfurRegistry.CINNABAR, "Cinnabar");
        this.addSulfurSource((Supplier<? extends Item>)SulfurRegistry.CRIMSON_IRON, "Crimson Iron");
        this.addSulfurSource((Supplier<? extends Item>)SulfurRegistry.PLATINUM, "Platinum");
        this.addSulfurSource((Supplier<? extends Item>)SulfurRegistry.VIBRANIUM, "Vibranium");
        this.addSulfurSource((Supplier<? extends Item>)SulfurRegistry.DESH, "Desh");
        this.addSulfurSource((Supplier<? extends Item>)SulfurRegistry.OSTRUM, "Ostrum");
        this.addSulfurSource((Supplier<? extends Item>)SulfurRegistry.CALORITE, "Calorite");
        this.addSulfurSource((Supplier<? extends Item>)SulfurRegistry.IESNIUM, "Iesnium");
        this.addSulfurSource((Supplier<? extends Item>)SulfurRegistry.DIAMOND, "Diamond");
        this.addSulfurSource((Supplier<? extends Item>)SulfurRegistry.EMERALD, "Emerald");
        this.addSulfurSource((Supplier<? extends Item>)SulfurRegistry.LAPIS, "Lapis");
        this.addSulfurSource((Supplier<? extends Item>)SulfurRegistry.QUARTZ, "Quartz");
        this.addSulfurSource((Supplier<? extends Item>)SulfurRegistry.AMETHYST, "Amethyst");
        this.addSulfurSource((Supplier<? extends Item>)SulfurRegistry.PRISMARINE, "Prismarine");
        this.addSulfurSource((Supplier<? extends Item>)SulfurRegistry.RUBY, "Ruby");
        this.addSulfurSource((Supplier<? extends Item>)SulfurRegistry.APATITE, "Apatite");
        this.addSulfurSource((Supplier<? extends Item>)SulfurRegistry.PERIDOT, "Peridot");
        this.addSulfurSource((Supplier<? extends Item>)SulfurRegistry.FLUORITE, "Fluorite");
        this.addSulfurSource((Supplier<? extends Item>)SulfurRegistry.SAPPHIRE, "Sapphire");
        this.addSulfurSource((Supplier<? extends Item>)SulfurRegistry.SAL_AMMONIAC, "Sal Ammoniac");
        this.addSulfurSource((Supplier<? extends Item>)SulfurRegistry.CERTUS_QUARTZ, "Certus Quartz");
        this.addSulfurSource((Supplier<? extends Item>)SulfurRegistry.FLUIX, "Fluix");
        this.addSulfurSource((Supplier<? extends Item>)SulfurRegistry.NITER, "Niter");
        this.addSulfurSource((Supplier<? extends Item>)SulfurRegistry.CHIMERITE, "Chimerite");
        this.addSulfurSource((Supplier<? extends Item>)SulfurRegistry.DEMONITE, "Demonite");
        this.addSulfurSource((Supplier<? extends Item>)SulfurRegistry.REDSTONE, "Redstone");
        this.addSulfurSource((Supplier<? extends Item>)SulfurRegistry.COAL, "Coal");
        this.addSulfurSource((Supplier<? extends Item>)SulfurRegistry.SULFUR, "Sulfur");
    }

    private void addSalts() {
        this.addSaltSource((Supplier<? extends Item>)SaltRegistry.MINERAL, "Minerals");
        this.addSaltSource((Supplier<? extends Item>)SaltRegistry.CROPS, "Crops");
        this.addSaltSource((Supplier<? extends Item>)SaltRegistry.STRATA, "Strata");
        this.addExtendedTooltip(() -> ((AlchemicalSaltItem)((AlchemicalSaltItem)((Object)SaltRegistry.STRATA.get()))).m_5456_(), "Salt extracted from the strata, that is, sedimentary rock, soil, clay and so on.");
        SaltRegistry.SALTS.getEntries().stream().map(RegistryObject::get).map(AlchemicalSaltItem.class::cast).forEach(salt -> {
            this.addItem(() -> salt, "Alchemical Salt %s");
            this.addTooltip(() -> salt, "Alchemical Salt calcinated from %s.", null, "Salt represents the \"body\" or \"physical matter\" of an object.");
        });
    }

    public void addSaltSource(Supplier<? extends Item> key, String name) {
        this.add(key.get().m_5524_() + ".source", name);
    }

    public void addSulfurSource(Supplier<? extends Item> key, String name) {
        this.add(key.get().m_5524_() + ".source", name);
    }

    public void addIngredientInfo(Supplier<Item> ingredient, String info) {
        this.add("jei.theurgy.ingredient." + ForgeRegistries.ITEMS.getKey((Object)ingredient.get()).m_135815_() + ".description", info);
    }

    private void addDivinationRods() {
        this.add("tooltip.theurgy..divination_rod.no_link", "The divination rod is " + ChatFormatting.RED + "not attuned" + ChatFormatting.RESET + " to any material.");
        this.add("tooltip.theurgy..divination_rod.linked_to", "The divination rod is attuned to %s");
        this.add("tooltip.theurgy..divination_rod.last_result", "Found %s at %s.");
        this.add("item.theurgy.divination_rod.unknown_linked_block", "Unknown Block (something went wrong)");
        String divinationRodUsage = this.f("{0} a block to attune the rod to it.\n{1} to let the rod search for blocks.\n{2} after a successful search to let the rod show the last found block without consuming durability.\n", this.green("Crouch-Click"), this.green("Right-Click and hold"), this.green("Right-Click without holding"));
        String sulfurAttunedDivinationRodUsage = this.f("{0} the rod with a type of Alchemical Sulfur to attune the rod to it.\n{1} to let the rod search for blocks.\n{2} after a successful search to let the rod show the last found block without consuming durability.\n", this.green("Craft"), this.green("Right-Click and hold"), this.green("Right-Click without holding"));
        String amethystDivinationRodUsage = this.f("{0} the rod, it is automatically attuned to Amethyst.\n{1} to let the rod search for blocks.\n{2} after a successful search to let the rod show the last found block without consuming durability.\n", this.green("Craft"), this.green("Right-Click and hold"), this.green("Right-Click without holding"));
        this.addItem((Supplier)ItemRegistry.DIVINATION_ROD_T1, "Glass Divination Rod");
        this.add(((DivinationRodItem)((Object)ItemRegistry.DIVINATION_ROD_T1.get())).m_5524_() + ".linked", "Glass Divination Rod %s");
        this.addExtendedTooltip((Supplier)ItemRegistry.DIVINATION_ROD_T1, "Divination rods can be attuned to a block and are then used to find other blocks of the same type.", divinationRodUsage);
        this.addItem((Supplier)ItemRegistry.DIVINATION_ROD_T2, "Iron Divination Rod");
        this.add(((DivinationRodItem)((Object)ItemRegistry.DIVINATION_ROD_T2.get())).m_5524_() + ".linked", "Iron Divination Rod %s");
        this.addExtendedTooltip((Supplier)ItemRegistry.DIVINATION_ROD_T2, "Divination rods can be attuned to a block and are then used to find other blocks of the same type.", divinationRodUsage);
        this.addItem((Supplier)ItemRegistry.DIVINATION_ROD_T3, "Diamond Divination Rod");
        this.add(((DivinationRodItem)((Object)ItemRegistry.DIVINATION_ROD_T3.get())).m_5524_() + ".linked", "Diamond Divination Rod %s");
        this.addExtendedTooltip((Supplier)ItemRegistry.DIVINATION_ROD_T3, "Divination rods can be attuned to a block and are then used to find other blocks of the same type.", divinationRodUsage);
        this.addItem((Supplier)ItemRegistry.DIVINATION_ROD_T4, "Netherite Divination Rod");
        this.add(((DivinationRodItem)((Object)ItemRegistry.DIVINATION_ROD_T4.get())).m_5524_() + ".linked", "Netherite Divination Rod %s");
        this.addExtendedTooltip((Supplier)ItemRegistry.DIVINATION_ROD_T4, "Divination rods can be attuned to a block and are then used to find other blocks of the same type.", divinationRodUsage);
        this.addItem((Supplier)ItemRegistry.SULFUR_ATTUNED_DIVINATION_ROD_ABUNDANT, "Divination Rod: Abundant Materials");
        this.add(((DivinationRodItem)((Object)ItemRegistry.SULFUR_ATTUNED_DIVINATION_ROD_ABUNDANT.get())).m_5524_() + ".linked", "Divination Rod: Abundant Materials %s");
        this.addTooltip((Supplier)ItemRegistry.SULFUR_ATTUNED_DIVINATION_ROD_ABUNDANT, "A divination rod attuned to find abundant materials by crafting it with an abundant alchemical sulfur.", "This type of divination rod is crafted pre-attuned to find blocks of the a specific type.", sulfurAttunedDivinationRodUsage);
        this.addItem((Supplier)ItemRegistry.SULFUR_ATTUNED_DIVINATION_ROD_COMMON, "Divination Rod: Common Materials");
        this.add(((DivinationRodItem)((Object)ItemRegistry.SULFUR_ATTUNED_DIVINATION_ROD_COMMON.get())).m_5524_() + ".linked", "Divination Rod: Common Materials %s");
        this.addTooltip((Supplier)ItemRegistry.SULFUR_ATTUNED_DIVINATION_ROD_COMMON, "A divination rod attuned to find common materials by crafting it with a common alchemical sulfur.", "This type of divination rod is crafted pre-attuned to find blocks of the a specific type.", sulfurAttunedDivinationRodUsage);
        this.addItem((Supplier)ItemRegistry.SULFUR_ATTUNED_DIVINATION_ROD_RARE, "Divination Rod: Rare Materials");
        this.add(((DivinationRodItem)((Object)ItemRegistry.SULFUR_ATTUNED_DIVINATION_ROD_RARE.get())).m_5524_() + ".linked", "Divination Rod: Rare Materials %s");
        this.addTooltip((Supplier)ItemRegistry.SULFUR_ATTUNED_DIVINATION_ROD_RARE, "A divination rod attuned to find rare materials by crafting it with a rare alchemical sulfur.", "This type of divination rod is crafted pre-attuned to find blocks of the a specific type.", sulfurAttunedDivinationRodUsage);
        this.addItem((Supplier)ItemRegistry.SULFUR_ATTUNED_DIVINATION_ROD_PRECIOUS, "Divination Rod: Precious Materials");
        this.add(((DivinationRodItem)((Object)ItemRegistry.SULFUR_ATTUNED_DIVINATION_ROD_PRECIOUS.get())).m_5524_() + ".linked", "Divination Rod: Precious Materials %s");
        this.addTooltip((Supplier)ItemRegistry.SULFUR_ATTUNED_DIVINATION_ROD_PRECIOUS, "A divination rod attuned to find precious materials by crafting it with a precious alchemical sulfur.", "This type of divination rod is crafted pre-attuned to find blocks of the a specific type.", sulfurAttunedDivinationRodUsage);
        this.addItem((Supplier)ItemRegistry.AMETHYST_DIVINATION_ROD, "Divination Rod: Amethyst");
        this.add(((DivinationRodItem)((Object)ItemRegistry.AMETHYST_DIVINATION_ROD.get())).m_5524_() + ".linked", "Divination Rod: %s");
        this.addTooltip((Supplier)ItemRegistry.AMETHYST_DIVINATION_ROD, "A divination rod attuned to find amethyst.", "This type of divination rod is crafted pre-attuned to find amethysts.", amethystDivinationRodUsage);
    }

    private void addItems() {
        this.add("itemGroup.theurgy", "Theurgy");
        this.addSalts();
        this.addSulfurs();
        this.addDivinationRods();
        this.addItem((Supplier)ItemRegistry.EMPTY_JAR_ICON, "Empty Jar Icon");
        this.addTooltip((Supplier)ItemRegistry.EMPTY_JAR_ICON, "Dummy item for rendering.");
        this.addItem((Supplier)ItemRegistry.EMPTY_JAR_IRON_BAND_ICON, "Empty Jar with Iron Band Icon");
        this.addTooltip((Supplier)ItemRegistry.EMPTY_JAR_IRON_BAND_ICON, "Dummy item for rendering.");
        this.addItem((Supplier)ItemRegistry.EMPTY_CERAMIC_JAR_ICON, "Empty Ceramic Jar Icon");
        this.addTooltip((Supplier)ItemRegistry.EMPTY_CERAMIC_JAR_ICON, "Dummy item for rendering.");
        this.addItem((Supplier)ItemRegistry.EMPTY_JAR_LABELED_ICON, "Labeled Empty Jar Icon");
        this.addTooltip((Supplier)ItemRegistry.EMPTY_JAR_LABELED_ICON, "Dummy item for rendering.");
        this.addItem((Supplier)ItemRegistry.EMPTY_CERAMIC_JAR_LABELED_ICON, "Labeled Empty Ceramic Jar Icon");
        this.addTooltip((Supplier)ItemRegistry.EMPTY_CERAMIC_JAR_LABELED_ICON, "Dummy item for rendering.");
        this.addItem((Supplier)ItemRegistry.JAR_LABEL_ICON, "Jar Label Icon");
        this.addTooltip((Supplier)ItemRegistry.JAR_LABEL_ICON, "Dummy item for rendering.");
        this.addItem((Supplier)ItemRegistry.JAR_LABEL_FRAME_ABUNDANT_ICON, "Jar Label Frame Abundant Icon");
        this.addTooltip((Supplier)ItemRegistry.JAR_LABEL_FRAME_ABUNDANT_ICON, "Dummy item for rendering.");
        this.addItem((Supplier)ItemRegistry.JAR_LABEL_FRAME_COMMON_ICON, "Jar Label Frame Common Icon");
        this.addTooltip((Supplier)ItemRegistry.JAR_LABEL_FRAME_COMMON_ICON, "Dummy item for rendering.");
        this.addItem((Supplier)ItemRegistry.JAR_LABEL_FRAME_RARE_ICON, "Jar Label Frame Rare Icon");
        this.addTooltip((Supplier)ItemRegistry.JAR_LABEL_FRAME_RARE_ICON, "Dummy item for rendering.");
        this.addItem((Supplier)ItemRegistry.JAR_LABEL_FRAME_PRECIOUS_ICON, "Jar Label Frame Precious Icon");
        this.addTooltip((Supplier)ItemRegistry.JAR_LABEL_FRAME_PRECIOUS_ICON, "Dummy item for rendering.");
        this.addItem((Supplier)ItemRegistry.THE_HERMETICA_ICON, "The Hermetica Icon");
        this.addTooltip((Supplier)ItemRegistry.THE_HERMETICA_ICON, "Dummy item for rendering.");
        this.addItem((Supplier)ItemRegistry.GEMS_ABUNDANT_ICON, "Abundant Gems Icon");
        this.addTooltip((Supplier)ItemRegistry.GEMS_ABUNDANT_ICON, "Dummy item for rendering.");
        this.addItem((Supplier)ItemRegistry.GEMS_COMMON_ICON, "Common Gems Icon");
        this.addTooltip((Supplier)ItemRegistry.GEMS_COMMON_ICON, "Dummy item for rendering.");
        this.addItem((Supplier)ItemRegistry.GEMS_RARE_ICON, "Rare Gems Icon");
        this.addTooltip((Supplier)ItemRegistry.GEMS_RARE_ICON, "Dummy item for rendering.");
        this.addItem((Supplier)ItemRegistry.GEMS_PRECIOUS_ICON, "Precious Gems Icon");
        this.addTooltip((Supplier)ItemRegistry.GEMS_PRECIOUS_ICON, "Dummy item for rendering.");
        this.addItem((Supplier)ItemRegistry.METALS_ABUNDANT_ICON, "Abundant Metals Icon");
        this.addTooltip((Supplier)ItemRegistry.METALS_ABUNDANT_ICON, "Dummy item for rendering.");
        this.addItem((Supplier)ItemRegistry.METALS_COMMON_ICON, "Common Metals Icon");
        this.addTooltip((Supplier)ItemRegistry.METALS_COMMON_ICON, "Dummy item for rendering.");
        this.addItem((Supplier)ItemRegistry.METALS_RARE_ICON, "Rare Metals Icon");
        this.addTooltip((Supplier)ItemRegistry.METALS_RARE_ICON, "Dummy item for rendering.");
        this.addItem((Supplier)ItemRegistry.METALS_PRECIOUS_ICON, "Precious Metals Icon");
        this.addTooltip((Supplier)ItemRegistry.METALS_PRECIOUS_ICON, "Dummy item for rendering.");
        this.addItem((Supplier)ItemRegistry.OTHER_MINERALS_ABUNDANT_ICON, "Abundant Other Minerals Icon");
        this.addTooltip((Supplier)ItemRegistry.OTHER_MINERALS_ABUNDANT_ICON, "Dummy item for rendering.");
        this.addItem((Supplier)ItemRegistry.OTHER_MINERALS_COMMON_ICON, "Common Other Minerals Icon");
        this.addTooltip((Supplier)ItemRegistry.OTHER_MINERALS_COMMON_ICON, "Dummy item for rendering.");
        this.addItem((Supplier)ItemRegistry.OTHER_MINERALS_RARE_ICON, "Rare Other Minerals Icon");
        this.addTooltip((Supplier)ItemRegistry.OTHER_MINERALS_RARE_ICON, "Dummy item for rendering.");
        this.addItem((Supplier)ItemRegistry.OTHER_MINERALS_PRECIOUS_ICON, "Precious Other Minerals Icon");
        this.addTooltip((Supplier)ItemRegistry.OTHER_MINERALS_PRECIOUS_ICON, "Dummy item for rendering.");
        this.addItem((Supplier)ItemRegistry.SAL_AMMONIAC_BUCKET, "Sal Ammoniac Bucket");
        this.addItem((Supplier)ItemRegistry.MERCURY_SHARD, "Mercury Shard");
        this.addExtendedTooltip((Supplier)ItemRegistry.MERCURY_SHARD, "Mercury shards are small pieces of Mercury in crystalline form. Their main uses are as ingredient in Digestion processes and as an energy source.");
        this.addItem((Supplier)ItemRegistry.MERCURY_CRYSTAL, "Mercury Crystal");
        this.addExtendedTooltip((Supplier)ItemRegistry.MERCURY_CRYSTAL, "Mercury crystals are large pieces of Mercury in crystalline form. Their main uses are as ingredient in Digestion processes and as an energy source.");
        this.addItem((Supplier)ItemRegistry.SAL_AMMONIAC_CRYSTAL, "Sal Ammoniac Crystal");
        this.addExtendedTooltip((Supplier)ItemRegistry.SAL_AMMONIAC_CRYSTAL, "Obtained by mining Sal Ammoniac Ore, or by crafting a Sal Ammoniac Bucket in a crafting grid.\n");
        this.addUsageTooltip((Supplier)ItemRegistry.SAL_AMMONIAC_CRYSTAL, "Can be used in a Sal Ammoniac Accumulator to rapidly create Sal Ammoniac to be used as a solvent.\n");
        this.addIngredientInfo((Supplier<Item>)ItemRegistry.SAL_AMMONIAC_CRYSTAL, "Obtained by mining Sal Ammoniac Ore.");
        this.addItem((Supplier)ItemRegistry.PURIFIED_GOLD, "Purified Gold");
        this.addTooltip((Supplier)ItemRegistry.PURIFIED_GOLD, "Alchemically pure gold.", "Gold that has been purified by alchemical Digestion. This further improves the property of Gold not to react with other elements, allowing it to be used in alchemical processes without adding impurities to the result.\n", "Acts as a catalysator, enabling various alchemical processes.");
    }

    protected void addTranslations() {
        this.addMisc();
        this.addSubtitles();
        this.addMessages();
        this.addItems();
        this.addBlocks();
        this.addFluids();
        this.addIntegrations();
        this.addBehaviours();
    }
}

