/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.content.apparatus.salammoniacaccumulator;

import com.klikli_dev.theurgy.content.apparatus.salammoniacaccumulator.SalAmmoniacAccumulatorCraftingBehaviour;
import com.klikli_dev.theurgy.content.particle.ParticleColor;
import com.klikli_dev.theurgy.content.particle.coloredbubble.ColoredBubbleParticleProvider;
import com.klikli_dev.theurgy.content.storage.MonitoredItemStackHandler;
import com.klikli_dev.theurgy.registry.BlockEntityRegistry;
import com.klikli_dev.theurgy.registry.ItemTagRegistry;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class SalAmmoniacAccumulatorBlockEntity
extends BlockEntity
implements GeoBlockEntity {
    protected final AnimatableInstanceCache animatableInstanceCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public ItemStackHandler inventory = new Inventory();
    public LazyOptional<IItemHandler> inventoryCapability = LazyOptional.of(() -> this.inventory);
    public FluidTank waterTank;
    public LazyOptional<IFluidHandler> waterTankCapability;
    protected SalAmmoniacAccumulatorCraftingBehaviour craftingBehaviour = new SalAmmoniacAccumulatorCraftingBehaviour((BlockEntity)this, () -> this.inventory, () -> this.inventory, () -> this.waterTank, this::getOutputTank);
    private boolean checkOutputTankOnNextQuery = true;
    private boolean hasOutputTank;

    public SalAmmoniacAccumulatorBlockEntity(BlockPos pPos, BlockState pState) {
        super((BlockEntityType)BlockEntityRegistry.SAL_AMMONIAC_ACCUMULATOR.get(), pPos, pState);
        this.waterTank = new WaterTank(10000, this.craftingBehaviour::canProcess);
        this.waterTankCapability = LazyOptional.of(() -> this.waterTank);
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        this.writeNetwork(tag);
        return tag;
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.readNetwork(tag);
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection connection, ClientboundBlockEntityDataPacket packet) {
        CompoundTag tag = packet.m_131708_();
        if (tag != null) {
            this.readNetwork(tag);
        }
    }

    public void readNetwork(CompoundTag tag) {
        if (tag.m_128441_("waterTank")) {
            this.waterTank.readFromNBT(tag.m_128469_("waterTank"));
        }
        if (tag.m_128441_("inventory")) {
            this.inventory.deserializeNBT(tag.m_128469_("inventory"));
        }
        this.craftingBehaviour.readNetwork(tag);
    }

    public void writeNetwork(CompoundTag tag) {
        tag.m_128365_("waterTank", (Tag)this.waterTank.writeToNBT(new CompoundTag()));
        tag.m_128365_("inventory", (Tag)this.inventory.serializeNBT());
        this.craftingBehaviour.writeNetwork(tag);
    }

    public void sendBlockUpdated() {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 2);
        }
    }

    public void tickServer() {
        if (!this.hasOutputTank()) {
            return;
        }
        boolean hasInput = !this.waterTank.isEmpty();
        this.craftingBehaviour.tickServer(true, hasInput);
    }

    public void tickClient() {
        boolean isProcessing = this.craftingBehaviour.isProcessing();
        if (isProcessing && this.m_58904_().m_46467_() % 2L == 0L) {
            FluidStack fluidStack = this.waterTank.getFluid();
            IClientFluidTypeExtensions fluidClientExtension = IClientFluidTypeExtensions.of((Fluid)fluidStack.getFluid());
            int waterColor = fluidClientExtension.getTintColor(fluidStack);
            ParticleColor particleColor = this.inventory.getStackInSlot(0).m_204117_(ItemTagRegistry.GEMS_SAL_AMMONIAC) ? new ParticleColor(255, 192, 128) : ParticleColor.fromInt(waterColor);
            float fluidHeight = (float)fluidStack.getAmount() / (float)this.waterTank.getCapacity();
            fluidHeight += 0.3f;
            this.m_58904_().m_7106_(ColoredBubbleParticleProvider.createOptions(particleColor), (double)this.m_58899_().m_123341_() + 0.33 + 0.33 * (double)this.m_58904_().m_213780_().m_188501_(), (double)((float)this.m_58899_().m_123342_() + (fluidHeight *= 0.6f)), (double)this.m_58899_().m_123343_() + 0.33 + 0.33 * (double)this.m_58904_().m_213780_().m_188501_(), 0.0, 0.015, 0.0);
        }
    }

    public IFluidHandler getOutputTank() {
        BlockPos below = this.m_58899_().m_7495_();
        BlockEntity blockEntity = this.f_58857_.m_7702_(below);
        return (IFluidHandler)blockEntity.getCapability(ForgeCapabilities.FLUID_HANDLER).orElseThrow(() -> new IllegalStateException("No fluid handler capability found on block entity below at location: " + below));
    }

    public void validateOutputTank() {
        BlockPos below = this.m_58899_().m_7495_();
        BlockEntity blockEntity = this.f_58857_.m_7702_(below);
        this.hasOutputTank = blockEntity != null && blockEntity.getCapability(ForgeCapabilities.FLUID_HANDLER).isPresent();
    }

    public boolean hasOutputTank() {
        if (this.checkOutputTankOnNextQuery) {
            this.checkOutputTankOnNextQuery = false;
            this.validateOutputTank();
        }
        return this.hasOutputTank;
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.inventoryCapability.cast();
        }
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            return this.waterTankCapability.cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.inventoryCapability.invalidate();
        this.waterTankCapability.invalidate();
    }

    protected void m_183515_(CompoundTag pTag) {
        super.m_183515_(pTag);
        pTag.m_128365_("inventory", (Tag)this.inventory.serializeNBT());
        pTag.m_128365_("waterTank", (Tag)this.waterTank.writeToNBT(new CompoundTag()));
        this.craftingBehaviour.saveAdditional(pTag);
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        if (pTag.m_128441_("inventory")) {
            this.inventory.deserializeNBT(pTag.m_128469_("inventory"));
        }
        if (pTag.m_128441_("waterTank")) {
            this.waterTank.readFromNBT(pTag.m_128469_("waterTank"));
        }
        this.craftingBehaviour.load(pTag);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.animatableInstanceCache;
    }

    public class Inventory
    extends MonitoredItemStackHandler {
        public Inventory() {
            super(1);
        }

        @Override
        protected void onContentTypeChanged(int slot, ItemStack oldStack, ItemStack newStack) {
            SalAmmoniacAccumulatorBlockEntity.this.craftingBehaviour.onInputItemChanged(oldStack, newStack);
            SalAmmoniacAccumulatorBlockEntity.this.sendBlockUpdated();
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            return SalAmmoniacAccumulatorBlockEntity.this.craftingBehaviour.canProcess(stack) && super.isItemValid(slot, stack);
        }

        protected void onContentsChanged(int slot) {
            SalAmmoniacAccumulatorBlockEntity.this.m_6596_();
        }
    }

    public class WaterTank
    extends FluidTank {
        public WaterTank(int capacity, Predicate<FluidStack> validator) {
            super(capacity, validator);
        }

        protected void onContentsChanged() {
            SalAmmoniacAccumulatorBlockEntity.this.m_6596_();
            SalAmmoniacAccumulatorBlockEntity.this.sendBlockUpdated();
        }
    }
}

