/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.content.apparatus.reformationarray;

import com.klikli_dev.theurgy.content.apparatus.reformationarray.ReformationResultPedestalBlockEntity;
import com.klikli_dev.theurgy.content.apparatus.reformationarray.ReformationSourcePedestalBlockEntity;
import com.klikli_dev.theurgy.content.apparatus.reformationarray.ReformationTargetPedestalBlockEntity;
import com.klikli_dev.theurgy.content.apparatus.reformationarray.SulfuricFluxEmitterBlockEntity;
import com.klikli_dev.theurgy.content.apparatus.reformationarray.SulfuricFluxEmitterSelectedPoint;
import com.klikli_dev.theurgy.content.behaviour.interaction.InteractionBehaviour;
import com.klikli_dev.theurgy.content.render.outliner.Outliner;
import com.klikli_dev.theurgy.network.Networking;
import com.klikli_dev.theurgy.network.messages.MessageShowSulfuricFluxEmitterStatus;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SulfuricFluxEmitterInteractionBehaviour
implements InteractionBehaviour {
    @Override
    public InteractionResult use(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        BlockEntity blockEntity = pLevel.m_7702_(pPos);
        if (!(blockEntity instanceof SulfuricFluxEmitterBlockEntity)) {
            return InteractionResult.PASS;
        }
        SulfuricFluxEmitterBlockEntity sulfuricFluxEmitter = (SulfuricFluxEmitterBlockEntity)blockEntity;
        if (pLevel.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        Networking.sendTo((ServerPlayer)pPlayer, new MessageShowSulfuricFluxEmitterStatus(pPos, sulfuricFluxEmitter.sourcePedestals, sulfuricFluxEmitter.targetPedestal, sulfuricFluxEmitter.resultPedestal));
        sulfuricFluxEmitter.checkValidMultiblockOnNextQuery = true;
        return InteractionResult.SUCCESS;
    }

    public void showStatus(Level level, BlockPos pos, Player player) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (!(blockEntity instanceof SulfuricFluxEmitterBlockEntity)) {
            return;
        }
        SulfuricFluxEmitterBlockEntity sulfuricFluxEmitter = (SulfuricFluxEmitterBlockEntity)blockEntity;
        this.showOutlines(level, sulfuricFluxEmitter);
        this.showStatusMessage(level, player, sulfuricFluxEmitter);
    }

    private void showOutlines(Level level, SulfuricFluxEmitterBlockEntity sulfuricFluxEmitter) {
        boolean isValid;
        VoxelShape shape;
        BlockPos pos;
        if (sulfuricFluxEmitter.targetPedestal != null) {
            pos = sulfuricFluxEmitter.targetPedestal.getBlockPos();
            shape = Shapes.m_83144_();
            isValid = level.m_7702_(sulfuricFluxEmitter.targetPedestal.getBlockPos()) instanceof ReformationTargetPedestalBlockEntity;
            Outliner.get().showAABB(sulfuricFluxEmitter.targetPedestal, shape.m_83215_().m_82338_(pos), 100).colored(isValid ? sulfuricFluxEmitter.targetPedestal.getColor().getRGB() : 0xFF0000).lineWidth(0.0625f);
        }
        if (sulfuricFluxEmitter.resultPedestal != null) {
            pos = sulfuricFluxEmitter.resultPedestal.getBlockPos();
            shape = Shapes.m_83144_();
            isValid = level.m_7702_(sulfuricFluxEmitter.resultPedestal.getBlockPos()) instanceof ReformationResultPedestalBlockEntity;
            Outliner.get().showAABB(sulfuricFluxEmitter.resultPedestal, shape.m_83215_().m_82338_(pos), 100).colored(isValid ? sulfuricFluxEmitter.resultPedestal.getColor().getRGB() : 0xFF0000).lineWidth(0.0625f);
        }
        for (SulfuricFluxEmitterSelectedPoint sourcePedestal : sulfuricFluxEmitter.sourcePedestals) {
            BlockPos pos2 = sourcePedestal.getBlockPos();
            VoxelShape shape2 = Shapes.m_83144_();
            boolean isValid2 = level.m_7702_(sourcePedestal.getBlockPos()) instanceof ReformationSourcePedestalBlockEntity;
            Outliner.get().showAABB(sourcePedestal, shape2.m_83215_().m_82338_(pos2), 100).colored(isValid2 ? sourcePedestal.getColor().getRGB() : 0xFF0000).lineWidth(0.0625f);
        }
    }

    private void showStatusMessage(Level level, Player player, SulfuricFluxEmitterBlockEntity sulfuricFluxEmitter) {
        if (sulfuricFluxEmitter.sourcePedestalsWithContents.isEmpty() && sulfuricFluxEmitter.targetPedestal == null && sulfuricFluxEmitter.resultPedestal == null) {
            player.m_5661_((Component)Component.m_237115_((String)"theurgy.behaviour.selection.summary.sulfuric_flux_emitter.no_selection").m_130940_(ChatFormatting.RED), true);
        } else {
            boolean hasTarget = sulfuricFluxEmitter.targetPedestal != null && level.m_7702_(sulfuricFluxEmitter.targetPedestal.getBlockPos()) instanceof ReformationTargetPedestalBlockEntity;
            boolean hasResult = sulfuricFluxEmitter.resultPedestal != null && level.m_7702_(sulfuricFluxEmitter.resultPedestal.getBlockPos()) instanceof ReformationResultPedestalBlockEntity;
            long sources = sulfuricFluxEmitter.sourcePedestals.stream().map(p -> level.m_7702_(p.getBlockPos())).filter(e -> e instanceof ReformationSourcePedestalBlockEntity).count();
            if (!hasTarget) {
                player.m_5661_((Component)Component.m_237115_((String)"theurgy.behaviour.selection.summary.sulfuric_flux_emitter.no_target").m_130940_(ChatFormatting.RED), true);
            }
            if (sources <= 0L) {
                player.m_5661_((Component)Component.m_237115_((String)"theurgy.behaviour.selection.summary.sulfuric_flux_emitter.no_sources").m_130940_(ChatFormatting.RED), true);
            }
            if (!hasResult) {
                player.m_5661_((Component)Component.m_237115_((String)"theurgy.behaviour.selection.summary.sulfuric_flux_emitter.no_result").m_130940_(ChatFormatting.RED), true);
            }
            if (hasTarget && sources > 0L && hasResult) {
                player.m_5661_((Component)Component.m_237110_((String)"theurgy.behaviour.selection.summary.sulfuric_flux_emitter", (Object[])new Object[]{Component.m_237113_((String)String.valueOf(sources)).m_130940_(ChatFormatting.DARK_PURPLE), Component.m_237113_((String)String.valueOf(1)).m_130940_(ChatFormatting.BLUE), Component.m_237113_((String)String.valueOf(1)).m_130940_(ChatFormatting.GREEN)}).m_130940_(ChatFormatting.WHITE), true);
            }
        }
    }
}

