/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.config;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;

public class TravelersBackpackConfig {
    public static Common.BackpackSettings.Tier leatherTier;
    public static Common.BackpackSettings.Tier ironTier;
    public static Common.BackpackSettings.Tier goldTier;
    public static Common.BackpackSettings.Tier diamondTier;
    public static Common.BackpackSettings.Tier netheriteTier;
    public static boolean enableTierUpgrades;
    public static boolean enableCraftingUpgrade;
    public static boolean craftingUpgradeByDefault;
    public static boolean craftingSavesItems;
    public static boolean enableBackpackBlockWearable;
    public static boolean enableBackpackRightClickUnequip;
    public static boolean invulnerableBackpack;
    public static boolean toolSlotsAcceptSwords;
    public static boolean toolSlotsAcceptEverything;
    public static List<? extends String> toolSlotsAcceptableItems;
    public static List<? extends String> blacklistedItems;
    public static boolean allowShulkerBoxes;
    public static boolean voidProtection;
    public static boolean backpackDeathPlace;
    public static boolean backpackForceDeathPlace;
    public static boolean enableSleepingBagSpawnPoint;
    public static boolean curiosIntegration;
    public static boolean enableLoot;
    public static boolean spawnEntitiesWithBackpack;
    public static List<? extends String> possibleOverworldEntityTypes;
    public static List<? extends String> possibleNetherEntityTypes;
    public static int spawnChance;
    public static List<? extends String> overworldBackpacks;
    public static List<? extends String> netherBackpacks;
    public static boolean enableVillagerTrade;
    public static boolean enableBackpackAbilities;
    public static boolean forceAbilityEnabled;
    public static List<? extends String> allowedAbilities;
    public static boolean tooManyBackpacksSlowness;
    public static int maxNumberOfBackpacks;
    public static double slownessPerExcessedBackpack;
    public static boolean enableLegacyGui;
    public static boolean enableToolCycling;
    public static boolean disableScrollWheel;
    public static boolean obtainTips;
    public static boolean renderTools;
    public static boolean renderBackpackWithElytra;
    public static boolean disableBackpackRender;
    public static boolean enableOverlay;
    public static int offsetX;
    public static int offsetY;
    public static final ForgeConfigSpec commonSpec;
    public static final Common COMMON;
    public static final ForgeConfigSpec clientSpec;
    public static final Client CLIENT;

    public static void register(ModLoadingContext context) {
        context.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)commonSpec);
        context.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)clientSpec);
    }

    public static void bakeCommonConfig() {
        leatherTier = new Common.BackpackSettings.Tier((Integer)TravelersBackpackConfig.COMMON.backpackSettings.leather.inventorySlotCount.get(), (Integer)TravelersBackpackConfig.COMMON.backpackSettings.leather.toolSlotCount.get(), (Integer)TravelersBackpackConfig.COMMON.backpackSettings.leather.tankCapacity.get());
        ironTier = new Common.BackpackSettings.Tier((Integer)TravelersBackpackConfig.COMMON.backpackSettings.iron.inventorySlotCount.get(), (Integer)TravelersBackpackConfig.COMMON.backpackSettings.iron.toolSlotCount.get(), (Integer)TravelersBackpackConfig.COMMON.backpackSettings.iron.tankCapacity.get());
        goldTier = new Common.BackpackSettings.Tier((Integer)TravelersBackpackConfig.COMMON.backpackSettings.gold.inventorySlotCount.get(), (Integer)TravelersBackpackConfig.COMMON.backpackSettings.gold.toolSlotCount.get(), (Integer)TravelersBackpackConfig.COMMON.backpackSettings.gold.tankCapacity.get());
        diamondTier = new Common.BackpackSettings.Tier((Integer)TravelersBackpackConfig.COMMON.backpackSettings.diamond.inventorySlotCount.get(), (Integer)TravelersBackpackConfig.COMMON.backpackSettings.diamond.toolSlotCount.get(), (Integer)TravelersBackpackConfig.COMMON.backpackSettings.diamond.tankCapacity.get());
        netheriteTier = new Common.BackpackSettings.Tier((Integer)TravelersBackpackConfig.COMMON.backpackSettings.netherite.inventorySlotCount.get(), (Integer)TravelersBackpackConfig.COMMON.backpackSettings.netherite.toolSlotCount.get(), (Integer)TravelersBackpackConfig.COMMON.backpackSettings.netherite.tankCapacity.get());
        enableTierUpgrades = (Boolean)TravelersBackpackConfig.COMMON.backpackSettings.enableTierUpgrades.get();
        enableCraftingUpgrade = (Boolean)TravelersBackpackConfig.COMMON.backpackSettings.enableCraftingUpgrade.get();
        craftingUpgradeByDefault = (Boolean)TravelersBackpackConfig.COMMON.backpackSettings.craftingUpgradeByDefault.get();
        craftingSavesItems = (Boolean)TravelersBackpackConfig.COMMON.backpackSettings.craftingSavesItems.get();
        enableBackpackBlockWearable = (Boolean)TravelersBackpackConfig.COMMON.backpackSettings.enableBackpackBlockWearable.get();
        enableBackpackRightClickUnequip = (Boolean)TravelersBackpackConfig.COMMON.backpackSettings.enableBackpackRightClickUnequip.get();
        invulnerableBackpack = (Boolean)TravelersBackpackConfig.COMMON.backpackSettings.invulnerableBackpack.get();
        toolSlotsAcceptSwords = (Boolean)TravelersBackpackConfig.COMMON.backpackSettings.toolSlotsAcceptSwords.get();
        toolSlotsAcceptableItems = (List)TravelersBackpackConfig.COMMON.backpackSettings.toolSlotsAcceptableItems.get();
        toolSlotsAcceptEverything = (Boolean)TravelersBackpackConfig.COMMON.backpackSettings.toolSlotsAcceptEverything.get();
        blacklistedItems = (List)TravelersBackpackConfig.COMMON.backpackSettings.blacklistedItems.get();
        allowShulkerBoxes = (Boolean)TravelersBackpackConfig.COMMON.backpackSettings.allowShulkerBoxes.get();
        voidProtection = (Boolean)TravelersBackpackConfig.COMMON.backpackSettings.voidProtection.get();
        backpackDeathPlace = (Boolean)TravelersBackpackConfig.COMMON.backpackSettings.backpackDeathPlace.get();
        backpackForceDeathPlace = (Boolean)TravelersBackpackConfig.COMMON.backpackSettings.backpackForceDeathPlace.get();
        enableSleepingBagSpawnPoint = (Boolean)TravelersBackpackConfig.COMMON.backpackSettings.enableSleepingBagSpawnPoint.get();
        curiosIntegration = (Boolean)TravelersBackpackConfig.COMMON.backpackSettings.curiosIntegration.get();
        enableLoot = (Boolean)TravelersBackpackConfig.COMMON.world.enableLoot.get();
        spawnEntitiesWithBackpack = (Boolean)TravelersBackpackConfig.COMMON.world.spawnEntitiesWithBackpack.get();
        possibleOverworldEntityTypes = (List)TravelersBackpackConfig.COMMON.world.possibleOverworldEntityTypes.get();
        possibleNetherEntityTypes = (List)TravelersBackpackConfig.COMMON.world.possibleNetherEntityTypes.get();
        overworldBackpacks = (List)TravelersBackpackConfig.COMMON.world.overworldBackpacks.get();
        netherBackpacks = (List)TravelersBackpackConfig.COMMON.world.netherBackpacks.get();
        enableVillagerTrade = (Boolean)TravelersBackpackConfig.COMMON.world.enableVillagerTrade.get();
        enableBackpackAbilities = (Boolean)TravelersBackpackConfig.COMMON.backpackAbilities.enableBackpackAbilities.get();
        forceAbilityEnabled = (Boolean)TravelersBackpackConfig.COMMON.backpackAbilities.forceAbilityEnabled.get();
        allowedAbilities = (List)TravelersBackpackConfig.COMMON.backpackAbilities.allowedAbilities.get();
        tooManyBackpacksSlowness = (Boolean)TravelersBackpackConfig.COMMON.slownessDebuff.tooManyBackpacksSlowness.get();
        maxNumberOfBackpacks = (Integer)TravelersBackpackConfig.COMMON.slownessDebuff.maxNumberOfBackpacks.get();
        slownessPerExcessedBackpack = (Double)TravelersBackpackConfig.COMMON.slownessDebuff.slownessPerExcessedBackpack.get();
    }

    public static void bakeClientConfig() {
        enableLegacyGui = (Boolean)TravelersBackpackConfig.CLIENT.enableLegacyGui.get();
        enableToolCycling = (Boolean)TravelersBackpackConfig.CLIENT.enableToolCycling.get();
        disableScrollWheel = (Boolean)TravelersBackpackConfig.CLIENT.disableScrollWheel.get();
        obtainTips = (Boolean)TravelersBackpackConfig.CLIENT.obtainTips.get();
        renderTools = (Boolean)TravelersBackpackConfig.CLIENT.renderTools.get();
        enableOverlay = (Boolean)TravelersBackpackConfig.CLIENT.overlay.enableOverlay.get();
        offsetX = (Integer)TravelersBackpackConfig.CLIENT.overlay.offsetX.get();
        offsetY = (Integer)TravelersBackpackConfig.CLIENT.overlay.offsetY.get();
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Common::new);
        commonSpec = (ForgeConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
        specPair = new ForgeConfigSpec.Builder().configure(Client::new);
        clientSpec = (ForgeConfigSpec)specPair.getRight();
        CLIENT = (Client)specPair.getLeft();
    }

    public static class Common {
        private static final String REGISTRY_NAME_MATCHER = "([a-z0-9_.-]+:[a-z0-9_/.-]+)";
        public final BackpackSettings backpackSettings;
        public final World world;
        public final BackpackAbilities backpackAbilities;
        public final SlownessDebuff slownessDebuff;

        Common(ForgeConfigSpec.Builder builder) {
            builder.comment("Common config settings").push("common");
            this.backpackSettings = new BackpackSettings(builder, "backpackSettings");
            this.world = new World(builder, "world");
            this.backpackAbilities = new BackpackAbilities(builder, "backpackAbilities");
            this.slownessDebuff = new SlownessDebuff(builder, "slownessDebuff");
            builder.pop();
        }

        public void loadItemsFromConfig(List<? extends String> configList, List<Item> targetList) {
            for (String string : configList) {
                ResourceLocation res = ResourceLocation.m_135820_((String)string);
                if (!ForgeRegistries.ITEMS.containsKey(res)) continue;
                targetList.add((Item)ForgeRegistries.ITEMS.getValue(res));
            }
        }

        public void loadEntityTypesFromConfig(List<? extends String> configList, List<EntityType> targetList) {
            for (String string : configList) {
                ResourceLocation res = ResourceLocation.m_135820_((String)string);
                if (!ForgeRegistries.ENTITY_TYPES.containsKey(res)) continue;
                targetList.add((EntityType)ForgeRegistries.ENTITY_TYPES.getValue(res));
            }
        }

        public static class BackpackSettings {
            public final TierConfig leather;
            public final TierConfig iron;
            public final TierConfig gold;
            public final TierConfig diamond;
            public final TierConfig netherite;
            public final ForgeConfigSpec.BooleanValue enableTierUpgrades;
            public final ForgeConfigSpec.BooleanValue enableCraftingUpgrade;
            public final ForgeConfigSpec.BooleanValue craftingUpgradeByDefault;
            public final ForgeConfigSpec.BooleanValue craftingSavesItems;
            public final ForgeConfigSpec.BooleanValue enableBackpackBlockWearable;
            public final ForgeConfigSpec.BooleanValue enableBackpackRightClickUnequip;
            public final ForgeConfigSpec.BooleanValue allowOnlyEquippedBackpack;
            public final ForgeConfigSpec.BooleanValue invulnerableBackpack;
            public final ForgeConfigSpec.BooleanValue toolSlotsAcceptSwords;
            public final ForgeConfigSpec.BooleanValue toolSlotsAcceptEverything;
            public final ForgeConfigSpec.ConfigValue<List<? extends String>> toolSlotsAcceptableItems;
            public final ForgeConfigSpec.ConfigValue<List<? extends String>> blacklistedItems;
            public final ForgeConfigSpec.BooleanValue allowShulkerBoxes;
            public final ForgeConfigSpec.BooleanValue voidProtection;
            public final ForgeConfigSpec.BooleanValue backpackDeathPlace;
            public final ForgeConfigSpec.BooleanValue backpackForceDeathPlace;
            public final ForgeConfigSpec.BooleanValue enableSleepingBagSpawnPoint;
            public final ForgeConfigSpec.BooleanValue curiosIntegration;

            BackpackSettings(ForgeConfigSpec.Builder builder, String path) {
                builder.push(path);
                this.leather = new TierConfig(builder, "Leather", 27, 2, 3000);
                this.iron = new TierConfig(builder, "Iron", 36, 3, 4000);
                this.gold = new TierConfig(builder, "Gold", 45, 4, 5000);
                this.diamond = new TierConfig(builder, "Diamond", 54, 5, 6000);
                this.netherite = new TierConfig(builder, "Netherite", 63, 6, 7000);
                this.enableTierUpgrades = builder.define("enableTierUpgrades", true);
                this.enableCraftingUpgrade = builder.define("enableCraftingUpgrade", true);
                this.craftingUpgradeByDefault = builder.comment("Newly crafted backpacks will have crafting upgrade included by default").define("craftingUpgradeByDefault", false);
                this.craftingSavesItems = builder.comment("Whether crafting grid should save items").define("craftingSavesItems", true);
                this.enableBackpackBlockWearable = builder.comment("Enables equipping the backpack on right-click from the ground").define("enableBackpackBlockWearable", true);
                this.enableBackpackRightClickUnequip = builder.comment("Enables unequipping the backpack on right-click on the ground with empty hand").define("enableBackpackRightClickUnequip", false);
                this.allowOnlyEquippedBackpack = builder.comment("Allows to use only equipped backpack").define("allowOnlyEquippedBackpack", false);
                this.invulnerableBackpack = builder.comment("Backpack immune to any damage source (lava, fire), can't be destroyed, never disappears as floating item").define("invulnerableBackpack", true);
                this.toolSlotsAcceptSwords = builder.define("toolSlotsAcceptSwords", true);
                this.toolSlotsAcceptableItems = builder.comment("List of items that can be put in tool slots (Use registry names, for example: \"minecraft:apple\", \"minecraft:flint\")").defineList("toolSlotsAcceptableItems", Collections.emptyList(), mapping -> ((String)mapping).matches(Common.REGISTRY_NAME_MATCHER));
                this.toolSlotsAcceptEverything = builder.comment("Tool slots accept any item").define("toolSlotsAcceptEverything", false);
                this.blacklistedItems = builder.comment("List of items that can't be put in backpack inventory (Use registry names, for example: \"minecraft:apple\", \"minecraft:flint\")").defineList("blacklistedItems", Collections.emptyList(), mapping -> ((String)mapping).matches(Common.REGISTRY_NAME_MATCHER));
                this.allowShulkerBoxes = builder.comment("Allows putting shulker boxes and other items with inventory in backpack").define("allowShulkerBoxes", false);
                this.voidProtection = builder.comment("Prevents backpack disappearing in void, spawns floating backpack above minimum Y when player dies in void").define("voidProtection", true);
                this.backpackDeathPlace = builder.comment("Places backpack at place where player died").define("backpackDeathPlace", true);
                this.backpackForceDeathPlace = builder.comment("Places backpack at place where player died, replacing all blocks that are breakable and do not have inventory (backpackDeathPlace must be true in order to work)").define("backpackForceDeathPlace", false);
                this.enableSleepingBagSpawnPoint = builder.define("enableSleepingBagSpawnPoint", false);
                this.curiosIntegration = builder.comment(new String[]{"If true, backpack can only be worn by placing it in curios 'Back' slot", "WARNING - Remember to TAKE OFF BACKPACK BEFORE enabling or disabling this integration!! - if not you'll lose your backpack"}).define("curiosIntegration", false);
                builder.pop();
            }

            public static class TierConfig {
                public final ForgeConfigSpec.IntValue inventorySlotCount;
                public final ForgeConfigSpec.IntValue toolSlotCount;
                public final ForgeConfigSpec.IntValue tankCapacity;

                public TierConfig(ForgeConfigSpec.Builder builder, String tier, int inventorySlotCountDefault, int toolSlotCountDefault, int tankCapacityDefault) {
                    builder.comment(tier + " Tier Backpack Settings").push(tier.toLowerCase(Locale.ENGLISH) + "TierBackpack");
                    this.inventorySlotCount = builder.comment("Number of inventory slots for the tier").defineInRange("inventorySlotCount", inventorySlotCountDefault, 1, 63);
                    this.toolSlotCount = builder.comment("Number of tool slots for the tier").defineInRange("toolSlotCount", toolSlotCountDefault, 0, 6);
                    this.tankCapacity = builder.comment("Tank capacity for the tier, 1000 equals 1 Bucket").defineInRange("tankCapacity", tankCapacityDefault, 1, 128000);
                    builder.pop();
                }
            }

            public record Tier(int inventorySlotCount, int toolSlotCount, int tankCapacity) {
            }
        }

        public static class World {
            public final ForgeConfigSpec.BooleanValue enableLoot;
            public final ForgeConfigSpec.BooleanValue spawnEntitiesWithBackpack;
            public final ForgeConfigSpec.DoubleValue chance;
            public final ForgeConfigSpec.ConfigValue<List<? extends String>> possibleOverworldEntityTypes;
            public final ForgeConfigSpec.ConfigValue<List<? extends String>> possibleNetherEntityTypes;
            public final ForgeConfigSpec.ConfigValue<List<? extends String>> overworldBackpacks;
            public final ForgeConfigSpec.ConfigValue<List<? extends String>> netherBackpacks;
            public final ForgeConfigSpec.BooleanValue enableVillagerTrade;

            World(ForgeConfigSpec.Builder builder, String path) {
                builder.push(path);
                this.enableLoot = builder.comment("Enables backpacks spawning in loot chests").define("enableLoot", true);
                this.spawnEntitiesWithBackpack = builder.comment("Enables chance to spawn Zombie, Skeleton, Wither Skeleton, Piglin or Enderman with random backpack equipped").define("spawnEntitiesWithBackpack", true);
                this.chance = builder.comment("Defines spawn chance of entity with a backpack").defineInRange("chance", 0.005, 0.0, 1.0);
                this.possibleOverworldEntityTypes = builder.comment("List of overworld entity types that can spawn with equipped backpack. DO NOT ADD anything to this list, because the game will crash, remove entries if mob should not spawn with backpack").defineList("possibleOverworldEntityTypes", this::getPossibleOverworldEntityTypes, mapping -> ((String)mapping).matches(Common.REGISTRY_NAME_MATCHER));
                this.possibleNetherEntityTypes = builder.comment("List of nether entity types that can spawn with equipped backpack. DO NOT ADD anything to this list, because the game will crash, remove entries if mob should not spawn with backpack").defineList("possibleNetherEntityTypes", this::getPossibleNetherEntityTypes, mapping -> ((String)mapping).matches(Common.REGISTRY_NAME_MATCHER));
                this.overworldBackpacks = builder.comment("List of backpacks that can spawn on overworld mobs").defineList("overworldBackpacks", this::getOverworldBackpacksList, mapping -> ((String)mapping).matches(Common.REGISTRY_NAME_MATCHER));
                this.netherBackpacks = builder.comment("List of backpacks that can spawn on nether mobs").defineList("netherBackpacks", this::getNetherBackpacksList, mapping -> ((String)mapping).matches(Common.REGISTRY_NAME_MATCHER));
                this.enableVillagerTrade = builder.comment("Enables trade for Villager Backpack in Librarian villager trades").define("enableVillagerTrade", true);
                builder.pop();
            }

            private List<String> getPossibleOverworldEntityTypes() {
                ArrayList<String> ret = new ArrayList<String>();
                ret.add("minecraft:zombie");
                ret.add("minecraft:skeleton");
                ret.add("minecraft:enderman");
                return ret;
            }

            private List<String> getPossibleNetherEntityTypes() {
                ArrayList<String> ret = new ArrayList<String>();
                ret.add("minecraft:wither_skeleton");
                ret.add("minecraft:piglin");
                return ret;
            }

            private List<String> getOverworldBackpacksList() {
                ArrayList<String> ret = new ArrayList<String>();
                ret.add("travelersbackpack:standard");
                ret.add("travelersbackpack:diamond");
                ret.add("travelersbackpack:gold");
                ret.add("travelersbackpack:emerald");
                ret.add("travelersbackpack:iron");
                ret.add("travelersbackpack:lapis");
                ret.add("travelersbackpack:redstone");
                ret.add("travelersbackpack:coal");
                ret.add("travelersbackpack:bookshelf");
                ret.add("travelersbackpack:sandstone");
                ret.add("travelersbackpack:snow");
                ret.add("travelersbackpack:sponge");
                ret.add("travelersbackpack:cake");
                ret.add("travelersbackpack:cactus");
                ret.add("travelersbackpack:hay");
                ret.add("travelersbackpack:melon");
                ret.add("travelersbackpack:pumpkin");
                ret.add("travelersbackpack:creeper");
                ret.add("travelersbackpack:enderman");
                ret.add("travelersbackpack:skeleton");
                ret.add("travelersbackpack:spider");
                ret.add("travelersbackpack:bee");
                ret.add("travelersbackpack:wolf");
                ret.add("travelersbackpack:fox");
                ret.add("travelersbackpack:ocelot");
                ret.add("travelersbackpack:horse");
                ret.add("travelersbackpack:cow");
                ret.add("travelersbackpack:pig");
                ret.add("travelersbackpack:sheep");
                ret.add("travelersbackpack:chicken");
                ret.add("travelersbackpack:squid");
                return ret;
            }

            private List<String> getNetherBackpacksList() {
                ArrayList<String> ret = new ArrayList<String>();
                ret.add("travelersbackpack:quartz");
                ret.add("travelersbackpack:nether");
                ret.add("travelersbackpack:blaze");
                ret.add("travelersbackpack:ghast");
                ret.add("travelersbackpack:magma_cube");
                ret.add("travelersbackpack:wither");
                return ret;
            }
        }

        public static class BackpackAbilities {
            public final ForgeConfigSpec.BooleanValue enableBackpackAbilities;
            public final ForgeConfigSpec.BooleanValue forceAbilityEnabled;
            public final ForgeConfigSpec.ConfigValue<List<? extends String>> allowedAbilities;

            BackpackAbilities(ForgeConfigSpec.Builder builder, String path) {
                builder.push(path);
                this.enableBackpackAbilities = builder.define("enableBackpackAbilities", true);
                this.forceAbilityEnabled = builder.comment("Newly crafted backpacks will have ability enabled by default").define("forceAbilityEnabled", true);
                this.allowedAbilities = builder.comment("List of backpacks that are allowed to have an ability. DO NOT ADD anything to this list, because the game will crash, remove entries if backpack should not have ability").defineList("allowedAbilities", this::getAllowedAbilities, mapping -> ((String)mapping).matches(Common.REGISTRY_NAME_MATCHER));
                builder.pop();
            }

            private List<String> getAllowedAbilities() {
                ArrayList<String> ret = new ArrayList<String>();
                ret.add("travelersbackpack:netherite");
                ret.add("travelersbackpack:diamond");
                ret.add("travelersbackpack:gold");
                ret.add("travelersbackpack:emerald");
                ret.add("travelersbackpack:iron");
                ret.add("travelersbackpack:lapis");
                ret.add("travelersbackpack:redstone");
                ret.add("travelersbackpack:bookshelf");
                ret.add("travelersbackpack:sponge");
                ret.add("travelersbackpack:cake");
                ret.add("travelersbackpack:cactus");
                ret.add("travelersbackpack:melon");
                ret.add("travelersbackpack:pumpkin");
                ret.add("travelersbackpack:creeper");
                ret.add("travelersbackpack:dragon");
                ret.add("travelersbackpack:enderman");
                ret.add("travelersbackpack:blaze");
                ret.add("travelersbackpack:ghast");
                ret.add("travelersbackpack:magma_cube");
                ret.add("travelersbackpack:spider");
                ret.add("travelersbackpack:wither");
                ret.add("travelersbackpack:bat");
                ret.add("travelersbackpack:bee");
                ret.add("travelersbackpack:ocelot");
                ret.add("travelersbackpack:cow");
                ret.add("travelersbackpack:chicken");
                ret.add("travelersbackpack:squid");
                return ret;
            }
        }

        public static class SlownessDebuff {
            public final ForgeConfigSpec.BooleanValue tooManyBackpacksSlowness;
            public final ForgeConfigSpec.IntValue maxNumberOfBackpacks;
            public final ForgeConfigSpec.DoubleValue slownessPerExcessedBackpack;

            SlownessDebuff(ForgeConfigSpec.Builder builder, String path) {
                builder.push(path);
                this.tooManyBackpacksSlowness = builder.comment("Player gets slowness effect, if carries too many backpacks in inventory").define("tooManyBackpacksSlowness", false);
                this.maxNumberOfBackpacks = builder.comment("Maximum number of backpacks, which can be carried in inventory, without slowness effect").defineInRange("maxNumberOfBackpacks", 3, 1, 37);
                this.slownessPerExcessedBackpack = builder.defineInRange("slownessPerExcessedBackpack", 1.0, 0.1, 5.0);
                builder.pop();
            }
        }
    }

    public static class Client {
        public final ForgeConfigSpec.BooleanValue showBackpackIconInInventory;
        public final ForgeConfigSpec.BooleanValue sendBackpackCoordinatesMessage;
        public final ForgeConfigSpec.BooleanValue enableLegacyGui;
        public final ForgeConfigSpec.BooleanValue enableToolCycling;
        public final ForgeConfigSpec.BooleanValue disableScrollWheel;
        public final ForgeConfigSpec.BooleanValue obtainTips;
        public final ForgeConfigSpec.BooleanValue renderTools;
        public final Overlay overlay;

        Client(ForgeConfigSpec.Builder builder) {
            builder.comment("Client-only settings").push("client");
            this.showBackpackIconInInventory = builder.comment("Whether the backpack icon should be visible in player's inventory").define("showBackpackIconInInventory", true);
            this.sendBackpackCoordinatesMessage = builder.comment("Sends a message to the player on death with backpack coordinates").define("sendBackpackCoordinatesMessage", true);
            this.enableLegacyGui = builder.comment("Enables legacy GUI (Blue slots for storage, brown for crafting and green for tools)").define("enableLegacyGui", false);
            this.enableToolCycling = builder.comment("Enables tool cycling via keybind (Default Z) + scroll combination, while backpack is worn").define("enableToolCycling", true);
            this.disableScrollWheel = builder.comment("Allows tool cycling using keybinding only (Default Z)").define("disableScrollWheel", false);
            this.obtainTips = builder.comment("Enables tip, how to obtain a backpack, if there's no crafting recipe for it").define("obtainTips", true);
            this.renderTools = builder.comment("Render tools in tool slots on the backpack, while worn").define("renderTools", true);
            this.overlay = new Overlay(builder, "The position of the Overlay on the screen", "overlay", true, 20, 30);
            builder.pop();
        }

        public static class Overlay {
            public final ForgeConfigSpec.BooleanValue enableOverlay;
            public final ForgeConfigSpec.IntValue offsetX;
            public final ForgeConfigSpec.IntValue offsetY;

            Overlay(ForgeConfigSpec.Builder builder, String comment, String path, boolean defaultOverlay, int defaultX, int defaultY) {
                builder.comment(comment).push(path);
                this.enableOverlay = builder.comment("Enables tanks and tool slots overlay, while backpack is worn").define("enableOverlay", defaultOverlay);
                this.offsetX = builder.comment("Offsets to left side").defineInRange("offsetX", defaultX, Integer.MIN_VALUE, Integer.MAX_VALUE);
                this.offsetY = builder.comment("Offsets to up").defineInRange("offsetY", defaultY, Integer.MIN_VALUE, Integer.MAX_VALUE);
                builder.pop();
            }
        }
    }
}

