/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.common.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.init.ModItems;
import com.tiviacz.travelersbackpack.init.ModRecipeSerializers;
import com.tiviacz.travelersbackpack.inventory.Tiers;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.SmithingTransformRecipe;
import net.minecraft.world.level.Level;

public class BackpackUpgradeRecipe
extends SmithingTransformRecipe {
    final Ingredient template;
    final Ingredient base;
    final Ingredient addition;
    final ItemStack result;

    public BackpackUpgradeRecipe(ResourceLocation id, Ingredient template, Ingredient base, Ingredient addition, ItemStack result) {
        super(id, template, base, addition, result);
        this.template = template;
        this.base = base;
        this.addition = addition;
        this.result = result;
    }

    public ItemStack m_5874_(Container pContainer, RegistryAccess pRegistryAccess) {
        ItemStack itemstack = this.result.m_41777_();
        CompoundTag compoundtag = pContainer.m_8020_(1).m_41783_();
        if (compoundtag != null) {
            compoundtag = compoundtag.m_6426_();
            if (pContainer.m_8020_(2).m_150930_((Item)ModItems.CRAFTING_UPGRADE.get())) {
                if (compoundtag.m_128441_("CraftingSettings")) {
                    if (compoundtag.m_128463_("CraftingSettings")[0] == 0) {
                        byte[] newArray = new byte[]{1, 0, 1};
                        compoundtag.m_128382_("CraftingSettings", newArray);
                        itemstack.m_41751_(compoundtag);
                        return itemstack;
                    }
                } else {
                    byte[] newArray = new byte[]{1, 0, 1};
                    compoundtag.m_128382_("CraftingSettings", newArray);
                    itemstack.m_41751_(compoundtag);
                    return itemstack;
                }
            }
            if (compoundtag.m_128441_("Tier")) {
                Tiers.Tier tier = Tiers.of(compoundtag.m_128451_("Tier"));
                if (pContainer.m_8020_(2).m_150930_(Tiers.of(compoundtag.m_128451_("Tier")).getTierUpgradeIngredient())) {
                    this.upgradeInventory(compoundtag, tier);
                    itemstack.m_41751_(compoundtag.m_6426_());
                    return itemstack;
                }
            } else if (pContainer.m_8020_(2).m_150930_(Tiers.LEATHER.getTierUpgradeIngredient())) {
                this.upgradeInventory(compoundtag, Tiers.LEATHER);
                itemstack.m_41751_(compoundtag.m_6426_());
                return itemstack;
            }
        }
        return ItemStack.f_41583_;
    }

    public void upgradeInventory(CompoundTag compound, Tiers.Tier tier) {
        compound.m_128405_("Tier", tier.getNextTier().getOrdinal());
        if (compound.m_128441_("ToolsInventory") && compound.m_128469_("ToolsInventory").m_128425_("Size", 3)) {
            compound.m_128469_("ToolsInventory").m_128405_("Size", tier.getNextTier().getToolSlots());
        }
        if (compound.m_128441_("Inventory") && compound.m_128469_("Inventory").m_128425_("Size", 3)) {
            compound.m_128469_("Inventory").m_128405_("Size", tier.getNextTier().getStorageSlots());
        }
        if (compound.m_128441_("LeftTank") && compound.m_128469_("LeftTank").m_128425_("Capacity", 3)) {
            compound.m_128469_("LeftTank").m_128405_("Capacity", tier.getNextTier().getTankCapacity());
        }
        if (compound.m_128441_("RightTank") && compound.m_128469_("RightTank").m_128425_("Capacity", 3)) {
            compound.m_128469_("RightTank").m_128405_("Capacity", tier.getNextTier().getTankCapacity());
        }
    }

    public boolean m_5818_(Container container, Level level) {
        ItemStack addition = container.m_8020_(2);
        boolean flag = true;
        if (!TravelersBackpackConfig.enableCraftingUpgrade) {
            boolean bl = flag = !addition.m_150930_((Item)ModItems.CRAFTING_UPGRADE.get());
        }
        if (!TravelersBackpackConfig.enableTierUpgrades) {
            flag = !addition.m_150930_((Item)ModItems.IRON_TIER_UPGRADE.get()) && !addition.m_150930_((Item)ModItems.GOLD_TIER_UPGRADE.get()) && !addition.m_150930_((Item)ModItems.DIAMOND_TIER_UPGRADE.get()) && !addition.m_150930_((Item)ModItems.NETHERITE_TIER_UPGRADE.get());
        }
        return this.matchesTier(container, level) && flag && super.m_5818_(container, level);
    }

    public boolean matchesTier(Container container, Level level) {
        ItemStack base = container.m_8020_(1);
        ItemStack addition = container.m_8020_(2);
        if (addition.m_41720_() == ModItems.CRAFTING_UPGRADE.get()) {
            return true;
        }
        if (!base.m_41782_() || !base.m_41783_().m_128441_("Tier")) {
            return addition.m_150930_((Item)ModItems.IRON_TIER_UPGRADE.get());
        }
        if (base.m_41783_().m_128441_("Tier")) {
            int tier = base.m_41783_().m_128451_("Tier");
            return switch (tier) {
                case 0 -> {
                    if (addition.m_41720_() == ModItems.IRON_TIER_UPGRADE.get()) {
                        yield true;
                    }
                    yield false;
                }
                case 1 -> {
                    if (addition.m_41720_() == ModItems.GOLD_TIER_UPGRADE.get()) {
                        yield true;
                    }
                    yield false;
                }
                case 2 -> {
                    if (addition.m_41720_() == ModItems.DIAMOND_TIER_UPGRADE.get()) {
                        yield true;
                    }
                    yield false;
                }
                case 3 -> {
                    if (addition.m_41720_() == ModItems.NETHERITE_TIER_UPGRADE.get()) {
                        yield true;
                    }
                    yield false;
                }
                default -> false;
            };
        }
        return false;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipeSerializers.BACKPACK_UPGRADE.get();
    }

    public static class Serializer
    implements RecipeSerializer<BackpackUpgradeRecipe> {
        public BackpackUpgradeRecipe fromJson(ResourceLocation p_266953_, JsonObject p_266720_) {
            Ingredient ingredient = Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)p_266720_, (String)"template"));
            Ingredient ingredient1 = Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)p_266720_, (String)"base"));
            Ingredient ingredient2 = Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)p_266720_, (String)"addition"));
            ItemStack itemstack = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)p_266720_, (String)"result"));
            return new BackpackUpgradeRecipe(p_266953_, ingredient, ingredient1, ingredient2, itemstack);
        }

        public BackpackUpgradeRecipe fromNetwork(ResourceLocation p_267117_, FriendlyByteBuf p_267316_) {
            Ingredient ingredient = Ingredient.m_43940_((FriendlyByteBuf)p_267316_);
            Ingredient ingredient1 = Ingredient.m_43940_((FriendlyByteBuf)p_267316_);
            Ingredient ingredient2 = Ingredient.m_43940_((FriendlyByteBuf)p_267316_);
            ItemStack itemstack = p_267316_.m_130267_();
            return new BackpackUpgradeRecipe(p_267117_, ingredient, ingredient1, ingredient2, itemstack);
        }

        public void toNetwork(FriendlyByteBuf p_266746_, BackpackUpgradeRecipe p_266927_) {
            p_266927_.template.m_43923_(p_266746_);
            p_266927_.base.m_43923_(p_266746_);
            p_266927_.addition.m_43923_(p_266746_);
            p_266746_.m_130055_(p_266927_.result);
        }
    }
}

