/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.client.screens.tooltip;

import com.tiviacz.travelersbackpack.client.screens.tooltip.BackpackTooltipComponent;
import com.tiviacz.travelersbackpack.util.BackpackUtils;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
public class ClientBackpackTooltipComponent
implements ClientTooltipComponent {
    private final BackpackTooltipComponent component;

    public ClientBackpackTooltipComponent(BackpackTooltipComponent component) {
        this.component = component;
    }

    public int m_142103_() {
        int height = 0;
        if (BackpackUtils.isCtrlPressed()) {
            if (!this.component.leftFluidStack.isEmpty()) {
                height += 10;
            }
            if (!this.component.rightFluidStack.isEmpty()) {
                height += 10;
            }
            if (!this.component.storage.isEmpty()) {
                height += (int)(Math.ceil((float)this.component.storage.size() / 9.0f) * 18.0);
            }
            if (!this.component.tools.isEmpty()) {
                height += 18;
            }
        }
        return height;
    }

    public int m_142069_(Font font) {
        int width = 0;
        if (BackpackUtils.isCtrlPressed() && !this.component.storage.isEmpty()) {
            width += Math.min(this.component.storage.size(), 9) * 18 + Math.min(this.component.storage.size(), 9) * 2;
        }
        return width;
    }

    public void m_142440_(Font pFont, int pMouseX, int pMouseY, Matrix4f pMatrix, MultiBufferSource.BufferSource pBufferSource) {
        if (BackpackUtils.isCtrlPressed()) {
            int yOffset = 0;
            if (!this.component.leftFluidStack.isEmpty()) {
                this.renderFluidTankTooltip(this.component.leftFluidStack, pFont, pMouseX, pMouseY, pMatrix, (MultiBufferSource)pBufferSource);
                yOffset += 10;
            }
            if (!this.component.rightFluidStack.isEmpty()) {
                this.renderFluidTankTooltip(this.component.rightFluidStack, pFont, pMouseX, pMouseY + yOffset, pMatrix, (MultiBufferSource)pBufferSource);
            }
        }
    }

    public void renderFluidTankTooltip(FluidStack fluidStack, Font font, int mouseX, int mouseY, Matrix4f matrix, MultiBufferSource bufferSource) {
        MutableComponent c = Component.m_237115_((String)fluidStack.getTranslationKey());
        MutableComponent c1 = Component.m_237113_((String)": ");
        MutableComponent c2 = Component.m_237113_((String)(fluidStack.getAmount() + "mB"));
        font.m_272077_((Component)c, (float)mouseX, (float)mouseY, -1, true, matrix, bufferSource, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        font.m_272077_((Component)c1, (float)mouseX + (float)font.m_92852_((FormattedText)c), (float)mouseY, -1, true, matrix, bufferSource, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        font.m_272077_((Component)c2, (float)mouseX + (float)font.m_92852_((FormattedText)c) + (float)font.m_92852_((FormattedText)c1), (float)mouseY, 0x5555FF, true, matrix, bufferSource, Font.DisplayMode.NORMAL, 0, 0xF000F0);
    }

    public void m_183452_(Font pFont, int pX, int pY, GuiGraphics pGuiGraphics) {
        int yOffset = 0;
        if (BackpackUtils.isCtrlPressed()) {
            if (!this.component.leftFluidStack.isEmpty()) {
                yOffset += 10;
            }
            if (!this.component.rightFluidStack.isEmpty()) {
                yOffset += 10;
            }
            boolean flag = false;
            if (!this.component.storage.isEmpty()) {
                int j = 0;
                flag = true;
                for (int i = 0; i < this.component.storage.size(); ++i) {
                    this.renderItem(this.component.storage.get(i), pX + j * 2 + j * 18, pY + yOffset, pFont, pGuiGraphics);
                    if (j < 8) {
                        ++j;
                        continue;
                    }
                    j = 0;
                    yOffset += 18;
                }
            }
            if (!this.component.tools.isEmpty()) {
                if (flag) {
                    yOffset += 18;
                }
                for (int i = 0; i < this.component.tools.size(); ++i) {
                    this.renderItem(this.component.tools.get(i), pX + i * 18, pY + yOffset, pFont, pGuiGraphics);
                }
            }
        }
    }

    private void renderItem(ItemStack stack, int pX, int pY, Font pFont, GuiGraphics guiGraphics) {
        guiGraphics.m_280203_(stack, pX, pY);
        guiGraphics.m_280370_(pFont, stack, pX, pY);
    }
}

