/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.client.model;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.tiviacz.travelersbackpack.client.screens.HudOverlay;
import com.tiviacz.travelersbackpack.util.ContainerUtils;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.items.ItemStackHandler;

public class StackModelPart
extends ModelPart {
    private final ItemStackHandler tools = new ItemStackHandler(2);
    private Player player;
    private MultiBufferSource buffer;

    public StackModelPart(ModelPart parent) {
        super(parent.f_104212_, parent.f_104213_);
    }

    public void prepare(ItemStack stack, Player player, MultiBufferSource vertices) {
        if (stack.m_41782_() && stack.m_41783_().m_128441_("ToolsInventory")) {
            this.tools.deserializeNBT(stack.m_41783_().m_128469_("ToolsInventory"));
        } else if (!ContainerUtils.isEmpty(this.tools)) {
            this.tools.setSize(2);
        }
        this.player = player;
        this.buffer = vertices;
    }

    public void m_104301_(PoseStack pPoseStack, VertexConsumer pVertexConsumer, int pPackedLight, int pPackedOverlay) {
        if (this.buffer == null || this.player == null) {
            return;
        }
        pPoseStack.m_85836_();
        this.m_104299_(pPoseStack);
        this.render(pPoseStack, this.player, this.buffer, pPackedLight, pPackedLight);
        pPoseStack.m_85849_();
    }

    public void render(PoseStack poseStack, Player player, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        BakedModel model;
        List<ItemStack> tools = HudOverlay.getTools(this.tools);
        if (tools.isEmpty()) {
            return;
        }
        ItemStack toolUpper = this.tools.getStackInSlot(0);
        ItemStack toolLower = ItemStack.f_41583_;
        if (!toolUpper.m_41619_() && tools.size() > 1) {
            toolLower = this.tools.getStackInSlot(tools.size() - 1);
        }
        if (!toolUpper.m_41619_()) {
            model = Minecraft.m_91087_().m_91291_().m_174264_(toolUpper, player.m_9236_(), (LivingEntity)player, 0);
            model = ForgeHooksClient.handleCameraTransforms((PoseStack)poseStack, (BakedModel)model, (ItemDisplayContext)ItemDisplayContext.NONE, (boolean)false);
            poseStack.m_85836_();
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)0);
            poseStack.m_85837_(0.05, 0.075, 0.27);
            poseStack.m_252781_(Axis.f_252403_.m_252977_(45.0f));
            poseStack.m_252781_(Axis.f_252529_.m_252977_(180.0f));
            poseStack.m_85841_(0.65f, 0.65f, 0.65f);
            RenderSystem.setShader(GameRenderer::m_172817_);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)InventoryMenu.f_39692_);
            Minecraft.m_91087_().m_91291_().m_115143_(toolUpper, ItemDisplayContext.NONE, false, poseStack, buffer, combinedLight, combinedOverlay, model);
            RenderSystem.disableBlend();
            poseStack.m_85849_();
        }
        if (!toolLower.m_41619_()) {
            model = Minecraft.m_91087_().m_91291_().m_174264_(toolLower, player.m_9236_(), (LivingEntity)player, 0);
            model = ForgeHooksClient.handleCameraTransforms((PoseStack)poseStack, (BakedModel)model, (ItemDisplayContext)ItemDisplayContext.NONE, (boolean)false);
            poseStack.m_85836_();
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)0);
            poseStack.m_85837_(-0.35, 0.95, 0.0);
            poseStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
            poseStack.m_252781_(Axis.f_252403_.m_252977_(45.0f));
            poseStack.m_85841_(0.65f, 0.65f, 0.65f);
            RenderSystem.setShader(GameRenderer::m_172817_);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)InventoryMenu.f_39692_);
            Minecraft.m_91087_().m_91291_().m_115143_(toolLower, ItemDisplayContext.NONE, false, poseStack, buffer, combinedLight, combinedOverlay, model);
            RenderSystem.disableBlend();
            poseStack.m_85849_();
        }
    }
}

