/*
 * Decompiled with CFR 0.152.
 */
package com.smashingmods.chemlib.common.items;

import com.smashingmods.chemlib.ChemLib;
import com.smashingmods.chemlib.api.Compound;
import com.smashingmods.chemlib.api.MatterState;
import com.smashingmods.chemlib.registry.ItemRegistry;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.LiteralContents;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.StringUtils;

public class CompoundItem
extends Item
implements Compound {
    private final String compoundName;
    private String abbreviation = "";
    private final MatterState matterState;
    private final Map<String, Integer> components;
    private final String description;
    private final int color;
    private final List<MobEffectInstance> effects;

    public CompoundItem(String pCompoundName, MatterState pMatterState, Map<String, Integer> pComponents, String pDescription, String pColor, List<MobEffectInstance> pEffects) {
        super(new Item.Properties());
        this.compoundName = pCompoundName;
        this.matterState = pMatterState;
        this.components = pComponents;
        this.description = pDescription;
        this.color = Integer.parseInt(pColor, 16) | 0xFF000000;
        this.effects = pEffects;
    }

    public CompoundItem(String pCompoundName, MatterState pMatterState, Map<String, Integer> pComponents, String pDescription, String pColor, List<MobEffectInstance> pEffects, CreativeModeTab pTab) {
        super(new Item.Properties());
        this.compoundName = pCompoundName;
        this.matterState = pMatterState;
        this.components = pComponents;
        this.description = pDescription;
        this.color = (int)Long.parseLong(pColor, 16);
        this.effects = pEffects;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        pTooltipComponents.add((Component)MutableComponent.m_237204_((ComponentContents)new LiteralContents(this.getAbbreviation())).m_130940_(ChatFormatting.DARK_AQUA));
        pTooltipComponents.add((Component)MutableComponent.m_237204_((ComponentContents)new LiteralContents(StringUtils.capitalize((String)this.getNamespace()))).m_130948_(ChemLib.MOD_ID_TEXT_STYLE));
    }

    public String getNamespace() {
        return ((ResourceKey)ForgeRegistries.ITEMS.getResourceKey((Object)this).get()).m_135782_().m_135827_();
    }

    @Override
    public String getChemicalName() {
        return this.compoundName;
    }

    @Override
    public String getAbbreviation() {
        if (this.abbreviation.isEmpty()) {
            this.abbreviation = this.buildAbbreviation();
        }
        return this.abbreviation;
    }

    @Override
    public MatterState getMatterState() {
        return this.matterState;
    }

    @Override
    public String getChemicalDescription() {
        return this.description;
    }

    @Override
    public int getColor() {
        return this.color;
    }

    @Override
    public List<MobEffectInstance> getEffects() {
        return this.effects;
    }

    @Override
    public Map<String, Integer> getComponents() {
        return this.components;
    }

    public int getColor(ItemStack pItemStack, int pTintIndex) {
        return pTintIndex > 0 ? -1 : this.color;
    }

    public static String getSubscript(String pString) {
        int subscriptZeroCodepoint = 8320;
        StringBuilder builder = new StringBuilder();
        for (char character : pString.toCharArray()) {
            builder.append(Character.toChars(8320 + Character.getNumericValue(character)));
        }
        return builder.toString();
    }

    public String buildAbbreviation() {
        StringBuilder builder = new StringBuilder();
        for (String name : this.components.keySet()) {
            ItemRegistry.getElementByName(name).ifPresent(elementItem -> builder.append(elementItem.getAbbreviation()));
            ItemRegistry.getCompoundByName(name).ifPresent(compoundItem -> builder.append(String.format("(%s)", compoundItem.getAbbreviation())));
            Integer count = this.components.get(name);
            if (count <= 1) continue;
            builder.append(CompoundItem.getSubscript(Integer.toString(count)));
        }
        return builder.toString();
    }
}

