/*
 * Decompiled with CFR 0.152.
 */
package com.smashingmods.chemlib.common.items;

import com.smashingmods.chemlib.ChemLib;
import com.smashingmods.chemlib.api.Chemical;
import com.smashingmods.chemlib.api.ChemicalItemType;
import com.smashingmods.chemlib.api.Element;
import com.smashingmods.chemlib.api.MatterState;
import com.smashingmods.chemlib.client.AbbreviationRenderer;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.LiteralContents;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.StringUtils;

public class ChemicalItem
extends Item
implements Chemical {
    private final Chemical chemical;
    private final ChemicalItemType itemType;

    public ChemicalItem(Chemical pChemical, ChemicalItemType pChemicalItemType, Item.Properties pProperties) {
        super(pProperties);
        this.chemical = pChemical;
        this.itemType = pChemicalItemType;
    }

    public ChemicalItem(ResourceLocation pResourceLocation, ChemicalItemType pChemicalItemType, Item.Properties pProperties) {
        this((Chemical)Objects.requireNonNull((Item)ForgeRegistries.ITEMS.getValue(pResourceLocation)), pChemicalItemType, pProperties);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        Chemical chemical = this.getChemical();
        if (chemical instanceof Element) {
            Element element = (Element)chemical;
            pTooltipComponents.add((Component)MutableComponent.m_237204_((ComponentContents)new LiteralContents(String.format("%s (%d)", this.getAbbreviation(), element.getAtomicNumber()))).m_130940_(ChatFormatting.DARK_AQUA));
            pTooltipComponents.add((Component)MutableComponent.m_237204_((ComponentContents)new LiteralContents(element.getGroupName())).m_130940_(ChatFormatting.GRAY));
        } else {
            pTooltipComponents.add((Component)MutableComponent.m_237204_((ComponentContents)new LiteralContents(this.getAbbreviation())).m_130940_(ChatFormatting.DARK_AQUA));
            pTooltipComponents.add((Component)MutableComponent.m_237204_((ComponentContents)new LiteralContents(StringUtils.capitalize((String)this.getNamespace()))).m_130948_(ChemLib.MOD_ID_TEXT_STYLE));
        }
    }

    public String getNamespace() {
        return ((ResourceKey)ForgeRegistries.ITEMS.getResourceKey((Object)this).get()).m_135782_().m_135827_();
    }

    public Chemical getChemical() {
        return this.chemical;
    }

    public ChemicalItemType getItemType() {
        return this.itemType;
    }

    @Override
    public String getChemicalName() {
        return this.chemical.getChemicalName();
    }

    @Override
    public String getAbbreviation() {
        return this.chemical.getAbbreviation();
    }

    @Override
    public MatterState getMatterState() {
        return this.chemical.getMatterState();
    }

    @Override
    public String getChemicalDescription() {
        return "";
    }

    @Override
    public List<MobEffectInstance> getEffects() {
        return this.getChemical().getEffects();
    }

    @Override
    public int getColor() {
        return this.clampMinColorValue(this.chemical.getColor(), 68);
    }

    public int getColor(ItemStack pItemStack, int pTintIndex) {
        return pTintIndex == 0 ? this.getColor() : -1;
    }

    public void initializeClient(@Nonnull Consumer<IClientItemExtensions> consumer) {
        super.initializeClient(consumer);
        consumer.accept(AbbreviationRenderer.RENDERER);
    }
}

