/*
 * Decompiled with CFR 0.152.
 */
package com.smashingmods.chemlib;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import java.nio.file.Path;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class Config {
    public static final Common COMMON;
    public static final ForgeConfigSpec COMMON_SPEC;

    public static void loadConfig(ForgeConfigSpec spec, Path path) {
        CommentedFileConfig configData = (CommentedFileConfig)CommentedFileConfig.builder((Path)path).sync().autosave().writingMode(WritingMode.REPLACE).build();
        configData.load();
        spec.setConfig((CommentedConfig)configData);
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Common::new);
        COMMON = (Common)specPair.getLeft();
        COMMON_SPEC = (ForgeConfigSpec)specPair.getRight();
    }

    public static class Common {
        private static final String categoryRendering = "Rendering Options";
        public static ForgeConfigSpec.BooleanValue renderElementAbbreviations;
        public static ForgeConfigSpec.BooleanValue renderDustAbbreviations;
        public static ForgeConfigSpec.BooleanValue renderNuggetAbbreviations;
        public static ForgeConfigSpec.BooleanValue renderIngotAbbreviations;
        public static ForgeConfigSpec.BooleanValue renderPlateAbbreviations;

        public Common(ForgeConfigSpec.Builder builder) {
            builder.comment("\n    These options are for rendering element abbreviations on different items in your inventory\n    Disable rendering abbreviations on a per item type basis.\n").push(categoryRendering);
            renderElementAbbreviations = builder.define("element abbreviations", true);
            renderDustAbbreviations = builder.define("dust abbreviations", false);
            renderNuggetAbbreviations = builder.define("nugget abbreviations", false);
            renderIngotAbbreviations = builder.define("ingot abbreviations", false);
            renderPlateAbbreviations = builder.define("plate abbreviations", false);
            builder.pop();
        }
    }
}

