/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedcrafting.core;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.Level;
import org.cyclops.commoncapabilities.api.capability.recipehandler.IPrototypedIngredientAlternatives;
import org.cyclops.commoncapabilities.api.capability.recipehandler.IRecipeDefinition;
import org.cyclops.commoncapabilities.api.ingredient.IIngredientMatcher;
import org.cyclops.commoncapabilities.api.ingredient.IMixedIngredients;
import org.cyclops.commoncapabilities.api.ingredient.IPrototypedIngredient;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.MixedIngredients;
import org.cyclops.commoncapabilities.api.ingredient.PrototypedIngredient;
import org.cyclops.commoncapabilities.api.ingredient.storage.IIngredientComponentStorage;
import org.cyclops.commoncapabilities.api.ingredient.storage.IngredientComponentStorageEmpty;
import org.cyclops.cyclopscore.datastructure.DimPos;
import org.cyclops.cyclopscore.helper.BlockEntityHelpers;
import org.cyclops.cyclopscore.ingredient.collection.IIngredientCollectionMutable;
import org.cyclops.cyclopscore.ingredient.collection.IIngredientList;
import org.cyclops.cyclopscore.ingredient.collection.IngredientArrayList;
import org.cyclops.cyclopscore.ingredient.collection.IngredientCollectionPrototypeMap;
import org.cyclops.cyclopscore.ingredient.collection.IngredientCollectionQuantitativeGrouper;
import org.cyclops.cyclopscore.ingredient.collection.IngredientHashSet;
import org.cyclops.integratedcrafting.Capabilities;
import org.cyclops.integratedcrafting.IntegratedCrafting;
import org.cyclops.integratedcrafting.api.crafting.CraftingJob;
import org.cyclops.integratedcrafting.api.crafting.CraftingJobDependencyGraph;
import org.cyclops.integratedcrafting.api.crafting.FailedCraftingRecipeException;
import org.cyclops.integratedcrafting.api.crafting.RecursiveCraftingRecipeException;
import org.cyclops.integratedcrafting.api.crafting.UnavailableCraftingInterfacesException;
import org.cyclops.integratedcrafting.api.crafting.UnknownCraftingRecipeException;
import org.cyclops.integratedcrafting.api.network.ICraftingNetwork;
import org.cyclops.integratedcrafting.api.recipe.IRecipeIndex;
import org.cyclops.integratedcrafting.capability.network.CraftingNetworkConfig;
import org.cyclops.integratedcrafting.core.MissingIngredients;
import org.cyclops.integratedcrafting.core.PartialCraftingJobCalculation;
import org.cyclops.integratedcrafting.core.PartialCraftingJobCalculationDependency;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.api.PartStateException;
import org.cyclops.integrateddynamics.api.ingredient.capability.IPositionedAddonsNetworkIngredientsHandler;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.api.network.IPositionedAddonsNetworkIngredients;
import org.cyclops.integrateddynamics.api.part.PartPos;
import org.cyclops.integrateddynamics.core.helper.NetworkHelpers;
import org.cyclops.integrateddynamics.core.network.IngredientChannelAdapter;
import org.cyclops.integrateddynamics.core.network.IngredientChannelIndexed;

public class CraftingHelpers {
    public static INetwork getNetworkChecked(PartPos pos) throws PartStateException {
        INetwork network = (INetwork)NetworkHelpers.getNetwork((BlockGetter)pos.getPos().getLevel(true), (BlockPos)pos.getPos().getBlockPos(), (Direction)pos.getSide()).orElse(null);
        if (network == null) {
            IntegratedDynamics.clog((Level)Level.ERROR, (String)"Could not get the network for transfer as no network was found.");
            throw new PartStateException(pos.getPos(), pos.getSide());
        }
        return network;
    }

    public static LazyOptional<ICraftingNetwork> getCraftingNetwork(@Nullable INetwork network) {
        if (network != null) {
            return network.getCapability(CraftingNetworkConfig.CAPABILITY);
        }
        return null;
    }

    public static ICraftingNetwork getCraftingNetworkChecked(@Nullable INetwork network) {
        return (ICraftingNetwork)CraftingHelpers.getCraftingNetwork(network).orElseThrow(() -> new IllegalStateException("Could not find a crafting network"));
    }

    public static <T, M> LazyOptional<IPositionedAddonsNetworkIngredients<T, M>> getIngredientsNetwork(INetwork network, IngredientComponent<T, M> ingredientComponent) {
        IPositionedAddonsNetworkIngredientsHandler ingredientsHandler = (IPositionedAddonsNetworkIngredientsHandler)ingredientComponent.getCapability(Capabilities.POSITIONED_ADDONS_NETWORK_INGREDIENTS_HANDLER).orElse(null);
        if (ingredientsHandler != null) {
            return ingredientsHandler.getStorage(network);
        }
        return LazyOptional.empty();
    }

    public static <T, M> IPositionedAddonsNetworkIngredients<T, M> getIngredientsNetworkChecked(INetwork network, IngredientComponent<T, M> ingredientComponent) {
        return (IPositionedAddonsNetworkIngredients)CraftingHelpers.getIngredientsNetwork(network, ingredientComponent).orElseThrow(() -> new IllegalStateException("Could not find an ingredients network"));
    }

    public static <T, M> IIngredientComponentStorage<T, M> getNetworkStorage(INetwork network, int channel, IngredientComponent<T, M> ingredientComponent, boolean scheduleObservation) {
        IPositionedAddonsNetworkIngredients ingredientsNetwork = (IPositionedAddonsNetworkIngredients)CraftingHelpers.getIngredientsNetwork(network, ingredientComponent).orElse(null);
        if (ingredientsNetwork != null) {
            if (scheduleObservation) {
                ingredientsNetwork.scheduleObservation();
            }
            return ingredientsNetwork.getChannel(channel);
        }
        return new IngredientComponentStorageEmpty(ingredientComponent);
    }

    public static void beforeCalculateCraftingJobs(INetwork network, int channel) {
        for (IngredientComponent ingredientComponent : IngredientComponent.REGISTRY.getValues()) {
            IPositionedAddonsNetworkIngredients ingredientsNetwork = (IPositionedAddonsNetworkIngredients)CraftingHelpers.getIngredientsNetwork(network, ingredientComponent).orElse(null);
            if (ingredientsNetwork == null || !ingredientsNetwork.isObservationForcedPending(channel)) continue;
            ingredientsNetwork.runObserverSync();
        }
    }

    public static <T, M> CraftingJob calculateCraftingJobs(INetwork network, int channel, IngredientComponent<T, M> ingredientComponent, T instance, M matchCondition, boolean craftMissing, IIdentifierGenerator identifierGenerator, CraftingJobDependencyGraph craftingJobsGraph, boolean collectMissingRecipes) throws UnknownCraftingRecipeException, RecursiveCraftingRecipeException {
        ICraftingNetwork craftingNetwork = CraftingHelpers.getCraftingNetworkChecked(network);
        IRecipeIndex recipeIndex = craftingNetwork.getRecipeIndex(channel);
        Function<IngredientComponent<?, ?>, IIngredientComponentStorage> storageGetter = CraftingHelpers.getNetworkStorageGetter(network, channel, true);
        CraftingHelpers.beforeCalculateCraftingJobs(network, channel);
        CraftingJob craftingJob = CraftingHelpers.calculateCraftingJobs(recipeIndex, channel, storageGetter, ingredientComponent, instance, matchCondition, craftMissing, Maps.newIdentityHashMap(), Maps.newIdentityHashMap(), identifierGenerator, craftingJobsGraph, Sets.newHashSet(), collectMissingRecipes);
        craftingJobsGraph.addCraftingJobId(craftingJob);
        return craftingJob;
    }

    public static CraftingJob calculateCraftingJobs(INetwork network, int channel, IRecipeDefinition recipe, int amount, boolean craftMissing, IIdentifierGenerator identifierGenerator, CraftingJobDependencyGraph craftingJobsGraph, boolean collectMissingRecipes) throws FailedCraftingRecipeException, RecursiveCraftingRecipeException {
        ICraftingNetwork craftingNetwork = CraftingHelpers.getCraftingNetworkChecked(network);
        IRecipeIndex recipeIndex = craftingNetwork.getRecipeIndex(channel);
        Function<IngredientComponent<?, ?>, IIngredientComponentStorage> storageGetter = CraftingHelpers.getNetworkStorageGetter(network, channel, true);
        CraftingHelpers.beforeCalculateCraftingJobs(network, channel);
        PartialCraftingJobCalculation result = CraftingHelpers.calculateCraftingJobs(recipeIndex, channel, storageGetter, recipe, amount, craftMissing, Maps.newIdentityHashMap(), Maps.newIdentityHashMap(), identifierGenerator, craftingJobsGraph, Sets.newHashSet(), collectMissingRecipes);
        if (result.getCraftingJob() == null) {
            throw new FailedCraftingRecipeException(recipe, amount, result.getMissingDependencies(), CraftingHelpers.compressMixedIngredients((IMixedIngredients)new MixedIngredients(result.getIngredientsStorage())), result.getPartialCraftingJobs());
        }
        craftingJobsGraph.addCraftingJobId(result.getCraftingJob());
        return result.getCraftingJob();
    }

    public static IIdentifierGenerator getGlobalCraftingJobIdentifier() {
        return () -> IntegratedCrafting.globalCounters.getNext("craftingJob");
    }

    public static <T, M> long getOutputQuantityForRecipe(IRecipeDefinition recipe, IngredientComponent<T, M> ingredientComponent, T instance, M matchCondition) {
        IIngredientMatcher matcher = ingredientComponent.getMatcher();
        return recipe.getOutput().getInstances(ingredientComponent).stream().filter(i -> matcher.matches(i, instance, matchCondition)).mapToLong(arg_0 -> ((IIngredientMatcher)matcher).getQuantity(arg_0)).sum();
    }

    protected static <T, M> CraftingJob calculateCraftingJobs(IRecipeIndex recipeIndex, int channel, Function<IngredientComponent<?, ?>, IIngredientComponentStorage> storageGetter, IngredientComponent<T, M> ingredientComponent, T instance, M matchCondition, boolean craftMissing, Map<IngredientComponent<?, ?>, IngredientCollectionPrototypeMap<?, ?>> simulatedExtractionMemory, Map<IngredientComponent<?, ?>, IIngredientCollectionMutable<?, ?>> extractionMemoryReusable, IIdentifierGenerator identifierGenerator, CraftingJobDependencyGraph craftingJobsGraph, Set<IPrototypedIngredient> parentDependencies, boolean collectMissingRecipes) throws UnknownCraftingRecipeException, RecursiveCraftingRecipeException {
        IIngredientMatcher matcher = ingredientComponent.getMatcher();
        Object quantifierlessCondition = matcher.withoutCondition(matchCondition, ingredientComponent.getPrimaryQuantifier().getMatchCondition());
        long instanceQuantity = matcher.getQuantity(instance);
        Iterator<IRecipeDefinition> recipes = recipeIndex.getRecipes(ingredientComponent, instance, quantifierlessCondition);
        List<Object> firstMissingDependencies = Lists.newArrayList();
        Map<Object, Object> firstIngredientsStorage = Collections.emptyMap();
        List<Object> firstPartialCraftingJobs = Lists.newArrayList();
        while (recipes.hasNext()) {
            long recipeOutputQuantity;
            int amount;
            IRecipeDefinition recipe = recipes.next();
            PartialCraftingJobCalculation result = CraftingHelpers.calculateCraftingJobs(recipeIndex, channel, storageGetter, recipe, amount = (int)Math.ceil((float)instanceQuantity / (float)(recipeOutputQuantity = CraftingHelpers.getOutputQuantityForRecipe(recipe, ingredientComponent, instance, quantifierlessCondition))), craftMissing, simulatedExtractionMemory, extractionMemoryReusable, identifierGenerator, craftingJobsGraph, parentDependencies, collectMissingRecipes && firstMissingDependencies.isEmpty());
            if (result.getCraftingJob() == null) {
                firstMissingDependencies = result.getMissingDependencies();
                firstIngredientsStorage = result.getIngredientsStorage();
                if (result.getPartialCraftingJobs() == null) continue;
                firstPartialCraftingJobs = result.getPartialCraftingJobs();
                continue;
            }
            return result.getCraftingJob();
        }
        throw new UnknownCraftingRecipeException((IPrototypedIngredient<?, ?>)new PrototypedIngredient(ingredientComponent, instance, matchCondition), matcher.getQuantity(instance), firstMissingDependencies, CraftingHelpers.compressMixedIngredients((IMixedIngredients)new MixedIngredients(firstIngredientsStorage)), firstPartialCraftingJobs);
    }

    protected static PartialCraftingJobCalculation calculateCraftingJobs(IRecipeIndex recipeIndex, int channel, Function<IngredientComponent<?, ?>, IIngredientComponentStorage> storageGetter, IRecipeDefinition recipe, int amount, boolean craftMissing, Map<IngredientComponent<?, ?>, IngredientCollectionPrototypeMap<?, ?>> simulatedExtractionMemory, Map<IngredientComponent<?, ?>, IIngredientCollectionMutable<?, ?>> extractionMemoryReusable, IIdentifierGenerator identifierGenerator, CraftingJobDependencyGraph craftingJobsGraph, Set<IPrototypedIngredient> parentDependencies, boolean collectMissingRecipes) throws RecursiveCraftingRecipeException {
        ArrayList missingDependencies = Lists.newArrayList();
        ArrayList partialCraftingJobs = Lists.newArrayList();
        Pair<Map<IngredientComponent<?, ?>, List<?>>, Map<IngredientComponent<?, ?>, MissingIngredients<?, ?>>> simulation = CraftingHelpers.getRecipeInputs(storageGetter, recipe, true, simulatedExtractionMemory, extractionMemoryReusable, true, amount);
        Map missingIngredients = (Map)simulation.getRight();
        if (!craftMissing && !missingIngredients.isEmpty()) {
            if (collectMissingRecipes) {
                for (Map.Entry entry : missingIngredients.entrySet()) {
                    for (MissingIngredients.Element element : ((MissingIngredients)entry.getValue()).getElements()) {
                        Map<IngredientComponent, List<Object>> storageMap;
                        MissingIngredients.PrototypedWithRequested alternative = element.getAlternatives().get(0);
                        IngredientComponent component = alternative.getRequestedPrototype().getComponent();
                        IIngredientMatcher matcher = component.getMatcher();
                        long storedQuantity = matcher.getQuantity(alternative.getRequestedPrototype().getPrototype()) - alternative.getQuantityMissing();
                        if (storedQuantity > 0L) {
                            storageMap = Maps.newIdentityHashMap();
                            storageMap.put(component, Collections.singletonList(matcher.withQuantity(alternative.getRequestedPrototype().getPrototype(), storedQuantity)));
                        } else {
                            storageMap = Collections.emptyMap();
                        }
                        missingDependencies.add(new UnknownCraftingRecipeException(alternative.getRequestedPrototype(), alternative.getQuantityMissing(), Collections.emptyList(), CraftingHelpers.compressMixedIngredients((IMixedIngredients)new MixedIngredients(storageMap)), Lists.newArrayList()));
                    }
                }
            }
            return new PartialCraftingJobCalculation(null, missingDependencies, (Map)simulation.getLeft(), null);
        }
        HashMap dependencies = Maps.newHashMapWithExpectedSize((int)missingIngredients.size());
        IdentityHashMap dependenciesOutputSurplus = Maps.newIdentityHashMap();
        for (IngredientComponent dependencyComponent : missingIngredients.keySet()) {
            try {
                PartialCraftingJobCalculationDependency resultDependency = CraftingHelpers.calculateCraftingJobDependencyComponent(dependencyComponent, dependenciesOutputSurplus, (MissingIngredients)missingIngredients.get(dependencyComponent), parentDependencies, dependencies, recipeIndex, channel, storageGetter, simulatedExtractionMemory, extractionMemoryReusable, identifierGenerator, craftingJobsGraph, collectMissingRecipes);
                if (resultDependency.isValid()) continue;
                missingDependencies.addAll(resultDependency.getUnknownCrafingRecipes());
                partialCraftingJobs.addAll(resultDependency.getPartialCraftingJobs());
                if (collectMissingRecipes) continue;
                break;
            }
            catch (RecursiveCraftingRecipeException e) {
                e.addRecipe(recipe);
                throw e;
            }
        }
        if (!missingDependencies.isEmpty()) {
            return new PartialCraftingJobCalculation(null, missingDependencies, (Map)simulation.getLeft(), partialCraftingJobs);
        }
        CraftingJob craftingJob = new CraftingJob(identifierGenerator.getNext(), channel, recipe, amount, CraftingHelpers.compressMixedIngredients((IMixedIngredients)new MixedIngredients((Map)simulation.getLeft())));
        for (CraftingJob dependency : dependencies.values()) {
            craftingJob.addDependency(dependency);
            craftingJobsGraph.addDependency(craftingJob, dependency);
        }
        return new PartialCraftingJobCalculation(craftingJob, null, (Map)simulation.getLeft(), null);
    }

    protected static <T, M> PartialCraftingJobCalculationDependency calculateCraftingJobDependencyComponent(IngredientComponent<T, M> dependencyComponent, Map<IngredientComponent<?, ?>, IngredientCollectionPrototypeMap<?, ?>> dependenciesOutputSurplus, MissingIngredients<T, M> missingIngredients, Set<IPrototypedIngredient> parentDependencies, Map<IRecipeDefinition, CraftingJob> dependencies, IRecipeIndex recipeIndex, int channel, Function<IngredientComponent<?, ?>, IIngredientComponentStorage> storageGetter, Map<IngredientComponent<?, ?>, IngredientCollectionPrototypeMap<?, ?>> simulatedExtractionMemory, Map<IngredientComponent<?, ?>, IIngredientCollectionMutable<?, ?>> extractionMemoryReusable, IIdentifierGenerator identifierGenerator, CraftingJobDependencyGraph craftingJobsGraph, boolean collectMissingRecipes) throws RecursiveCraftingRecipeException {
        IIngredientMatcher dependencyMatcher = dependencyComponent.getMatcher();
        ArrayList missingDependencies = Lists.newArrayList();
        for (MissingIngredients.Element<T, M> missingElement : missingIngredients.getElements()) {
            CraftingJob existingJob;
            CraftingJob dependency = null;
            Object dependencyInstance = null;
            boolean skipDependency = false;
            UnknownCraftingRecipeException firstError = null;
            for (MissingIngredients.PrototypedWithRequested<T, M> prototypedAlternative : missingElement.getAlternatives()) {
                if (missingElement.isInputReusable() && extractionMemoryReusable.get(dependencyComponent).contains(prototypedAlternative.getRequestedPrototype().getPrototype())) {
                    skipDependency = true;
                    break;
                }
                PrototypedIngredient prototype = new PrototypedIngredient(dependencyComponent, dependencyMatcher.withQuantity(prototypedAlternative.getRequestedPrototype().getPrototype(), prototypedAlternative.getQuantityMissing()), prototypedAlternative.getRequestedPrototype().getCondition());
                IngredientCollectionPrototypeMap<?, ?> dependencyComponentSurplusOld = dependenciesOutputSurplus.get(dependencyComponent);
                IngredientCollectionPrototypeMap dependencyComponentSurplus = null;
                if (dependencyComponentSurplusOld != null) {
                    dependencyComponentSurplus = new IngredientCollectionPrototypeMap(dependencyComponentSurplusOld.getComponent(), true);
                    dependencyComponentSurplus.addAll(dependencyComponentSurplusOld);
                    long remainingQuantity = dependencyMatcher.getQuantity(prototype.getPrototype());
                    IIngredientMatcher prototypeMatcher = prototype.getComponent().getMatcher();
                    Iterator surplusIt = dependencyComponentSurplus.iterator(prototype.getPrototype(), prototypeMatcher.withoutCondition(prototype.getCondition(), prototype.getComponent().getPrimaryQuantifier().getMatchCondition()));
                    boolean updatedRemainingQuantity = false;
                    while (remainingQuantity > 0L && surplusIt.hasNext()) {
                        updatedRemainingQuantity = true;
                        Object matchingInstance = surplusIt.next();
                        long matchingInstanceQuantity = dependencyMatcher.getQuantity(matchingInstance);
                        if (matchingInstanceQuantity <= remainingQuantity) {
                            remainingQuantity -= matchingInstanceQuantity;
                            surplusIt.remove();
                            continue;
                        }
                        remainingQuantity = 0L;
                        surplusIt.remove();
                        dependencyComponentSurplus.setQuantity(matchingInstance, matchingInstanceQuantity -= remainingQuantity);
                    }
                    if (updatedRemainingQuantity) {
                        if (remainingQuantity == 0L) {
                            dependenciesOutputSurplus.put(dependencyComponent, dependencyComponentSurplus);
                            skipDependency = true;
                            break;
                        }
                        prototype = new PrototypedIngredient(dependencyComponent, dependencyMatcher.withQuantity(prototype.getPrototype(), remainingQuantity), prototype.getCondition());
                    }
                }
                try {
                    HashSet childDependencies = Sets.newHashSet(parentDependencies);
                    if (!childDependencies.add(prototype)) {
                        throw new RecursiveCraftingRecipeException((IPrototypedIngredient)prototype);
                    }
                    dependency = CraftingHelpers.calculateCraftingJobs(recipeIndex, channel, storageGetter, dependencyComponent, prototype.getPrototype(), prototype.getCondition(), true, simulatedExtractionMemory, extractionMemoryReusable, identifierGenerator, craftingJobsGraph, childDependencies, collectMissingRecipes);
                    dependencyInstance = prototype.getPrototype();
                    if (dependencyComponentSurplus != null) {
                        dependenciesOutputSurplus.put(dependencyComponent, dependencyComponentSurplus);
                    }
                    Object dependencyQuantifierlessCondition = dependencyMatcher.withoutCondition(prototype.getCondition(), dependencyComponent.getPrimaryQuantifier().getMatchCondition());
                    long requestedQuantity = dependencyMatcher.getQuantity(prototype.getPrototype());
                    for (IngredientComponent outputComponent : dependency.getRecipe().getOutput().getComponents()) {
                        IngredientCollectionPrototypeMap componentSurplus = dependenciesOutputSurplus.get(outputComponent);
                        if (componentSurplus == null) {
                            componentSurplus = new IngredientCollectionPrototypeMap(outputComponent, true);
                            dependenciesOutputSurplus.put(outputComponent, componentSurplus);
                        }
                        List instances = dependency.getRecipe().getOutput().getInstances(outputComponent);
                        long recipeAmount = dependency.getAmount();
                        if (recipeAmount > 1L) {
                            IIngredientMatcher matcher = outputComponent.getMatcher();
                            instances = instances.stream().map(instance -> matcher.withQuantity(instance, matcher.getQuantity(instance) * recipeAmount)).collect(Collectors.toList());
                        }
                        CraftingHelpers.addRemainderAsSurplusForComponent(outputComponent, instances, componentSurplus, prototype.getComponent(), prototype.getPrototype(), dependencyQuantifierlessCondition, requestedQuantity);
                    }
                    break;
                }
                catch (UnknownCraftingRecipeException e) {
                    if (firstError != null) continue;
                    firstError = new UnknownCraftingRecipeException(e.getIngredient(), prototypedAlternative.getQuantityMissing(), e.getMissingChildRecipes(), CraftingHelpers.compressMixedIngredients(e.getIngredientsStorage()), e.getPartialCraftingJobs());
                }
            }
            if (skipDependency) continue;
            if (dependency == null) {
                missingDependencies.add(firstError);
                if (!collectMissingRecipes) break;
                continue;
            }
            simulatedExtractionMemory.get(dependencyComponent).remove(dependencyInstance);
            if (missingElement.isInputReusable()) {
                extractionMemoryReusable.get(dependencyComponent).add(dependencyInstance);
            }
            if ((existingJob = dependencies.get(dependency.getRecipe())) == null) {
                dependencies.put(dependency.getRecipe(), dependency);
                continue;
            }
            craftingJobsGraph.mergeCraftingJobs(existingJob, dependency, true);
        }
        return new PartialCraftingJobCalculationDependency(missingDependencies, dependencies.values());
    }

    protected static <T1, M1, T2, M2> void addRemainderAsSurplusForComponent(IngredientComponent<T1, M1> ingredientComponent, List<T1> instances, IngredientCollectionPrototypeMap<T1, M1> simulatedExtractionMemory, IngredientComponent<T2, M2> blackListComponent, T2 blacklistInstance, M2 blacklistCondition, long blacklistQuantity) {
        IIngredientMatcher blacklistMatcher = blackListComponent.getMatcher();
        for (T1 instance : instances) {
            long quantity;
            IIngredientMatcher outputMatcher = ingredientComponent.getMatcher();
            long reduceQuantity = 0L;
            if (blackListComponent == ingredientComponent && blacklistMatcher.matches(blacklistInstance, instance, blacklistCondition)) {
                reduceQuantity = blacklistQuantity;
            }
            if ((quantity = simulatedExtractionMemory.getQuantity(instance) + (outputMatcher.getQuantity(instance) - reduceQuantity)) <= 0L) continue;
            simulatedExtractionMemory.setQuantity(instance, quantity);
        }
    }

    public static void scheduleCraftingJobs(ICraftingNetwork craftingNetwork, CraftingJobDependencyGraph craftingJobDependencyGraph, boolean allowDistribution, @Nullable UUID initiator) throws UnavailableCraftingInterfacesException {
        ArrayList startedJobs = Lists.newArrayList();
        craftingNetwork.getCraftingJobDependencyGraph().importDependencies(craftingJobDependencyGraph);
        for (CraftingJob craftingJob : craftingJobDependencyGraph.getCraftingJobs()) {
            try {
                craftingNetwork.scheduleCraftingJob(craftingJob, allowDistribution);
            }
            catch (UnavailableCraftingInterfacesException e) {
                for (CraftingJob startedJob : startedJobs) {
                    craftingNetwork.cancelCraftingJob(startedJob.getChannel(), startedJob.getId());
                }
                throw new UnavailableCraftingInterfacesException(craftingJobDependencyGraph.getCraftingJobs());
            }
            startedJobs.add(craftingJob);
            if (initiator == null) continue;
            craftingJob.setInitiatorUuid(initiator.toString());
        }
    }

    public static CraftingJob scheduleCraftingJob(ICraftingNetwork craftingNetwork, CraftingJob craftingJob, boolean allowDistribution, @Nullable UUID initiator) throws UnavailableCraftingInterfacesException {
        craftingNetwork.scheduleCraftingJob(craftingJob, allowDistribution);
        if (initiator != null) {
            craftingJob.setInitiatorUuid(initiator.toString());
        }
        return craftingJob;
    }

    @Nullable
    public static <T, M> CraftingJob calculateAndScheduleCraftingJob(INetwork network, int channel, IngredientComponent<T, M> ingredientComponent, T instance, M matchCondition, boolean craftMissing, boolean allowDistribution, IIdentifierGenerator identifierGenerator, @Nullable UUID initiator) {
        try {
            CraftingJobDependencyGraph dependencyGraph = new CraftingJobDependencyGraph();
            CraftingJob craftingJob = CraftingHelpers.calculateCraftingJobs(network, channel, ingredientComponent, instance, matchCondition, craftMissing, identifierGenerator, dependencyGraph, false);
            ICraftingNetwork craftingNetwork = CraftingHelpers.getCraftingNetworkChecked(network);
            CraftingHelpers.scheduleCraftingJobs(craftingNetwork, dependencyGraph, allowDistribution, initiator);
            return craftingJob;
        }
        catch (RecursiveCraftingRecipeException | UnavailableCraftingInterfacesException | UnknownCraftingRecipeException e) {
            return null;
        }
    }

    @Nullable
    public static CraftingJob calculateAndScheduleCraftingJob(INetwork network, int channel, IRecipeDefinition recipe, int amount, boolean craftMissing, boolean allowDistribution, IIdentifierGenerator identifierGenerator, @Nullable UUID initiator) {
        try {
            CraftingJobDependencyGraph dependencyGraph = new CraftingJobDependencyGraph();
            CraftingJob craftingJob = CraftingHelpers.calculateCraftingJobs(network, channel, recipe, amount, craftMissing, identifierGenerator, dependencyGraph, false);
            ICraftingNetwork craftingNetwork = CraftingHelpers.getCraftingNetworkChecked(network);
            CraftingHelpers.scheduleCraftingJobs(craftingNetwork, dependencyGraph, allowDistribution, initiator);
            return craftingJob;
        }
        catch (FailedCraftingRecipeException | RecursiveCraftingRecipeException | UnavailableCraftingInterfacesException e) {
            return null;
        }
    }

    public static <T, M> boolean hasStorageInstance(INetwork network, int channel, IngredientComponent<T, M> ingredientComponent, T instance, M matchCondition) {
        boolean contains;
        IIngredientComponentStorage<T, M> storage = CraftingHelpers.getNetworkStorage(network, channel, ingredientComponent, true);
        if (storage instanceof IngredientChannelAdapter) {
            ((IngredientChannelAdapter)storage).disableLimits();
        }
        if (storage instanceof IngredientChannelIndexed) {
            IIngredientMatcher matcher = ingredientComponent.getMatcher();
            long quantityPresent = ((IngredientChannelIndexed)storage).getIndex().getQuantity(instance);
            contains = matcher.hasCondition(matchCondition, ingredientComponent.getPrimaryQuantifier().getMatchCondition()) ? quantityPresent >= matcher.getQuantity(instance) : quantityPresent > 0L;
        } else {
            boolean bl = contains = !ingredientComponent.getMatcher().isEmpty(storage.extract(instance, matchCondition, true));
        }
        if (storage instanceof IngredientChannelAdapter) {
            ((IngredientChannelAdapter)storage).enableLimits();
        }
        return contains;
    }

    public static <T, M> long getStorageInstanceQuantity(INetwork network, int channel, IngredientComponent<T, M> ingredientComponent, T instance, M matchCondition) {
        IIngredientComponentStorage<T, M> storage = CraftingHelpers.getNetworkStorage(network, channel, ingredientComponent, true);
        if (storage instanceof IngredientChannelAdapter) {
            ((IngredientChannelAdapter)storage).disableLimits();
        }
        long quantityPresent = storage instanceof IngredientChannelIndexed ? ((IngredientChannelIndexed)storage).getIndex().getQuantity(instance) : ingredientComponent.getMatcher().getQuantity(storage.extract(instance, matchCondition, true));
        if (storage instanceof IngredientChannelAdapter) {
            ((IngredientChannelAdapter)storage).enableLimits();
        }
        return quantityPresent;
    }

    public static <T, M> boolean isCrafting(ICraftingNetwork craftingNetwork, int channel, IngredientComponent<T, M> ingredientComponent, T instance, M matchCondition) {
        Iterator<CraftingJob> craftingJobs = craftingNetwork.getCraftingJobs(channel, ingredientComponent, instance, matchCondition);
        return craftingJobs.hasNext();
    }

    public static boolean isCrafting(ICraftingNetwork craftingNetwork, int channel, IRecipeDefinition recipe) {
        Iterator<CraftingJob> it = craftingNetwork.getCraftingJobs(channel);
        while (it.hasNext()) {
            if (!it.next().getRecipe().equals(recipe)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static <T, M> List<T> getIngredientRecipeInputs(IIngredientComponentStorage<T, M> storage, IngredientComponent<T, M> ingredientComponent, IRecipeDefinition recipe, boolean simulate, long recipeOutputQuantity) {
        return (List)CraftingHelpers.getIngredientRecipeInputs(storage, ingredientComponent, recipe, simulate, simulate ? new IngredientCollectionPrototypeMap(ingredientComponent, true) : null, new IngredientHashSet(ingredientComponent), false, recipeOutputQuantity).getLeft();
    }

    public static <T, M> Pair<List<T>, MissingIngredients<T, M>> getIngredientRecipeInputs(IIngredientComponentStorage<T, M> storage, IngredientComponent<T, M> ingredientComponent, IRecipeDefinition recipe, boolean simulate, IngredientCollectionPrototypeMap<T, M> simulatedExtractionMemory, IIngredientCollectionMutable<T, M> extractionMemoryReusable, boolean collectMissingIngredients, long recipeOutputQuantity) {
        IIngredientMatcher matcher = ingredientComponent.getMatcher();
        if (storage.getMaxQuantity() == 0L && extractionMemoryReusable.isEmpty() && IntStream.range(0, recipe.getInputs(ingredientComponent).size()).noneMatch(i -> recipe.isInputReusable(ingredientComponent, i))) {
            if (collectMissingIngredients) {
                List recipeInputs = recipe.getInputs(ingredientComponent);
                MissingIngredients missing = new MissingIngredients(recipeInputs.stream().map(IPrototypedIngredientAlternatives::getAlternatives).map(l -> CraftingHelpers.multiplyPrototypedIngredients(l, recipeOutputQuantity)).map(ps -> new MissingIngredients.Element(ps.stream().map(p -> new MissingIngredients.PrototypedWithRequested(p, matcher.getQuantity(p.getPrototype()))).collect(Collectors.toList()), false)).collect(Collectors.toList()));
                return Pair.of((Object)Lists.newArrayList(Collections.nCopies(recipe.getInputs(ingredientComponent).size(), ingredientComponent.getMatcher().getEmptyInstance())), missing);
            }
            return Pair.of(null, null);
        }
        List inputAlternativePrototypes = recipe.getInputs(ingredientComponent);
        ArrayList inputInstances = Lists.newArrayList();
        ArrayList missingElements = collectMissingIngredients ? Lists.newArrayList() : null;
        for (int inputIndex = 0; inputIndex < inputAlternativePrototypes.size(); ++inputIndex) {
            IngredientCollectionPrototypeMap simulatedExtractionMemoryAlternative;
            IPrototypedIngredientAlternatives inputPrototypes = (IPrototypedIngredientAlternatives)inputAlternativePrototypes.get(inputIndex);
            Object firstInputInstance = null;
            boolean setFirstInputInstance = false;
            Object inputInstance = null;
            boolean hasInputInstance = false;
            IngredientCollectionPrototypeMap simulatedExtractionMemoryBufferFirst = null;
            Object extractionMemoryReusableBufferFirst = null;
            ArrayList missingAlternatives = Lists.newArrayList();
            IngredientCollectionPrototypeMap ingredientCollectionPrototypeMap = simulatedExtractionMemoryAlternative = simulate ? new IngredientCollectionPrototypeMap(ingredientComponent, true) : null;
            if (simulate) {
                simulatedExtractionMemoryAlternative.addAll(simulatedExtractionMemory);
            }
            for (IPrototypedIngredient<T, M> inputPrototype : inputPrototypes.getAlternatives()) {
                long memoryQuantity;
                boolean inputReusable = recipe.isInputReusable(ingredientComponent, inputIndex);
                IngredientCollectionPrototypeMap simulatedExtractionMemoryBuffer = simulate ? new IngredientCollectionPrototypeMap(ingredientComponent, true) : null;
                IngredientHashSet extractionMemoryReusableBuffer = inputReusable ? new IngredientHashSet(ingredientComponent) : null;
                boolean shouldBreak = false;
                if (recipeOutputQuantity > 1L && !inputReusable) {
                    inputPrototype = CraftingHelpers.multiplyPrototypedIngredient(inputPrototype, recipeOutputQuantity);
                }
                if (matcher.isEmpty(inputPrototype.getPrototype())) {
                    inputInstance = inputPrototype.getPrototype();
                    hasInputInstance = true;
                    break;
                }
                long prototypeQuantity = matcher.getQuantity(inputPrototype.getPrototype());
                if (inputReusable && extractionMemoryReusable.contains(inputPrototype.getPrototype())) {
                    inputInstance = inputPrototype.getComponent().getMatcher().getEmptyInstance();
                    hasInputInstance = true;
                    shouldBreak = true;
                } else if (simulate && (memoryQuantity = simulatedExtractionMemoryAlternative.getQuantity(inputPrototype.getPrototype())) != 0L) {
                    long newQuantity = memoryQuantity + prototypeQuantity;
                    if (newQuantity > 0L) {
                        long quantityExtracted;
                        Object newInstance = matcher.withQuantity(inputPrototype.getPrototype(), newQuantity);
                        Object matchCondition = matcher.withoutCondition(inputPrototype.getCondition(), ingredientComponent.getPrimaryQuantifier().getMatchCondition());
                        if (storage instanceof IngredientChannelAdapter) {
                            ((IngredientChannelAdapter)storage).disableLimits();
                        }
                        Object extracted = storage.extract(newInstance, matchCondition, true);
                        if (storage instanceof IngredientChannelAdapter) {
                            ((IngredientChannelAdapter)storage).enableLimits();
                        }
                        if ((quantityExtracted = matcher.getQuantity(extracted)) == newQuantity) {
                            inputInstance = inputPrototype.getPrototype();
                            simulatedExtractionMemoryAlternative.add(inputInstance);
                            simulatedExtractionMemoryBuffer.add(inputInstance);
                            if (inputReusable) {
                                extractionMemoryReusableBuffer.add(inputInstance);
                            }
                            hasInputInstance = true;
                            shouldBreak = true;
                        } else if (collectMissingIngredients) {
                            long quantityMissingPrevious = Math.max(0L, memoryQuantity - quantityExtracted);
                            long quantityMissingTotal = newQuantity - quantityExtracted;
                            long quantityMissingRelative = quantityMissingTotal - quantityMissingPrevious;
                            missingAlternatives.add(new MissingIngredients.PrototypedWithRequested<T, M>(inputPrototype, quantityMissingRelative));
                            inputInstance = matcher.withQuantity(inputPrototype.getPrototype(), prototypeQuantity - quantityMissingRelative);
                            simulatedExtractionMemoryAlternative.setQuantity(inputPrototype.getPrototype(), quantityMissingTotal);
                            simulatedExtractionMemoryBuffer.add(matcher.withQuantity(inputPrototype.getPrototype(), quantityMissingRelative));
                        }
                    } else {
                        simulatedExtractionMemoryAlternative.add(inputPrototype.getPrototype());
                        simulatedExtractionMemoryBuffer.add(inputPrototype.getPrototype());
                        if (inputReusable) {
                            extractionMemoryReusableBuffer.add(inputPrototype.getPrototype());
                        }
                        inputInstance = inputPrototype.getComponent().getMatcher().getEmptyInstance();
                        hasInputInstance = true;
                        shouldBreak = true;
                    }
                } else {
                    Object matchCondition = matcher.withoutCondition(inputPrototype.getCondition(), ingredientComponent.getPrimaryQuantifier().getMatchCondition());
                    if (storage instanceof IngredientChannelAdapter) {
                        ((IngredientChannelAdapter)storage).disableLimits();
                    }
                    Object extracted = storage.extract(inputPrototype.getPrototype(), matchCondition, simulate);
                    if (storage instanceof IngredientChannelAdapter) {
                        ((IngredientChannelAdapter)storage).enableLimits();
                    }
                    long quantityExtracted = matcher.getQuantity(extracted);
                    inputInstance = extracted;
                    if (simulate) {
                        simulatedExtractionMemoryAlternative.add(extracted);
                        simulatedExtractionMemoryBuffer.add(inputPrototype.getPrototype());
                    }
                    if (prototypeQuantity == quantityExtracted) {
                        hasInputInstance = true;
                        shouldBreak = true;
                        if (inputReusable) {
                            extractionMemoryReusableBuffer.add(inputPrototype.getPrototype());
                        }
                    } else if (collectMissingIngredients) {
                        long quantityMissing = prototypeQuantity - quantityExtracted;
                        missingAlternatives.add(new MissingIngredients.PrototypedWithRequested<T, M>(inputPrototype, quantityMissing));
                    }
                }
                if (!setFirstInputInstance || shouldBreak) {
                    setFirstInputInstance = true;
                    firstInputInstance = inputInstance;
                    simulatedExtractionMemoryBufferFirst = simulatedExtractionMemoryBuffer;
                    extractionMemoryReusableBufferFirst = inputReusable ? extractionMemoryReusableBuffer : null;
                }
                if (!shouldBreak) continue;
                break;
            }
            if (simulatedExtractionMemoryBufferFirst != null) {
                for (Object instance : simulatedExtractionMemoryBufferFirst) {
                    simulatedExtractionMemory.add(instance);
                }
            }
            if (extractionMemoryReusableBufferFirst != null) {
                for (Object instance : extractionMemoryReusableBufferFirst) {
                    extractionMemoryReusable.add(instance);
                }
            }
            if (!hasInputInstance) {
                if (!simulate) {
                    for (Object instance : inputInstances) {
                        Object remaining = storage.insert(instance, false);
                        if (matcher.isEmpty(remaining)) continue;
                        throw new IllegalStateException("Extraction for a crafting recipe faileddue to inconsistent insertion behaviour by destination in simulation and non-simulation: " + storage + ". Lost: " + remaining);
                    }
                }
                if (!collectMissingIngredients) {
                    return Pair.of(null, null);
                }
                if (missingAlternatives.size() > 0) {
                    missingElements.add(new MissingIngredients.Element(missingAlternatives, recipe.isInputReusable(ingredientComponent, inputIndex)));
                }
            }
            if (hasInputInstance) {
                inputInstances.add(inputInstance);
                continue;
            }
            if (!setFirstInputInstance || matcher.isEmpty(firstInputInstance)) continue;
            inputInstances.add(firstInputInstance);
        }
        return Pair.of((Object)inputInstances, (Object)(collectMissingIngredients ? new MissingIngredients(missingElements) : null));
    }

    @Nullable
    public static IMixedIngredients getRecipeInputs(INetwork network, int channel, IRecipeDefinition recipe, boolean simulate, long recipeOutputQuantity) {
        Map inputs = (Map)CraftingHelpers.getRecipeInputs(CraftingHelpers.getNetworkStorageGetter(network, channel, true), recipe, simulate, Maps.newIdentityHashMap(), Maps.newIdentityHashMap(), false, recipeOutputQuantity).getLeft();
        return inputs == null ? null : new MixedIngredients(inputs);
    }

    public static Function<IngredientComponent<?, ?>, IIngredientComponentStorage> getNetworkStorageGetter(INetwork network, int channel, boolean scheduleObservation) {
        return ingredientComponent -> CraftingHelpers.getNetworkStorage(network, channel, ingredientComponent, scheduleObservation);
    }

    public static Pair<Map<IngredientComponent<?, ?>, List<?>>, Map<IngredientComponent<?, ?>, MissingIngredients<?, ?>>> getRecipeInputs(Function<IngredientComponent<?, ?>, IIngredientComponentStorage> storageGetter, IRecipeDefinition recipe, boolean simulate, Map<IngredientComponent<?, ?>, IngredientCollectionPrototypeMap<?, ?>> simulatedExtractionMemories, Map<IngredientComponent<?, ?>, IIngredientCollectionMutable<?, ?>> extractionMemoriesReusable, boolean collectMissingIngredients, long recipeOutputQuantity) {
        IdentityHashMap ingredientsAvailable = Maps.newIdentityHashMap();
        IdentityHashMap ingredientsMissing = Maps.newIdentityHashMap();
        for (IngredientComponent ingredientComponent : recipe.getInputComponents()) {
            IngredientHashSet extractionMemoryReusable;
            IIngredientComponentStorage storage = storageGetter.apply(ingredientComponent);
            IngredientCollectionPrototypeMap simulatedExtractionMemory = simulatedExtractionMemories.get(ingredientComponent);
            if (simulatedExtractionMemory == null) {
                simulatedExtractionMemory = new IngredientCollectionPrototypeMap(ingredientComponent, true);
                simulatedExtractionMemories.put(ingredientComponent, simulatedExtractionMemory);
            }
            if ((extractionMemoryReusable = extractionMemoriesReusable.get(ingredientComponent)) == null) {
                extractionMemoryReusable = new IngredientHashSet(ingredientComponent);
                extractionMemoriesReusable.put((IngredientComponent<?, ?>)ingredientComponent, (IIngredientCollectionMutable<?, ?>)extractionMemoryReusable);
            }
            Pair subIngredients = CraftingHelpers.getIngredientRecipeInputs(storage, ingredientComponent, recipe, simulate, simulatedExtractionMemory, extractionMemoryReusable, collectMissingIngredients, recipeOutputQuantity);
            List subIngredientAvailable = (List)subIngredients.getLeft();
            MissingIngredients subIngredientsMissing = (MissingIngredients)subIngredients.getRight();
            if (subIngredientAvailable == null && !collectMissingIngredients) {
                return Pair.of(null, null);
            }
            if (subIngredientAvailable != null && !subIngredientAvailable.isEmpty()) {
                ingredientsAvailable.put(ingredientComponent, subIngredientAvailable);
            }
            if (!collectMissingIngredients || subIngredientsMissing.getElements().isEmpty()) continue;
            ingredientsMissing.put(ingredientComponent, subIngredientsMissing);
        }
        IdentityHashMap ingredientsMissingCompressed = Maps.newIdentityHashMap();
        for (IngredientComponent ingredientComponent : ingredientsMissing.keySet()) {
            ingredientsMissingCompressed.put(ingredientComponent, CraftingHelpers.compressMissingIngredients((MissingIngredients)ingredientsMissing.get(ingredientComponent)));
        }
        return Pair.of((Object)ingredientsAvailable, (Object)ingredientsMissingCompressed);
    }

    public static <T, M> List<IPrototypedIngredient<T, M>> getCompressedIngredients(IngredientComponent<T, M> ingredientComponent, IMixedIngredients mixedIngredients) {
        ArrayList outputs = Lists.newArrayList();
        IIngredientMatcher matcher = ingredientComponent.getMatcher();
        for (Object instance : mixedIngredients.getInstances(ingredientComponent)) {
            boolean stacked = false;
            ListIterator<PrototypedIngredient> existingIt = outputs.listIterator();
            while (existingIt.hasNext()) {
                IPrototypedIngredient prototypedIngredient = (IPrototypedIngredient)existingIt.next();
                if (!matcher.matches(instance, prototypedIngredient.getPrototype(), prototypedIngredient.getCondition())) continue;
                Object stackedInstance = matcher.withQuantity(prototypedIngredient.getPrototype(), matcher.getQuantity(prototypedIngredient.getPrototype()) + matcher.getQuantity(instance));
                existingIt.set(new PrototypedIngredient(ingredientComponent, stackedInstance, prototypedIngredient.getCondition()));
                stacked = true;
                break;
            }
            if (stacked) continue;
            outputs.add(new PrototypedIngredient(ingredientComponent, instance, matcher.getExactMatchNoQuantityCondition()));
        }
        return outputs;
    }

    public static <T, M> MissingIngredients<T, M> compressMissingIngredients(MissingIngredients<T, M> missingIngredients) {
        LinkedHashMap elementsCompressedMap = Maps.newLinkedHashMap();
        for (MissingIngredients.Element<T, M> element : missingIngredients.getElements()) {
            elementsCompressedMap.merge(element, 1L, Long::sum);
        }
        ArrayList elementsCompressed = Lists.newArrayList();
        for (Map.Entry entry : elementsCompressedMap.entrySet()) {
            Long quantity = (Long)entry.getValue();
            if (quantity == 1L || ((MissingIngredients.Element)entry.getKey()).isInputReusable()) {
                elementsCompressed.add((MissingIngredients.Element)entry.getKey());
                continue;
            }
            MissingIngredients.Element elementOld = (MissingIngredients.Element)entry.getKey();
            MissingIngredients.Element elementNewQuantity = new MissingIngredients.Element(elementOld.getAlternatives().stream().map(alt -> new MissingIngredients.PrototypedWithRequested(alt.getRequestedPrototype(), alt.getQuantityMissing() * quantity)).toList(), elementOld.isInputReusable());
            elementsCompressed.add(elementNewQuantity);
        }
        return new MissingIngredients(elementsCompressed);
    }

    public static Map<IngredientComponent<?, ?>, List<IPrototypedIngredient<?, ?>>> getRecipeOutputs(IRecipeDefinition recipe) {
        HashMap outputs = Maps.newHashMap();
        IMixedIngredients mixedIngredients = recipe.getOutput();
        for (IngredientComponent ingredientComponent : mixedIngredients.getComponents()) {
            outputs.put(ingredientComponent, CraftingHelpers.getCompressedIngredients(ingredientComponent, mixedIngredients));
        }
        return outputs;
    }

    public static Map<IngredientComponent<?, ?>, List<IPrototypedIngredient<?, ?>>> multiplyRecipeOutputs(Map<IngredientComponent<?, ?>, List<IPrototypedIngredient<?, ?>>> recipeOutputs, int amount) {
        if (amount == 1) {
            return recipeOutputs;
        }
        IdentityHashMap newRecipeOutputs = Maps.newIdentityHashMap();
        for (Map.Entry<IngredientComponent<?, ?>, List<IPrototypedIngredient<?, ?>>> entry : recipeOutputs.entrySet()) {
            newRecipeOutputs.put(entry.getKey(), CraftingHelpers.multiplyPrototypedIngredients(entry.getValue(), amount));
        }
        return newRecipeOutputs;
    }

    public static <T, M> List<IPrototypedIngredient<T, M>> multiplyPrototypedIngredients(Collection<IPrototypedIngredient<T, M>> prototypedIngredients, long amount) {
        return prototypedIngredients.stream().map(p -> CraftingHelpers.multiplyPrototypedIngredient(p, amount)).collect(Collectors.toList());
    }

    public static <T, M> IPrototypedIngredient<T, M> multiplyPrototypedIngredient(IPrototypedIngredient<T, M> prototypedIngredient, long amount) {
        IIngredientMatcher matcher = prototypedIngredient.getComponent().getMatcher();
        return new PrototypedIngredient(prototypedIngredient.getComponent(), matcher.withQuantity(prototypedIngredient.getPrototype(), matcher.getQuantity(prototypedIngredient.getPrototype()) * amount), prototypedIngredient.getCondition());
    }

    public static IMixedIngredients mergeMixedIngredients(IMixedIngredients a, IMixedIngredients b) {
        IngredientCollectionQuantitativeGrouper grouping;
        IdentityHashMap groupings = Maps.newIdentityHashMap();
        for (IngredientComponent component : a.getComponents()) {
            grouping = new IngredientCollectionQuantitativeGrouper((IIngredientList)new IngredientArrayList(component));
            groupings.put(component, grouping);
            grouping.addAll((Iterable)a.getInstances(component));
        }
        for (IngredientComponent component : b.getComponents()) {
            grouping = (IngredientCollectionQuantitativeGrouper)groupings.get(component);
            if (grouping == null) {
                grouping = new IngredientCollectionQuantitativeGrouper((IIngredientList)new IngredientArrayList(component));
                groupings.put(component, grouping);
            }
            grouping.addAll((Iterable)b.getInstances(component));
        }
        IdentityHashMap ingredients = Maps.newIdentityHashMap();
        for (Map.Entry entry : groupings.entrySet()) {
            ingredients.put((IngredientComponent)entry.getKey(), Lists.newArrayList((Iterable)((Iterable)entry.getValue())));
        }
        return new MixedIngredients((Map)ingredients);
    }

    protected static IMixedIngredients compressMixedIngredients(IMixedIngredients mixedIngredients) {
        IdentityHashMap groupings = Maps.newIdentityHashMap();
        for (IngredientComponent component : mixedIngredients.getComponents()) {
            IngredientCollectionQuantitativeGrouper grouping = new IngredientCollectionQuantitativeGrouper((IIngredientList)new IngredientArrayList(component));
            groupings.put(component, grouping);
            grouping.addAll((Iterable)mixedIngredients.getInstances(component));
        }
        IdentityHashMap ingredients = Maps.newIdentityHashMap();
        for (Map.Entry entry : groupings.entrySet()) {
            IIngredientMatcher matcher = ((IngredientComponent)entry.getKey()).getMatcher();
            List values = ((IngredientCollectionQuantitativeGrouper)entry.getValue()).stream().filter(i -> !matcher.isEmpty(i)).collect(Collectors.toList());
            if (values.isEmpty()) continue;
            ingredients.put((IngredientComponent)entry.getKey(), values);
        }
        return new MixedIngredients((Map)ingredients);
    }

    public static <T, M> boolean insertIngredientCrafting(IngredientComponent<T, M> ingredientComponent, ICapabilityProvider capabilityProvider, @Nullable Direction side, IMixedIngredients ingredients, IIngredientComponentStorage<T, M> storageFallback, boolean simulate) {
        Object remaining;
        IIngredientMatcher matcher = ingredientComponent.getMatcher();
        IIngredientComponentStorage storage = ingredientComponent.getStorage(capabilityProvider, side);
        List instances = ingredients.getInstances(ingredientComponent);
        ArrayList failedInstances = Lists.newArrayList();
        boolean ok = true;
        for (Object instance : instances) {
            remaining = storage.insert(instance, simulate);
            if (matcher.isEmpty(remaining)) continue;
            ok = false;
            if (simulate) continue;
            failedInstances.add(remaining);
        }
        for (Object instance : failedInstances) {
            remaining = storageFallback.insert(instance, false);
            if (matcher.isEmpty(remaining)) continue;
            throw new IllegalStateException("Insertion for a crafting recipe faileddue to inconsistent insertion behaviour by destination in simulation and non-simulation: " + capabilityProvider + ". Lost: " + instances);
        }
        return ok;
    }

    public static boolean insertCrafting(Function<IngredientComponent<?, ?>, PartPos> targetGetter, IMixedIngredients ingredients, INetwork network, int channel, boolean simulate) {
        IdentityHashMap tileMap = Maps.newIdentityHashMap();
        for (IngredientComponent ingredientComponent : ingredients.getComponents()) {
            BlockEntity tile = BlockEntityHelpers.get((DimPos)targetGetter.apply(ingredientComponent).getPos(), BlockEntity.class).orElse(null);
            if (tile != null) {
                tileMap.put(ingredientComponent, tile);
                continue;
            }
            return false;
        }
        boolean ok = true;
        for (Map.Entry entry : tileMap.entrySet()) {
            IIngredientComponentStorage storageNetwork;
            IIngredientComponentStorage iIngredientComponentStorage = storageNetwork = simulate ? null : CraftingHelpers.getNetworkStorage(network, channel, (IngredientComponent)entry.getKey(), false);
            if (CraftingHelpers.insertIngredientCrafting((IngredientComponent)entry.getKey(), (ICapabilityProvider)entry.getValue(), targetGetter.apply((IngredientComponent)entry.getKey()).getSide(), ingredients, storageNetwork, simulate)) continue;
            ok = false;
        }
        return ok;
    }

    public static List<CraftingJob> splitCraftingJobs(CraftingJob craftingJob, int splitFactor, CraftingJobDependencyGraph dependencyGraph, IIdentifierGenerator identifierGenerator) {
        splitFactor = Math.min(splitFactor, craftingJob.getAmount());
        int division = craftingJob.getAmount() / splitFactor;
        int modulus = craftingJob.getAmount() % splitFactor;
        ArrayList newCraftingJobs = Lists.newArrayList();
        for (int i = 0; i < splitFactor; ++i) {
            CraftingJob clonedJob = craftingJob.clone(identifierGenerator);
            newCraftingJobs.add(clonedJob);
            int newAmount = division;
            if (modulus > 0) {
                ++newAmount;
                --modulus;
            }
            clonedJob.setAmount(newAmount);
        }
        Collection<CraftingJob> originalDependencies = dependencyGraph.getDependencies(craftingJob);
        Collection<CraftingJob> originalDependents = dependencyGraph.getDependents(craftingJob);
        for (CraftingJob dependency : originalDependencies) {
            craftingJob.removeDependency(dependency);
            dependencyGraph.removeDependency(craftingJob.getId(), dependency.getId());
        }
        for (CraftingJob dependent : originalDependents) {
            dependent.removeDependency(craftingJob);
            dependencyGraph.removeDependency(dependent.getId(), craftingJob.getId());
        }
        for (CraftingJob dependency : originalDependencies) {
            for (CraftingJob newCraftingJob : newCraftingJobs) {
                newCraftingJob.addDependency(dependency);
                dependencyGraph.addDependency(newCraftingJob, dependency);
            }
        }
        for (CraftingJob originalDependent : originalDependents) {
            for (CraftingJob newCraftingJob : newCraftingJobs) {
                originalDependent.addDependency(newCraftingJob);
                dependencyGraph.addDependency(originalDependent, newCraftingJob);
            }
        }
        return newCraftingJobs;
    }

    public static IMixedIngredients insertIngredients(IMixedIngredients ingredients, Function<IngredientComponent<?, ?>, IIngredientComponentStorage> storageGetter, boolean simulate) {
        IdentityHashMap remainingIngredients = Maps.newIdentityHashMap();
        for (IngredientComponent component : ingredients.getComponents()) {
            IIngredientComponentStorage storage = storageGetter.apply(component);
            IIngredientMatcher matcher = component.getMatcher();
            for (Object instance : ingredients.getInstances(component)) {
                Object remainder = storage.insert(instance, simulate);
                if (matcher.isEmpty(remainder)) continue;
                List remainingInstances = (List)remainingIngredients.get(component);
                if (remainingInstances == null) {
                    remainingInstances = Lists.newArrayList();
                    remainingIngredients.put(component, remainingInstances);
                }
                remainingInstances.add(instance);
            }
        }
        return new MixedIngredients((Map)remainingIngredients);
    }

    public static interface IIdentifierGenerator {
        public int getNext();
    }
}

