/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalcustomization.loader;

import com.blakebr0.mysticalagriculture.api.registry.IMobSoulTypeRegistry;
import com.blakebr0.mysticalagriculture.api.soul.MobSoulType;
import com.blakebr0.mysticalcustomization.MysticalCustomization;
import com.blakebr0.mysticalcustomization.create.MobSoulTypeCreator;
import com.blakebr0.mysticalcustomization.modify.MobSoulTypeModifier;
import com.blakebr0.mysticalcustomization.util.ErrorManager;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;

public final class MobSoulTypeLoader {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final String CATEGORY = "Mob Soul Type";
    public static final Map<MobSoulType, List<ResourceLocation>> ENTITY_ADDITIONS_MAP = new HashMap<MobSoulType, List<ResourceLocation>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onRegisterMobSoulTypes(IMobSoulTypeRegistry registry) {
        File[] files;
        File dir = FMLPaths.CONFIGDIR.get().resolve("mysticalcustomization/mobsoultypes/").toFile();
        if (!dir.exists() && dir.mkdirs()) {
            MysticalCustomization.LOGGER.info("Created /config/mysticalcustomization/mobsoultypes/ directory");
        }
        if ((files = dir.listFiles((FileFilter)FileFilterUtils.suffixFileFilter((String)".json"))) == null) {
            return;
        }
        for (File file : files) {
            InputStreamReader reader = null;
            ResourceLocation id = null;
            MobSoulType type = null;
            try {
                reader = new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8);
                JsonObject json = JsonParser.parseReader((Reader)reader).getAsJsonObject();
                String name = file.getName().replace(".json", "");
                id = new ResourceLocation("mysticalcustomization", name);
                try {
                    type = MobSoulTypeCreator.create(id, json);
                }
                catch (JsonSyntaxException e) {
                    ErrorManager.INSTANCE.addError(CATEGORY, "Creating %s: %s".formatted(id, e.getMessage()));
                }
                reader.close();
            }
            catch (Exception e) {
                try {
                    ErrorManager.INSTANCE.addFatalError(CATEGORY, "An error occurred creating mob soul type with id %s.".formatted(id), e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(reader);
                    throw throwable;
                }
                IOUtils.closeQuietly((Reader)reader);
            }
            IOUtils.closeQuietly((Reader)reader);
            if (type == null) continue;
            registry.register(type);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onPostRegisterMobSoulTypes(IMobSoulTypeRegistry registry) {
        block16: {
            File file;
            block17: {
                File dir = FMLPaths.CONFIGDIR.get().resolve("mysticalcustomization/").toFile();
                if (!dir.exists() && dir.mkdirs()) {
                    MysticalCustomization.LOGGER.info("Created /config/mysticalcustomization/ directory");
                }
                if (!(file = FMLPaths.CONFIGDIR.get().resolve("mysticalcustomization/configure-mobsoultypes.json").toFile()).exists() || !file.isFile()) break block17;
                FileReader reader = null;
                try {
                    reader = new FileReader(file);
                    JsonObject json = JsonParser.parseReader((Reader)reader).getAsJsonObject();
                    for (Map.Entry entry : json.entrySet()) {
                        String id = (String)entry.getKey();
                        JsonObject changes = ((JsonElement)entry.getValue()).getAsJsonObject();
                        MobSoulType type2 = registry.getMobSoulTypeById(ResourceLocation.m_135820_((String)id));
                        try {
                            if (type2 == null) {
                                throw new JsonSyntaxException("Unknown mob soul type id: %s".formatted(id));
                            }
                            MobSoulTypeModifier.modify(type2, changes);
                        }
                        catch (JsonSyntaxException e) {
                            ErrorManager.INSTANCE.addError(CATEGORY, "Modifying %s: %s".formatted(id, e.getMessage()));
                        }
                    }
                    reader.close();
                }
                catch (Exception e) {
                    try {
                        ErrorManager.INSTANCE.addFatalError(CATEGORY, "An error occurred while reading configure-mobsoultypes.json.", e);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(reader);
                        throw throwable;
                    }
                    IOUtils.closeQuietly((Reader)reader);
                    break block16;
                }
                IOUtils.closeQuietly((Reader)reader);
                break block16;
            }
            try (FileWriter writer = new FileWriter(file);){
                JsonObject object = new JsonObject();
                GSON.toJson((JsonElement)object, (Appendable)writer);
            }
            catch (IOException e) {
                MysticalCustomization.LOGGER.error("An error occurred while creating configure-mobsoultypes.json", (Throwable)e);
            }
        }
        ENTITY_ADDITIONS_MAP.forEach((type, entities) -> {
            for (ResourceLocation entity : entities) {
                boolean success = registry.addEntityTo(type, entity);
                if (success) continue;
                ErrorManager.INSTANCE.addError(CATEGORY, "Modifying %s: Could not add entity %s, maybe it's already in use?".formatted(type.getId(), entity));
            }
        });
    }
}

