/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.dyenamics.client.util;

import cy.jdkdigital.dyenamics.common.cap.DyenamicSwagProvider;
import cy.jdkdigital.dyenamics.common.network.PacketHandler;
import cy.jdkdigital.dyenamics.core.init.BlockInit;
import cy.jdkdigital.dyenamics.core.init.EntityInit;
import cy.jdkdigital.dyenamics.core.init.ItemInit;
import cy.jdkdigital.dyenamics.core.util.DyenamicDyeColor;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD, modid="dyenamics")
public class ModEventHandler {
    @SubscribeEvent
    public static void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(EntityInit::setup);
        PacketHandler.register();
        for (DyenamicDyeColor color : DyenamicDyeColor.dyenamicValues()) {
            Map<String, RegistryObject<Block>> blocks = BlockInit.DYED_BLOCKS.get(color.m_7912_());
            CauldronInteraction.f_175607_.put(((Block)blocks.get("banner").get()).m_5456_(), CauldronInteraction.f_175614_);
        }
    }

    @SubscribeEvent
    public static void onEntityAttributeCreate(EntityAttributeCreationEvent event) {
        event.put((EntityType)EntityInit.SHEEP.get(), Sheep.m_29873_().m_22265_());
    }

    @SubscribeEvent
    public static void tabContents(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey().equals((Object)CreativeModeTabs.f_256968_)) {
            ItemInit.DYE_ITEMS.forEach((s, registryObject) -> event.m_246326_((ItemLike)registryObject.get()));
        }
        for (DyenamicDyeColor color : DyenamicDyeColor.dyenamicValues()) {
            Map<String, RegistryObject<Block>> blocks = BlockInit.DYED_BLOCKS.get(color.m_7912_());
            if (event.getTabKey().equals((Object)CreativeModeTabs.f_256725_)) {
                event.accept((Supplier)blocks.get("terracotta"));
                event.accept((Supplier)blocks.get("glazed_terracotta"));
                event.accept((Supplier)blocks.get("concrete"));
                event.accept((Supplier)blocks.get("concrete_powder"));
                event.accept((Supplier)blocks.get("wool"));
                event.accept((Supplier)blocks.get("stained_glass"));
                event.accept((Supplier)blocks.get("stained_glass_pane"));
                if (ModList.get().isLoaded("thermal")) {
                    event.accept((Supplier)blocks.get("rockwool"));
                }
                event.accept((Supplier)blocks.get("carpet"));
            }
            if (!event.getTabKey().equals((Object)CreativeModeTabs.f_256725_) && !event.getTabKey().equals((Object)CreativeModeTabs.f_256791_)) continue;
            event.accept((Supplier)blocks.get("candle"));
            event.accept((Supplier)blocks.get("bed"));
            event.accept((Supplier)blocks.get("shulker_box"));
            event.accept((Supplier)blocks.get("banner"));
        }
    }

    @SubscribeEvent
    public static void registerCap(RegisterCapabilitiesEvent event) {
        event.register(DyenamicSwagProvider.class);
    }
}

