/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.network.diagnostics.http;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import org.apache.logging.log4j.Level;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.core.network.diagnostics.http.DiagnosticsWebServerInitializer;

public class DiagnosticsWebServer {
    private final int port;
    private EventLoopGroup bossGroup;
    private EventLoopGroup workerGroup;
    private Channel channel;

    public DiagnosticsWebServer(int port) {
        this.port = port;
    }

    public int getPort() {
        return this.port;
    }

    public String getUrl() {
        return String.format("http://localhost:%s/", this.getPort());
    }

    public Channel getChannel() {
        return this.channel;
    }

    public void initialize() {
        IntegratedDynamics.clog(Level.INFO, "Starting local Integrated Dynamics network diagnostics server...");
        this.bossGroup = new NioEventLoopGroup(1);
        this.workerGroup = new NioEventLoopGroup();
        ServerBootstrap b = new ServerBootstrap();
        ((ServerBootstrap)b.group(this.bossGroup, this.workerGroup).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)new DiagnosticsWebServerInitializer());
        try {
            this.channel = b.bind(this.port).sync().channel();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        IntegratedDynamics.clog(Level.INFO, "Started local Integrated Dynamics network diagnostics server on http://localhost:" + this.port + "/");
    }

    public void deinitialize() {
        IntegratedDynamics.clog(Level.INFO, "Stopping local Integrated Dynamics network diagnostics server...");
        if (this.bossGroup != null && this.workerGroup != null) {
            try {
                this.bossGroup.shutdownGracefully().sync();
                this.workerGroup.shutdownGracefully().sync();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        IntegratedDynamics.clog(Level.INFO, "Stopped local Integrated Dynamics network diagnostics server");
    }
}

