/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.network;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import it.unimi.dsi.fastutil.objects.Object2IntAVLTreeMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityDispatcher;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.eventbus.api.Event;
import org.cyclops.cyclopscore.datastructure.DimPos;
import org.cyclops.cyclopscore.helper.BlockEntityHelpers;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.api.PartStateException;
import org.cyclops.integrateddynamics.api.network.AttachCapabilitiesEventNetwork;
import org.cyclops.integrateddynamics.api.network.IEventListenableNetworkElement;
import org.cyclops.integrateddynamics.api.network.IFullNetworkListener;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.api.network.INetworkElement;
import org.cyclops.integrateddynamics.api.network.INetworkElementProvider;
import org.cyclops.integrateddynamics.api.network.event.INetworkEvent;
import org.cyclops.integrateddynamics.api.network.event.INetworkEventBus;
import org.cyclops.integrateddynamics.api.path.IPathElement;
import org.cyclops.integrateddynamics.api.path.ISidedPathElement;
import org.cyclops.integrateddynamics.capability.network.NetworkCarrierConfig;
import org.cyclops.integrateddynamics.capability.networkelementprovider.NetworkElementProviderConfig;
import org.cyclops.integrateddynamics.capability.path.SidedPathElement;
import org.cyclops.integrateddynamics.core.network.diagnostics.NetworkDiagnostics;
import org.cyclops.integrateddynamics.core.network.event.NetworkElementAddEvent;
import org.cyclops.integrateddynamics.core.network.event.NetworkElementRemoveEvent;
import org.cyclops.integrateddynamics.core.network.event.NetworkEventBus;
import org.cyclops.integrateddynamics.core.network.event.VariableContentsUpdatedEvent;
import org.cyclops.integrateddynamics.core.path.Cluster;
import org.cyclops.integrateddynamics.core.path.PathFinder;
import org.cyclops.integrateddynamics.core.persist.world.NetworkWorldStorage;

public class Network
implements INetwork {
    private Cluster baseCluster;
    private final INetworkEventBus eventBus = new NetworkEventBus();
    private final TreeSet<INetworkElement> elements = Sets.newTreeSet();
    private Object2IntMap<INetworkElement> updateableElementsTicks = null;
    private TreeSet<INetworkElement> invalidatedElements = Sets.newTreeSet();
    private Map<INetworkElement, Long> lastSecondDurations = Maps.newHashMap();
    private final CapabilityDispatcher capabilityDispatcher;
    private IFullNetworkListener[] fullNetworkListeners;
    private CompoundTag toRead = null;
    private volatile boolean changed = false;
    private volatile boolean killed = false;
    private boolean crashed = false;

    public static Network initiateNetworkSetup(ISidedPathElement sidedPathElement) {
        Network network = new Network(PathFinder.getConnectedCluster(sidedPathElement));
        NetworkWorldStorage.getInstance((ModBase)IntegratedDynamics._instance).addNewNetwork(network);
        return network;
    }

    public static boolean areNetworksEqual(Network networkA, Network networkB) {
        return networkA.elements.containsAll(networkB.elements) && networkA.elements.size() == networkB.elements.size();
    }

    public Network() {
        this.baseCluster = new Cluster();
        this.capabilityDispatcher = this.gatherCapabilities();
        this.onConstruct();
    }

    public Network(Cluster pathElements) {
        this.baseCluster = pathElements;
        this.capabilityDispatcher = this.gatherCapabilities();
        this.onConstruct();
        this.deriveNetworkElements(this.baseCluster);
    }

    protected CapabilityDispatcher gatherCapabilities() {
        AttachCapabilitiesEventNetwork event = new AttachCapabilitiesEventNetwork(this);
        MinecraftForge.EVENT_BUS.post((Event)event);
        List<IFullNetworkListener> listeners = event.getFullNetworkListeners();
        this.fullNetworkListeners = listeners.toArray(new IFullNetworkListener[listeners.size()]);
        return event.getCapabilities().size() > 0 ? new CapabilityDispatcher(event.getCapabilities(), event.getListeners()) : null;
    }

    protected IFullNetworkListener[] gatherFullNetworkListeners() {
        ArrayList listeners = Lists.newArrayList();
        return listeners.toArray(new IFullNetworkListener[listeners.size()]);
    }

    protected void onConstruct() {
    }

    private void deriveNetworkElements(Cluster pathElements) {
        if (!this.killIfEmpty()) {
            for (ISidedPathElement sidedPathElement : pathElements) {
                Level world = sidedPathElement.getPathElement().getPosition().getLevel(true);
                BlockPos pos = sidedPathElement.getPathElement().getPosition().getBlockPos();
                Direction side = sidedPathElement.getSide();
                BlockEntityHelpers.getCapability((BlockGetter)world, (BlockPos)pos, (Direction)side, NetworkCarrierConfig.CAPABILITY).ifPresent(networkCarrier -> {
                    INetwork network = networkCarrier.getNetwork();
                    if (network != null) {
                        network.removePathElement(sidedPathElement.getPathElement(), side);
                    }
                    networkCarrier.setNetwork(null);
                    networkCarrier.setNetwork(this);
                });
                BlockEntityHelpers.getCapability((BlockGetter)world, (BlockPos)pos, (Direction)side, NetworkElementProviderConfig.CAPABILITY).ifPresent(networkElementProvider -> {
                    for (INetworkElement element : networkElementProvider.createNetworkElements(world, pos)) {
                        this.addNetworkElement(element, true);
                    }
                });
            }
            this.onNetworkChanged();
        }
    }

    @Override
    public boolean isInitialized() {
        return this.updateableElementsTicks != null;
    }

    @Override
    public INetworkEventBus getEventBus() {
        return this.eventBus;
    }

    public void initialize() {
        this.initialize(false);
    }

    public boolean equals(Object object) {
        return object instanceof Network && Network.areNetworksEqual(this, (Network)object);
    }

    public CompoundTag toNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128365_("baseCluster", (Tag)this.baseCluster.toNBT());
        tag.m_128379_("crashed", this.crashed);
        if (this.capabilityDispatcher != null) {
            tag.m_128365_("ForgeCaps", (Tag)this.capabilityDispatcher.serializeNBT());
        }
        return tag;
    }

    public void fromNBT(CompoundTag tag) {
        this.toRead = tag;
    }

    public void fromNBTEffective(CompoundTag tag) {
        this.baseCluster.fromNBT(tag.m_128469_("baseCluster"));
        this.crashed = tag.m_128471_("crashed");
        if (this.capabilityDispatcher != null && tag.m_128441_("ForgeCaps")) {
            this.capabilityDispatcher.deserializeNBT(tag.m_128469_("ForgeCaps"));
        }
        this.deriveNetworkElements(this.baseCluster);
        this.initialize(true);
    }

    @Override
    public synchronized boolean addNetworkElement(INetworkElement element, boolean networkPreinit) {
        for (IFullNetworkListener fullNetworkListener : this.fullNetworkListeners) {
            if (fullNetworkListener.addNetworkElement(element, networkPreinit)) continue;
            return false;
        }
        if (this.getEventBus().postCancelable(new NetworkElementAddEvent.Pre(this, element))) {
            this.elements.add(element);
            if (!element.onNetworkAddition(this)) {
                this.elements.remove(element);
                return false;
            }
            if (!networkPreinit) {
                this.addNetworkElementUpdateable(element);
            }
            if (element instanceof IEventListenableNetworkElement) {
                IEventListenableNetworkElement listenableElement = (IEventListenableNetworkElement)element;
                listenableElement.getNetworkEventListener().ifPresent(listener -> {
                    if (listener.hasEventSubscriptions()) {
                        for (Class<INetworkEvent> eventType : listener.getSubscribedEvents()) {
                            this.getEventBus().register(listenableElement, eventType);
                        }
                    }
                });
            }
            this.getEventBus().post(new NetworkElementAddEvent.Post(this, element));
            this.onNetworkChanged();
            return true;
        }
        return false;
    }

    @Override
    public void addNetworkElementUpdateable(INetworkElement element) {
        if (element.isUpdate()) {
            this.updateableElementsTicks.put((Object)element, 0);
        }
    }

    @Override
    public boolean removeNetworkElementPre(INetworkElement element) {
        for (IFullNetworkListener fullNetworkListener : this.fullNetworkListeners) {
            if (fullNetworkListener.removeNetworkElementPre(element)) continue;
            return false;
        }
        return this.getEventBus().postCancelable(new NetworkElementRemoveEvent.Pre(this, element));
    }

    @Override
    public synchronized void setPriorityAndChannel(INetworkElement element, int priority, int channel) {
        this.elements.remove(element);
        int oldTickValue = this.updateableElementsTicks.defaultReturnValue();
        if (element.isUpdate()) {
            oldTickValue = this.updateableElementsTicks.removeInt((Object)element);
        }
        element.setPriorityAndChannel(this, priority, channel);
        this.elements.add(element);
        if (element.isUpdate()) {
            this.updateableElementsTicks.put((Object)element, oldTickValue == this.updateableElementsTicks.defaultReturnValue() ? element.getUpdateInterval() : oldTickValue);
        }
    }

    @Override
    public void removeNetworkElementPost(INetworkElement element) {
        for (IFullNetworkListener fullNetworkListener : this.fullNetworkListeners) {
            fullNetworkListener.removeNetworkElementPost(element);
        }
        if (element instanceof IEventListenableNetworkElement) {
            IEventListenableNetworkElement listenableElement = (IEventListenableNetworkElement)element;
            listenableElement.getNetworkEventListener().ifPresent(listener -> {
                if (listener.hasEventSubscriptions()) {
                    this.getEventBus().unregister(listenableElement);
                }
            });
        }
        element.beforeNetworkKill(this);
        element.onNetworkRemoval(this);
        this.elements.remove(element);
        this.removeNetworkElementUpdateable(element);
        this.invalidatedElements.remove(element);
        this.getEventBus().post(new NetworkElementRemoveEvent.Post(this, element));
        this.onNetworkChanged();
    }

    @Override
    public synchronized void removeNetworkElementUpdateable(INetworkElement element) {
        if (this.isInitialized()) {
            this.updateableElementsTicks.removeInt((Object)element);
        }
    }

    protected void initialize(boolean silent) {
        this.updateableElementsTicks = new Object2IntAVLTreeMap();
        this.updateableElementsTicks.defaultReturnValue(Integer.MIN_VALUE);
        for (INetworkElement element : this.elements) {
            this.addNetworkElementUpdateable(element);
            if (!silent) {
                element.afterNetworkAlive(this);
            }
            element.afterNetworkReAlive(this);
        }
        this.getEventBus().post(new VariableContentsUpdatedEvent(this));
    }

    @Override
    public void kill() {
        for (IFullNetworkListener fullNetworkListener : this.fullNetworkListeners) {
            fullNetworkListener.kill();
        }
        for (INetworkElement element : this.elements) {
            element.beforeNetworkKill(this);
        }
        this.killed = true;
    }

    @Override
    public boolean killIfEmpty() {
        if (this.baseCluster.isEmpty()) {
            this.kill();
            this.onNetworkChanged();
            return true;
        }
        return false;
    }

    @Override
    public boolean canUpdate(INetworkElement element) {
        for (IFullNetworkListener fullNetworkListener : this.fullNetworkListeners) {
            if (fullNetworkListener.canUpdate(element)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void postUpdate(INetworkElement element) {
        for (IFullNetworkListener fullNetworkListener : this.fullNetworkListeners) {
            fullNetworkListener.postUpdate(element);
        }
    }

    @Override
    public void onSkipUpdate(INetworkElement element) {
        for (IFullNetworkListener fullNetworkListener : this.fullNetworkListeners) {
            fullNetworkListener.onSkipUpdate(element);
        }
    }

    @Override
    public void updateGuaranteed() {
        if (this.toRead != null) {
            this.fromNBTEffective(this.toRead);
            this.toRead = null;
        }
    }

    @Override
    public final synchronized void update() {
        this.changed = false;
        if (this.killIfEmpty() || this.killed) {
            NetworkWorldStorage.getInstance((ModBase)IntegratedDynamics._instance).removeInvalidatedNetwork(this);
        } else {
            this.onUpdate();
            boolean isBeingDiagnozed = NetworkDiagnostics.getInstance().isBeingDiagnozed();
            if (!isBeingDiagnozed && !this.lastSecondDurations.isEmpty()) {
                this.lastSecondDurations.clear();
            }
            for (Object2IntMap.Entry entry : this.updateableElementsTicks.object2IntEntrySet()) {
                INetworkElement element = (INetworkElement)entry.getKey();
                try {
                    if (!this.isValid(element)) continue;
                    long startTime = 0L;
                    if (isBeingDiagnozed) {
                        startTime = System.nanoTime();
                    }
                    int lastElementTick = entry.getIntValue();
                    if (this.canUpdate(element)) {
                        if (lastElementTick <= 0) {
                            entry.setValue(element.getUpdateInterval() - 1);
                            element.update(this);
                            this.postUpdate(element);
                        } else {
                            entry.setValue(lastElementTick - 1);
                        }
                    } else {
                        this.onSkipUpdate(element);
                        entry.setValue(lastElementTick - 1);
                    }
                    if (!isBeingDiagnozed) continue;
                    long duration = System.nanoTime() - startTime;
                    Long lastDuration = this.lastSecondDurations.get(element);
                    if (lastDuration != null) {
                        duration += lastDuration.longValue();
                    }
                    this.lastSecondDurations.put(element, duration);
                }
                catch (PartStateException e) {
                    IntegratedDynamics.clog(org.apache.logging.log4j.Level.WARN, "Attempted to tick a part that was not properly unloaded. Report this to the Integrated Dynamics issue tracker with details on what you did leading up to this stacktrace. The part was forcefully unloaded");
                    e.printStackTrace();
                    element.invalidate(this);
                }
            }
        }
    }

    protected void onUpdate() {
        for (IFullNetworkListener fullNetworkListener : this.fullNetworkListeners) {
            fullNetworkListener.update();
        }
    }

    @Override
    public synchronized boolean removePathElement(IPathElement pathElement, Direction side) {
        for (IFullNetworkListener fullNetworkListener : this.fullNetworkListeners) {
            if (fullNetworkListener.removePathElement(pathElement, side)) continue;
            return false;
        }
        if (this.baseCluster.remove(SidedPathElement.of(pathElement, null))) {
            DimPos position = pathElement.getPosition();
            INetworkElementProvider networkElementProvider = (INetworkElementProvider)BlockEntityHelpers.getCapability((DimPos)position, (Direction)side, NetworkElementProviderConfig.CAPABILITY).orElse(null);
            if (networkElementProvider != null) {
                Collection<INetworkElement> networkElements = networkElementProvider.createNetworkElements(position.getLevel(true), position.getBlockPos());
                for (INetworkElement networkElement : networkElements) {
                    if (this.removeNetworkElementPre(networkElement)) continue;
                    return false;
                }
                for (INetworkElement networkElement : networkElements) {
                    this.removeNetworkElementPost(networkElement);
                }
                this.onNetworkChanged();
                return true;
            }
        } else {
            Thread.dumpStack();
            IntegratedDynamics.clog(org.apache.logging.log4j.Level.WARN, "Tried to remove a path element from a network it was not present in.");
            System.out.println("Cluster: " + this.baseCluster);
            System.out.println("Tried removing element: " + pathElement);
        }
        return false;
    }

    @Override
    public void afterServerLoad() {
        for (IFullNetworkListener fullNetworkListener : this.fullNetworkListeners) {
            fullNetworkListener.afterServerLoad();
        }
        for (INetworkElement element : this.getElements()) {
            this.invalidateElement(element);
        }
    }

    @Override
    public void beforeServerStop() {
        for (IFullNetworkListener fullNetworkListener : this.fullNetworkListeners) {
            fullNetworkListener.beforeServerStop();
        }
    }

    @Override
    public Set<INetworkElement> getElements() {
        return this.elements;
    }

    @Override
    public boolean isKilled() {
        return this.killed;
    }

    protected void onNetworkChanged() {
        this.changed = true;
    }

    @Override
    public boolean hasChanged() {
        return this.changed;
    }

    @Override
    public int getCablesCount() {
        return this.baseCluster.size();
    }

    @Override
    public long getLastSecondDuration(INetworkElement networkElement) {
        Long duration = this.lastSecondDurations.get(networkElement);
        return duration == null ? 0L : duration;
    }

    @Override
    public void resetLastSecondDurations() {
        this.lastSecondDurations.clear();
    }

    @Override
    public boolean isCrashed() {
        return this.crashed;
    }

    @Override
    public void setCrashed(boolean crashed) {
        this.crashed = crashed;
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> capability) {
        return this.capabilityDispatcher == null ? null : this.capabilityDispatcher.getCapability(capability, null);
    }

    @Override
    public void invalidateElement(INetworkElement element) {
        for (IFullNetworkListener fullNetworkListener : this.fullNetworkListeners) {
            fullNetworkListener.invalidateElement(element);
        }
        this.invalidatedElements.add(element);
    }

    @Override
    public void revalidateElement(INetworkElement element) {
        for (IFullNetworkListener fullNetworkListener : this.fullNetworkListeners) {
            fullNetworkListener.revalidateElement(element);
        }
        this.invalidatedElements.remove(element);
    }

    @Override
    public boolean containsSidedPathElement(ISidedPathElement pathElement) {
        return this.baseCluster.contains(pathElement);
    }

    @Override
    public IFullNetworkListener[] getFullNetworkListeners() {
        return this.fullNetworkListeners;
    }

    protected boolean isValid(INetworkElement element) {
        if (this.invalidatedElements.contains(element)) {
            if (element.canRevalidate(this)) {
                element.revalidate(this);
                return true;
            }
            return false;
        }
        return true;
    }
}

