/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.item;

import java.util.Arrays;
import java.util.List;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.data.ModelData;
import org.cyclops.cyclopscore.datastructure.Wrapper;
import org.cyclops.integrateddynamics.api.client.model.IVariableModelBaked;
import org.cyclops.integrateddynamics.api.evaluate.expression.IExpression;
import org.cyclops.integrateddynamics.api.evaluate.operator.IOperator;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.evaluate.variable.IVariable;
import org.cyclops.integrateddynamics.api.item.IOperatorVariableFacade;
import org.cyclops.integrateddynamics.api.item.IVariableFacade;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.api.network.IPartNetwork;
import org.cyclops.integrateddynamics.core.client.model.VariableModelProviders;
import org.cyclops.integrateddynamics.core.evaluate.expression.LazyExpression;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueHelpers;
import org.cyclops.integrateddynamics.core.item.VariableFacadeBase;

public class OperatorVariableFacade
extends VariableFacadeBase
implements IOperatorVariableFacade {
    private final IOperator operator;
    private final int[] variableIds;
    private IExpression expression = null;
    private int lastNetworkHash = -1;
    private final boolean[] validatingVariables;
    private final boolean[] variables;

    public OperatorVariableFacade(boolean generateId, IOperator operator, int[] variableIds) {
        super(generateId);
        this.operator = operator;
        this.variableIds = variableIds;
        this.validatingVariables = this.variableIds != null ? new boolean[this.variableIds.length] : null;
        this.variables = this.variableIds != null ? new boolean[this.variableIds.length] : null;
    }

    public OperatorVariableFacade(int id, IOperator operator, int[] variableIds) {
        super(id);
        this.operator = operator;
        this.variableIds = variableIds;
        this.validatingVariables = this.variableIds != null ? new boolean[this.variableIds.length] : null;
        this.variables = this.variableIds != null ? new boolean[this.variableIds.length] : null;
    }

    @Override
    public <V extends IValue> IVariable<V> getVariable(INetwork network, IPartNetwork partNetwork) {
        if (this.isValid()) {
            int newNetworkHash;
            int n = newNetworkHash = network != null ? network.hashCode() : -1;
            if (this.expression == null || this.expression.hasErrored() || newNetworkHash != this.lastNetworkHash) {
                this.lastNetworkHash = newNetworkHash;
                IVariable[] variables = new IVariable[this.variableIds.length];
                for (int i = 0; i < this.variableIds.length; ++i) {
                    int variableId = this.variableIds[i];
                    if (!partNetwork.hasVariableFacade(variableId)) {
                        return null;
                    }
                    IVariableFacade variableFacade = partNetwork.getVariableFacade(variableId);
                    if (!variableFacade.isValid() || variableFacade == this) {
                        return null;
                    }
                    if (this.variables[i]) {
                        return null;
                    }
                    this.variables[i] = true;
                    variables[i] = variableFacade.getVariable(network, partNetwork);
                    this.variables[i] = false;
                    if (variables[i] != null) continue;
                    return null;
                }
                this.expression = new LazyExpression(this.getId(), this.operator, variables, partNetwork);
            }
            return this.expression;
        }
        return null;
    }

    @Override
    public boolean isValid() {
        return this.getVariableIds() != null && this.getOperator() != null;
    }

    @Override
    public void validate(INetwork network, IPartNetwork partNetwork, final IVariableFacade.IValidator validator, IValueType containingValueType) {
        if (!this.isValid()) {
            validator.addError(Component.m_237115_((String)"variable.integrateddynamics.error.invalid_item"));
        } else {
            IValueType[] valueTypes = new IValueType[this.variableIds.length];
            IVariable[] variables = new IVariable[this.variableIds.length];
            boolean checkFurther = true;
            for (int i = 0; i < this.variableIds.length; ++i) {
                int variableId = this.variableIds[i];
                if (variableId < 0) {
                    validator.addError(Component.m_237115_((String)"variable.integrateddynamics.error.invalid_item"));
                    checkFurther = false;
                    continue;
                }
                if (!partNetwork.hasVariableFacade(variableId)) {
                    validator.addError(Component.m_237110_((String)"operator.integrateddynamics.error.variable_not_in_network", (Object[])new Object[]{Integer.toString(variableId)}));
                    checkFurther = false;
                    continue;
                }
                IVariableFacade variableFacade = partNetwork.getVariableFacade(variableId);
                if (variableFacade == this) {
                    validator.addError(Component.m_237110_((String)"operator.integrateddynamics.error.cyclic_reference", (Object[])new Object[]{Integer.toString(variableId)}));
                    checkFurther = false;
                    continue;
                }
                if (variableFacade == null) continue;
                IValueType valueType = this.getOperator().getInputTypes()[i];
                final Wrapper isValid = new Wrapper((Object)true);
                if (this.validatingVariables[i]) {
                    validator.addError(Component.m_237110_((String)"operator.integrateddynamics.error.cyclic_reference", (Object[])new Object[]{this.getId()}));
                    checkFurther = false;
                    break;
                }
                this.validatingVariables[i] = true;
                variableFacade.validate(network, partNetwork, new IVariableFacade.IValidator(){

                    @Override
                    public void addError(MutableComponent error) {
                        validator.addError(error);
                        isValid.set((Object)false);
                    }
                }, valueType);
                this.validatingVariables[i] = false;
                if (((Boolean)isValid.get()).booleanValue()) {
                    IVariable variable = variableFacade.getVariable(network, partNetwork);
                    if (variable == null) continue;
                    variables[i] = variable;
                    valueTypes[i] = variable.getType();
                    continue;
                }
                checkFurther = false;
            }
            if (checkFurther) {
                IValueType outputType;
                IOperator op = this.getOperator();
                MutableComponent error = op.validateTypes(valueTypes);
                if (error != null) {
                    validator.addError(error);
                }
                if (!ValueHelpers.correspondsTo(outputType = op.getConditionalOutputType(variables), containingValueType)) {
                    validator.addError(Component.m_237110_((String)"aspect.integrateddynamics.error.invalid_type", (Object[])new Object[]{Component.m_237115_((String)containingValueType.getTranslationKey()), Component.m_237115_((String)outputType.getTranslationKey())}));
                }
            }
        }
    }

    @Override
    public IValueType getOutputType() {
        IOperator operator = this.getOperator();
        if (operator == null) {
            return null;
        }
        return operator.getOutputType();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(List<Component> list, Level world) {
        if (this.isValid()) {
            this.getOperator().loadTooltip(list, false);
            StringBuilder sb = new StringBuilder();
            sb.append("{");
            boolean first = true;
            for (int variableId : this.getVariableIds()) {
                if (!first) {
                    sb.append(",");
                }
                sb.append(this.getReferenceDisplay(variableId));
                first = false;
            }
            sb.append("}");
            list.add((Component)Component.m_237110_((String)"operator.integrateddynamics.tooltip.variable_ids", (Object[])new Object[]{sb.toString()}));
        }
        super.appendHoverText(list, world);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void addModelOverlay(IVariableModelBaked variableModelBaked, List<BakedQuad> quads, RandomSource random, ModelData modelData) {
        if (this.isValid()) {
            IValueType valueType = this.getOperator().getOutputType();
            BakedModel bakedModel = variableModelBaked.getSubModels(VariableModelProviders.VALUETYPE).getBakedModels().get(valueType);
            if (bakedModel != null) {
                quads.addAll(bakedModel.getQuads(null, null, random, modelData, null));
            }
        }
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OperatorVariableFacade)) {
            return false;
        }
        OperatorVariableFacade other = (OperatorVariableFacade)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getLastNetworkHash() != other.getLastNetworkHash()) {
            return false;
        }
        IOperator this$operator = this.getOperator();
        IOperator other$operator = other.getOperator();
        if (this$operator == null ? other$operator != null : !this$operator.equals(other$operator)) {
            return false;
        }
        if (!Arrays.equals(this.getVariableIds(), other.getVariableIds())) {
            return false;
        }
        IExpression this$expression = this.getExpression();
        IExpression other$expression = other.getExpression();
        if (this$expression == null ? other$expression != null : !this$expression.equals(other$expression)) {
            return false;
        }
        if (!Arrays.equals(this.getValidatingVariables(), other.getValidatingVariables())) {
            return false;
        }
        return Arrays.equals(this.getVariables(), other.getVariables());
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof OperatorVariableFacade;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getLastNetworkHash();
        IOperator $operator = this.getOperator();
        result = result * 59 + ($operator == null ? 43 : $operator.hashCode());
        result = result * 59 + Arrays.hashCode(this.getVariableIds());
        IExpression $expression = this.getExpression();
        result = result * 59 + ($expression == null ? 43 : $expression.hashCode());
        result = result * 59 + Arrays.hashCode(this.getValidatingVariables());
        result = result * 59 + Arrays.hashCode(this.getVariables());
        return result;
    }

    @Override
    public IOperator getOperator() {
        return this.operator;
    }

    @Override
    public int[] getVariableIds() {
        return this.variableIds;
    }

    @Override
    public IExpression getExpression() {
        return this.expression;
    }

    public int getLastNetworkHash() {
        return this.lastNetworkHash;
    }

    public boolean[] getValidatingVariables() {
        return this.validatingVariables;
    }

    public boolean[] getVariables() {
        return this.variables;
    }

    public void setExpression(IExpression expression) {
        this.expression = expression;
    }

    public void setLastNetworkHash(int lastNetworkHash) {
        this.lastNetworkHash = lastNetworkHash;
    }

    @Override
    public String toString() {
        return "OperatorVariableFacade(operator=" + this.getOperator() + ", variableIds=" + Arrays.toString(this.getVariableIds()) + ", expression=" + this.getExpression() + ", lastNetworkHash=" + this.getLastNetworkHash() + ", validatingVariables=" + Arrays.toString(this.getValidatingVariables()) + ", variables=" + Arrays.toString(this.getVariables()) + ")";
    }
}

