/*
 * Decompiled with CFR 0.152.
 */
package net.permutated.pylons.machines.infusion;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.permutated.pylons.ModRegistry;
import net.permutated.pylons.item.PotionFilterCard;
import net.permutated.pylons.machines.base.AbstractPylonTile;
import net.permutated.pylons.util.ChunkManager;

public class InfusionPylonTile
extends AbstractPylonTile {
    public InfusionPylonTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModRegistry.INFUSION_PYLON_TILE.get(), pos, state);
    }

    @Override
    protected boolean isItemValid(ItemStack stack) {
        return stack.m_41720_() instanceof PotionFilterCard;
    }

    @Override
    public void tick() {
        ServerPlayer player;
        MinecraftServer server;
        if (this.f_58857_ != null && !this.f_58857_.f_46443_ && this.canTick(60) && this.owner != null && (server = this.f_58857_.m_7654_()) != null && (player = server.m_6846_().m_11259_(this.owner)) != null && player.m_5801_()) {
            ChunkManager.loadChunk(this.owner, (ServerLevel)this.f_58857_, this.m_58899_());
            for (MobEffectInstance effect : this.getEffects()) {
                player.m_7292_(effect);
            }
        }
    }

    public List<MobEffectInstance> getEffects() {
        ArrayList<MobEffectInstance> effects = new ArrayList<MobEffectInstance>();
        for (int i = 0; i < this.itemStackHandler.getSlots(); ++i) {
            ItemStack stack = this.itemStackHandler.getStackInSlot(i);
            if (stack.m_41619_() || !(stack.m_41720_() instanceof PotionFilterCard) || !PotionFilterCard.isAllowed(stack)) continue;
            MobEffect effect = PotionFilterCard.getEffect(stack);
            int duration = PotionFilterCard.getDuration(stack);
            int amplifier = PotionFilterCard.getAmplifier(stack);
            if (duration < PotionFilterCard.getRequiredDuration() || effect == null) continue;
            effects.add(new MobEffectInstance(effect, PotionFilterCard.getAppliedDuration(), amplifier, true, false));
        }
        return effects;
    }
}

