/*
 * Decompiled with CFR 0.152.
 */
package dev.uncandango.alltheleaks.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.uncandango.alltheleaks.AllTheLeaks;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import net.minecraft.util.GsonHelper;
import net.minecraftforge.fml.loading.FMLPaths;

public class ATLProperties {
    private static final Gson GSON = new GsonBuilder().setLenient().setPrettyPrinting().disableHtmlEscaping().serializeNulls().create();
    private static final Path path = FMLPaths.CONFIGDIR.get().resolve("alltheleaks.json");
    private JsonObject properties;
    private static final JsonElement defaultProperties = ATLProperties.getDefaultProperties();
    private static ATLProperties INSTANCE;
    public boolean preventSearchIgnoredItems;
    public boolean ingredientDedupe;
    public boolean resourceLocationDedupe;

    private ATLProperties() {
        this.load();
    }

    public static ATLProperties get() {
        if (INSTANCE == null) {
            INSTANCE = new ATLProperties();
        }
        return INSTANCE;
    }

    private static JsonElement getDefaultProperties() {
        JsonObject properties = new JsonObject();
        properties.addProperty("preventSearchIgnoredItems", Boolean.valueOf(false));
        properties.addProperty("ingredientDedupe", Boolean.valueOf(false));
        properties.addProperty("resourceLocationDedupe", Boolean.valueOf(false));
        return properties;
    }

    public void load() {
        if (!path.toFile().exists()) {
            ATLProperties.save();
        }
        try (BufferedReader reader = Files.newBufferedReader(path);){
            this.properties = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
            this.preventSearchIgnoredItems = GsonHelper.m_13855_((JsonObject)this.properties, (String)"preventSearchIgnoredItems", (boolean)false);
            this.ingredientDedupe = AllTheLeaks.INDEV ? GsonHelper.m_13855_((JsonObject)this.properties, (String)"ingredientDedupe", (boolean)false) : false;
            this.resourceLocationDedupe = GsonHelper.m_13855_((JsonObject)this.properties, (String)"resourceLocationDedupe", (boolean)false);
        }
        catch (IOException e) {
            AllTheLeaks.LOGGER.error("Failed to load config file", (Throwable)e);
            this.properties = new JsonObject();
        }
    }

    public static void save() {
        try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
            GSON.toJson(defaultProperties, (Appendable)writer);
        }
        catch (IOException e) {
            AllTheLeaks.LOGGER.error("Failed to save config file", (Throwable)e);
        }
    }
}

