/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.event;

import com.google.common.collect.ImmutableList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.animal.Cod;
import net.minecraft.world.entity.animal.Pufferfish;
import net.minecraft.world.entity.animal.Rabbit;
import net.minecraft.world.entity.animal.Salmon;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.FireworkRocketItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.Tags;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.furnace.FurnaceFuelBurnTimeEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.item.ICoreItem;
import net.silentchaos512.gear.api.item.ICoreTool;
import net.silentchaos512.gear.api.material.MaterialList;
import net.silentchaos512.gear.api.part.PartDataList;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.api.traits.TraitActionContext;
import net.silentchaos512.gear.gear.part.CompoundPart;
import net.silentchaos512.gear.gear.part.PartData;
import net.silentchaos512.gear.item.CompoundPartItem;
import net.silentchaos512.gear.item.gear.GearArmorItem;
import net.silentchaos512.gear.util.Const;
import net.silentchaos512.gear.util.GearData;
import net.silentchaos512.gear.util.GearHelper;
import net.silentchaos512.gear.util.SynergyUtils;
import net.silentchaos512.gear.util.TextUtil;
import net.silentchaos512.gear.util.TraitHelper;
import net.silentchaos512.lib.advancements.LibTriggers;
import net.silentchaos512.lib.util.EntityHelper;

@Mod.EventBusSubscriber
public final class GearEvents {
    public static final ResourceLocation APPLY_TIP_UPGRADE = SilentGear.getId("apply_tip_upgrade");
    public static final ResourceLocation CRAFTED_WITH_ROUGH_ROD = SilentGear.getId("crafted_with_rough_rod");
    public static final ResourceLocation MAX_DURABILITY = SilentGear.getId("max_durability");
    public static final ResourceLocation REPAIR_FROM_BROKEN = SilentGear.getId("repair_from_broken");
    public static final ResourceLocation UNIQUE_MAIN_PARTS = SilentGear.getId("unique_main_parts");
    public static final ResourceLocation FALL_WITH_MOONWALKER = SilentGear.getId("fall_with_moonwalker");
    private static final Set<UUID> entityAttackedThisTick = new HashSet<UUID>();
    private static final float BURN_TICKS_PER_DURABILITY = 4.0f;
    private static final List<Function<Level, Entity>> JABBERWOCKY_MOBS = ImmutableList.of(world -> new Wolf(EntityType.f_20499_, world), world -> new Cat(EntityType.f_20553_, world), world -> new Rabbit(EntityType.f_20517_, world), world -> new Chicken(EntityType.f_20555_, world), world -> new Cod(EntityType.f_20556_, world), world -> new Salmon(EntityType.f_20519_, world), world -> new Pufferfish(EntityType.f_20516_, world));
    private static final Map<Entity, Vec3> BOUNCE_TICKS = new HashMap<Entity, Vec3>();

    private GearEvents() {
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent events) {
        entityAttackedThisTick.clear();
    }

    @SubscribeEvent
    public static void onAttackEntity(LivingAttackEvent event) {
        LivingEntity attacked = event.getEntity();
        if (attacked == null || attacked.m_9236_().f_46443_ || entityAttackedThisTick.contains(attacked.m_20148_())) {
            return;
        }
        DamageSource source = event.getSource();
        if (source == null || !"player".equals(source.m_19385_())) {
            return;
        }
        Entity attacker = source.m_7639_();
        if (!(attacker instanceof Player)) {
            return;
        }
        Player player = (Player)attacker;
        ItemStack weapon = player.m_21205_();
        if (!(weapon.m_41720_() instanceof ICoreTool)) {
            return;
        }
        float baseDamage = event.getAmount();
        float newDamage = TraitHelper.activateTraits(weapon, baseDamage, (trait, level, value) -> trait.onAttackEntity(new TraitActionContext(player, level, weapon), attacked, value));
        if (Math.abs(newDamage - baseDamage) > 1.0E-4f) {
            event.setCanceled(true);
            entityAttackedThisTick.add(attacked.m_20148_());
            attacked.m_6469_(source, newDamage);
        }
    }

    @SubscribeEvent
    public static void onLivingHurt(LivingHurtEvent event) {
        int chilled;
        int aquatic;
        LivingEntity attacked = event.getEntity();
        DamageSource source = event.getSource();
        if (source == null || !"player".equals(source.m_19385_())) {
            return;
        }
        Entity attacker = source.m_7639_();
        if (!(attacker instanceof Player)) {
            return;
        }
        Player player = (Player)attacker;
        ItemStack weapon = player.m_21205_();
        if (!(weapon.m_41720_() instanceof ICoreTool)) {
            return;
        }
        int adamant = TraitHelper.getTraitLevel(weapon, Const.Traits.ADAMANT);
        if (adamant > 0 && attacked.m_21233_() > 21.0f) {
            event.setAmount(event.getAmount() + (float)(2 * adamant));
        }
        if ((aquatic = TraitHelper.getTraitLevel(weapon, Const.Traits.AQUATIC)) > 0 && attacked.m_6040_()) {
            event.setAmount(event.getAmount() + (float)(2 * aquatic));
        }
        if ((chilled = TraitHelper.getTraitLevel(weapon, Const.Traits.CHILLED)) > 0 && attacked.m_5825_()) {
            event.setAmount(event.getAmount() + (float)(2 * chilled));
        }
    }

    @SubscribeEvent
    public static void onLivingDamage(LivingDamageEvent event) {
        if (event.getEntity() instanceof Player && GearEvents.isFireDamage(event.getSource())) {
            GearEvents.damageFlammableItems(event);
        }
    }

    private static boolean isFireDamage(DamageSource source) {
        return source.m_269533_(DamageTypeTags.f_268745_);
    }

    private static void damageFlammableItems(LivingDamageEvent event) {
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            ItemStack stack = event.getEntity().m_6844_(slot);
            if (!GearHelper.isGear(stack) || !TraitHelper.hasTrait(stack, Const.Traits.FLAMMABLE)) continue;
            GearHelper.attemptDamage(stack, 2, event.getEntity(), slot);
            if (!GearHelper.isBroken(stack)) continue;
            event.getEntity().m_213846_((Component)TextUtil.translate("trait", "flammable.itemDestroyed", stack.m_41786_()));
            event.getEntity().m_21166_(slot);
            stack.m_41774_(1);
        }
    }

    @SubscribeEvent
    public static void onFurnaceFuelBurnTimeEvent(FurnaceFuelBurnTimeEvent event) {
        ItemStack stack = event.getItemStack();
        if (GearHelper.isGear(stack) && TraitHelper.hasTrait(stack, Const.Traits.FLAMMABLE)) {
            float durability = GearData.getStat(stack, GearHelper.getDurabilityStat(stack));
            event.setBurnTime((int)(durability * 4.0f));
        }
    }

    @SubscribeEvent
    public static void onLivingHurtMagicArmor(LivingHurtEvent event) {
        if (event.getSource().m_276093_(DamageTypes.f_268515_)) {
            float magicArmor = GearEvents.getTotalMagicArmor(event.getEntity());
            float scale = 1.0f - GearEvents.getReducedMagicDamageScale(magicArmor);
            event.setAmount(event.getAmount() * scale);
        }
    }

    private static float getTotalMagicArmor(LivingEntity entity) {
        float total = 0.0f;
        for (ItemStack stack : entity.m_6168_()) {
            if (!(stack.m_41720_() instanceof GearArmorItem)) continue;
            total = (float)((double)total + ((GearArmorItem)stack.m_41720_()).getArmorMagicProtection(stack));
        }
        return total;
    }

    private static float getReducedMagicDamageScale(float magicArmor) {
        if (magicArmor > 20.0f) {
            return 0.6f + 0.015f * (magicArmor - 20.0f);
        }
        return 0.03f * magicArmor;
    }

    @SubscribeEvent
    public static void onBreakSpeed(PlayerEvent.BreakSpeed event) {
        BlockState state;
        Player player = event.getEntity();
        ItemStack tool = player.m_21205_();
        if (tool.m_41720_() instanceof ICoreItem && tool.m_41735_(state = event.getState())) {
            int level = TraitHelper.getTraitLevel(tool, Const.Traits.LUSTROUS);
            int light = GearEvents.getLightForLustrousTrait((BlockAndTintGetter)player.m_9236_(), player.m_20183_());
            event.setNewSpeed(event.getNewSpeed() + (float)GearEvents.getLustrousSpeedBonus(level, light));
        }
    }

    public static int getLightForLustrousTrait(BlockAndTintGetter world, BlockPos pos) {
        int blockLight = world.m_45517_(LightLayer.BLOCK, pos);
        int skyLight = world.m_45517_(LightLayer.SKY, pos);
        return Math.max(skyLight, blockLight * 3 / 4);
    }

    public static int getLustrousSpeedBonus(int level, int light) {
        return 4 * level * light / 15;
    }

    @SubscribeEvent
    public static void onXpDrop(LivingExperienceDropEvent event) {
        if (event.getAttackingPlayer() == null) {
            return;
        }
        ItemStack tool = event.getAttackingPlayer().m_21205_();
        if (tool.m_41619_() || !(tool.m_41720_() instanceof ICoreTool)) {
            return;
        }
        int ancientLevel = TraitHelper.getTraitLevel(tool, Const.Traits.ANCIENT);
        if (ancientLevel == 0) {
            return;
        }
        int bonusXp = (int)((float)event.getOriginalExperience() * 0.25f * (float)ancientLevel);
        event.setDroppedExperience(event.getDroppedExperience() + bonusXp);
    }

    @SubscribeEvent
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        if (event.getPlayer() == null) {
            return;
        }
        ItemStack tool = event.getPlayer().m_21205_();
        if (tool.m_41619_() || !(tool.m_41720_() instanceof ICoreTool)) {
            return;
        }
        int ancientLevel = TraitHelper.getTraitLevel(tool, Const.Traits.ANCIENT);
        if (ancientLevel > 0) {
            int bonusXp = (int)((float)event.getExpToDrop() * 0.25f * (float)ancientLevel);
            event.setExpToDrop(event.getExpToDrop() + bonusXp);
        }
        if (TraitHelper.hasTrait(tool, Const.Traits.JABBERWOCKY) && event.getState().m_204336_(Tags.Blocks.ORES_DIAMOND) && EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44985_, (ItemStack)tool) == 0) {
            Entity entity = JABBERWOCKY_MOBS.get(SilentGear.RANDOM.nextInt(JABBERWOCKY_MOBS.size())).apply(event.getPlayer().m_20193_());
            entity.m_6021_((double)event.getPos().m_123341_() + 0.5, (double)event.getPos().m_123342_(), (double)event.getPos().m_123343_() + 0.5);
            EntityHelper.safeSpawn((Entity)entity);
        }
    }

    @SubscribeEvent
    public static void onGearCrafted(PlayerEvent.ItemCraftedEvent event) {
        ItemStack result = event.getCrafting();
        if (GearHelper.isGear(result) && event.getEntity() instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)event.getEntity();
            if (GearData.hasPart(result, PartType.ROD, p -> p.containsMaterial(Const.Materials.WOOD_ROUGH))) {
                LibTriggers.GENERIC_INT.trigger(player, CRAFTED_WITH_ROUGH_ROD, 1);
            }
            int brokenCount = GearData.getBrokenCount(result);
            int repairCount = GearData.getRepairCount(result);
            if (brokenCount > 0 && repairCount > 0) {
                LibTriggers.GENERIC_INT.trigger(player, REPAIR_FROM_BROKEN, brokenCount);
            }
            LibTriggers.GENERIC_INT.trigger(player, MAX_DURABILITY, result.m_41776_());
            PartDataList parts = GearData.getConstructionParts(result);
            if (!parts.getTips().isEmpty()) {
                LibTriggers.GENERIC_INT.trigger(player, APPLY_TIP_UPGRADE, 1);
            }
            LibTriggers.GENERIC_INT.trigger(player, UNIQUE_MAIN_PARTS, GearEvents.getUniqueMainMaterialCount(parts));
        }
    }

    private static int getUniqueMainMaterialCount(PartDataList parts) {
        for (PartData part : parts) {
            if (!(part.get() instanceof CompoundPart) || part.getType() != PartType.MAIN) continue;
            MaterialList materials = CompoundPartItem.getMaterials(part.getItem());
            return SynergyUtils.getUniques(materials).size();
        }
        return 1;
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onLivingDeath(LivingDeathEvent event) {
        Player player;
        Entity killer = event.getSource().m_7639_();
        if (killer instanceof Player && !killer.m_9236_().f_46443_ && TraitHelper.hasTraitEitherHand(player = (Player)killer, Const.Traits.CONFETTI)) {
            for (int i = 0; i < 3; ++i) {
                FireworkRocketEntity rocket = new FireworkRocketEntity(player.m_9236_(), event.getEntity().m_20185_(), event.getEntity().m_20188_(), event.getEntity().m_20189_(), GearEvents.createRandomFirework());
                EntityHelper.safeSpawn((Entity)rocket);
            }
        }
    }

    private static ItemStack createRandomFirework() {
        ItemStack ret = new ItemStack((ItemLike)Items.f_42688_);
        CompoundTag nbt = ret.m_41698_("Fireworks");
        nbt.m_128344_("Flight", (byte)(SilentGear.RANDOM.nextInt(3) + 1));
        CompoundTag explosion = new CompoundTag();
        explosion.m_128344_("Type", (byte)SilentGear.RANDOM.nextInt(FireworkRocketItem.Shape.values().length));
        ListTag colors = new ListTag();
        for (int i = 0; i < SilentGear.RANDOM.nextInt(4) + 1; ++i) {
            DyeColor dye = DyeColor.values()[SilentGear.RANDOM.nextInt(DyeColor.values().length)];
            SilentGear.LOGGER.debug((Object)dye);
            colors.add((Object)IntTag.m_128679_((int)dye.m_41070_()));
        }
        explosion.m_128365_("Colors", (Tag)colors);
        ListTag explosions = new ListTag();
        explosions.add((Object)explosion);
        nbt.m_128365_("Explosions", (Tag)explosions);
        return ret;
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (!event.player.m_9236_().f_46443_ && event.phase == TickEvent.Phase.START) {
            int magnetic = Math.max(TraitHelper.getHighestLevelEitherHand(event.player, Const.Traits.MAGNETIC), TraitHelper.getHighestLevelCurio((LivingEntity)event.player, Const.Traits.MAGNETIC));
            if (magnetic > 0) {
                GearEvents.tickMagnetic(event.player, magnetic);
            }
            if (!event.player.m_204029_(FluidTags.f_13131_) && TraitHelper.hasTrait(event.player.m_6844_(EquipmentSlot.HEAD), Const.Traits.TURTLE)) {
                event.player.m_7292_(new MobEffectInstance(MobEffects.f_19608_, 210, 0, false, false, true));
            }
            if (event.player.m_20186_() < -64.0 && TraitHelper.hasTraitArmor(event.player, Const.Traits.VOID_WARD)) {
                event.player.m_5997_(0.0, 10.0, 0.0);
                event.player.m_7292_(new MobEffectInstance(MobEffects.f_19591_, 400, 3, true, false));
                event.player.m_7292_(new MobEffectInstance(MobEffects.f_19620_, 200, 9, true, false));
            }
        }
    }

    private static void tickMagnetic(Player player, int magneticLevel) {
        if (player.m_6047_()) {
            return;
        }
        int range = magneticLevel * 3 + 1;
        Vec3 target = new Vec3(player.m_20185_(), player.m_20227_(0.5), player.m_20189_());
        AABB aabb = new AABB(player.m_20185_() - (double)range, player.m_20186_() - (double)range, player.m_20189_() - (double)range, player.m_20185_() + (double)range + 1.0, player.m_20186_() + (double)range + 1.0, player.m_20189_() + (double)range + 1.0);
        for (ItemEntity entity : player.m_9236_().m_6443_(ItemEntity.class, aabb, e -> e.m_20280_((Entity)player) < (double)(range * range))) {
            if (!GearEvents.canMagneticPullItem(entity)) continue;
            Vec3 vec = entity.m_7688_((LivingEntity)player).m_82505_(target);
            vec = vec.m_82541_().m_82490_(0.06);
            if (entity.m_20186_() < target.f_82480_) {
                double xzDistanceSq = (entity.m_20185_() - target.f_82479_) * (entity.m_20185_() - target.f_82479_) + (entity.m_20189_() - target.f_82481_) * (entity.m_20189_() - target.f_82481_);
                vec = vec.m_82520_(0.0, 0.005 + xzDistanceSq / 1000.0, 0.0);
            }
            entity.m_5997_(vec.f_82479_, vec.f_82480_, vec.f_82481_);
        }
    }

    private static boolean canMagneticPullItem(ItemEntity entity) {
        return !entity.m_32063_() && !entity.getPersistentData().m_128471_("PreventRemoteMovement");
    }

    @SubscribeEvent
    public static void onLivingFall(LivingFallEvent event) {
        LivingEntity livingEntity;
        ItemStack stack = event.getEntity().m_6844_(EquipmentSlot.FEET);
        if (event.getDistance() > 3.0f && (livingEntity = event.getEntity()) instanceof Player) {
            int bounce;
            Player player = (Player)livingEntity;
            int moonwalker = TraitHelper.getHighestLevelArmorOrCurio(player, Const.Traits.MOONWALKER);
            if (moonwalker > 0) {
                float gravity = 1.0f + (float)moonwalker * -0.15f;
                event.setDistance(event.getDistance() * gravity);
                if (event.getEntity() instanceof ServerPlayer) {
                    LibTriggers.GENERIC_INT.trigger((ServerPlayer)event.getEntity(), FALL_WITH_MOONWALKER, 1);
                }
            }
            if ((bounce = TraitHelper.getHighestLevelArmorOrCurio(player, Const.Traits.BOUNCE)) > 0 && event.getDistance() > 3.0f && !event.getEntity().m_20162_()) {
                int damage = (int)(event.getDistance() / 3.0f) - 1;
                if (damage > 0) {
                    GearHelper.attemptDamage(stack, damage, event.getEntity(), EquipmentSlot.FEET);
                }
                event.getEntity().m_9236_().m_5594_(null, event.getEntity().m_20183_(), SoundEvents.f_12390_, SoundSource.PLAYERS, 1.0f, 1.0f);
                event.setCanceled(true);
            }
        }
    }

    public static void onPlayerTickBouncing(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && !event.player.m_21255_() && BOUNCE_TICKS.containsKey(event.player)) {
            Vec3 motion = BOUNCE_TICKS.get(event.player);
            event.player.m_20334_(motion.f_82479_, motion.f_82480_ * 20.0, motion.f_82481_);
            event.player.m_6853_(false);
            BOUNCE_TICKS.remove(event.player);
            SilentGear.LOGGER.debug("bounce {}", (Object)motion);
            if (event.player.m_20184_().f_82480_ < 0.0) {
                GearEvents.bounceEntity((Entity)event.player);
            }
        }
    }

    private static void bounceEntity(Entity entity) {
        Vec3 vector3d = entity.m_20184_();
        if (vector3d.f_82480_ < 0.0) {
            Vec3 vec = new Vec3(vector3d.f_82479_, -vector3d.f_82480_ * 0.75, vector3d.f_82481_);
            SilentGear.LOGGER.debug("{} -> {}", (Object)vector3d, (Object)vec);
            BOUNCE_TICKS.put(entity, vec);
        }
    }

    @SubscribeEvent
    public static void onPlayerHurt(LivingHurtEvent event) {
        Player player;
        int bounce;
        Entity source;
        if (event.getEntity() instanceof Player && (source = event.getSource().m_7640_()) instanceof LivingEntity && (bounce = TraitHelper.getHighestLevelArmor(player = (Player)event.getEntity(), Const.Traits.BOUNCE)) > 0) {
            SilentGear.LOGGER.debug("knockback");
            ((LivingEntity)source).m_147240_((double)(2 * bounce), (double)(-Mth.m_14031_((float)(source.m_146908_() * ((float)Math.PI / 180)))), (double)Mth.m_14089_((float)(source.m_146908_() * ((float)Math.PI / 180))));
        }
    }
}

