/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.crafting.ingredient;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.item.ICoreItem;
import net.silentchaos512.gear.setup.SgItems;

public final class GearTypeIngredient
extends Ingredient {
    private final GearType type;

    private GearTypeIngredient(GearType type) {
        super(SgItems.ITEMS.getEntries().stream().filter(iro -> iro.isPresent() && iro.get() instanceof ICoreItem).map(iro -> (ICoreItem)iro.get()).filter(item -> item.getGearType().matches(type)).map(item -> new Ingredient.ItemValue(new ItemStack((ItemLike)item))));
        this.type = type;
    }

    public static GearTypeIngredient of(GearType type) {
        return new GearTypeIngredient(type);
    }

    public boolean test(@Nullable ItemStack stack) {
        if (stack == null || stack.m_41619_()) {
            return false;
        }
        return stack.m_41720_() instanceof ICoreItem && ((ICoreItem)stack.m_41720_()).getGearType().matches(this.type);
    }

    public boolean isSimple() {
        return false;
    }

    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return Serializer.INSTANCE;
    }

    public JsonElement m_43942_() {
        JsonObject json = new JsonObject();
        json.addProperty("type", Serializer.NAME.toString());
        json.addProperty("gear_type", this.type.getName());
        return json;
    }

    public static final class Serializer
    implements IIngredientSerializer<GearTypeIngredient> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation NAME = new ResourceLocation("silentgear", "gear_type");

        private Serializer() {
        }

        public GearTypeIngredient parse(FriendlyByteBuf buffer) {
            String typeName = buffer.m_130277_();
            GearType type = GearType.get(typeName);
            if (type.isInvalid()) {
                throw new JsonParseException("Unknown gear type: " + typeName);
            }
            return new GearTypeIngredient(type);
        }

        public GearTypeIngredient parse(JsonObject json) {
            String typeName = GsonHelper.m_13851_((JsonObject)json, (String)"gear_type", (String)"");
            if (typeName.isEmpty()) {
                throw new JsonSyntaxException("'gear_type' is missing");
            }
            GearType type = GearType.get(typeName);
            if (type.isInvalid()) {
                throw new JsonSyntaxException("gear_type " + typeName + " does not exist");
            }
            return new GearTypeIngredient(type);
        }

        public void write(FriendlyByteBuf buffer, GearTypeIngredient ingredient) {
            buffer.m_130070_(ingredient.type.getName());
        }
    }
}

