/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.api.traits;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.Mth;
import net.minecraft.world.item.TooltipFlag;
import net.silentchaos512.gear.api.traits.ITrait;
import net.silentchaos512.gear.api.traits.ITraitCondition;
import net.silentchaos512.gear.api.traits.ITraitInstance;
import net.silentchaos512.gear.api.traits.LazyTraitInstance;
import net.silentchaos512.gear.api.util.DataResource;
import net.silentchaos512.gear.client.KeyTracker;
import net.silentchaos512.gear.gear.trait.TraitManager;
import net.silentchaos512.gear.gear.trait.TraitSerializers;
import net.silentchaos512.gear.util.TextUtil;

public final class TraitInstance
implements ITraitInstance {
    private final DataResource<ITrait> trait;
    private final int level;
    private final ImmutableList<ITraitCondition> conditions;

    private TraitInstance(ITrait trait, int level, ITraitCondition ... conditions) {
        this(DataResource.trait(trait.getId()), level, conditions);
    }

    private TraitInstance(DataResource<ITrait> trait, int level, ITraitCondition ... conditions) {
        this.trait = trait;
        this.level = level;
        this.conditions = ImmutableList.builder().add((Object[])(trait.isPresent() ? trait.get().getConditions().toArray(new ITraitCondition[0]) : new ITraitCondition[]{})).add((Object[])conditions).build();
    }

    public static ITraitInstance of(DataResource<ITrait> trait, int level, ITraitCondition ... conditions) {
        if (trait.isPresent()) {
            return TraitInstance.of(trait.get(), level, conditions);
        }
        return TraitInstance.lazy(trait.getId(), level, conditions);
    }

    public static TraitInstance of(ITrait trait, int level, ITraitCondition ... conditions) {
        return new TraitInstance(trait, level, conditions);
    }

    public static LazyTraitInstance lazy(ResourceLocation traitId, int level, ITraitCondition ... conditions) {
        return new LazyTraitInstance(traitId, level, conditions);
    }

    @Override
    public ResourceLocation getTraitId() {
        return this.trait.getId();
    }

    @Override
    @Nonnull
    public ITrait getTrait() {
        return this.trait.get();
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    @Override
    public Collection<ITraitCondition> getConditions() {
        return this.conditions;
    }

    public MutableComponent getDisplayName() {
        MutableComponent text = this.trait.get().getDisplayName(this.level).m_6881_();
        if (!this.conditions.isEmpty()) {
            text.m_130946_("*");
        }
        return text;
    }

    public void addInformation(List<Component> tooltip, TooltipFlag flag) {
        if (!this.trait.get().showInTooltip(flag)) {
            return;
        }
        MutableComponent displayName = this.getDisplayName().m_130940_(ChatFormatting.ITALIC);
        tooltip.add((Component)(this.trait.get().isHidden() ? TextUtil.withColor(displayName, ChatFormatting.DARK_GRAY) : displayName));
        if (KeyTracker.isAltDown()) {
            MutableComponent description = TextUtil.withColor(this.trait.get().getDescription(this.level), ChatFormatting.DARK_GRAY);
            tooltip.add((Component)Component.m_237113_((String)"    ").m_7220_((Component)description));
        }
    }

    public static TraitInstance deserialize(JsonObject json) {
        ResourceLocation traitId = new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"name"));
        ITrait trait = TraitManager.get(traitId);
        if (trait == null) {
            throw new JsonSyntaxException("Unknown trait: " + traitId);
        }
        int level = Mth.m_14045_((int)GsonHelper.m_13824_((JsonObject)json, (String)"level", (int)1), (int)1, (int)trait.getMaxLevel());
        ArrayList<ITraitCondition> conditions = new ArrayList<ITraitCondition>();
        if (json.has("conditions")) {
            JsonArray array = json.getAsJsonArray("conditions");
            for (JsonElement j : array) {
                conditions.add(TraitSerializers.deserializeCondition(j.getAsJsonObject()));
            }
        }
        return TraitInstance.of(trait, level, conditions.toArray(new ITraitCondition[0]));
    }

    public static TraitInstance read(FriendlyByteBuf buffer) {
        DataResource<ITrait> trait = DataResource.trait(buffer.m_130281_());
        byte level = buffer.readByte();
        ITraitCondition[] conditions = new ITraitCondition[buffer.readByte()];
        for (int i = 0; i < conditions.length; ++i) {
            conditions[i] = TraitSerializers.readCondition(buffer);
        }
        return new TraitInstance(trait, (int)level, conditions);
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.m_130085_(this.getTraitId());
        buffer.writeByte(this.level);
        buffer.writeByte(this.conditions.size());
        this.conditions.forEach(condition -> TraitSerializers.writeCondition(condition, buffer));
    }
}

