/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.api.data.part;

import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.silentchaos512.gear.api.data.part.PartBuilder;
import net.silentchaos512.gear.data.DataGenerators;
import org.jetbrains.annotations.NotNull;

public abstract class PartsProviderBase
implements DataProvider {
    protected final DataGenerator generator;
    protected final String modId;

    public PartsProviderBase(DataGenerator generator, String modId) {
        this.generator = generator;
        this.modId = modId;
    }

    @NotNull
    public String m_6055_() {
        return "Silent Gear Parts: " + this.modId;
    }

    protected abstract Collection<PartBuilder> getParts();

    public CompletableFuture<?> m_213708_(CachedOutput cache) {
        Path outputFolder = this.generator.getPackOutput().m_245114_();
        HashSet set = Sets.newHashSet();
        ArrayList list = new ArrayList();
        this.getParts().forEach(builder -> {
            if (!set.add(builder.getId())) {
                throw new IllegalStateException("Duplicate part: " + builder.getId());
            }
            Path path = outputFolder.resolve(String.format("data/%s/silentgear_parts/%s.json", builder.getId().m_135827_(), builder.getId().m_135815_()));
            list.add(DataGenerators.saveStable(cache, (JsonElement)builder.serialize(), path));
        });
        return CompletableFuture.allOf(list.toArray(new CompletableFuture[0]));
    }
}

