/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.adventure.loot;

import dev.shadowsoffire.apotheosis.adventure.AdventureModule;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.server.ServerLifecycleHooks;

@Mod.EventBusSubscriber(modid="apotheosis", bus=Mod.EventBusSubscriber.Bus.FORGE)
class ShieldBreakerTest
implements Predicate<ItemStack> {
    private static Map<Level, Zombies> zombieCache = new IdentityHashMap<Level, Zombies>();

    ShieldBreakerTest() {
    }

    @Override
    public boolean test(ItemStack t) {
        try {
            MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
            ServerLevel level = null;
            if (server != null) {
                level = server.m_129880_(Level.f_46428_);
            } else if (FMLEnvironment.dist.isClient()) {
                level = Client.getLevel();
            }
            if (level != null) {
                Zombies zombies = zombieCache.computeIfAbsent((Level)level, Zombies::new);
                return t.canDisableShield(zombies.target.m_21206_(), (LivingEntity)zombies.target, (LivingEntity)zombies.attacker);
            }
            return t.canDisableShield(Items.f_42740_.m_7968_(), null, null);
        }
        catch (Exception ex) {
            AdventureModule.LOGGER.error("Failed to execute ShieldBreakerTest", (Throwable)ex);
            return false;
        }
    }

    @SubscribeEvent
    public static void unload(LevelEvent.Unload e) {
        zombieCache.remove(e.getLevel());
    }

    private static class Client {
        private Client() {
        }

        static Level getLevel() {
            return Minecraft.m_91087_().f_91073_;
        }
    }

    private record Zombies(Zombie attacker, Zombie target) {
        public Zombies(Level level) {
            this(new Zombie(level), new Zombie(level));
            this.target.m_21008_(InteractionHand.OFF_HAND, new ItemStack((ItemLike)Items.f_42740_));
        }
    }
}

