/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.universalgrid.apiiml.network.item;

import com.refinedmods.refinedstorage.api.network.INetwork;
import com.refinedmods.refinedstorage.api.network.item.INetworkItem;
import com.refinedmods.refinedstorage.api.network.item.INetworkItemManager;
import com.refinedmods.refinedstorage.api.network.security.Permission;
import com.refinedmods.refinedstorage.apiimpl.API;
import com.refinedmods.refinedstorage.inventory.player.PlayerSlot;
import com.refinedmods.refinedstorage.util.LevelUtils;
import com.ultramega.universalgrid.apiiml.network.grid.WirelessUniversalGridGridFactory;
import com.ultramega.universalgrid.config.UniversalGridConfig;
import com.ultramega.universalgrid.item.WirelessUniversalGridItem;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.energy.IEnergyStorage;

public class WirelessUniversalGridNetworkItem
implements INetworkItem {
    private INetworkItemManager handler;
    private Player player;
    private ItemStack stack;
    private PlayerSlot slot;

    public WirelessUniversalGridNetworkItem(INetworkItemManager handler, Player player, ItemStack stack, PlayerSlot slot) {
        this.handler = handler;
        this.player = player;
        this.stack = stack;
        this.slot = slot;
    }

    public Player getPlayer() {
        return this.player;
    }

    public boolean onOpen(INetwork network) {
        IEnergyStorage energy = (IEnergyStorage)this.stack.getCapability(ForgeCapabilities.ENERGY, null).orElse(null);
        if (((Boolean)UniversalGridConfig.UNIVERSAL_GRID_USE_ENERGY.get()).booleanValue() && ((WirelessUniversalGridItem)this.stack.m_41720_()).getType() != WirelessUniversalGridItem.Type.CREATIVE && energy != null && energy.getEnergyStored() <= (Integer)UniversalGridConfig.UNIVERSAL_GRID_OPEN_USAGE.get()) {
            this.sendOutOfEnergyMessage();
            return false;
        }
        if (!network.getSecurityManager().hasPermission(Permission.MODIFY, this.player)) {
            LevelUtils.sendNoPermissionMessage((Player)this.player);
            return false;
        }
        API.instance().getGridManager().openGrid(WirelessUniversalGridGridFactory.ID, (ServerPlayer)this.player, this.stack, this.slot);
        this.drainEnergy((Integer)UniversalGridConfig.UNIVERSAL_GRID_OPEN_USAGE.get());
        return true;
    }

    public void drainEnergy(int energy) {
        if (((Boolean)UniversalGridConfig.UNIVERSAL_GRID_USE_ENERGY.get()).booleanValue() && ((WirelessUniversalGridItem)this.stack.m_41720_()).getType() != WirelessUniversalGridItem.Type.CREATIVE) {
            this.stack.getCapability(ForgeCapabilities.ENERGY).ifPresent(energyStorage -> {
                energyStorage.extractEnergy(energy, false);
                if (energyStorage.getEnergyStored() <= 0) {
                    this.handler.close(this.player);
                    this.player.m_6915_();
                    this.sendOutOfEnergyMessage();
                }
            });
        }
    }

    private void sendOutOfEnergyMessage() {
        this.player.m_213846_((Component)Component.m_237110_((String)"misc.refinedstorage.network_item.out_of_energy", (Object[])new Object[]{Component.m_237115_((String)this.stack.m_41720_().m_5524_())}));
    }
}

